<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

//-----------------------------------------------------------------
// 错误报告级别配置
//-----------------------------------------------------------------
error_reporting(E_ERROR | E_PARSE);

//-----------------------------------------------------------------
// UTF-8安全截取字符串（按字符显示宽度近似计算）
//-----------------------------------------------------------------
function cut_str($sourcestr, $cutlength)
{
    $sourceStr = (string)$sourcestr;
    $cutLength = max(0, (int)$cutlength);

    $resultStr = '';
    $byteIndex = 0;
    $charCount = 0;
    $totalBytes = strlen($sourceStr);

    while (($charCount < $cutLength) && ($byteIndex < $totalBytes)) {
        $currentByte = ord(substr($sourceStr, $byteIndex, 1));

        if ($currentByte >= 224) {
            $resultStr .= substr($sourceStr, $byteIndex, 3);
            $byteIndex += 3;
            $charCount += 1;
        } elseif ($currentByte >= 192) {
            $resultStr .= substr($sourceStr, $byteIndex, 2);
            $byteIndex += 2;
            $charCount += 1;
        } elseif ($currentByte >= 65 && $currentByte <= 90) {
            $resultStr .= substr($sourceStr, $byteIndex, 1);
            $byteIndex += 1;
            $charCount += 1;
        } else {
            $resultStr .= substr($sourceStr, $byteIndex, 1);
            $byteIndex += 1;
            $charCount += 0.5;
        }
    }

    if ($totalBytes > $byteIndex) {
        $resultStr .= "...";
    }

    return $resultStr;
}