<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

return [
    // 引擎配置
    'type'               => 'Think',         // 使用Think原生模板引擎
    'auto_rule'          => 1,               // URL自动转为小写下划线
    'view_dir_name'      => 'view',          // 视图目录名称
    'view_suffix'        => 'htm',           // 模板文件后缀
    'view_depr'          => DIRECTORY_SEPARATOR, // 系统安全分隔符

    // 标签配置
    'tpl_begin'          => '{',             // 模板标签起始符
    'tpl_end'            => '}',              // 模板标签结束符
    'taglib_begin'       => '{',             // 标签库起始符
    'taglib_end'         => '}',             // 标签库结束符

    // 安全配置
    'default_filter'     => 'htmlspecialchars',
    'tpl_deny_php'       => true,
    'tpl_deny_func_list' => 'echo,exit,die,print,var_dump',

    // 自定义配置
    'tpl_replace_string' => [
        '__INDEX__' => '/static/default',    // 静态资源路径替换
    ],
    'taglib_pre_load'    => 'app\index\common\taglib\Rycms' // 预加载标签库
];
