<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\index\controller;

use app\index\controller\Common;
use app\index\model\Article as ArticleModel;
use app\index\model\Cate as CateModel;
use think\facade\View;
use think\exception\HttpException;
use think\facade\Lang;

class Cate extends Common
{
    //-----------------------------------------------------------------
    // 栏目页
    //-----------------------------------------------------------------
    public function index()
    {
        try {
            $originCate = $this->getCurrentCate();
            $finalCate = $this->handleCateRedirect($originCate);
            $cateId = $originCate->jump_id > 0 ? $finalCate->id : $originCate->id;

            return View::fetch($this->buildTemplatePath($finalCate), [
                'Cates'      => $finalCate,
                'FaCates'    => $this->getParentCate($finalCate),
                'SonNavMenu' => $this->buildSonNav($finalCate->id),
                'ArtRes'     => $this->prepareArticleData($cateId),
                'topcid'     => $this->getRootCategoryId($cateId) ?: $cateId,
                'cateid'     => $cateId,
                'PosBread'   => $this->generateBreadcrumbs($cateId),
                'sort'       => input('sort', 'default'),
            ]);
        } catch (HttpException $e) {
            return view('error/exception_jump', [
                'jump_msg'  => $e->getMessage(),
                'jump_url'  => url('/'),
                'wait_time' => 5
            ]);
        }
    }

    //-----------------------------------------------------------------
    // 获取当前栏目
    //-----------------------------------------------------------------
    private function getCurrentCate(): \think\Model
    {
        $cate = CateModel::where('ename', input('name'))->find();
        
        if (!$cate || $cate['status'] == 0) {
            throw new HttpException(404, Lang::get('cate_not_exists'));
        }
        
        if ($cate->type == 0) {
            throw new HttpException(404, Lang::get('cate_data_not_exists'));
        }
        
        return $cate;
    }

    //-----------------------------------------------------------------
    // 处理栏目跳转
    //-----------------------------------------------------------------
    private function handleCateRedirect(\think\Model $cate): \think\Model
    {
        return $cate->jump_id > 0 ? CateModel::findOrFail($cate->jump_id) : $cate;
    }

    //-----------------------------------------------------------------
    // 准备文章数据
    //----------------------------------------------------------------- 
    private function prepareArticleData(int $cateId)
    {
        $childIds = array_merge([$cateId], $this->getAllChildIds($cateId));
        $articleData = ArticleModel::getPaginatedArticles($childIds, input('sort', 'default'));

        return $articleData->each(function ($article) {
            $article->tags = $this->processArticleTags($article->tag);
            $article->url = $this->generateArticleUrl($article);
        });
    }

    //-----------------------------------------------------------------
    // 模板路径生成
    //-----------------------------------------------------------------
    private function buildTemplatePath(\think\Model $cate): string
    {
        $basePath = $this->getCurrentTheme() . '/';
        return $cate->type === 2 
            ? $basePath . $cate->page_tmp 
            : $basePath . $cate->lst_tmp;
    }

    //-----------------------------------------------------------------
    // 获取父级栏目
    //-----------------------------------------------------------------
    private function getParentCate(\think\Model $cate): \think\Model
    {
        return $cate->pid === 0 ? $cate : CateModel::find($cate->pid);
    }
}