<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare (strict_types = 1);
namespace app\index\controller;

use think\facade\Cookie;
use think\facade\Lang;
use think\facade\Request;
use think\facade\Config;
use think\facade\Session;

class Language
{
 
    //-----------------------------------------------------------------
    // 语言切换方法
    //-----------------------------------------------------------------
    public function switch()
    {

        $lang = strtolower(Request::param('lang', 'zh-cn')); // 获取语言参数并转为小写，默认中文
        
        $supportedLangs = Config::get('lang.allow_lang_list', ['zh-cn', 'en-us']); // 从配置获取支持的语言列表
        
        if (!in_array($lang, $supportedLangs)) { // 验证语言是否在支持列表中
            return json([
                'code' => 0,
                'msg' => Lang::get('Unsupported language') // 返回不支持语言的错误提示
            ]);
        }

        try {
            //-----------------------------------------------------------------
            // 设置语言环境（Session + Cookie + 框架语言）
            //-----------------------------------------------------------------
            $cookieVar = Config::get('lang.cookie_var', 'royalcms_lang'); // 从配置获取cookie变量名，默认royalcms_lang
            
            Session::set('royal_lang', $lang); // 设置Session，使用统一前缀royal_lang
            
            Cookie::set($cookieVar, $lang, 30 * 86400); // 设置Cookie，有效期30天
            
            Lang::setLangSet($lang); // 设置框架当前语言环境
            
            return json([
                'code' => 200,
                'msg' => Lang::get('Language switched successfully'), // 返回语言切换成功提示
                'data' => [
                    'lang' => $lang // 返回设置的语言代码
                ]
            ]);
            
        } catch (\Exception $e) {
            return json([
                'code' => 0,
                'msg' => Lang::get('Operation failed') // 返回操作失败提示
            ]);
        }
    }
}