<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\index\controller;

use app\index\controller\Common;
use app\index\model\Article as ArticleModel;
use app\index\model\Cate as CateModel;
use think\facade\View;

class Search extends Common
{
    //-----------------------------------------------------------------
    // 搜索页
    //-----------------------------------------------------------------
    public function index()
    {
        $keyword = input('keyword', '');
        $type = input('type', 'all');
        
        if (empty($keyword)) {
            return $this->renderEmptySearch($keyword, $type);
        }

        $ArtRes = $this->buildSearchQuery($keyword, $type)
            ->field('id,cateid,type,sort,create_time,price,star,click,stitle,title,keywords,description,thumb,content')
            ->order('sort ASC, create_time DESC')
            ->paginate([
                'list_rows' => 12,
                'query'     => request()->get(),
            ]);

        return View::fetch($this->getCurrentTheme() . '/search.htm', [
            'keyword' => $keyword,
            'type'    => $type,
            'ArtRes'  => $ArtRes,
            'total'   => $ArtRes->total()
        ]);
    }

    //-----------------------------------------------------------------
    // 渲染空搜索
    //-----------------------------------------------------------------
    private function renderEmptySearch(string $keyword, string $type)
    {
        return View::fetch($this->getCurrentTheme() . '/search.htm', [
            'keyword' => $keyword,
            'type'    => $type,
            'ArtRes'  => null,
            'total'   => 0
        ]);
    }

    //-----------------------------------------------------------------
    // 构建搜索查询
    //-----------------------------------------------------------------
    private function buildSearchQuery(string $keyword, string $type)
    {
        $query = ArticleModel::with(['bltCate' => fn($q) => 
                $q->field('id,title,ename,type')])
            ->where('status', 1)
            ->where('type', '<>', 5)
            ->where(fn($q) => $q->whereOr([
                ['title', 'like', "%{$keyword}%"],
                ['description', 'like', "%{$keyword}%"],
                ['stitle', 'like', "%{$keyword}%"],
                ['keywords', 'like', "%{$keyword}%"]
            ]));

        if ($type !== 'all') {
            $cateIds = $this->getCateIdsByType((int)$type);
            $query->whereIn('cateid', $cateIds ?: [0]);
        }

        return $query;
    }

    //-----------------------------------------------------------------
    // 根据栏目类型获取栏目ID
    //-----------------------------------------------------------------
    private function getCateIdsByType(int $cateType): array
    {
        $rootCates = CateModel::where('type', $cateType)
            ->where('pid', 0)
            ->where('status', 1)
            ->select();
        
        $allCateIds = [];
        foreach ($rootCates as $cate) {
            $allCateIds = array_merge($allCateIds, $this->getAllChildCateIds($cate->id));
        }
        
        return array_unique($allCateIds);
    }

    //-----------------------------------------------------------------
    // 递归获取栏目所有子栏目ID
    //-----------------------------------------------------------------
    private function getAllChildCateIds(int $cateId): array
    {
        $cateIds = [$cateId];
        $childCates = CateModel::where('pid', $cateId)->where('status', 1)->select();
            
        foreach ($childCates as $childCate) {
            $cateIds = array_merge($cateIds, $this->getAllChildCateIds($childCate->id));
        }
        
        return $cateIds;
    }
}