<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\index\model;
use app\index\model\Base;
use think\model\relation\BelongsTo;

class Article extends Base
{
     protected $name = 'article';
    //-----------------------------------------------------------------
    // 栏目关联关系
    //-----------------------------------------------------------------
    public function bltCate(): BelongsTo
    {
        return $this->belongsTo(Cate::class, 'cateid')->bind([
            'cate_ename' => 'ename',
            'cate_title' => 'title',
        ]);
    }

    //-----------------------------------------------------------------
    // 获取分页文章列表
    //-----------------------------------------------------------------
    public static function getPaginatedArticles(array $cateIds, string $sort = 'default', int $size = 12)
    {
        $query = self::with(['bltCate' => fn($q) => $q->field('id,ename,title')])
            ->field('id,cateid,type,sort,tag,create_time,icon,price,star,click,like_count,stitle,title,keywords,description,thumb,content')
            ->whereIn('cateid', $cateIds)
            ->where('status', 1);

        return self::applySort($query, $sort)
            ->cache(3600)
            ->paginate([
                'list_rows' => min($size, 100),
                'query'     => request()->get(),
            ]);
    }

    //-----------------------------------------------------------------
    // 应用排序规则
    //-----------------------------------------------------------------
    private static function applySort($query, string $sort)
    {
        $orderMap = [
            'popularity' => 'click DESC, sort ASC, create_time DESC',
            'price-low'  => self::getPriceOrder('ASC'),
            'price-high' => self::getPriceOrder('DESC'),
            'newest'     => 'create_time DESC, sort ASC',
            'star'       => 'star DESC, sort ASC, create_time DESC'
        ];

        return $query->orderRaw($orderMap[$sort] ?? 'sort ASC, create_time DESC');
    }

    //-----------------------------------------------------------------
    // 获取价格排序SQL
    //-----------------------------------------------------------------
    private static function getPriceOrder(string $direction): string
    {
        return "CAST(price AS DECIMAL(10,2)) {$direction}, sort ASC, create_time DESC";
    }
}