<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 */
use think\facade\Route;

//-----------------------------------------------------------------
// 前台路由组
//-----------------------------------------------------------------

//-----------------------------------------------------------------
// 基础路由
//-----------------------------------------------------------------
Route::rule('/', 'Index/index')->name('home');

//-----------------------------------------------------------------
// 功能模块路由
//-----------------------------------------------------------------
Route::rule('/a/search', 'index/search/index')->name('search');
Route::post('/download/record', 'index/DownloadLog/record')->name('down'); 
Route::post('/a/form/msg', 'index/Message/index')->name('message'); // 确保是POST
Route::post('/language/switch', 'index/Language/switch')->name('language_switch'); // 新增语言切换路由

//-----------------------------------------------------------------
// 动态参数路由（严格参数过滤）
//-----------------------------------------------------------------
Route::get('/a/:name', 'index/cate/index')
    ->pattern(['name' => '[a-zA-Z0-9\-_]+'])
    ->name('cate');

Route::get('/article/:encryptedId', 'index/article/index')
    ->pattern(['encryptedId' => '[a-zA-Z0-9\-_]{10,50}'])
    ->name('article');