<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\middleware;

use think\facade\Cookie;
use think\facade\Lang;
use think\facade\Config;
use think\facade\Session;

class SetLang
{
     
    //-----------------------------------------------------------------
    // 语言设置中间件
    //-----------------------------------------------------------------

    public function handle($request, \Closure $next)
    {
        // 获取配置中的cookie变量名，默认使用'royalcms_lang'
        $cookieVar = Config::get('lang.cookie_var', 'royalcms_lang');

        // 获取默认语言设置，默认为'zh-cn'（中文）
        $defaultLang = Config::get('lang.default_lang', 'zh-cn');

        //-----------------------------------------------------------------
        // 语言检测优先级：Session > Cookie > 默认配置
        //-----------------------------------------------------------------

        // 1. 最高优先级：从Session中获取语言设置（使用统一前缀royal_lang）
        $lang = Session::get('royal_lang');

        // 2. 第二优先级：如果Session中没有，从Cookie中获取
        if (!$lang) {
            $lang = Cookie::get($cookieVar);
        }

        // 3. 最低优先级：如果以上都没有，使用默认语言
        if (!$lang) {
            $lang = $defaultLang;
        }

        //-----------------------------------------------------------------
        // 语言有效性验证
        //-----------------------------------------------------------------

        // 获取允许的语言列表，默认为['zh-cn', 'en-us']
        $allowLangs = Config::get('lang.allow_lang_list', ['zh-cn', 'en-us']);

        // 验证检测到的语言是否在允许列表中
        if (!in_array($lang, $allowLangs)) {
            // 如果语言不被支持，则回退到默认语言
            $lang = $defaultLang;
        }

        //-----------------------------------------------------------------
        // 应用语言设置
        //-----------------------------------------------------------------

        // 设置系统语言环境
        Lang::setLangSet($lang);

        //-----------------------------------------------------------------
        // 传递语言设置到其他组件
        //-----------------------------------------------------------------

        // 定义全局常量，供模型层使用（用于数据库表前缀等）
        define('CURRENT_LANG', $lang);

        // 将当前语言设置附加到请求对象，供控制器和视图使用
        $request->CurLang = $lang;

        // 继续执行后续中间件和请求处理
        return $next($request);
    }
}
