<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\royaladmin\controller;

use app\royaladmin\controller\RyBase;
use think\facade\Request;
use app\royaladmin\model\RyLink as RyLinkModel;
use app\royaladmin\validate\RyLink as RyLinkValidate;
use app\royaladmin\fields\form\RyLinkFields;
use app\royaladmin\fields\list\RyLinkList;
use Throwable;

// -----------------------------------------------------------------------------
// 友情链接控制器
// 负责友情链接的增删改查及展示功能
// -----------------------------------------------------------------------------
class RyLink extends RyBase
{
    // -------------------------------------------------------------------------
    // 类常量与属性
    // -------------------------------------------------------------------------
    protected $modelClass    = RyLinkModel::class;
    protected $validateClass = RyLinkValidate::class;

    // -------------------------------------------------------------------------
    // 表单处理方法
    // -------------------------------------------------------------------------
    public function form(?int $id = null)
    {
        // 非AJAX请求渲染视图
        if (!Request::isAjax()) {
            $model = $id ? RyLinkModel::find($id) : null;
            $currentData = $model ? $model->getData() : [];
            $pageTitle = $id ? lang('edit_link') : lang('add_link');
            $currentParentId = Request::param('type/d', 0);
            $formTabs = RyLinkFields::getFormTabs();

            return parent::renderFormView($formTabs, $currentData, $pageTitle, $currentParentId);
        }

        // AJAX请求处理数据提交
        return $this->processFormSubmission($id);
    }

    // -------------------------------------------------------------------------
    // 获取链接数据
    // -------------------------------------------------------------------------
    public function getLinkData()
    {
        $type = Request::param('type/d', 0);
        
        $searchFields = [
            'title'  => 's',
            'status' => 'd',
            'type'   => 'd'
        ];
        
        // 类型为0时移除类型过滤
        if ($type === 0) {
            unset($searchFields['type']);
        }
        
        return $this->getCommonData([
            'searchFields' => $searchFields,
            'field'        => 'title,thumb,id,sort,url,create_time,type,status',
            'order'        => 'sort asc, create_time DESC'
        ]);
    }

    // -------------------------------------------------------------------------
    // 链接列表页面
    // -------------------------------------------------------------------------
    public function lst()
    {
        $config = RyLinkList::getListConfig();
        return view('common/list', array_merge($config, $config['viewParams']));
    }

    // -------------------------------------------------------------------------
    // 私有辅助方法
    // -------------------------------------------------------------------------

    /** 处理表单提交 */
    private function processFormSubmission(?int $id)
    {
        try {
            $data = Request::param();
            $result = parent::handleFormSubmit($data, $id);
            
            $adTitle = $data['title'] ?? ($id ? "ID:{$id}" : lang('new_link'));
            $actionType = $id ? lang('edit') : lang('add');
            
            $this->logFormAction("{$actionType}" . lang('link') . "《{$adTitle}》");

            return json([
                'code' => 200,
                'msg'  => "{$actionType}" . lang('link_success'),
                'url'  => url('link/lst', ['type' => $data['type'] ?? 0])->build(),
                'data' => $result['data'] ?? []
            ]);
        } catch (Throwable $e) {
            return json([
                'code' => $e->getCode() ?: 500,
                'msg'  => $e->getMessage()
            ]);
        }
    }
}