<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\royaladmin\controller;

use app\royaladmin\controller\RyBase;
use app\royaladmin\model\RyLog as RyLogModel;
use app\royaladmin\fields\list\RyLogList;

class RyLog extends RyBase
{
    // -------------------------------------------------------------------------
    // 类常量与属性
    // -------------------------------------------------------------------------

    protected $modelClass = RyLogModel::class;
 
    //-----------------------------------------------------------------
    // 获取日志数据
    //-----------------------------------------------------------------
    public function getLogData()
    {
        return $this->getCommonData([
            'field' => '*',
            'order' => 'login_time DESC, id DESC',
            'condition' => function ($query) {
                $userGroupId = session('auser_gid');

                if ($userGroupId == 1) {
                    // 管理员组，无需额外条件
                } elseif ($userGroupId > 1) {
                    $query->where('groupid', '>', 1);
                } else {
                    $query->whereRaw('1=0');
                }
            }
        ]);
    }
 
    //-----------------------------------------------------------------
    // 日志列表
    //-----------------------------------------------------------------
    public function lst()
    {
        $config = RyLogList::getListConfig();
        return view('common/list', $config);
    }
}