<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\form;

class RyAdFields
{
    // 广告表单字段配置（优化版）
    public static function getFormTabs(): array
    {
        return [
            [
                'title'  => '基本内容',
                'name'   => 'base',
                'icon'   => '',
                'fields' => [

                    [
                        'name'        => 'title',
                        'type'        => 'text',
                        'title'       => '广告标题',
                        'required'    => true,
                        'maxlength'   => 60,
                        'verify'      => 'required',
                        'placeholder' => '请输入广告标题（最多60字符）',
                    ],

                    [
                        'name'        => 'adposid',
                        'type'        => 'select',
                        'title'       => '所属位置',
                        'required'    => true,
                        'verify'      => 'required',
                        'placeholder' => '请选择广告位置',
                        'use_parent_id' => true,
                        'options'     => [], // 动态填充
                    ],
                    [
                        'name'        => 'stitle',
                        'type'        => 'text',
                        'title'       => '简略标题',
                        'maxlength'   => 60,
                        'placeholder' => '请输入广告副标题（最多60字符）',
                    ],
                    [
                        'name'        => 'thumb',
                        'type'        => 'image',
                        'title'       => '广告图片',
                        'required'    => true,
                        'verify'      => 'required',
                        'placeholder' => '请上传广告图片',
                    ],
                    [
                        'name'        => 'detailimg',
                        'type'        => 'image',
                        'title'       => '详情图片',
                        'placeholder' => '请上传详情图片',
                    ],

                    [
                        'name'   => 'content',
                        'type'   => 'editor',
                        'title'  => '文章内容',
                        'editor' => 'textarea-content',
                    ]
                ],

            ],
            [
                'title'  => '附加内容',
                'name'   => 'other',
                'icon'   => '',
                'fields' => [
                    [
                        'name'        => 'link',
                        'type'        => 'text',
                        'title'       => '跳转链接',
                        'maxlength'   => 120,
                        'placeholder' => '请输入完整链接（http://）',
                    ],
                    [
                        'name'        => 'jump_cate',
                        'type'        => 'select',
                        'title'       => '跳转栏目',
                        'placeholder' => '请选择栏目',
                        'options'     => [], // 动态填充
                    ],
                    [
                        'name'        => 'jump_article',
                        'type'        => 'select',
                        'title'       => '跳转文章',
                        'options'     => [], // 动态填充
                        'placeholder' => '请选择文章',
                    ],
                    [
                        'name'        => 'end_time',
                        'nameid' => 'date-time',
                        'type'        => 'text',
                        'title'       => '到期时间',
                        'placeholder' => '选择到期日期（留空或0表示长期有效）',
                    ],
                    [
                        'name'      => 'desc',
                        'type'      => 'textarea',
                        'title'     => '广告描述',
                        'maxlength' => 250,
                        'placeholder' => '不超过200个字符',
                    ],
                ],
            ],

        ];
    }
}
