<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\form;

class RyArticleFields
{

    public static function getFormTabs(): array
    {
        return [
            [
                'title'  => '基本内容',
                'name'   => 'base',
                'icon'   => '',
                'fields' => [
                    [
                        'name'        => 'title',
                        'type'        => 'text',
                        'title'       => '文档标题',
                        'required'    => true,
                        'maxlength'   => 120,
                        'verify'      => 'required',
                        'placeholder' => '标题最多120个字符',
                    ],
                    [
                        'name'        => 'cateid',
                        'type'        => 'select',
                        'title'       => '所属栏目',
                        'required'    => true,
                        'verify'      => 'required',
                        'placeholder' => '请选择栏目',
                        'use_parent_id' => true,
                        'options'     => [],
                    ],
                    [
                        'name'        => 'tag',
                        'type'        => 'tagselect',
                        'title'       => '文档标签',
                        'placeholder' => '选择或输入标签',
                        'options'     => [],
                    ],
                    [
                        'name'        => 'stitle',
                        'type'        => 'text',
                        'title'       => '简略标题',
                        'maxlength'   => 120,
                        'placeholder' => '最多120个字符',
                    ],

                    [
                        'name'  => 'icon',
                        'type'  => 'text',
                        'title' => '文档图标',
                        'placeholder' => '图标代码',
                    ],
                    [
                        'name'        => 'thumb',
                        'type'        => 'image',
                        'title'       => '文档封面',
                        'placeholder' => '请上传小于600kb的JPG/PNG/GIF图片，比例4:3（宽度推荐600-1000px)',
                    ],

                    [
                        'name'      => 'annex',
                        'type'      => 'file',
                        'title'     => '文档附件',
                        'placeholder' => '上传zip/rar/doc/xls文件（≤50M），禁止exe文件'
                    ],
                    [
                        'name'    => 'type',
                        'type'    => 'radio',
                        'title'   => '文档属性',
                        'options' => [
                            ['name' => '普通', 'value' => '0', 'title' => '普通'],
                            ['name' => '头条', 'value' => '1', 'title' => '头条'],
                            ['name' => '热门', 'value' => '2', 'title' => '热门'],
                            ['name' => '推荐', 'value' => '3', 'title' => '推荐'],
                            ['name' => '加粗', 'value' => '4', 'title' => '加粗'],
                            ['name' => '只读', 'value' => '5', 'title' => '只读']
                        ],
                    ],
                    [
                        'name'   => 'content',
                        'type'   => 'editor',
                        'title'  => '文档内容',
                        'editor' => 'textarea-content',
                    ]
                ],
            ],

            [
                'title'  => '附加内容',
                'name'   => 'other',
                'icon'   => '',
                'fields' => [
                    [
                        'name'      => 'keywords',
                        'type'      => 'text',
                        'title'     => '关键词语',
                        'maxlength' => 120,
                    ],
                    [
                        'name'      => 'description',
                        'type'      => 'textarea',
                        'title'     => '文档描述',
                        'maxlength' => 250,
                        'placeholder' => '为空时自动截取文档内容前60-100字符',
                    ],

                    [
                        'name'  => 'author',
                        'type'  => 'text',
                        'title' => '文档作者',
                        'placeholder' => '默认留空',
                    ],
                    [
                        'name'  => 'source',
                        'type'  => 'text',
                        'title' => '文档来源',
                        'placeholder' => '默认留空',
                    ],

                    [
                        'name'  => 'click',
                        'type'  => 'text',
                        'title' => '点击次数',
                        'placeholder' => '纯数字（默认随机数）',
                    ],
                    [
                        'name'   => 'create_time',
                        'type'   => 'text',
                        'title'  => '发布时间',
                        'nameid' => 'date-time',
                        'placeholder' => '手动输入时，格式：2015-11-30',
                    ],
                    [
                        'name'      => 'url',
                        'type'      => 'text',
                        'title'     => '跳转链接',
                        'maxlength' => 240,
                        'placeholder' => '示例：https://www.baidu.com/',
                    ],
                    [
                        'name'        => 'video',
                        'type'        => 'text',
                        'title'       => '视频链接',
                        'placeholder' => '输入腾讯/优酷iframe地址',
                        'maxlength'   => 240,
                    ],
                    [
                        'name'        => 'catesub',
                        'type'        => 'checkbox',
                        'title'       => '所属副栏目',
                        'verify'      => 'required',
                        'placeholder' => '请选择栏目',
                        'options'     => [],
                    ]
                ],
            ],
            [
                'title'  => '文档图集',
                'name'   => 'images',
                'icon'   => '',
                'fields' => [
                    [
                        'name'        => 'price',
                        'type'        => 'text',
                        'title'       => '产品价格',
                        'maxlength'   => 120,
                        'placeholder' => '纯数字',
                    ],
                    [
                        'name'        => 'like',
                        'type'        => 'text',
                        'title'       => '满意度',
                        'maxlength'   => 120,
                        'placeholder' => '纯数字',
                    ],

                    [
                        'name'        => 'images',
                        'type'        => 'images',
                        'title'       => '文档图集',
                        'placeholder' => '请上传小于600kb的JPG/PNG/GIF图片，比例4:3（宽度推荐600-1000px)',
                    ],
                    [
                        'name'   => 'content_xn',
                        'type'   => 'editor',
                        'title'  => '产品性能',
                        'editor' => 'content_xn',
                    ],

                ],
            ],

        ];
    }
}
