<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\form;

class RyAuserFields
{
    
    public static function getFormTabs(): array
    {
        return [
            [
                'title'  => '基本内容', 
                'name'   => 'base',
                'icon'   => '',
                'fields' => [
                    [
                        'name'        => 'groupid',
                        'type'        => 'select',
                        'title'       => '所属用户组',
                        'required'    => true,
                        'verify'      => 'required',
                        'placeholder' => '请选择用户组',
                        'options'     => [], // 留空，动态填充
                    ],
                    [
                        'name'        => 'uname',
                        'type'        => 'text',
                        'title'       => '用户账号',
                        'required'    => true,
                        'maxlength'   => 120,
                        'verify'      => 'required',
                        'placeholder' => '账号为字母和数字组合',
                    ],
                    [
                        'name'    => 'thumb',
                        'type'    => 'image',
                        'title'   => '用户头像',  
                        'placeholder'   => '请上传小于600kb内1:1的头像。', 
                    ],
                    [
                        'name'      => 'nickname',
                        'type'      => 'text',
                        'title'     => '用户昵称',
                        'placeholder' => '昵称最多20个字符',
                        'maxlength' => 40,
                    ],
                    [
                        'name'      => 'password',
                        'type'      => 'text',
                        'title'     => '用户密码',
                        'required'    => true,
                        'maxlength'   => 120,
                        'verify'      => 'required',
                    ],
                    [
                        'name'      => 'repassword',
                        'type'      => 'text',
                        'title'     => '请再次输入密码',
                        'required'    => true,
                        'maxlength'   => 120,
                        'verify'      => 'required',
                    ],
                     
                ],
            ],
             
        ];
    }
}