<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\form;

class RyAuthRuleFields
{
    // 权限控制字段配置
    public static function getFormTabs(): array
    {
        return [
            [
                'title'  => '基本内容',
                'name'   => 'base',
                'icon'   => '',
                'fields' => [
                    [
                        'name'        => 'pid',
                        'type'        => 'select',
                        'title'       => '上级权限',
                        'required'    => true,
                        'verify'      => 'required',
                        'placeholder' => '顶级权限',
                          'use_parent_id' => true,
                        'options'     => [],
                    ],
                    [
                        'name'        => 'title',
                        'type'        => 'text',
                        'title'       => '权限名称',
                        'maxlength'   => 120,
                        'required'    => true,
                        'verify'      => 'required',
                        'placeholder' => '标题最多120个字符',
                    ],
                    [
                        'name'        => 'name',
                        'type'        => 'text',
                        'title'       => '权限代码',
                        'required'    => true,
                        'verify'      => 'required',
                        'maxlength'   => 120,
                        'placeholder' => '必须为英文，例：RyCate/edit',
                    ],
                    [
                        'name'        => 'rule',
                        'type'        => 'text',
                        'title'       => '权限路由',
                        'maxlength'   => 120,
                        'placeholder' => '必须为英文，例：RyCate/edit',
                    ],
                    [
                        'name'        => 'icon',
                        'type'        => 'text',
                        'title'       => '权限图标',
                        'maxlength'   => 120,
                        'placeholder' => '例：layui-icon-picture',
                    ],
                    [
                        'name'      => 'show',
                        'type'      => 'radio',
                        'title'     => '左侧导航',
                        'options'     => [

                            [
                                'name' => '否',
                                'value' => '0',
                                'title' => '否',
                            ],
                            [
                                'name' => '是',
                                'value' => '1',
                                'title' => '是',
                            ]
                        ],
                    ],
                    [
                        'name'      => 'status',
                        'type'      => 'radio',
                        'title'     => '启用状态',
                        'options'     => [
                            [
                                'name' => '是',
                                'value' => '1',
                                'title' => '是',
                            ],
                            [
                                'name' => '否',
                                'value' => '0',
                                'title' => '否',
                            ]
                        ],
                    ]
                ],
            ],

        ];
    }
}
