<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\form;

class RyCateFields
{
    public static function getFormTabs(): array
    {
        return [
            [
                'title'  => '栏目内容',
                'name'   => 'base',
                'icon'   => '',
                'fields' => [

                    [
                        'name'        => 'title',
                        'type'        => 'text',
                        'title'       => '栏目名称',
                        'required'    => true,
                        'maxlength'   => 120,
                        'verify'      => 'required',
                        'placeholder' => '不超过120个字符',
                    ],
                    [
                        'name'        => 'pid',
                        'type'        => 'select',
                        'title'       => '所属栏目',
                        'required'    => true,
                        'verify'      => 'required',
                        'placeholder' => '顶级栏目',
                        'use_parent_id' => true,
                        'options'     => [],
                    ],

                    [
                        'name'        => 'ename',
                        'type'        => 'text',
                        'title'       => '栏目路由',
                        'maxlength'   => 120,
                        'required'    => true,
                        'verify'      => 'required',
                        'placeholder' => '必须为字母和下划线（如：about_us',
                    ],
                    [
                        'name'        => 'jump_id',
                        'type'        => 'select',
                        'title'       => '跳转栏目',
                        'verify'      => 'required',
                        'placeholder' => '不跳转',
                        'options'     => [],
                    ],
                    [
                        'name'        => 'sname',
                        'type'        => 'text',
                        'title'       => '简略标题',
                        'maxlength'   => 120,
                        'placeholder' => '不超过120个字符',
                    ],

                    [
                        'name'    => 'thumb',
                        'type'    => 'image',
                        'title'   => '栏目封面',
                        'placeholder'   => '上传<600kb的JPG/PNG/GIF图片',
                    ],
                    [
                        'name'    => 'background',
                        'type'    => 'image',
                        'title'   => '栏目背景',
                        'placeholder'   => '上传<600kb的JPG/PNG/GIF图片',
                    ],
                    [
                        'name'      => 'annex',
                        'type'      => 'file',
                        'title'     => '栏目附件',
                        'placeholder' => '上传zip/rar/doc/xls文件（≤50M），禁止exe文件'
                    ],

                    [
                        'name'      => 'type',
                        'type'      => 'radio',
                        'title'     => '栏目类型',
                        'options'     => [
                            [
                                'name' => '列表',
                                'value' => '1',
                                'title' => '列表',
                            ],
                            [
                                'name'      => '单页',
                                'value'      => '2',
                                'title'      => '单页',
                            ],
                            [
                                'name'      => '外链',
                                'value'      => '3',
                                'title'      => '外链',
                            ],
                            [
                                'name' => '产品',
                                'value' => '4',
                                'title' => '产品',
                            ],
                            [
                                'name' => '新闻',
                                'value' => '5',
                                'title' => '新闻',
                            ],

                        ],
                    ],


                ],
            ],

            [
                'title'  => '栏目内容',
                'name'   => 'content',
                'icon'   => '',
                'fields' => [
                    [
                        'name'      => 'content',
                        'type'      => 'editor',
                        'title'     => '栏目内容',
                        'editor' => 'textarea-content',
                    ],


                ],
            ],
            [
                'title'  => '栏目模板',
                'name'   => 'other',
                'icon'   => '',
                'fields' => [

                    [
                        'name'      => 'page_tmp',
                        'type'      => 'text',
                        'title'     => '单页模板',
                        'placeholder' => '默认：index_article.htm', 
                        'maxlength' => 120,
                    ],
                    [
                        'name'      => 'lst_tmp',
                        'type'      => 'text',
                        'title'     => '列表模板',
                        'placeholder' => '默认：list_article.htm', 
                        'maxlength' => 120,
                    ],
                    [
                        'name'      => 'article_tmp',
                        'type'      => 'text',
                        'title'     => '详情模板',
                        'placeholder' => '默认：article_article.htm', 
                        'maxlength' => 120,
                    ],
                    [
                        'name'      => 'keywords',
                        'type'      => 'text',
                        'title'     => '关键词语',
                        'maxlength' => 120,
                    ],
                    [
                        'name'      => 'desc',
                        'type'      => 'textarea',
                        'title'     => '栏目描述',
                        'maxlength' => 250,
                    ],
                    [
                        'name'      => 'link',
                        'type'      => 'text',
                        'title'     => '跳转链接',
                        'placeholder' => '示例：https://www.baidu.com/',
                        'maxlength' => 240,
                    ],
                    [
                        'name'      => 'video',
                        'type'      => 'text',
                        'title'     => '视频链接',
                        'placeholder'     => '腾讯/优酷iframe地址',
                        'maxlength' => 240,
                    ]


                ],
            ],
        ];
    }
}
