<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\form;

class RyConfFields
{

    public static function getFormTabs(): array
    {
        return [
            [
                'title'  => '基本内容',
                'name'   => 'base',
                'icon'   => '',
                'fields' => [
                    [
                        'name'        => 'title',
                        'type'        => 'text',
                        'title'       => '字段名称',
                        'required'    => true,
                        'maxlength'   => 120,
                        'verify'      => 'required',
                        'placeholder' => '最多120个字符',
                    ],
                    [
                        'name'        => 'ename',
                        'type'        => 'text',
                        'title'       => '字段标识',
                        'required'    => true,
                        'maxlength'   => 20,
                        'verify'      => 'required',
                        'placeholder' => '必须为10位以内小写英文字母',
                    ],


                    [
                        'name'        => 'model',
                        'type'        => 'radio',
                        'title'       => '字段标识',
                        'options'     => [
                            ['title'  => '基本配置', 'value' => '1'],
                            ['title'  => 'Logo图片', 'value' => '2'],
                            ['title'  => '联系方式', 'value' => '3'],
                            ['title'  => '系统字段', 'value' => '4'], 
                        ],

                    ],
                    [
                        'name'        => 'type',
                        'type'        => 'radio',
                        'title'       => '字段类型',
                        'required'    => true,
                        'verify'      => 'required',
                        'options'     => [
                            ['title'  => '单行文本', 'value' => '1'],
                            ['title'  => '多行文本', 'value' => '2'],
                            ['title'  => '单选按钮', 'value' => '3'],
                            ['title'  => '复选框', 'value' => '4'],
                            ['title'  => '下拉菜单', 'value' => '5'],
                            ['title'  => '附件', 'value' => '6'],
                        ],

                    ],
                    [
                        'name'      => 'values',
                        'type'      => 'textarea',
                        'title'     => '选项列表',
                        'maxlength' => 250,
                        'placeholder' => '单选/复选/下拉必填！多个选项用英文逗号分隔，举例：男,女,其他',
                    ],
                    [
                        'name'        => 'value',
                        'type'        => 'text',
                        'title'       => '默认内容',
                        'maxlength'   => 120,
                    ],

                ],
            ],

        ];
    }
}
