<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\form;

class RyLinkFields
{

    public static function getFormTabs(): array
    {
        return [
            [
                'title'  => '基本内容',
                'name'   => 'base',
                'icon'   => '',
                'fields' => [
                    [
                        'name'        => 'type',
                        'type'        => 'radio',
                        'title'       => '链接类型',
                        'required'    => true,
                        'verify'      => 'required',
                        'options'     => [
                            [
                                'title'  => '文字链接',
                                'value' => '1',
                            ],
                            [
                                'title'  => '图片链接',
                                'value' => '2',
                            ]
                        ],

                    ],
                    [
                        'name'        => 'title',
                        'type'        => 'text',
                        'title'       => '链接标题',
                        'required'    => true,
                        'maxlength'   => 120,
                        'verify'      => 'required',
                        'placeholder' => '标题最多120个字符',
                    ],
                    [
                        'name'    => 'thumb',
                        'type'    => 'image',
                        'title'   => '链接图片',
                        'placeholder'   => '请上传小于600kb、jpg、jpeg、png、gif格式图片。',
                    ],
                    [
                        'name'        => 'url',
                        'type'        => 'text',
                        'title'       => '链接地址',
                        'placeholder' => 'https://',
                        'maxlength'   => 120,
                    ],
                    [
                        'name'      => 'desc',
                        'type'      => 'textarea',
                        'title'     => '链接描述',
                        'maxlength' => 250,
                    ],
                ],
            ],

        ];
    }
}
