<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\list;

use think\facade\Request;
use app\royaladmin\model\RyAdpos;

class RyAdList
{

    public static function getListConfig(): array
    {
        $type = Request::param('adposid');

        // ==================== 获取广告位数据用于导航菜单 ====================
        $adposList = RyAdpos::order('sort', 'asc')
            ->select()
            ->toArray();

        $navItems = [];
        foreach ($adposList as $adpos) {
            $navItems[] = [
                'title' => $adpos['title'],
                'url' => url('ad/lst', ['adposid' => $adpos['id']]),
                'active' => $type == $adpos['id'] // 判断当前是否选中
            ];
        }

        // ==================== 表格列配置 ====================
        $cols = [
            [
                'type' => 'checkbox',
                'fixed' => 'left'
            ],
            [
                'field' => 'id',
                'title' => 'ID',
                'width' => 70,
                'sort' => true,
                'align' => 'center'
            ],
            [
                'field' => 'sort',
                'title' => '排序',
                'width' => 60,
                'align' => 'center',
                'edit' => 'text',
                'templet' => '#sortTpl'
            ],
            [
                'field' => 'thumb',
                'title' => '广告图片',
                'width' => 120,
                'align' => 'center',
                'templet' => '#thumbTpl'
            ],
            [
                'field' => 'title',
                'title' => '广告图片标题',
                'sort' => true
            ],
            [
                'field' => 'stitle',
                'title' => '广告图片副标题',
            ],
            
            [
                'field' => 'status',
                'title' => '启用',
                'width' => 60,
                'templet' => '#statusTpl',
                'align' => 'center'
            ],
            [
                'fixed' => 'right',
                'title' => '基本操作',
                'toolbar' => '#barEdit',
                'width' => 100,
                'align' => 'center'
            ],
        ];

        // ==================== 工具栏配置 ====================
        $toolbar = [
            [
                'url'    => url('ad/form', ['adposid' => $type]),
                'params' => [
                    'width'  => '1200px',
                    'height' => '95%',
                ],
                'event'  => 'openform',
                'icon'   => 'layui-icon-addition',
                'text'   => '添加广告图片',
            ],
            [
                'url'    => url('ad/del'),
                'params' => [],
                'event'  => 'del',
                'icon'   => 'layui-icon-delete',
                'text'   => '批量删除',
                'class'  => 'layui-btn-danger',
            ],
            [
                'url'    => url('adpos/lst'),
                'text'   => '返回广告位列表',
                'params' => [],
                'event'  => '',
                'icon'   => 'layui-icon-tabs',
                'class'  => 'layui-btn-normal',
            ],
        ];

        // ==================== 行操作配置 ====================
        $actions = [
            [
                'url' => url('ad/form') . '?id=',
                'text' => '编辑',
                'event' => 'openform',
                'params' => [
                    'width' => '1200px',
                    'height' => '95%'
                ]
            ],
            [
                'url' => url('ad/del') . '?id=',
                'text' => '删除',
                'color' => 'red',
                'event' => 'del'
            ],
        ];

        // ==================== 搜索字段配置 ====================
        $searchFields = [
            [
                'type'        => 'text',
                'name'        => 'title',
                'placeholder' => '请输入广告图片标题',
            ],
            [
                'type'        => 'select',
                'name'        => 'status',
                'placeholder' => '状态',
                'width'       => '80px',
                'options'     => [
                    [
                        'value' => 1,
                        'name' => '启用'
                    ],
                    [
                        'value' => 0,
                        'name' => '隐藏'
                    ],
                ],
            ],
        ];

        // ==================== 返回配置数组 ====================
        return [
            'cols'         => json_encode([$cols], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE),
            'toolbar'      => $toolbar,
            'actions'      => $actions,
            'searchFields' => $searchFields,
            'dataUrl'      => url('ad/getAdData', [
                'adposid' => $type,
                'status' => Request::param('status')
            ]),
            'model'        => 'ad',
            'navItems'     => $navItems, // 返回广告位导航菜单
            'listTitle'    => '广告图片列表',
            'viewParams'   => [
                'type'       => $type,
                'moduleType' => 'ad'
            ]
        ];
    }
}
