<?php

namespace app\royaladmin\fields\list;

class RyAdposList
{
    /**
     * 获取图片位置列表配置
     * @return array 列表配置数组
     */
    public static function getListConfig(): array
    {
        // ==================== 表格列配置 ====================
        $cols = [
            [
                'field' => 'id',
                'title' => 'ID',
                'width' => 70,
                'sort' => true,
                'align' => 'center'
            ],
            [
                'field'   => 'sort',
                'title'   => '排序',
                'width'   => 60,
                'align'   => 'center',
                'edit'    => 'text',
                'templet' => '#sortTpl',
            ],
            [
                'field' => 'title',
                'title' => '广告位置',
                'sort' => true,
                'templet' => '#urlTpl'
            ],
            [
                'field' => 'ads_count',
                'title' => '广告数量',
                'align' => 'center',
                'width' => 120,
                'sort' => true
            ],
            [
                'field' => 'width',
                'title' => '广告图片宽度',
                'align' => 'center',
                'width' => 120
            ],
            [
                'field' => 'height',
                'title' => '广告图片高度',
                'align' => 'center',
                'width' => 120
            ],
            [
                'fixed' => 'right',
                'title' => '基本操作',
                'toolbar' => '#barEdit',
                'width' => 200,
                'align' => 'center'
            ],
        ];

        // ==================== 工具栏配置 ====================
        $toolbar = [
            [
                'url'    => url('adpos/form'),
                'params' => [
                    'width'  => '640px',
                    'height' => '400px',
                ],
                'event'  => 'openform',
                'icon'   => 'layui-icon-addition',
                'text'   => '添加广告位置',
            ],
        ];

        // ==================== 行操作配置 ====================
        $actions = [
            [
                'url' => url('ad/form') . '?adposid=',
                'text' => '添加广告图片',
                 'color' => 'green',
                'event' => 'openform',
                     'params' => [
                    'width'  => '1200px',
                    'height' => '95%',
                ],
            ],
            [
                'url' => url('adpos/form') . '?id=',
                'text' => '编辑',
                'event' => 'openform',
                'params' => [
                    'width' => '640px',
                    'height' => '400px'
                ]
            ],
            [
                'url' => url('adpos/del') . '?id=',
                'text' => '删除',
                'color' => 'red',
                'params' => [],
                'event' => 'del'
            ],
        ];

        // ==================== 视图参数 ====================
        $viewParams = [
            'colsUrl' => '/royalcms/ad/lst.html?adposid=',
        ];

        // ==================== 返回配置数组 ====================
        return [
            'cols'         => json_encode([$cols], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE),
            'toolbar'      => $toolbar,
            'actions'      => $actions,
            'searchFields' => [],
            'dataUrl'      => url('adpos/getAdposData'),
            'model'        => 'adpos',
            'navItems'     => [],
            'listTitle'    => '图片位置列表',
            'viewParams'   => $viewParams
        ];
    }
}
