<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\list;

use think\facade\Request;
use app\royaladmin\model\RyCate;

class RyArticleList
{
    /**
     * 获取文档列表配置
     * @return array 列表配置数组
     */
    public static function getListConfig(): array
    {
        $type = Request::param('cateid'); // 获取栏目ID参数[2](@ref)

        // ==================== 表格列配置 ====================
        $cols = [
            [
                'type'  => 'checkbox',
                'fixed' => 'left',
            ],
            [
                'field' => 'id',
                'title' => 'ID',
                'width' => 70,
                'sort'  => true,
                'align' => 'center',
            ],
            [
                'field'   => 'sort',
                'title'   => '排序',
                'width'   => 60,
                'align'   => 'center',
                'edit'    => 'text',
                'templet' => '#sortTpl',
            ],
            [
                'field' => 'title',
                'title' => '文档标题',
                'sort'  => true,
            ],
            [
                'field'   => 'thumb',
                'title'   => '封面',
                'width'   => 80,
                'align'   => 'center',
                'templet' => '#thumbTpl',
            ],

            [
                'field' => 'create_time',
                'title' => '创建时间',
                'width' => 120,
                'align' => 'center',
                'sort'  => true,
            ],
            [
                'field'   => 'type',
                'title'   => '属性',
                'width'   => 60,
                'templet' => '#artTypeTpl',
                'align'   => 'center',
            ],
            [
                'field'   => 'is_index',
                'title'   => '首显',
                'width'   => 60,
                'templet' => '#indexTpl',
                'align'   => 'center',
            ],
            [
                'field'   => 'status',
                'title'   => '启用',
                'width'   => 60,
                'templet' => '#statusTpl',
                'align'   => 'center',
            ],
            [
                'fixed'   => 'right',
                'title'   => '基本操作',
                'toolbar' => '#barEdit',
                'width'   => 140,
                'align'   => 'center',
            ],
        ];

        // ==================== 工具栏配置 ====================
        $toolbar = [
            [
                'url'    => url('article/form', ['cateid' => $type]),
                'params' => ['width' => '90%', 'height' => '98%'],
                'event'  => 'openform',
                'icon'   => 'layui-icon-addition',
                'text'   => '添加文档',
            ],
            [
                'url'    => url('article/moveAll'),
                'text'   => '批量移动',
                'params' => ['height' => '98%'],
                'event'  => 'moveAll',
                'icon'   => 'layui-icon-release',
                'class'  => 'layui-btn-normal',
            ],
            [
                'url'    => url('article/del'),
                'params' => [],
                'event'  => 'del',
                'icon'   => 'layui-icon-delete',
                'text'   => '批量删除',
                'class'  => 'layui-btn-danger',
            ],

        ];

        // ==================== 行操作配置 ====================
        $actions = [
            [
                'url'    => url('article/form', ['id' => '']),
                'text'   => '编辑',
                'event'  => 'openform',
                'params' => ['width' => '90%', 'height' => '98%'],
            ],
            [
                'url'    => url('article/del', ['id' => '']),
                'text'   => '删除',
                'color'  => 'red',
                'event'  => 'del',
            ],
            [
                'url'    => '/article',
                'text'   => '预览',
                'color'  => 'gray',
                'event'  => 'none',
            ],
        ];

        // ==================== 搜索字段配置 ====================
        $searchFields = [
            [
                'type'        => 'text',
                'name'        => 'title',
                'placeholder' => '请输入文档标题',
            ],
            [
                'type'        => 'select',
                'name'        => 'status',
                'placeholder' => '状态',
                'width'       => '80px',
                'options'     => [
                    ['value' => 1, 'name' => '启用'],
                    ['value' => 0, 'name' => '关闭'],
                ],
            ],
        ];

        // ==================== 返回配置数组 ====================
        return [
            'cols'         => json_encode([$cols], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE),
            'toolbar'      => $toolbar,
            'actions'      => $actions,
            'searchFields' => $searchFields,
            'dataUrl'      => url('article/getArtData', [
                'cateid' => $type,
                'status' => Request::param('status')
            ]),
            'model'        => 'article',
            'navItems'     => [],
            'listTitle'    => '文档列表',
            'viewParams'   => [
                'type'       => $type,
                'cateRes'    => RyCate::getTreeData(withPrefix: false),
                'moduleType' => 'article'
            ]
        ];
    }
}
