<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\list;

use think\facade\Request;
use think\facade\Session;
use app\royaladmin\model\RyAuthGroup;

class RyAuserList
{

    public static function getListConfig(): array
    {
        $currentUserId = Session::get('auser_id');
        $currentGroupId = Session::get('auser_gid');

        // ==================== 表格列配置 ====================
        $cols = [
            [
                'field' => 'id',
                'title' => 'ID',
                'width' => 70,
                'sort' => true,
                'align' => 'center'
            ],
            [
                'field' => 'group_title',
                'title' => '所属用户组',
                'width' => 120,
                'align' => 'center'
            ],
            [
                'field' => 'title',
                'title' => '用户名称',
                'sort' => true
            ],
            [
                'field' => 'is_current',
                'title' => '是否当前登录用户',
                'width' => 200,
                'align' => 'center',
                'templet' => '#currentUserTpl'
            ],
            [
                'field' => 'status',
                'title' => '显示',
                'width' => 60,
                'templet' => '#statusTpl',
                'align' => 'center'
            ],
            [
                'fixed' => 'right',
                'title' => '操作',
                'toolbar' => '#barEdit',
                'width' => 150,
                'align' => 'center'
            ]
        ];

        // ==================== 导航菜单配置 ====================
        $navItems = [];
        if ($currentGroupId <= 2) {
            $navItems = [
                [
                    'url' => url('auser/lst'),
                    'title' => '用户列表',
                    'active' => 1
                ],
                [
                    'url' => url('group/lst'),
                    'title' => '用户组表',
                    'active' => 0
                ]
            ];
            
            // 仅超级管理员显示权限列表
            if ($currentUserId == 1) {
                $navItems[] = [
                    'url'    => url('rule/lst'),
                    'title'  => '权限列表',
                    'active' => 0
                ];
            }
        }

        // ==================== 工具栏配置 ====================
        $toolbar = [];
        if ($currentGroupId <= 2) {
            $toolbar = [
                [
                    'url' => url('auser/add'),
                    'params' => [
                        'width' => '600px',
                        'height' => '400px'
                    ],
                    'event' => 'openform',
                    'icon' => 'layui-icon-addition',
                    'text' => '添加用户'
                ],
                [
                    'url' => url('log/lst'),
                    'text' => '登录日志',
                    'params' => [],
                    'event' => '',
                    'icon' => 'layui-icon-tabs',
                    'class' => 'layui-btn-normal'
                ],
                [
                    'url' => url('action/lst'),
                    'text' => '操作日志',
                    'params' => [],
                    'event' => '',
                    'icon' => 'layui-icon-link',
                    'class' => 'layui-btn-warm'
                ]
            ];
        }

        // ==================== 行操作配置 ====================
        $actions = [
            [
                'url' => url('auser/edit') . '?id=',
                'text' => '修改密码',
                'event' => 'openform',
                'params' => [
                    'width' => '600px',
                    'height' => '400px'
                ]
            ],
        ];

        // 仅超级管理员显示删除按钮
        if ($currentUserId == 1) {
            $actions[] = [
                'url' => url('auser/del') . '?id=',
                'text' => '删除',
                'color' => 'red',
                'params' => [],
                'event' => 'del'
            ];
        }

        // ==================== 搜索字段配置 ====================
        $searchFields = [
            // 用户列表暂时不需要搜索字段，可根据需要添加
            // [
            //     'type'        => 'text',
            //     'name'        => 'title',
            //     'placeholder' => '请输入用户名称',
            // ],
        ];

        // ==================== 返回配置数组 ====================
        return [
            'cols'         => json_encode([$cols], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE),
            'toolbar'      => $toolbar,
            'actions'      => $actions,
            'searchFields' => $searchFields,
            'dataUrl'      => url('auser/getUserData'),
            'model'        => 'Auser',
            'navItems'     => $navItems,
            'listTitle'    => '用户列表',
            'viewParams'   => [
                'moduleType' => 'auser'
            ]
        ];
    }

    /**
     * 获取树形结构数据（供表单使用）
     */
    public static function getGroupTreeData(): array
    {
        return RyAuthGroup::getTreeData(
            withPrefix: true,
            fields: ['id', 'pid', 'title', 'status', 'title_auth'],
            scope: 'filterSuperAdmin'
        );
    }
}