<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\list; 
class RyCateList 
{
    /**
     * 获取栏目列表配置
     * @return array 列表配置数组
     */
    public static function getListConfig(): array 
    {
        // 表格列配置
        $cols = [
            [
                'field' => 'id',
                'title' => 'ID',
                'width' => 70,
                'sort'  => true,
                'align' => 'center',
            ],
            [
                'field'   => 'sort',
                'title'   => '排序',
                'width'   => 60,
                'align'   => 'center',
                'edit'    => 'text',
                'templet' => '#sortTpl',
            ],
            [
                'field'   => 'title',
                'title'   => '栏目名称',
                'templet' => '#treeTitleTpl',
            ],
        
            [
                'field'   => 'thumb',
                'title'   => '封面',
                'width'   => 80,
                'align'   => 'center',
                'templet' => '#thumbTpl',
            ],
            [
                'field'   => 'background',
                'title'   => '背景',
                'width'   => 80,
                'align'   => 'center',
                'templet' => '#backgroundTpl',
            ],
            [
                'field'   => 'art_count',
                'title'   => '文章数',
                'width'   => 70,
                'align'   => 'center', 
            ],
            [
                'field'   => 'type',
                'title'   => '类型',
                'width'   => 70,
                'align'   => 'center',
                'templet' => '#catetypeTpl',
            ],
     
            [
                'field'   => 'navmenu',
                'title'   => '导航',
                'width'   => 70,
                'templet' => '#navmenuTpl',
                'align'   => 'center',
            ],
            [
                'field'   => 'status',
                'title'   => '启用',
                'width'   => 70,
                'templet' => '#statusTpl',
                'align'   => 'center',
            ],
            [
                'fixed'   => 'right',
                'title'   => '基本操作',
                'toolbar' => '#barEdit',
                'width'   => 180,
                'align'   => 'center',
            ],
        ];

        // 表头操作配置
        $toolbar = [
            [
                'url'    => url('cate/form'),
                'params' => ['height' => '98%'],
                'event'  => 'openform',
                'icon'   => 'layui-icon-addition',
                'text'   => '添加栏目',
            ],
            [
                'url'    => '',
                'params' => [],
                'text'   => '全部展开',
                'event'  => 'expandAll',
                'icon'   => 'layui-icon-down',
                'class'  => 'layui-btn-primary'
            ],
            [
                'url'    => '',
                'params' => [],
                'text'   => '全部折叠',
                'event'  => 'collapseAll',
                'icon'   => 'layui-icon-up',
                'class'  => 'layui-btn-primary'
            ]
        ];

        // 表格行操作配置
        $actions = [
            [
                'url'    => url('cate/form') . '?addpid=',
                'text'   => '添加',
                  'color'  => 'green',
                'event'  => 'openform',
                'params' => [],
            ],
            [
                'url'    => url('cate/form') . '?id=',
                'text'   => '编辑',
                'event'  => 'openform',
                'params' => ['height' => '98%'],
            ],
            [
                'url'    => url('cate/del') . '?id=',
                'text'   => '删除',
                'color'  => 'red',
                'params' => [
                    'title' => '谨慎操作：删除栏目将导致关联内容失效。',
                ],
                'event'  => 'del',
            ],
            [
                'url'    => '/a'. '/',
                'text'   => '预览',
                'color'  => 'gray',
                'event'  => 'none',
            ],
        ];

        return [
            'cols'        => json_encode([$cols], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE),
            'toolbar'     => $toolbar,
            'actions'     => $actions,
            'dataUrl'     => url('cate/getCateData'),
            'model'       => 'cate',
            'navItems'    => [],
            'listTitle'   => '栏目列表',
            'isTreeTable' => true
        ];
    }
}