<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\list;

use think\facade\Request;

class RyConfList
{
    public static function getListConfig(): array
    {
        $requestParams = Request::param();
        $modelType = Request::param('model', '1');

        // ==================== 左侧导航配置 ====================
        $navItems = [
            [
                'url' => url('conf/lst', array_merge($requestParams, ['model' => '1'])),
                'title' => '基本字段',
                'active' => $modelType === '1'
            ],
            [
                'url' => url('conf/lst', array_merge($requestParams, ['model' => '2'])),
                'title' => 'Logo图片',
                'active' => $modelType === '2'
            ],
            [
                'url' => url('conf/lst', array_merge($requestParams, ['model' => '3'])),
                'title' => '联系方式',
                'active' => $modelType === '3'
            ],
            [
                'url' => url('conf/lst', array_merge($requestParams, ['model' => '4'])),
                'title' => '系统字段',
                'active' => $modelType === '4'
            ] 
        ];

        // ==================== 表格列配置 ====================
        $cols = [

            [
                'type' => 'checkbox',
                'fixed' => 'left'
            ],
            [
                'field' => 'id',
                'title' => 'ID',
                'width' => 70,
                'sort' => true,
                'align' => 'center'
            ],
            [
                'field' => 'sort',
                'title' => '排序',
                'width' => 60,
                'align' => 'center',
                'edit' => 'text',
                'templet' => '#sortTpl'
            ],
            [
                'field' => 'title',
                'title' => '字段标题',
                'sort' => true
            ],
            [
                'field' => 'model',
                'title' => '设置位置',
                'sort' => true,
                'width' => 150,
                'align' => 'center'
            ],
            [
                'field' => 'ename',
                'title' => '字段代码',
                'width' => 150,
            ],
            [
                'field' => 'type',
                'title' => '字段类型',
                'sort' => true,
                'width' => 150,
                'align' => 'center',
                'templet' => '#typeTpl'
            ],
            [
                'field' => 'status',
                'title' => '启用',
                'width' => 60,
                'templet' => '#statusTpl',
                'align' => 'center'
            ],
            [
                'fixed' => 'right',
                'title' => '操作',
                'toolbar' => '#barEdit',
                'width' => 100,
                'align' => 'center'
            ]
        ];

        // ==================== 工具栏配置 ====================
        $toolbar = [
            [
                'url' => url('conf/form'),
                'params' => [
                    'width' => '800px',
                    'height' => '560px'
                ],
                'event' => 'openform',
                'icon' => 'layui-icon-addition',
                'text' => '添加字段'
            ],
            [
                'url' => url('conf/del'),
                'params' => [],
                'event' => 'del',
                'icon' => 'layui-icon-delete',
                'text' => '批量删除',
                'class' => 'layui-btn-danger'
            ],
            [
                'url' => url('conf/conf', $requestParams),
                'text' => '返回配置',
                'params' => [],
                'event' => '',
                'icon' => 'layui-icon-tabs',
                'class' => 'layui-btn-normal'
            ]
        ];

        // ==================== 行操作配置 ====================
        $actions = [
            [
                'url' => url('conf/form') . '?id=',
                'text' => '编辑',
                'event' => 'openform',
                'params' => [
                    'width' => '800px',
                    'height' => '560px'
                ]
            ]
        ];

        // ==================== 搜索字段配置 ====================
        $searchFields = [
            [
                'type' => 'text',
                'name' => 'title',
                'placeholder' => '请输入字段标题',
            ],
            [
                'type' => 'select',
                'name' => 'status',
                'placeholder' => '状态',
                'width'       => '80px',
                'options' => [
                    ['value' => 1, 'name' => '启用'],
                    ['value' => 0, 'name' => '隐藏']
                ]
            ]
        ];

        // ==================== 返回配置数组 ====================
        return [
            'cols' => json_encode([$cols], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE),
            'toolbar' => $toolbar,
            'actions' => $actions,
            'searchFields' => $searchFields,
            'navItems' => $navItems,
            'dataUrl' => url('conf/getConfData', $requestParams),
            'model' => 'conf',
            'listTitle' => '配置字段列表',
            'viewParams' => [
                'modelType' => $modelType
            ]
        ];
    }
}
