<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\list;

use think\facade\Session;

class RyDownLogList
{

    public static function getListConfig(): array
    {
        $currentUserId = Session::get('auser_id');

        // ==================== 表格列配置 ====================
        $cols = [
            [
                'type' => 'checkbox',
                'fixed' => 'left'
            ],
            [
                'field' => 'id',
                'title' => 'ID',
                'width' => 70,
                'sort'  => true,
                'align' => 'center'
            ],
            [
                'field' => 'ip',
                'title' => 'IP地址',
                'width' => 140,
                'align' => 'center'
            ],
            [
                'field' => 'platform',
                'title' => '操作系统',
                'width' => 120,
                'align' => 'center'
            ],
            [
                'field' => 'browser',
                'title' => '浏览器',
                'width' => 120,
                'align' => 'center',
                'templet' => function($d) {
                    $ua = $d['user_agent'] ?? '';
                    if (strpos($ua, 'Chrome')) return 'Chrome';
                    if (strpos($ua, 'Firefox')) return 'Firefox';
                    if (strpos($ua, 'Safari')) return 'Safari';
                    if (strpos($ua, 'Edge')) return 'Edge';
                    if (strpos($ua, 'MicroMessenger')) return '微信';
                    return '其他';
                }
            ],
            [
                'field' => 'language',
                'title' => '语言',
                'width' => 100,
                'align' => 'center'
            ],
            [
                'field' => 'referrer',
                'title' => '来源页面',
                'minWidth' => 200,
                'templet' => function($d) {
                    $referrer = $d['referrer'] ?? '';
                    if (empty($referrer)) return '直接访问';
                    return '<a href="' . $referrer . '" target="_blank" title="' . $referrer . '">' . 
                           (strlen($referrer) > 40 ? substr($referrer, 0, 40) . '...' : $referrer) . 
                           '</a>';
                }
            ],
            [
                'field' => 'download_time',
                'title' => '下载时间',
                'width' => 180,
                'sort'  => true,
                'align' => 'center'
            ],
            [
                'field' => 'create_time',
                'title' => '记录时间',
                'width' => 180,
                'sort'  => true,
                'align' => 'center'
            ],
        ];

        // ==================== 导航菜单配置 ====================
        $navItems = [
            [
                'url'    => url('log/lst'),
                'title'  => '登录日志',
                'active' => 0,
            ],
            [
                'url'    => url('action/lst'),
                'title'  => '操作日志',
                'active' => 0,
            ],
             [
                'url'    => url('downlog/lst'),
                'title'  => '下载日志',
                'active' => 1,
            ],
        ];

        // ==================== 工具栏配置 ====================
        $toolbar = [];
 

        // ==================== 行操作配置 ====================
        $actions = [ ];

        // ==================== 搜索字段配置 ====================
        $searchFields = [ 
        ];

        // ==================== 返回配置数组 ====================
        return [
            'cols'         => json_encode([$cols], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE),
            'toolbar'      => $toolbar,
            'actions'      => $actions,
            'searchFields' => $searchFields,
            'dataUrl'      => url('downlog/getDownLogData'),
            'model'        => 'downlog',
            'navItems'     => $navItems,
            'listTitle'    => '下载日志管理',
            'viewParams'   => [
                'moduleType' => 'downlog'
            ]
        ];
    }
}