<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\list;

class RyFormList
{

    public static function getListConfig(): array
    {
        // ==================== 表格列配置 ====================
        $cols = [
            [
                'type'   => 'checkbox', 
                'fixed'  => 'left'
            ],
            [
                'field'  => 'id', 
                'title'  => 'ID', 
                'width'  => 70, 
                'sort'   => true, 
                'align'  => 'center'
            ], 
            [
                'field'  => 'name',
                'title'  => '姓名', 
                'width'  => 120
            ],
            [
                'field'  => 'phone',
                'title'  => '电话', 
                'width'  => 120
            ],
            [
                'field'  => 'email',
                'title'  => '邮箱', 
                'width'  => 120
            ],
            [
                'field'  => 'area',
                'title'  => '公司名称',  
            ],
            [
                'field'  => 'add',
                'title'  => '地址' 
            ], 
            [
                'field'  => 'advance',
                'title'  => '留言内容' 
            ], 
            [
                'field'  => 'create_time',
                'title'  => '留言时间',
                'width'  => 160,
                'align'  => 'center',
                'sort'   => true
            ],
            [
                'field'  => 'status',
                'title'  => '显示',
                'width'  => 60,
                'templet' => '#statusTpl',
                'align'  => 'center'
            ] 
        ];

        // ==================== 导航菜单配置 ====================
        $navItems = [];

        // ==================== 工具栏配置 ====================
        $toolbar = [ 
            [
                'url'    => url('form/del'),
                'params' => [],
                'event'  => 'del',
                'icon'   => 'layui-icon-delete',
                'text'   => '批量删除',
                'class'  => 'layui-btn-danger' 
            ]
        ];

        // ==================== 行操作配置 ====================
        $actions = [
            // 留言表单通常不需要行操作，可根据需要添加
            // [
            //     'url' => url('form/detail') . '?id=',
            //     'text' => '查看详情',
            //     'event' => 'openform',
            //     'params' => [
            //         'width' => '80%',
            //         'height' => '80%'
            //     ]
            // ],
        ];

        // ==================== 搜索字段配置 ====================
        $searchFields = [
            // 可根据需要添加搜索字段
            // [
            //     'type'        => 'text',
            //     'name'        => 'name',
            //     'placeholder' => '请输入姓名',
            // ],
            // [
            //     'type'        => 'text',
            //     'name'        => 'phone',
            //     'placeholder' => '请输入电话',
            // ],
        ];

        // ==================== 返回配置数组 ====================
        return [
            'cols'         => json_encode([$cols], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE),
            'toolbar'      => $toolbar,
            'actions'      => $actions,
            'searchFields' => $searchFields,
            'dataUrl'      => url('form/getData'),
            'model'        => 'form',
            'navItems'     => $navItems,
            'listTitle'    => '留言表单',
            'viewParams'   => [
                'moduleType' => 'form'
            ]
        ];
    }
}