<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\list;

use think\facade\Session;

class RyLogList
{

    public static function getListConfig(): array
    {
        $currentUserId = Session::get('auser_id');

        // ==================== 表格列配置 ====================
        $cols = [
            [
                'type' => 'checkbox',
                'fixed' => 'left'
            ],
            [
                'field' => 'id',
                'title' => 'ID',
                'width' => 70,
                'sort'  => true,
                'align' => 'center'
            ],
            [
                'field' => 'uname',
                'title' => '管理员名称',
                'width' => 180,
            ],
            [
                'field' => 'login_time',
                'title' => '登陆时间',
                'width' => 180,
                'sort'  => true,
                'align' => 'center'
            ],
            [
                'field' => 'login_ip',
                'title' => '登陆IP',
                'width' => 180,
                'align' => 'center'
            ],
            [
                'field' => 'login_os',
                'title' => '登陆操作系统',
            ],
        ];

        // ==================== 导航菜单配置 ====================
        $navItems = [
            [
                'url'    => url('log/lst'),
                'title'  => '登录日志',
                'active' => 1,
            ],
            [
                'url'    => url('action/lst'),
                'title'  => '操作日志',
                'active' => 0,
            ] 
        ];

        // ==================== 工具栏配置 ====================
        $toolbar = [];
        if ($currentUserId === 1) {
            $toolbar = [
                [
                    'url'    => url('log/del'),
                    'params' => [],
                    'event'  => 'del',
                    'icon'   => 'layui-icon-delete',
                    'text'   => '批量删除',
                    'class'  => 'layui-btn-danger',
                ],
            ];
        }

        // ==================== 行操作配置 ====================
        $actions = [
            // 登录日志通常不需要行操作，可根据需要添加
        ];

        // ==================== 搜索字段配置 ====================
        $searchFields = [
            // 可根据需要添加搜索字段
            // [
            //     'type'        => 'text',
            //     'name'        => 'uname',
            //     'placeholder' => '请输入管理员名称',
            // ],
            // [
            //     'type'        => 'text',
            //     'name'        => 'login_ip',
            //     'placeholder' => '请输入登录IP',
            // ],
        ];

        // ==================== 返回配置数组 ====================
        return [
            'cols'         => json_encode([$cols], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE),
            'toolbar'      => $toolbar,
            'actions'      => $actions,
            'searchFields' => $searchFields,
            'dataUrl'      => url('log/getLogData'),
            'model'        => 'log',
            'navItems'     => $navItems,
            'listTitle'    => '登陆日志',
            'viewParams'   => [
                'moduleType' => 'log'
            ]
        ];
    }
}