<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\fields\list;

class RyRecycleList
{
    /**
     * 获取回收站列表配置
     * @return array 列表配置数组
     */
    public static function getListConfig(): array
    {
        // ==================== 表格列配置 ====================
        $cols = [
            [
                'type'  => 'checkbox',
                'fixed' => 'left',
            ],
            [
                'field' => 'id',
                'title' => 'ID',
                'width' => 70,
                'sort'  => true,
                'align' => 'center',
            ],
            [
                'field' => 'title',
                'title' => '文章标题',
                'sort'  => true,
            ],
            [
                'field' => 'catename',
                'title' => '所属栏目',
                'width' => 120,
                'align' => 'center',
            ],
            [
                'field' => 'delete_time',
                'title' => '删除时间',
                'width' => 160,
                'align' => 'center',
                'sort'  => true,
            ]
        ];

        // ==================== 工具栏配置 ====================
        $toolbar = [
            [
                'url'    => url('article/batchRestore'),
                'text'   => '批量还原',
                'event'  => 'batchRestore',
                'icon'   => 'layui-icon-refresh',
                'class'  => 'layui-btn-normal',
                'params' => [],
            ],
            [
                'url'    => url('article/clearRecycle'),
                'text'   => '清空回收站',
                'event'  => 'clearRecycle',
                'icon'   => 'layui-icon-delete',
                'class'  => 'layui-btn-danger',
                'params' => [],
            ],
            [
                'url'    => url('article/lst'),
                'text'   => '返回列表',
                'event'  => '',
                'icon'   => 'layui-icon-return',
                'class'  => 'layui-btn-primary',
                'params' => [],
            ]
        ];

        // ==================== 搜索字段配置 ====================
        $searchFields = [
            [
                'type'        => 'text',
                'name'        => 'title',
                'placeholder' => '请输入文章标题',
            ]
        ];

        // ==================== 返回配置数组 ====================
        return [
            'cols'         => json_encode([$cols], JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_UNESCAPED_UNICODE),
            'toolbar'      => $toolbar,
            'searchFields' => $searchFields,
            'dataUrl'      => url('article/getRecycleData'),
            'model'        => 'article',
            'navItems'     => [],
            'actions'      => [], // 回收站无需行操作按钮
            'listTitle'    => '回收站',
            'viewParams'   => [
                'cateRes' => [] // 栏目数据留空（按需补充）
            ]
        ];
    }
}