<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

return [

    // =========================================================================
    // System General
    // =========================================================================
    'add' => 'Add',
    'edit' => 'Edit',
    'delete' => 'Delete',
    'restore' => 'Restore',
    'operation' => 'Operation',

    'total' => 'Total',
    'review' => 'Review',
    'status' => 'Status',
    'sort' => 'Sort',
    'data' => 'Data',
    'all_data' => 'AllData',

    'unknown' => 'Unknown',
    'get_success' => 'Success',
    'get_failed' => 'Failed',
    'add_success' => '%s added',
    'edit_success' => '%s updated',
    'delete_success' => 'Deleted',
    'delete_success_count' => '%d %s deleted',
    'operation_success' => 'Success',
    'operation_failed' => 'Failed',
    'operation_failed_retry' => 'Failed, retry',
    'render_success' => 'Rendered',

    'illegal_request' => 'Invalid request',
    'illegal_request_operation' => 'Invalid operation',
    'invalid_parameters' => 'Invalid parameters',
    'invalid_operation' => 'Invalid operation',
    'title_required' => '%s required',
    'url_required' => 'URL required',
    'url_valid' => 'Invalid URL',

    'server_error' => 'Server error',
    'system_error' => 'System error',
    'system_busy' => 'System busy',
    'system_busy_try_later' => 'System busy',
    'system_config_error' => 'Config error',
    'system_exception' => 'System exception',
    'contact_admin' => 'Contact admin',
    'contact_technical' => 'Contact tech',

    // =========================================================================
    // Login Auth
    // =========================================================================
    'login_success' => 'Login success',
    'login_failed' => 'Login failed',
    'logout' => 'Logout',
    'logout_success' => 'Logout success',
    'logout_alert' => 'Confirm logout?',
    'already_logged_in' => 'Already logged in',
    'captcha_error' => 'Captcha error',
    'account_not_exists' => 'Account not exists',
    'account_disabled' => 'Account disabled',
    'session_expired' => 'Session expired',
    'access_denied' => 'Access denied',

    // =========================================================================
    // Permission Management
    // =========================================================================
    'no_permission_view_other_user' => 'No permission',
    'no_delete_permission' => 'No permission',
    'operation_forbidden' => 'Forbidden',
    'select_at_least_one_permission' => 'Select permission',

    // =========================================================================
    // Data Operations
    // =========================================================================
    'data_not_exists' => 'Data not exists',
    'model_pk_undefined' => 'No primary key',
    'invalid_data_selection' => 'Invalid data',
    'no_data_operation' => 'No data',
    'invalid_record_id' => 'Invalid ID',
    'record_not_exists' => 'Record not exists',
    'select_data_first' => 'Select data',
    'max_delete_limit' => 'Max 50 items',
    'no_data_found' => 'No data found',
    'model_not_exists' => 'Model not exists',

    // =========================================================================
    // File Upload
    // =========================================================================
    'upload_success' => 'Upload success',
    'upload_failed' => 'Upload failed',
    'upload_server_error' => 'Server error',
    'upload_size_exceed' => 'File too large',
    'file_size_exceed' => 'File too large',
    'invalid_file_type' => 'Invalid file type',
    'file_not_exists' => 'File not exists',
    'file_too_large' => 'File too large',
    'file_extension_error' => 'Invalid extension',
    'file_type_error' => 'Invalid file type',
    'watermark_failed' => 'Watermark failed',
    'storage_failed' => 'Storage failed',
    'path_invalid' => 'Invalid path',

    // =========================================================================
    // Status & Sort
    // =========================================================================
    'status_update_success' => 'Status updated',
    'sort_value_must_be_number' => 'Sort must be number',
    'sort_value_range' => 'Sort 0-10000',
    'sort_update_success' => 'Sort updated',

    // =========================================================================
    // Cache Management
    // =========================================================================
    'cache_clear_success' => 'Cache cleared',
    'clear_cache' => 'Clear cache',
    'clear_cache_confirm' => 'Clear cache?',

    // =========================================================================
    // Backup Management
    // =========================================================================
    'backup_data' => 'Backup',
    'backup_confirm' => 'Confirm backup?',
    'backup_success' => 'Backup success',
    'backup_failed' => 'Backup failed',
    'invalid_action_type' => 'Invalid action',
    'backup_file_not_found' => 'Backup not found',
    'backup_file_corrupted' => 'Backup corrupted',
    'backup_permission_denied' => 'No permission',

    // =========================================================================
    // Admin Home
    // =========================================================================
    'admin_home' => '后台首页',
    // 'admin_home' => 'Admin Home',
    // 'index_home' => 'Home',
    'index_home' => 'Home',
    'website_data_overview' => 'Overview',
    'quick_operations' => 'Quick actions',
    'system_information' => 'System info',
    'website_expiry_countdown' => 'Expiry countdown',
    'notes' => 'Notes',
    // 'technical_support' => 'Support',
    'technical_support' => '技术支持',
    'support_us' => 'Support us',
    // 'admin_video' => 'Video tutorial',
    'admin_video' => '视频教程',
    'admin_doc' => '开发文档',
    // 'admin_doc' => 'Documentation',
    'admin_banquan' => '© RoyalCMS V2',

    'day' => 'day',
    'hour' => 'hour',
    'minute' => 'minute',
    'second' => 'second',
    'website_expiry' => 'Expiry',

    'thank_you_for_support' => 'Thank you',
    'donation_help' => 'Help us improve',

    'wechat_consultation' => 'WeChat',
    'scan_qrcode_to_add_wechat' => 'Scan QR code',
    'wechat_qrcode' => 'WeChat QR',
    'qq_consultation' => 'QQ',
    'qq_number' => 'QQ: 2689543658',
    'consult_immediately' => 'Consult now',

    'system_version' => 'Version',
    'php_version' => 'PHP',
    'server_software' => 'Server',
    'database' => 'Database',
    'login_ip' => 'Login IP',
    'server_time' => 'Server time',
    'uptime' => 'Uptime',

    'pending_articles' => 'Pending articles',
    'all_articles' => 'All articles',
    'all_categories' => 'All categories',
    'image_ads' => 'Image ads',

    'category_list' => 'Categories',
    'article_list' => 'Articles',
    'website_settings' => 'Settings',
    'user_management' => 'Users',
    'friend_links' => 'Links',

    'data_protection' => 'Data protection',
    'data_protection_content' => 'Backup data weekly',
    'operation_specifications' => 'Operations',
    'operation_specifications_content' => 'Confirm before delete',
    'login_environment' => 'Login environment',
    'login_environment_content' => 'Use secure network',
    'account_protection' => 'Account protection',
    'account_protection_content' => 'Protect account',
    'password_management' => 'Password',
    'password_management_content' => 'Use strong password',

    'published_new_article' => 'New article: %s',
    'added_new_category' => 'New category: %s',

    'uptime_format' => '%d days %d hours %d minutes',

    'donate' => 'Donate',
    'technical' => 'Tech',

    // =========================================================================
    // Article Management
    // =========================================================================
    'article' => 'Article',
    'new_article' => 'New article',
    'add_article' => 'Add article',
    'edit_article' => 'Edit article',
    'article_success' => 'Article success',
    'article_failed' => 'Article failed',
    'article_title' => 'Title',
    'article_content' => 'Content',
    'article_cateid' => 'Category',
    'article_thumb' => 'Thumb',
    'article_tag' => 'Tags',
    'cateid_required' => 'Select category',

    'select_articles_first' => 'Select articles',
    'target_category_not_exists' => 'Category not exists',
    'batch_move_articles_log' => 'Moved %d articles',
    'batch_move_success' => 'Moved %d articles',
    'no_articles_found' => 'No articles',
    'delete_articles_log' => 'Deleted %d articles',
    'delete_articles_success' => 'Deleted %d articles',
    'operation_failed_check_log' => 'Check log',

    // =========================================================================
    // Category Management
    // =========================================================================
    'category' => 'Category',
    'new_category' => 'New category',
    'add_category' => 'Add category',
    'edit_category' => 'Edit category',
    'category_success' => 'Category success',
    'category_failed' => 'Category failed',
    'category_title' => 'Name',
    'category_ename' => 'English name',
    'category_pid' => 'Parent',
    'category_type' => 'Type',
    'ename_required' => 'English name required',

    'invalid_category_id' => 'Invalid category',
    'category_not_exists' => 'Category not exists',
    'cannot_delete_category_with_data' => 'Category has %d articles',
    'delete_category_log' => 'Deleted category %s',
    'delete_category_success' => 'Deleted category %s',

    // =========================================================================
    // Link Management
    // =========================================================================
    'link' => 'Link',
    'new_link' => 'New link',
    'add_link' => 'Add link',
    'edit_link' => 'Edit link',
    'link_success' => 'Link success',
    'link_failed' => 'Link failed',
    'link_title' => 'Title',
    'link_url' => 'URL',
    'link_thumb' => 'Icon',
    'link_type' => 'Type',

    // =========================================================================
    // Ad Management
    // =========================================================================
    'ad' => 'Ad',
    'new_ad' => 'New ad',
    'add_ad' => 'Add ad',
    'edit_ad' => 'Edit ad',
    'ad_success' => 'Ad success',
    'ad_failed' => 'Ad failed',
    'ad_title' => 'Title',
    'ad_stitle' => 'Subtitle',
    'ad_thumb' => 'Image',
    'ad_url' => 'URL',
    'ad_pos' => 'Position',
    'ad_end_time' => 'End time',
    'adposid_required' => 'Select position',
    'thumb_required' => 'Upload image',

    'adpos_not_exists' => 'Position not exists',
    'adpos_disabled' => 'Position disabled',

    // =========================================================================
    // Ad Position Management
    // =========================================================================
    'adpos' => 'Ad position',
    'new_adpos' => 'New position',
    'add_adpos' => 'Add position',
    'edit_adpos' => 'Edit position',
    'adpos_success' => 'Position success',
    'adpos_failed' => 'Position failed',
    'adpos_title' => 'Name',
    'adpos_ename' => 'English ID',
    'adpos_width' => 'Width',
    'adpos_height' => 'Height',
    'width_required' => 'Width required',
    'height_required' => 'Height required',

    'invalid_delete_params' => 'Invalid params',
    'adpos_not_exists' => 'Position not exists',
    'cannot_delete_adpos_with_ads' => 'Position has %d ads',
    'delete_adpos_failed' => 'Delete failed',
    'delete_adpos_log' => 'Deleted position %s',
    'delete_adpos_success' => 'Deleted position %s',

    // =========================================================================
    // User Management
    // =========================================================================
    'user_data' => 'Users',
    'user_list' => 'User list',
    'add_user_success' => 'User added',
    'edit_user_success' => 'User updated',
    'delete_user_success' => '%d users deleted',
    'edit_failed' => 'Update failed',
    'invalid_user_ids' => 'Invalid users',
    'service_exception' => 'Service exception',

    'add_user' => 'Add user',
    'edit_user' => 'Edit user',
    'delete_user' => 'Delete user',
    'user_data_modified' => 'User %d updated',

    // =========================================================================
    // User Group Management
    // =========================================================================
    'add_user_group' => 'Add group',
    'edit_user_group' => 'Edit group',
    'delete_group_success' => '%d groups deleted',
    'permission_update_success' => 'Permissions updated',
    'permission_update_failed' => 'Permissions failed',
    'permission_save_failed' => 'Save failed',
    'user_group_not_exists' => 'Group not exists',
    'user_group_not_exists_or_deleted' => 'Group not exists',

    'user_group_management' => 'Group management',
    'assign_permission' => 'Assign permissions',
    'delete_group' => 'Delete group',
    'user_group_operation' => 'Group operation',

    // =========================================================================
    // Permission Management
    // =========================================================================
    'permission' => 'Permission',
    'new_permission' => 'New permission',
    'add_permission' => 'Add permission',
    'edit_permission' => 'Edit permission',
    'permission_success' => 'Permission success',
    'permission_failed' => 'Permission failed',
    'permission_title' => 'Name',
    'permission_name' => 'ID',
    'permission_pid' => 'Parent',
    'permission_show' => 'Show',
    'permission_list' => 'Permissions',
    'name_required' => 'ID required',

    'delete_permission' => 'Delete permission',
    'permission_operation' => 'Permission operation',

    // =========================================================================
    // Backup Management
    // =========================================================================
    'backup_added' => 'Backup added',
    'backup_restored' => 'Backup restored',
    'backup_deleted' => 'Backup %s deleted',
    'backup_management' => 'Backup management',

    // =========================================================================
    // Config Management
    // =========================================================================
    'config_field' => 'Config field',
    'new_field' => 'New field',
    'add_config_field' => 'Add field',
    'edit_config_field' => 'Edit field',
    'config_field_success' => 'Field success',
    'config_update_success' => 'Config updated',
    'field_name' => 'Name',
    'field_ename' => 'English ID',
    'field_type' => 'Type',
    'field_model' => 'Model',
    'field_name_exists' => 'Field %s exists',
    'invalid_category_param' => 'Invalid category',
    'invalid_option' => 'Invalid %s option',
    'system_field_protected' => 'System field %s protected',
    'no_data_to_delete' => 'No data',
    'delete_config_fields_log' => 'Deleted %d fields',
    'delete_config_fields_success' => '%d fields deleted',
    'update_config_items_log' => 'Updated %d items',
    'config_data_process_exception' => 'Config exception',

    // =========================================================================
    // Log Related
    // =========================================================================
    'delete_data_log' => 'Deleted %d %s',
    'delete_failed_debug' => 'Delete failed: %d %s',
];