<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare (strict_types = 1);

namespace app\royaladmin\middleware;

use app\royaladmin\model\RyAuser; // 根据实际模型命名空间调整
use think\facade\Session;

class Check
{
        
    //-------------------------------------------------------------------------
    // 登陆判断
    //-------------------------------------------------------------------------

    public function handle($request, \Closure $next)
    {
        $isLoginPage = preg_match('/login/', $request->pathinfo());
        
        // 未登录且不在登录页，跳转到登录
        if (empty(Session::get('auser_id')) && !$isLoginPage) {
            return $this->jumpToLogin('您还未登陆系统，请先登陆！！！');
        }
    
        // 已登录用户进行会话验证
        if (Session::has('auser_id')) {
            $userId = Session::get('auser_id');
            $user = RyAuser::find($userId);
            
            if (!$user) {
                Session::clear();
                return $this->jumpToLogin('用户不存在，请重新登录！');
            }
    
       
        }
    
        return $next($request);
    }


    //-------------------------------------------------------------------------
    // 跳转接口
    //-------------------------------------------------------------------------

    private function jumpToLogin(string $message)
    {
        return view('public/exception_jump', [
            'jump_msg' => $message,
            'jump_url' => '/royalcms/website/login/index'
        ]);
    }
}