<?php
// ... 文件头部注释保持不变 ...

declare(strict_types=1);

namespace app\royaladmin\model;

use app\royaladmin\model\RyBase;
use app\royaladmin\model\traits\TreeBuilder; 

class RyCate extends RyBase
{
    //-----------------------------------------------------------------
    // 模型构造函数 - 多语言表前缀处理
    //-----------------------------------------------------------------
    public function __construct(array $data = [])
    {
        // 调用父类构造函数初始化模型数据
        parent::__construct($data);

        // 从全局常量获取当前语言设置，如果未定义则使用默认中文
        $lang = defined('CURRENT_LANG') ? CURRENT_LANG : 'zh-cn';

        // 根据语言设置表前缀：中文使用ry_，英文使用ry_en_
        $prefix = $lang === 'zh-cn' ? 'ry_' : 'ry_en_';

        // 设置当前模型对应的数据库表名（前缀 + 模型名称）
        $this->table = $prefix . $this->name;
    }

    use TreeBuilder;

    protected $name = 'cate';
    public static $chineseName = '栏目';

    // +----------------------------------------------------------------------
    // | 模型关联
    // +----------------------------------------------------------------------
    public function articles()
    {
        return $this->hasMany(RyArticle::class, 'cateid', 'id');
    } 
}