<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare (strict_types = 1);
namespace app\royaladmin\model;

use think\Model;
use think\facade\Db;
use app\royaladmin\model\RyBase;
class RyConf extends RyBase
{
    //-----------------------------------------------------------------
    // 模型构造函数 - 多语言表前缀处理
    //-----------------------------------------------------------------
    public function __construct(array $data = [])
    {
        // 调用父类构造函数初始化模型数据
        parent::__construct($data);

        // 从全局常量获取当前语言设置，如果未定义则使用默认中文
        $lang = defined('CURRENT_LANG') ? CURRENT_LANG : 'zh-cn';

        // 根据语言设置表前缀：中文使用ry_，英文使用ry_en_
        $prefix = $lang === 'zh-cn' ? 'ry_' : 'ry_en_';

        // 设置当前模型对应的数据库表名（前缀 + 模型名称）
        $this->table = $prefix . $this->name;
    }

    // +----------------------------------------------------------------------
    // | 定义数据表名称
    // +----------------------------------------------------------------------

    protected $name = 'conf';
     
    // 模型中文名称
    public static $chineseName = '配置';
     
    // +----------------------------------------------------------------------
    // | 类型获取器
    // +----------------------------------------------------------------------

    public function getTypeAttr($value)
    {
        $type = [
            1 => '单行文本',
            2 => '多行文本', 
            3 => '单选按钮', 
            4 => '复选框', 
            5 => '下拉菜单', 
            6 => '附件', 
        ];
        return $type[$value];
    }
    public function getModelAttr($value)
    {
        $type = [
            1 => '基本配置',
            2 => 'logo图片', 
            3 => '联系方式', 
            4 => '系统设置',  
        ];
        return $type[$value];
    }
 

    // +----------------------------------------------------------------------
    // | 更新
    // +----------------------------------------------------------------------

    public static function updateConfigBatch(array $configData): int
    {
        try {
            Db::startTrans();
            $updateCount = 0;

            foreach ($configData as $item) {
                // 参数安全过滤
                $id = (int)($item['id'] ?? 0);
                $value = htmlspecialchars($item['value'] ?? '', ENT_QUOTES);

                if ($id > 0) {
                    $result = self::where('id', $id)
                        ->update(['value' => $value]);

                    if ($result !== false) {
                        $updateCount++;
                    }
                }
            }

            Db::commit();
            return $updateCount;

        } catch (\Throwable $e) {
            Db::rollback();
            throw new \Exception("批量更新失败: " . $e->getMessage());
        }
    }
}
