<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\royaladmin\model;

use think\Model;

class RyDownLog extends Model
{
    // 设置表名
    protected $name = 'download_logs';
    
    // 设置主键
    protected $pk = 'id';
    
    // 自动写入时间戳
    protected $autoWriteTimestamp = true;
    protected $createTime = 'create_time';
    protected $updateTime = false;
    
    // 字段类型转换
    protected $type = [
        'id' => 'integer',
        'cookie_enabled' => 'boolean',
        'java_enabled' => 'boolean',
    ];
    
    // 搜索条件
    public function searchIpAttr($query, $value)
    {
        $query->where('ip', 'like', "%{$value}%");
    }
    
    public function searchPlatformAttr($query, $value)
    {
        $query->where('platform', $value);
    }
    
    public function searchStartTimeAttr($query, $value)
    {
        $query->whereTime('create_time', '>=', $value);
    }
    
    public function searchEndTimeAttr($query, $value)
    {
        $query->whereTime('create_time', '<=', $value);
    }
}