<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\royaladmin\model;

use think\Model;

class RyTag extends Model
{
     //-----------------------------------------------------------------
    // 模型构造函数 - 多语言表前缀处理
    //-----------------------------------------------------------------
    public function __construct(array $data = [])
    {
        // 调用父类构造函数初始化模型数据
        parent::__construct($data);

        // 从全局常量获取当前语言设置，如果未定义则使用默认中文
        $lang = defined('CURRENT_LANG') ? CURRENT_LANG : 'zh-cn';

        // 根据语言设置表前缀：中文使用ry_，英文使用ry_en_
        $prefix = $lang === 'zh-cn' ? 'ry_' : 'ry_en_';

        // 设置当前模型对应的数据库表名（前缀 + 模型名称）
        $this->table = $prefix . $this->name;
    }

   protected $name = 'tag';
    protected $autoWriteTimestamp = true;
    protected $createTime = 'create_time';
    protected $updateTime = 'update_time';

    /**
     * 获取标签树形数据
     */
    public static function getTagOptions(): array
    {
        $tags = self::where('status', 1)
            ->order('sort ASC, id ASC')
            ->select();
        
        $options = [];
        foreach ($tags as $tag) {
            $options[] = [
                'id' => $tag->getAttr('id'),
                'name' => $tag->getAttr('name'),   // 使用 getAttr 方法
                'color' => $tag->getAttr('color'),
            ];
        }
     
        return $options;
    }

    /**
     * 根据ID获取标签名称
     */
    public static function getTagNamesByIds($tagIds): array
    {
        if (empty($tagIds)) {
            return [];
        }
        
        if (is_string($tagIds)) {
            $tagIds = explode(',', $tagIds);
        }
        
        $tags = self::whereIn('id', $tagIds)
            ->where('status', 1)
            ->column('name');
            
        return array_values($tags);
    }

    /**
     * 获取热门标签
     */
    public static function getHotTags($limit = 20): array
    {
        return self::where('status', 1)
            ->order('click DESC, sort ASC')
            ->limit($limit)
            ->select()
            ->toArray();
    }
}