<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\model\traits;

trait TreeBuilder
{
    // -------------------------------------------------------------------------
    // 获取树形结构数据
    // -------------------------------------------------------------------------
    public static function getTreeData(
        bool $withPrefix = true,
        array $fields = ['*'],
        ?string $scope = null,
        array $append = [],
        array|int|null $type = null // 允许数组或单个值
    ): array {
        $query = static::field($fields)->order('sort asc,id asc');

        // 类型判断:处理 type 条件
        if ($type !== null) {
            if (is_array($type)) {
                if (!empty($type)) {
                    $query->whereIn('type', $type);
                }
            } else {
                $query->where('type', $type);
            }
        }

        if ($scope && method_exists(static::class, 'scope' . ucfirst($scope))) {
            $query->{$scope}();
        }

        $dataList = $query->select();
        
        if (!empty($append)) {
            $dataList->append($append);
        }

        return static::buildTreeData($dataList->toArray(), $withPrefix);
    }

    // -------------------------------------------------------------------------
    // 构建树形数据
    // -------------------------------------------------------------------------
    private static function buildTreeData(array $data, bool $withPrefix): array
    {
        $grouped = [];
        foreach ($data as $item) {
            $grouped[$item['pid']][] = $item;
        }

        $tree = [];
        self::buildTreeNodes(
            data: $grouped,
            pid: 0,
            result: $tree,
            level: 0,
            withPrefix: $withPrefix
        );
        return $tree;
    }

    // -------------------------------------------------------------------------
    // 递归构建树节点
    // -------------------------------------------------------------------------
    private static function buildTreeNodes(
        array &$data,
        int $pid,
        array &$result,
        int $level,
        bool $withPrefix
    ): void {
        if (!isset($data[$pid])) return;

        foreach ($data[$pid] as $node) {
            $item = $node;
            if ($withPrefix) {
                $item['title'] = str_repeat('------', $level) . '' . $item['title'];
            }
            $item['level'] = $level;
            $item['is_leaf'] = empty($data[$item['id']]);

            $result[] = $item;
            self::buildTreeNodes($data, $item['id'], $result, $level + 1, $withPrefix);
        }
    }
}