<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------


use think\facade\Route;

// +----------------------------------------------------------------------
// | 首页
// +----------------------------------------------------------------------

Route::rule('website/home', 'RyIndex/index'); // 首页

// +----------------------------------------------------------------------
// | 图片广告列表路由
// +----------------------------------------------------------------------

Route::group('ad', function () {
    Route::rule('getAdData', 'getAdData'); // 数据
    Route::rule('lst', 'lst');             // 列表
    Route::rule('form', 'form');           // 添加
    Route::rule('del', 'baseDel');         // 删除
})->prefix('RyAd/');

// +----------------------------------------------------------------------
// | 图片广告位置路由
// +----------------------------------------------------------------------

Route::group('adpos', function () {
    Route::rule('getAdposData', 'getAdposData'); // 数据
    Route::rule('lst', 'lst');                   // 列表
    Route::rule('form', 'form');                 // 添加
    Route::rule('del', 'del');                   // 删除
})->prefix('RyAdpos/');

// +----------------------------------------------------------------------
// | 文章路由
// +----------------------------------------------------------------------

Route::group('article', function () {
    Route::rule('getArtData', 'getArtData'); // 数据
    Route::rule('lst', 'lst');               // 列表
    Route::rule('recycle', 'recycle');               // 回收站
    Route::rule('getRecycleData', 'getRecycleData'); // 回收站数据接口
    Route::rule('batchRestore', 'batchRestore');     // 还原数据
    Route::rule('clearRecycle', 'clearRecycle');     // 清空回收站
    Route::rule('form', 'form');             // 添加
    Route::rule('del', 'del');               // 删除
    Route::rule('moveAll', 'moveAll');       // 移动
    Route::rule('restoreAll', 'restoreAll'); // 还原
})->prefix('RyArticle/');
 
// +----------------------------------------------------------------------
// | 栏目路由
// +----------------------------------------------------------------------

Route::group('cate', function () {
    Route::rule('getCateData', 'getCateData'); // 数据
    Route::rule('lst', 'lst');                 // 列表
    Route::rule('form', 'form');               // 添加
    Route::rule('del', 'del');                 // 删除
})->prefix('RyCate/');

// +----------------------------------------------------------------------
// | 用户路由
// +----------------------------------------------------------------------

Route::group('auser', function () {
    Route::rule('getUserData', 'getUserData'); // 数据
    Route::rule('lst', 'lst');                 // 列表
    Route::rule('add', 'add');                 // 添加
    Route::rule('edit', 'edit');               // 编辑
    Route::rule('del', 'del');                 // 删除
    Route::rule('detail', 'detail');                 // 当前用户
})->prefix('RyAuser/');

// +----------------------------------------------------------------------
// | 登录日志
// +----------------------------------------------------------------------

Route::group('log', function () {
    Route::rule('getLogData', 'getLogData'); // 数据
    Route::rule('lst', 'lst');               // 列表
    Route::rule('del', 'baseDel');           // 删除
})->prefix('RyLog/');

 
// +----------------------------------------------------------------------
// | 操作日志
// +----------------------------------------------------------------------

Route::group('action', function () {
    Route::rule('getLogData', 'getLogData'); // 数据
    Route::rule('lst', 'lst');               // 列表
    Route::rule('del', 'baseDel');           // 删除
})->prefix('RyActionLog/');

// +----------------------------------------------------------------------
// | 用户组路由
// +----------------------------------------------------------------------

Route::group('group', function () {
    Route::rule('getGroupData', 'getGroupData'); // 数据
    Route::rule('lst', 'lst');                   // 列表
    Route::rule('form', 'form');                 // 添加
    Route::rule('power', 'power');               // 权限
    Route::rule('del', 'del');                   // 删除
})->prefix('RyAuthGroup/');

// +----------------------------------------------------------------------
// | 权限路由
// +----------------------------------------------------------------------

Route::group('rule', function () {
    Route::rule('getRuleData', 'getRuleData'); // 数据
    Route::rule('lst', 'lst');                 // 列表
    Route::rule('form', 'form');               // 添加
    Route::rule('del', 'del');                 // 删除
})->prefix('RyAuthRule/');

// +----------------------------------------------------------------------
// | 备份还原
// +----------------------------------------------------------------------

Route::group('bak', function () {
    Route::rule('bak', 'bak'); // 备份
})->prefix('RyBak/');

// +----------------------------------------------------------------------
// | 公共路由
// +----------------------------------------------------------------------

Route::group('common', function () {
    Route::rule('clearCache', 'clearCache');     // 清除缓存
    Route::rule('sort', 'BaseSort');             // 修改排序
    Route::rule('changeStatus', 'changeStatus'); // 修改状态
})->prefix('RyCommon/');

// +----------------------------------------------------------------------
// | 上传路由
// +----------------------------------------------------------------------

Route::group('upload', function () {
    Route::rule('uploadimg', 'UploadImg');    // 上传图片
    Route::rule('uploadImages', 'uploadImages'); // 上传图集
    Route::rule('DeleteImg', 'DeleteImg');    // 删除图片
    Route::rule('uploadFile', 'uploadFile');  // 上传文件
})->prefix('RyUpload/');

// +----------------------------------------------------------------------
// | 设置路由
// +----------------------------------------------------------------------

Route::group('Conf', function () {
    Route::rule('conf', 'conf');               // 设置
    Route::rule('getConfData', 'getConfData'); // 数据
    Route::rule('lst', 'lst');                 // 列表
    Route::rule('form', 'form');               // 添加
    Route::rule('del', 'del');                 // 删除
})->prefix('RyConf/');

// +----------------------------------------------------------------------
// | 表单路由
// +----------------------------------------------------------------------

Route::group('Form', function () {
    Route::rule('getData', 'getData'); // 数据
    Route::rule('lst', 'lst');         // 列表
    Route::rule('del', 'baseDel');     // 删除
})->prefix('RyForm/');

// +----------------------------------------------------------------------
// | 链接路由
// +----------------------------------------------------------------------

Route::group('link', function () {
    Route::rule('getLinkData', 'getLinkData'); // 数据
    Route::rule('lst', 'lst');                 // 列表
    Route::rule('form', 'form');               // 添加
    Route::rule('del', 'baseDel');             // 删除
})->prefix('RyLink/');
  

// +----------------------------------------------------------------------
// | 登陆
// +----------------------------------------------------------------------

Route::group('website/login', function () {
    Route::rule('index', 'index');           // 登陆页面
    Route::rule('logincheck', 'logincheck'); // 登陆验证
    Route::rule('loginout', 'loginout');     // 退出登陆
})->prefix('RyLogin/');