<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\royaladmin\validate;

use think\Validate;

class RyAd extends Validate
{
    // -------------------------------
    // 验证规则定义
    // -------------------------------
    protected $rule = [
        'title'  => 'require|max:120',    // 中文标题（必填）
        'thumb'  => 'max:250',            // 中文图片路径
        'link'      => 'max:250',            // 跳转链接
        'video'     => 'max:250',            // 视频链接
        'desc'   => 'max:250',            // 中文描述
    ];

    // -------------------------------
    // 验证失败提示信息
    // -------------------------------
    protected $message = [
        'title.require' => '广告图片标题不得为空！',
        'title.max'     => '广告图片标题最多不能超过120个字符',
        'thumb.max'     => '广告图片最多不能超过250个字符',
        'link.max'         => '跳转链接最多不能超过250个字符',
        'video.max'        => '视频地址最多不能超过250个字符',
        'desc.max'      => '中文描述最多不能超过250个字符',
    ];

    // -------------------------------
    // 验证场景定义
    // -------------------------------
    protected $scene = [
        'add'  => ['title', 'thumb', 'link', 'video', 'desc'],
        'edit' => ['title', 'thumb', 'link', 'video', 'desc']
    ];
}
