<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\royaladmin\validate;

use think\Validate;

class RyAdpos extends Validate
{
    //------------------------------
    //  验证规则定义
    //------------------------------
    protected $rule = [
        'title'  => 'require|max:60', // 必须|不超过60字符|广告位唯一
        'width'  => 'require|number|between:1,10000', // 必须|数字类型|1-10000范围
        'height' => 'require|number|between:1,10000', // 必须|数字类型|1-10000范围
    ];

    //------------------------------
    //  验证提示信息
    //------------------------------
    protected $message = [
        'title.require'  => '广告位置名称不得为空！',
        'title.max'      => '广告位置名称最多不能超过60个字符',
        'width.require'  => '广告图片宽度不得为空！',
        'width.number'   => '广告图片宽度必须是数字！',
        'width.between'  => '广告图片宽度只能在1-10000之间',
        'height.require' => '广告图片高度不得为空！',
        'height.number'  => '广告图片高度必须是数字！',
        'height.between' => '广告图片高度只能在1-10000之间',
    ];

    //------------------------------
    //  验证场景定义
    //------------------------------
    protected $scene = [
        'add',  // 添加广告位场景
        'edit'  // 编辑广告位场景
    ];
}
