<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\royaladmin\validate;

use think\Validate;

class RyArticle extends Validate
{

    //------------------------------
    // 验证规则 (多语言字段校验)
    //------------------------------
    protected $rule = [
        'cateid' => 'require|checkCateid',
        'title'  => 'require|max:250',
        'desc'   => 'max:250',
        'thumb'  => 'regex:/^[\w\/\.-]+$/|max:250', // 允许英文/数字/下划线/斜线/点/横线 
    ];

    //------------------------------
    // 多语言错误提示（中英对照）
    //------------------------------
    protected $message = [
        'title.require' => '文章标题必填',
        'title.max'     => '文章标题超过250字限制',
        'desc.max'      => '文章简介超过250字限制',
        'thumb.regex' => '文章封面路径只允许英文、数字、_、/、. 和 - 字符',
        'thumb.max'   => '文章封面路径超过250字符限制',
    ];
    //------------------------------
    // 验证栏目
    //------------------------------
    protected function checkCateid($value, $rule, $data)
    {
        if ($value == 0) {
            return '必须选择有效栏目';
        }
        return true;
    }
    //------------------------------
    // 场景配置（保持操作一致性）
    //------------------------------
    protected $scene = [
        'add'  => [
            'title',
            'desc',
            'thumb',
            'cateid'
        ],
        'edit' => [
            'title',
            'desc',
            'thumb',
            'cateid'
        ]
    ];
}
