<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------


declare(strict_types=1);
// ========================================================================
// 权限角色组验证器
// ========================================================================
namespace app\royaladmin\validate;

use think\Validate;

class RyAuthGroup extends Validate
{
    //----------------------------------------------------------------------
    // 验证规则
    //----------------------------------------------------------------------
    protected $rule = [
        'title' => 'require|max:60', // 角色名称必填且最长60字
    ];

    //----------------------------------------------------------------------
    // 错误提示
    //----------------------------------------------------------------------
    protected $message = [
        'title.require' => '标题必填',
        'title.max'     => '标题最多不能超过60个字',
    ];

    //----------------------------------------------------------------------
    // 验证场景
    //----------------------------------------------------------------------
    protected $scene = [
        'add'  => ['title'],  // 新增场景验证字段
        'edit' => ['title'],  // 编辑场景验证字段
    ];
} 