<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------


declare(strict_types=1);
// ========================================================================
// 权限规则验证器
// ========================================================================
namespace app\royaladmin\validate;

use think\Validate;

class RyAuthRule extends Validate
{
    //----------------------------------------------------------------------
    // 验证规则
    //----------------------------------------------------------------------
    protected $rule = [
        'title' => 'require|max:120',    // 权限名称必填且最长120字
        'name'  => 'require|regex:^[a-zA-Z\/]+$',  // 权限代码必填，允许英文和斜杠（如：EyAd/lst）
        // 'rule'  => 'require|regex:/^[a-zA-Z0-9_\-\/]+$/'  // 必填，允许英文、数字、下划线、破折号、斜杠
    ];

    //----------------------------------------------------------------------
    // 错误提示
    //----------------------------------------------------------------------
    protected $message = [
        'title.require' => '权限名称必填',
        'title.max'     => '权限名称最多不能超过120个字',
        'name.require'  => '权限代码不能为空',
        'name.regex'    => '权限代码格式错误（示例：EyAd/lst）',
        // 'rule.require'  => '权限路由不能为空',
        // 'rule.regex'    => '权限路由只能包含英文、数字、_、-、/'
    ];

    //----------------------------------------------------------------------
    // 验证场景
    //----------------------------------------------------------------------
    protected $scene = [
        'add'  => ['title', 'name'],  // 新增场景验证字段
        'edit' => ['title', 'name']   // 编辑场景验证字段
    ];
} 