<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------


declare(strict_types=1);

namespace app\royaladmin\validate;

use think\Validate;

class RyCate extends Validate
{
    // ----------------------------------------------------------------------
    // 验证规则
    // ----------------------------------------------------------------------
    protected $rule = [
        'title'      => 'require|max:120',
        'ename'         => 'require|max:65|alphaDash|unique:cate',
        'sname'         => 'max:120',
        'thumb'         => 'max:255',
        'background'    => 'max:255',
        'link'          => 'max:255',
        'page_tmp'      => 'max:120',
        'lst_tmp'       => 'max:120',
        'article_tmp'   => 'max:120',
        'keywords'      => 'max:255',
        'desc'          => 'max:255',
    ];

    // ----------------------------------------------------------------------
    // 验证提示信息
    // ----------------------------------------------------------------------
    protected $message = [
        'title.require'  => '栏目名称不得为空！',
        'title.max'      => '栏目名称最多不能超过120个字符',
        'ename.require'     => '路由标识不能为空！',
        'ename.max'         => '路由标识最多不能超过65个字符',
        'ename.alphaDash'       => '路由标识必须为纯字母和下划线',
        'ename.unique'      => '路由标识已存在',
        'sname.max'         => '栏目简称最多不能超过60个字符',
        'thumb.max'         => '栏目封面路径长度超限',
        'background.max'    => '背景图路径长度超限',
        'link.max'          => '外链地址长度超限',
        'page_tmp.max'      => '单页模板名称长度超限',
        'lst_tmp.max'       => '列表模板名称长度超限',
        'article_tmp.max'   => '内容模板名称长度超限',
        'keywords.max'      => '关键词总长度超限',
        'desc.max'          => '栏目描述最多不能超过255字符',
    ];

    // ----------------------------------------------------------------------
    // 验证场景
    // ----------------------------------------------------------------------
    protected $scene = [
        'add'   => [
            'title',
            'ename',
            'sname',
            'thumb',
            'background',
            'link',
            'page_tmp',
            'lst_tmp',
            'article_tmp',
            'keywords',
            'desc'
        ],
        'edit'  => [
            'title',
            'ename',
            'sname',
            'thumb',
            'background',
            'link',
            'page_tmp',
            'lst_tmp',
            'article_tmp',
            'keywords',
            'desc'
        ]
    ];
}
