<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\royaladmin\validate;

use think\Validate;
 
class RyConf extends Validate
{
    // -------------------------------
    // 基础验证规则
    // -------------------------------
    protected $rule = [
        'title' => 'max:120',        // 中文名称长度限制
        'ename' => 'max:60|alpha|unique:conf', // 字段标识格式及唯一性校验
    ];

    // -------------------------------
    // 验证失败提示信息（补全版）
    // -------------------------------
    protected $message = [
        'title.max'    => '字段名称不得超过120个字符！',
        'ename.max'    => '字段标识不得超过60个字符！',   // 补充长度限制提示
        'ename.alpha'  => '字段标识必须是字母！',
        'ename.unique' => '字段标识不得重复！',
        'ename.min'    => '字段标识需至少5个字母！',     // 补充编辑场景最小长度提示
    ];

    // -------------------------------
    // 验证场景定义
    // -------------------------------
    protected $scene = ['add', 'edit'];

    // -------------------------------
    // 编辑场景特殊规则
    // -------------------------------
    public function sceneEdit()
    {
        return $this->only(['title', 'ename'])
            ->append('ename', 'min:5')  // 编辑时追加最小长度要求
            ->remove('ename', 'unique');
    }
}
