<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

declare(strict_types=1);

namespace app\royaladmin\validate;

use think\Validate;

/**
 * ------------------------------------------------------------
 * 文章数据验证器
 * ------------------------------------------------------------
 * 执行严格的内容格式校验，防止非法数据入库
 */
class RyDown extends Validate
{
    //------------------------------
    // 验证规则 (多语言字段校验)
    //------------------------------
    protected $rule = [
        // 中文标题（必填+长度）
        'title_cn'  => 'require|max:250',
        // 英文标题（长度限制）
        'title_en'  => 'max:250',
        
        // 中文简介（长度限制）
        'desc_cn'   => 'max:250',
        // 英文简介（长度限制） 
        'desc_en'   => 'max:250',
        
        // 中文缩略图（路径格式+长度）
        'thumb_cn'  => 'regex:/^[\w\/\.-]+$/|max:250', // 允许英文/数字/下划线/斜线/点/横线
        // 英文缩略图（路径格式+长度）
        'thumb_en'  => 'regex:/^[\w\/\.-]+$/|max:250'
    ];

    //------------------------------
    // 多语言错误提示（中英对照）
    //------------------------------
    protected $message = [
        // 标题相关
        'title_cn.require' => '文章标题必填',
        'title_cn.max'     => '中文标题超过250字限制',
        'title_en.max'     => '英文标题超过250字符限制',
        
        // 简介相关
        'desc_cn.max'      => '中文简介超过250字限制',
        'desc_en.max'      => '英文简介超过250字符限制',
        
        // 缩略图
        'thumb_cn.regex' => '中文缩略图路径只允许英文、数字、_、/、. 和 - 字符',
        'thumb_cn.max'   => '中文缩略图路径超过250字符限制',
        'thumb_en.regex' => '英文缩略图路径只允许英文、数字、_、/、. 和 - 字符',
        'thumb_en.max'   => '英文缩略图路径超过250字符限制'
    ];

    //------------------------------
    // 场景配置（保持操作一致性）
    //------------------------------
    protected $scene = [
        'add'  => [
            'title_cn', 'title_en',
            'desc_cn', 'desc_en',
            'thumb_cn', 'thumb_en'
        ],
        'edit' => [
            'title_cn', 'title_en',
            'desc_cn', 'desc_en',
            'thumb_cn', 'thumb_en'
        ]
    ];
}