<?php
// -----------------------------------------------------------------------------
/*!
 * RoyalCMS 若伊智能网站构建系统
 * 
 * @name      RoyalCMS 若伊智能网站构建系统
 * @version   2.0.0
 * @author    RoyalCMS Team
 * @copyright Copyright (c) 2018-2024 RoyalCMS.keeyoung.cn All rights reserved.
 * @license   MIT License
 * @homepage  https://www.royalcms.com.cn
 * 
 * 开源授权说明：
 * 允许：个人/商业免费使用、修改、分发、二次开发
 * 允许：基于本系统进行商业项目开发
 *
 * 严禁：直接打包本系统代码进行售卖
 * 严禁：将本系统作为付费产品的一部分分发
 * 严禁：去除版权信息后声称自己是原作者
 * 
 * 法律声明：
 * 任何违反上述规定的行为均构成侵权，我们将采取法律手段维护权益
 * 包括但不限于民事诉讼、刑事举报等法律途径
 * 
 * 请尊重开源精神，共建良好开源环境！
 */
// -----------------------------------------------------------------------------

namespace app\royaladmin\validate;

use think\Validate;

class RyUpload extends Validate
{
    /**
     * 验证规则
     */
    protected $rule = [
        // 文件验证规则 (最大10MB)
        'file'  => 'require|fileSize:10485760|fileExt:zip,rar,7z,pdf,doc,docx,xls,xlsx,txt,mp3,mp4,mov',
        // 图片验证规则 (最大1MB)
        'image' => 'require|fileSize:1024000|fileExt:jpg,png,gif,jpeg,webp|fileMime:image/jpeg,image/png,image/gif,image/webp'
    ];

    /**
     * 中文错误提示
     */
    protected $message = [
        // 通用必须上传
        'file.require'     => '请选择要上传的文件',
        'image.require'    => '请选择要上传的图片',

        // 文件相关
        'file.fileSize'    => '文件大小不能超过10MB',
        'file.fileExt'     => '文件类型不支持，支持格式：ZIP/RAR/7Z/PDF/Office文件/TXT/音视频',

        // 图片相关
        'image.fileSize'   => '图片大小不能超过1MB',
        'image.fileExt'    => '图片格式只支持JPG/PNG/GIF/WEBP',
        'image.fileMime'   => '图片MIME类型不合法'
    ];

    /**
     * 验证场景
     */
    protected $scene = [
        'file'  => ['file'],   // 文件上传验证
        'image' => ['image']   // 图片上传验证
    ];
 
}