<?php

return [
    'default' => env('filesystem.driver', 'public'),
    'disks'   => [
        'local'  => [
            'type'       => 'local',
            'root'       => app()->getRuntimePath() . 'storage',
            'visibility' => 'private',  // 私有文件建议改为private
        ],
        'public' => [
            'type'         => 'local',
            // 使用绝对路径确保路径明确
            'root'         => app()->getRootPath() . 'public/uploads',
            // 对外访问路径（根据实际URL结构配置）
            'url'          => env('APP_URL', '') . '/uploads',
            'visibility'   => 'public',
            // 添加写入权限控制
            'permissions'  => [
                'file' => [
                    'public'  => 0644,
                    'private' => 0644,
                ],
                'dir'  => [
                    'public'  => 0755,
                    'private' => 0755,
                ],
            ]
        ],
    ],
 
];