<?php
// 检查是否已安装
$runtimeDir = dirname(__DIR__) . DIRECTORY_SEPARATOR . 'runtime' . DIRECTORY_SEPARATOR;
$lockFile = $runtimeDir . 'install.lock';

if (file_exists($lockFile)) {
    // 已安装，包含原始的ThinkPHP入口文件
    require __DIR__ . '/index_bak.php';
    exit;
}

// 未安装，显示安装引导页面
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoyalCMS - 系统未安装</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { 
            font-family: "Microsoft YaHei", Arial, sans-serif; 
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
            height: 100vh; 
            display: flex; 
            align-items: center; 
            justify-content: center; 
            margin: 0; 
        }
        .container { 
            background: white; 
            padding: 40px; 
            border-radius: 10px; 
            text-align: center; 
            box-shadow: 0 10px 30px rgba(0,0,0,0.2); 
            max-width: 600px;
            margin: 20px;
        }
        h1 { color: #2c3e50; margin-bottom: 20px; }
        p { color: #7f8c8d; margin-bottom: 20px; line-height: 1.6; }
        .btn { 
            display: inline-block; 
            padding: 12px 30px; 
            background: #3498db; 
            color: white; 
            text-decoration: none; 
            border-radius: 5px; 
            margin: 10px; 
            transition: all 0.3s; 
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        .btn:hover { 
            background: #2980b9; 
            transform: translateY(-2px); 
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        .btn-primary { 
            background: #e74c3c; 
            font-weight: bold;
        }
        .btn-primary:hover { 
            background: #c0392b; 
        }
        .install-info {
            background: #e8f5e8;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
            color: #27ae60;
        }
        .step-indicator {
            display: flex;
            justify-content: center;
            margin: 20px 0;
        }
        .step {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #bdc3c7;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 10px;
        }
        .step.active {
            background: #3498db;
        }
        .step.completed {
            background: #27ae60;
        }
        .debug-info {
            background: #f8f9fa;
            padding: 10px;
            border-radius: 5px;
            margin: 15px 0;
            text-align: left;
            font-size: 12px;
            color: #6c757d;
        }
        .debug-info code {
            background: #e9ecef;
            padding: 2px 5px;
            border-radius: 3px;
            font-family: monospace;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>欢迎使用 RoyalCMS</h1>
        <p>检测到系统尚未安装，点击下方按钮开始安装过程。</p>
        
        <div class="step-indicator">
            <div class="step completed">1</div>
            <div class="step active">2</div>
            <div class="step">3</div>
            <div class="step">4</div>
        </div>
        
        <div class="install-info">
            <p>安装过程将自动导入数据库，创建测试账号。</p>
            <p>账号: demo, 密码: 123456</p>
        </div>
        
        <div>
            <a href="install/install.php" class="btn btn-primary">开始安装 RoyalCMS</a>
            <a href="/" class="btn">刷新页面</a>
        </div>
        
        <?php if (isset($_GET['debug'])): ?>
        <div class="debug-info">
            <p><strong>调试信息:</strong></p>
            <p>当前文件: <code><?php echo __FILE__; ?></code></p>
            <p>Runtime目录: <code><?php echo $runtimeDir; ?></code></p>
            <p>锁文件路径: <code><?php echo $lockFile; ?></code></p>
            <p>目录是否存在: <code><?php echo is_dir($runtimeDir) ? '是' : '否'; ?></code></p>
            <p>锁文件是否存在: <code><?php echo file_exists($lockFile) ? '是' : '否'; ?></code></p>
        </div>
        <?php endif; ?>
        
        <div style="margin-top: 20px; font-size: 14px; color: #95a5a6;">
            <p>安装前请确保: MySQL服务已启动，并有创建数据库的权限</p>
            <p>如果遇到问题，请<a href="?debug=1" style="color: #3498db;">查看调试信息</a></p>
        </div>
    </div>
</body>
</html>