/*
 Navicat Premium Data Transfer

 Source Server         : 本地
 Source Server Type    : MySQL
 Source Server Version : 50734
 Source Host           : localhost:3306
 Source Schema         : royalcms

 Target Server Type    : MySQL
 Target Server Version : 50734
 File Encoding         : 65001

 Date: 01/12/2025 17:37:22
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for ry_action_log
-- ----------------------------
DROP TABLE IF EXISTS `ry_action_log`;
CREATE TABLE `ry_action_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uname` varchar(50) NOT NULL DEFAULT '' COMMENT '操作人用户名',
  `module` varchar(2048) NOT NULL DEFAULT '' COMMENT '操作模块名称',
  `action` varchar(30) NOT NULL DEFAULT '' COMMENT '操作类型',
  `data_id` int(11) NOT NULL DEFAULT '0' COMMENT '操作数据ID',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '操作描述',
  `ip` varchar(45) NOT NULL DEFAULT '' COMMENT '操作IP地址(支持IPv6)',
  `os` varchar(50) NOT NULL DEFAULT '' COMMENT '客户端操作系统',
  `create_time` int(11) NOT NULL COMMENT '操作时间戳',
  `groupid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '管理员用户组ID',
  `adminid` mediumint(9) unsigned NOT NULL DEFAULT '1' COMMENT '管理员用户ID',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_create_time` (`create_time`),
  KEY `idx_uname` (`uname`),
  KEY `idx_action` (`action`),
  KEY `idx_data_id` (`data_id`),
  KEY `idx_groupid` (`groupid`),
  KEY `idx_adminid` (`adminid`),
  KEY `idx_module_prefix` (`module`(100)) COMMENT '模块名前缀索引',
  KEY `idx_group_admin` (`groupid`,`adminid`),
  KEY `idx_module_action` (`module`(50),`action`),
  KEY `idx_ip_time` (`ip`,`create_time`),
  KEY `idx_os_time` (`os`,`create_time`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统操作日志表';

-- ----------------------------
-- Records of ry_action_log
-- ----------------------------
BEGIN;
INSERT INTO `ry_action_log` VALUES (1, 'demo', '备份管理', '添加', 1, '添加备份', '::1', 'MacOS', 1764577992, 1, 1);
INSERT INTO `ry_action_log` VALUES (2, 'demo', '修改文档《品质保证》', '', 0, '', '::1', 'MacOS', 1764578027, 1, 1);
INSERT INTO `ry_action_log` VALUES (3, 'demo', '修改文档《专业团队》', '', 0, '', '::1', 'MacOS', 1764578069, 1, 1);
INSERT INTO `ry_action_log` VALUES (4, 'demo', '修改文档《专业团队》', '', 0, '', '::1', 'MacOS', 1764578094, 1, 1);
INSERT INTO `ry_action_log` VALUES (5, 'demo', '更新8个配置项', '', 0, '', '::1', 'MacOS', 1764578263, 1, 1);
INSERT INTO `ry_action_log` VALUES (6, 'demo', '添加链接《royalcms》', '', 0, '', '::1', 'MacOS', 1764578298, 1, 1);
INSERT INTO `ry_action_log` VALUES (7, 'demo', '更新8个配置项', '', 0, '', '::1', 'MacOS', 1764581265, 1, 1);
INSERT INTO `ry_action_log` VALUES (8, 'demo', '备份管理', '添加', 1, '添加备份', '::1', 'MacOS', 1764581479, 1, 1);
INSERT INTO `ry_action_log` VALUES (9, 'demo', '备份管理', '添加', 1, '添加备份', '::1', 'MacOS', 1764581805, 1, 1);
COMMIT;

-- ----------------------------
-- Table structure for ry_ad
-- ----------------------------
DROP TABLE IF EXISTS `ry_ad`;
CREATE TABLE `ry_ad` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '图片广告ID',
  `adposid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告名称',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告缩略图',
  `detailimg` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告详情图',
  `content` text COMMENT '图片广告详情内容',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1启用，0关闭',
  `sort` mediumint(9) unsigned NOT NULL DEFAULT '50' COMMENT '排序权重(数字越小越靠前)',
  `adminid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '创建者管理员ID',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间戳',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间戳',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT '软删除时间戳(0表示未删除)',
  `jump_cate` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '跳转栏目ID',
  `jump_article` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '跳转文章ID',
  `stitle` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告简略标题',
  `link` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告链接',
  `video` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告视频链接地址',
  `desc` varchar(2048) NOT NULL DEFAULT '' COMMENT '图片广告简介',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_adposid` (`adposid`),
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`),
  KEY `idx_create_time` (`create_time`),
  KEY `idx_delete_time` (`delete_time`),
  KEY `idx_jump_cate` (`jump_cate`),
  KEY `idx_jump_article` (`jump_article`),
  KEY `idx_adminid` (`adminid`),
  KEY `idx_update_time` (`update_time`),
  KEY `idx_title_prefix` (`title`(100)),
  KEY `idx_stitle` (`stitle`(100)),
  KEY `idx_link` (`link`(100)),
  KEY `idx_video` (`video`(100))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='广告内容表';

-- ----------------------------
-- Records of ry_ad
-- ----------------------------
BEGIN;
INSERT INTO `ry_ad` VALUES (1, 1, '专注芯片创新，引领智能时代', '/uploads/images/banner.jpg', '', '', 1, 50, 1, 1761787224, 1762758137, 0, 2, 0, '致力于高端芯片研发与解决方案，为全球客户提供专业技术产品与服务支持。', '', '', '');
INSERT INTO `ry_ad` VALUES (2, 1, '先进芯片工艺，赋能未来科技', '/uploads/images/banner1.jpg', '', '', 1, 50, 1, 1761787291, 1762758137, 0, 0, 0, '采用前沿制程技术，打造高性能芯片产品，满足人工智能等领域的多样化应用需求。', '', '', '');
INSERT INTO `ry_ad` VALUES (3, 1, '智能芯片方案，助力高效应用', '/uploads/images/banner2.jpg', '', '', 1, 50, 1, 1761787313, 1762758137, 0, 0, 0, '为机器学习等场景提供专用芯片，在性能表现与能效控制方面均具备优异表现。', '', '', '');
COMMIT;

-- ----------------------------
-- Table structure for ry_adpos
-- ----------------------------
DROP TABLE IF EXISTS `ry_adpos`;
CREATE TABLE `ry_adpos` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT COMMENT '图片位置ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '广告位置名称',
  `width` varchar(120) NOT NULL DEFAULT '' COMMENT '广告位置宽度(单位:px)',
  `height` varchar(120) NOT NULL DEFAULT '' COMMENT '广告位置高度(单位:px)',
  `sort` mediumint(9) unsigned NOT NULL DEFAULT '50' COMMENT '排序权重(数字越小越靠前)',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1启用，0禁用',
  `adminid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '创建者管理员ID',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间戳',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间戳',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT '软删除时间戳(0表示未删除)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`),
  KEY `idx_create_time` (`create_time`),
  KEY `idx_delete_time` (`delete_time`),
  KEY `idx_title` (`title`(50)) COMMENT '标题前缀索引',
  KEY `idx_adminid` (`adminid`),
  KEY `idx_update_time` (`update_time`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='广告位置表';

-- ----------------------------
-- Records of ry_adpos
-- ----------------------------
BEGIN;
INSERT INTO `ry_adpos` VALUES (1, '首页banner', '1920', '1080', 50, 1, 0, 0, 0, 0);
COMMIT;

-- ----------------------------
-- Table structure for ry_article
-- ----------------------------
DROP TABLE IF EXISTS `ry_article`;
CREATE TABLE `ry_article` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章ID',
  `cateid` mediumint(9) NOT NULL DEFAULT '0' COMMENT '文章对应栏目ID',
  `title` varchar(1024) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '文章标题',
  `thumb` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章缩略图',
  `annex` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章附件',
  `content` longtext CHARACTER SET utf8 COMMENT '文章内容',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '文章启用状态',
  `sort` smallint(6) unsigned NOT NULL DEFAULT '50' COMMENT '文章排序:默认50',
  `adminid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '文章对应管理员ID',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '发布时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT '删除时间',
  `stitle` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章简略标题',
  `class` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文档级别',
  `keywords` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章关键词',
  `price` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章权重',
  `description` varchar(2048) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章描述',
  `type` tinyint(1) DEFAULT '0' COMMENT '文章属性',
  `link` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章外链链接',
  `video` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章视频地址',
  `author` varchar(120) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章作者',
  `source` varchar(120) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章来源',
  `is_index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否首页显示:0-否,1-是',
  `star` mediumint(9) unsigned NOT NULL DEFAULT '30' COMMENT '文章初始点赞数',
  `images` varchar(2048) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章图集',
  `catesub` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章对应子栏目ID',
  `area` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '建筑面积',
  `coverarea` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '占地面积',
  `openrate` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '商业开业率',
  `content_xn` longtext CHARACTER SET utf8 COMMENT '性能优势',
  `content_notice` longtext CHARACTER SET utf8 COMMENT '注意事项',
  `click` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '文章初始点击数',
  `like_count` varchar(9) CHARACTER SET utf8 NOT NULL DEFAULT '50' COMMENT '文章初始点击数',
  `icon` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '图片广告详情图',
  `tag` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '标签ID集合，逗号分隔',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cateid` (`cateid`),
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`),
  KEY `idx_create_time` (`create_time`),
  KEY `idx_update_time` (`update_time`),
  KEY `idx_delete_time` (`delete_time`),
  KEY `idx_adminid` (`adminid`),
  KEY `idx_is_index` (`is_index`),
  KEY `idx_click` (`click`),
  KEY `idx_like_count` (`like_count`),
  KEY `idx_star` (`star`),
  KEY `idx_type` (`type`),
  KEY `idx_author` (`author`(50)),
  KEY `idx_source` (`source`(50)),
  KEY `idx_title_prefix` (`title`(100)),
  KEY `idx_stitle` (`stitle`(100)),
  KEY `idx_keywords` (`keywords`(100)),
  KEY `idx_tag` (`tag`(100)),
  KEY `idx_cate_status_time` (`cateid`,`status`,`create_time`),
  KEY `idx_status_delete_time` (`status`,`delete_time`,`sort`),
  KEY `idx_cate_isindex` (`cateid`,`is_index`,`sort`),
  KEY `idx_type_status_time` (`type`,`status`,`create_time`)
) ENGINE=InnoDB AUTO_INCREMENT=669 DEFAULT CHARSET=utf8mb4 COMMENT='文章管理表';

-- ----------------------------
-- Records of ry_article
-- ----------------------------
BEGIN;
INSERT INTO `ry_article` VALUES (101, 17, '芯科科技发布新一代7nm AI推理芯片XK-AI300系列', '/uploads/images/news/news1.jpg', '', '<p>芯科科技今日正式发布新一代7nm AI推理芯片XK-AI300，该芯片采用先进的7纳米工艺制程，性能较上一代产品提升300%，能效比提升50%。XK-AI300专为边缘计算和云端AI推理场景设计，支持多种神经网络模型，包括CNN、RNN、Transformer等。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/news/news5.jpg\" alt=\"AI芯片产品图\"></p><p>该芯片集成了专用的张量处理单元(张量处理单元)，支持INT8、INT16、FP16等多种精度计算，在保持高精度的同时大幅提升计算效率。XK-AI300还配备了先进的散热系统和功耗管理模块，力求在高负载下仍能保持稳定运行。</p><p>芯科科技CEO张明表示：\"XK-AI300的发布标志着我们在AI芯片领域的技术实力再上新台阶。这款芯片将为智能制造、自动驾驶、智能安防等领域提供强大的算力支持。\"</p><p>目前，XK-AI300已开始量产，并与多家行业头部企业达成合作意向。预计首批产品将于下季度交付客户使用。</p>', 1, 50, 1, 1756655748, 1756655748, 0, '芯科科技发布新一代7nm AI推理芯片，性能显著提升，专为边缘计算和云端AI推理场景设计', '', 'AI芯片,7nm工艺,推理芯片,芯科科技', '', '芯科科技发布新一代7nm AI推理芯片XK-AI300，性能提升300%，能效比提升50%，专为边缘计算和云端AI推理场景设计。', 0, '', '', '张明', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 272, '0', '', '');
INSERT INTO `ry_article` VALUES (102, 17, '芯科科技荣获2024年度科技创新企业奖项', '/uploads/images/news/news2.jpg', '', '<p>在近日举行的2024中国半导体产业创新大会上，芯科科技凭借在芯片设计领域的突出贡献，荣获\"2024年度科技创新企业奖\"。这是公司连续第三年获得该奖项，充分体现了行业对芯科科技创新能力的认可。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/news/news8.jpg\" alt=\"颁奖典礼现场\"></p><p>评委会在颁奖词中表示，芯科科技在AI芯片、物联网芯片等领域的创新成果显著，特别是在7nm工艺技术上的突破，为中国半导体产业的发展做出了重要贡献。公司的研发投入占营业收入的比例连续多年保持在20%以上，建立了完善的创新体系。</p><p>芯科科技CTO李强在领奖时表示：\"这个奖项是对我们团队不懈努力的肯定。我们将继续加大研发投入，在3nm、2nm等更先进制程上持续突破，为中国芯片产业的发展贡献力量。\"</p><p>截至目前，芯科科技已累计获得专利授权超过500项，其中发明专利占比超过60%。公司建立了从芯片设计、制造到封测的全产业链创新能力。</p>', 1, 49, 1, 1756569348, 1756569348, 0, '芯科科技凭借在芯片设计领域的突出贡献，连续三年获得科技创新企业奖项，体现行业认可', '', '科技创新奖,半导体产业,芯科科技,行业认可', '', '芯科科技荣获2024年度科技创新企业奖，连续三年获此殊荣，体现行业对公司创新能力的充分肯定。', 0, '', '', '李强', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 515, '0', '', '');
INSERT INTO `ry_article` VALUES (103, 17, '芯科科技与清华大学共建联合实验室签约', '/uploads/images/news/news3.jpg', '', '<p>芯科科技与清华大学微电子学院近日签署战略合作协议，共同成立\"先进芯片技术联合实验室\"。该实验室将聚焦于下一代芯片技术的研发，包括3nm工艺、新型存储技术、光电集成等前沿领域。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/news/news12.jpg\" alt=\"签约仪式现场\"></p><p>根据协议，芯科科技将在未来五年内投入2亿元人民币用于实验室建设和技术研发。实验室将配备国际先进的研发设备，包括电子束光刻机、原子层沉积系统等。双方还将联合培养博士、硕士研究生，为芯片产业输送高端人才。</p><p>清华大学微电子学院院长王教授表示：\"与芯科科技的合作将充分发挥校企双方的优势，推动芯片技术的创新发展。我们期待在基础研究和产业化应用方面取得显著成果。\"</p><p>联合实验室的首批研究项目已经启动，包括基于开源指令集架构架构的高性能处理器设计、存算一体芯片技术等。这些研究成果将直接应用于芯科科技的未来产品中。</p>', 1, 48, 1, 1756482948, 1756482948, 0, '芯科科技与清华大学微电子学院签署战略合作协议，共同成立先进芯片技术联合实验室', '', '校企合作,联合实验室,清华大学,芯片研发', '', '芯科科技与清华大学共建先进芯片技术联合实验室，五年投入2亿元，聚焦下一代芯片技术研发。', 0, '', '', '王教授', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 652, '0', '', '');
INSERT INTO `ry_article` VALUES (121, 18, '全球芯片市场规模2024年预计达6000亿美元', '/uploads/images/news/news4.jpg', '', '<p>根据较新发布的《2024全球半导体市场报告》，全球芯片市场规模预计将在2024年突破6000亿美元，同比增长8.5%。这一增长主要得益于人工智能、物联网、5G等新兴技术的快速发展。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/news/news9.jpg\" alt=\"全球芯片市场趋势图\"></p><p>报告显示，AI芯片市场增长最为显著，预计年增长率将达到25%以上。汽车电子芯片需求也持续旺盛，随着智能网联汽车和自动驾驶技术的发展，车规级芯片市场规模有望突破500亿美元。</p><p>从地区分布来看，亚太地区仍然是全球最大的芯片市场，占比超过60%。中国市场的表现尤为突出，在政策支持和市场需求的双重推动下，中国芯片产业保持快速增长态势。</p><p>专家分析认为，尽管面临地缘政治和供应链的挑战，但芯片产业的长期增长趋势不会改变。技术创新和产业升级将继续推动市场发展，特别是在高性能计算、边缘AI等新兴领域。</p>', 1, 50, 1, 1756396548, 1756396548, 0, '根据最新发布的全球半导体市场报告，AI芯片和汽车电子芯片成为市场主要增长动力', '', '芯片市场,半导体产业,市场规模,行业趋势', '', '2024年全球芯片市场规模预计突破6000亿美元，AI芯片和汽车电子芯片成为主要增长动力。', 0, '', '', '行业分析师', '行业研究报告', 1, 30, '', '', '', '', '', NULL, NULL, 283, '0', '', '');
INSERT INTO `ry_article` VALUES (122, 18, '3nm芯片制程技术取得重要进展突破', '/uploads/images/news/news5.jpg', '', '<p>全球半导体行业在3nm制程技术上取得重要突破，多家芯片制造商宣布3nm工艺即将量产。与5nm工艺相比，3nm工艺在性能提升30%的同时，功耗降低35%，晶体管密度提升约70%。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/news/news15.jpg\" alt=\"3nm芯片结构图\"></p><p>技术突破主要体现在晶体管结构的创新上，包括环绕栅极晶体管技术的成熟应用、新材料的使用以及制造工艺的优化。这些技术进步使得芯片在相同面积下能够集成更多晶体管，为高性能计算和AI应用提供更强算力。</p><p>业内专家表示，3nm技术的突破将推动整个电子产业的发展。智能手机、数据中心、自动驾驶等领域的性能将得到显著提升。预计到2025年，3nm芯片将占据高端芯片市场的重要份额。</p><p>与此同时，2nm工艺的研发也在加速推进。各大芯片制造商纷纷加大研发投入，力争在下一代制程技术上取得先进优势。</p>', 1, 49, 1, 1756310148, 1756310148, 0, '全球半导体行业在3nm制程技术上取得重要突破，多家芯片制造商宣布3nm工艺即将量产', '', '3nm工艺,制程技术,半导体制造,技术突破', '', '3nm芯片制程技术取得重要突破，性能提升30%，功耗降低35%，将推动电子产业新一轮升级。', 0, '', '', '技术专家', '行业技术动态', 1, 30, '', '', '', '', '', NULL, NULL, 261, '0', '', '');
INSERT INTO `ry_article` VALUES (141, 19, '芯科科技突破存算一体芯片关键技术研发', '/uploads/images/news/news6.jpg', '', '<p>芯科科技研发团队在存算一体芯片技术上取得重大突破，成功开发出基于新型忆阻器的存算一体芯片原型。该技术能够大幅提升AI计算能效，特别适合边缘计算和物联网应用场景。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/news/news18.jpg\" alt=\"存算一体芯片示意图\"></p><p>传统计算架构中，数据需要在存储器和处理器之间频繁传输，产生大量功耗和延迟。存算一体技术通过在存储器中直接进行计算，消除了数据搬运的开销，能效比提升10倍以上。</p><p>芯科科技的首款存算一体芯片采用28nm工艺制造，在图像识别任务中表现出色，功耗仅为传统架构的十分之一。研发团队正在优化设计，计划在下一代产品中采用更先进的制程工艺。</p><p>这项技术的突破将为AI在终端设备上的部署提供新的可能，使得复杂的AI算法能够在功耗受限的设备上高效运行，推动AI技术的普及应用。</p>', 1, 50, 1, 1756223748, 1756223748, 0, '芯科科技研发团队在存算一体芯片技术上取得重大突破，成功开发出基于新型忆阻器的芯片原型', '', '存算一体,忆阻器,AI芯片,技术创新', '', '芯科科技突破存算一体芯片关键技术，能效比提升10倍，为边缘AI计算提供新解决方案。', 0, '', '', '研发团队', '技术研发动态', 1, 30, '', '', '', '', '', NULL, NULL, 184, '0', '', '');
INSERT INTO `ry_article` VALUES (142, 19, '新型芯片散热技术有效提升芯片性能表现', '/uploads/images/news/news7.jpg', '', '<p>芯科科技材料实验室开发出一种新型芯片散热技术，采用石墨烯复合材料和微流体冷却系统，能够将芯片工作温度降低20°C以上，性能提升30%。这项技术突破解决了高性能芯片的散热瓶颈问题。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/news/news22.jpg\" alt=\"散热技术示意图\"></p><p>传统的散热方案在芯片功耗不断提升的背景下已经接近较高水平。芯科科技的新技术通过多层石墨烯导热膜和微通道液体冷却的协同作用，实现了高效的热量传导和散发。</p><p>测试数据显示，在相同的功耗下，采用新散热技术的芯片能够维持更高的工作频率，性能提升显著。同时，芯片的可靠性和寿命也得到大幅提升。</p><p>该技术已申请多项专利，预计将在下一代高性能计算芯片中率先应用。芯科科技正在与散热模组供应商合作，推动该技术的产业化进程。</p>', 1, 49, 1, 1756137348, 1756137348, 0, '芯科科技材料实验室开发新型芯片散热技术，采用石墨烯复合材料和微流体冷却系统', '', '散热技术,石墨烯,芯片性能,热管理', '', '芯科科技开发新型芯片散热技术，工作温度降低20°C，性能提升30%，突破散热瓶颈。', 0, '', '', '材料实验室', '技术研发动态', 1, 30, '', '', '', '', '', NULL, NULL, 246, '0', '', '');
INSERT INTO `ry_article` VALUES (161, 20, '芯科科技将参展2024全球半导体技术大会', '/uploads/images/news/news8.jpg', '', '<p>芯科科技确认参展2024全球半导体技术大会(GSCT 2024)，本次大会将于下月在上海国际会展中心举行。芯科科技将在展会上展示较新的芯片产品和解决方案，包括7nm AI芯片、物联网芯片和汽车电子芯片等。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/news/news25.jpg\" alt=\"展会预告图\"></p><p>展会期间，芯科科技将设立500平方米的特装展位，分为产品展示区、技术交流区和商务洽谈区。参观者可以亲身体验基于芯科芯片的各种应用解决方案，包括智能家居、工业自动化、自动驾驶等场景。</p><p>公司CTO李强将在大会主论坛发表题为\"AI芯片技术发展趋势与创新路径\"的主题演讲，分享芯科科技在AI芯片领域的技术洞察和研发成果。</p><p>此外，芯科科技还将在展会期间举办多场技术研讨会和合作伙伴交流会，与行业专家、客户和合作伙伴深入探讨芯片技术的发展和应用创新。</p>', 1, 50, 1, 1756050948, 1756050948, 0, '芯科科技确认参展2024全球半导体技术大会，将展示最新的芯片产品和解决方案', '', '半导体展会,技术大会,产品展示,行业交流', '', '芯科科技将参展2024全球半导体技术大会，展示最新芯片产品和解决方案，CTO发表主题演讲。', 0, '', '', '展会组委会', '活动预告', 1, 30, '', '', '', '', '', NULL, NULL, 281, '0', '', '');
INSERT INTO `ry_article` VALUES (162, 20, '芯科科技2024校园招聘活动正式启动', '/uploads/images/news/news9.jpg', '', '<p>芯科科技2024校园招聘活动正式启动，本次招聘面向全国重点高校的优秀毕业生，提供芯片设计、软件开发、算法研究等百余个岗位。公司将为新员工提供完善的培训体系和职业发展通道。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/news/news28.jpg\" alt=\"招聘宣传图\"></p><p>招聘岗位涵盖数字芯片设计、模拟芯片设计、FPGA开发、嵌入式软件、AI算法、测试工程等多个方向。芯科科技特别重视研发人才的培养，新入职的研发工程师将参与实际项目，在资深工程师的指导下快速成长。</p><p>公司人力资源总监表示：\"我们寻找对技术充满热情、具有创新精神的年轻人。芯科科技提供有竞争力的薪酬福利和广阔的发展平台，帮助优秀人才实现职业梦想。\"</p><p>校园招聘将覆盖北京、上海、南京、武汉、成都等地的重点高校，包括清华大学、北京大学、上海交通大学、浙江大学等。应聘者可以通过公司官网或招聘平台提交简历。</p>', 1, 49, 1, 1755964548, 1755964548, 0, '芯科科技2024校园招聘活动正式启动，面向全国重点高校提供芯片设计、软件开发等岗位', '', '校园招聘,人才引进,职业发展,芯科科技', '', '芯科科技启动2024校园招聘，提供芯片设计、软件开发等百余岗位，覆盖全国重点高校。', 0, '', '', '人力资源部', '招聘信息', 1, 30, '', '', '', '', '', NULL, NULL, 153, '0', '', '');
INSERT INTO `ry_article` VALUES (181, 15, '云端AI训练平台解决方案', '/uploads/images/news/news10.jpg', '', '<p>芯科科技推出完整的云端AI训练平台解决方案，基于自研的AI训练芯片和优化软件栈，为企业和科研机构提供高效的AI模型训练服务。该解决方案支持大规模分布式训练，显著缩短模型训练时间。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/news/news32.jpg\" alt=\"AI训练平台架构图\"/></p><p>解决方案核心包括XK-AI200训练芯片集群、分布式训练框架、模型管理系统和监控平台。单机柜可提供超过10PetaFLOPS的计算能力，支持千卡级别的集群扩展。</p><p>在软件层面，解决方案提供了自动混合精度训练、梯度压缩、模型并行等优化技术，训练效率提升3倍以上。同时支持深度学习框架、机器学习框架等主流深度学习框架，用户无需修改代码即可获得性能提升。</p><p>该方案已成功应用于多个行业头部客户，在自然语言处理、计算机视觉、推荐系统等场景中表现出色。客户反馈训练成本降低40%，模型迭代速度提升2倍。</p>', 1, 50, 1, 1755878148, 1762229343, 0, '芯科科技推出完整的云端AI训练平台解决方案，基于自研的AI训练芯片和优化软件栈，为企业和科研机构提供高效的AI模型训练服务。该解决方案支持大规模分布式训练，显著缩短模型训练时间。  AI训练平台架构图', '', 'AI训练,云计算,分布式训练,深度学习', '', '芯科科技云端AI训练平台解决方案，提供高效AI模型训练服务，训练效率提升3倍以上。', 0, '', '', '解决方案团队', '技术解决方案', 0, 30, '', '', '', '', '', '', NULL, 167, '0', '', '人工智能,网络安全,前端开发,后端开发,数据库');
INSERT INTO `ry_article` VALUES (182, 15, '边缘AI推理解决方案', '/uploads/images/news/news11.jpg', '', '<p style=\"text-indent: 0em; text-align: left;\">针对边缘计算场景的AI推理需求，芯科科技推出完整的边缘AI推理解决方案。该方案基于低功耗AI推理芯片XK-AI100，结合轻量级推理框架，实现在终端设备上的高效AI推理。</p><p style=\"text-align: center; text-indent: 0em;\"><img src=\"/uploads/images/news/news35.jpg\" alt=\"边缘AI应用场景\"/></p><p style=\"text-indent: 0em; text-align: left;\">解决方案支持多种边缘设备形态，包括嵌入式模组、边缘服务器和智能网关。在功耗受限的条件下，仍能提供出色的AI推理性能，满足实时性要求高的应用场景。</p><p style=\"text-indent: 0em; text-align: left;\">关键技术特性包括模型量化压缩、算子融合优化、动态功耗管理等。支持开放神经网络交换格式标准模型格式，提供模型转换工具，方便用户将训练好的模型部署到边缘设备。</p><p style=\"text-indent: 0em; text-align: left;\">该方案已广泛应用于智能安防、工业质检、自动驾驶等领域。在某智能制造项目中，实现了产线产品缺陷检测准确率99.5%，检测速度达到毫秒级别。</p>', 1, 49, 1, 1755705600, 1762229387, 0, '针对边缘计算场景的AI推理需求，芯科科技推出完整的边缘AI推理解决方案。该方案基于低功耗AI推理芯片XK-AI100，结合轻量级推理框架，实现在终端设备上的高效AI推理。', '', '边缘计算,AI推理,终端智能,实时处理', '', '芯科科技边缘AI推理解决方案，基于低功耗AI芯片，实现终端设备高效AI推理，满足实时应用需求。', 0, '', '', '解决方案团队', '技术解决方案', 0, 30, '', '', '', '', '', '', NULL, 195, '0', '', '网络安全,前端开发,大数据,数据库,5G技术,DevOps');
INSERT INTO `ry_article` VALUES (254, 100, '人工智能', '', '', NULL, 1, 50, 1, 1761793322, 1761793322, 0, '为机器学习深度学习提供高性能计算芯片支持', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-robot', '');
INSERT INTO `ry_article` VALUES (255, 100, '物联网', '', '', NULL, 1, 49, 1, 1761793322, 1761793322, 0, '低功耗连接芯片支持多种无线通信协议标准', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-wifi', '');
INSERT INTO `ry_article` VALUES (256, 100, '汽车电子', '', '', NULL, 1, 48, 1, 1761793322, 1761793322, 0, '车规级安全芯片支持自动驾驶系统安全可靠', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-car', '');
INSERT INTO `ry_article` VALUES (257, 100, '消费电子', '', '', NULL, 1, 47, 1, 1761793322, 1761793322, 0, '高性能低功耗芯片提升智能终端用户体验', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-mobile-alt', '');
INSERT INTO `ry_article` VALUES (258, 100, '工业控制', '', '', NULL, 1, 46, 1, 1761793322, 1761793322, 0, '高可靠性工业芯片适用于恶劣工作环境', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-industry', '');
INSERT INTO `ry_article` VALUES (259, 100, '5G通信', '', '', NULL, 1, 45, 1, 1761793322, 1761793322, 0, '高速数据传输芯片支持毫米波通信技术', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-satellite', '');
INSERT INTO `ry_article` VALUES (260, 2, '公司介绍', '/uploads/images/about.jpg', '', '<h3>专注芯片设计与制造的高新技术企业</h3><p>芯科科技成立于2010年，是一家专注于高端芯片设计与制造的高新技术企业。我们拥有完整的芯片研发产业链，从芯片设计、流片制造到封装测试，为客户提供一站式解决方案。</p><p>公司总部位于北京中关村科技园区，在上海、深圳、成都设有研发中心，在美国硅谷、德国慕尼黑设有海外研发机构。我们的产品广泛应用于人工智能、物联网、汽车电子、消费电子、工业控制和5G通信等领域。</p><p>芯科科技始终坚持&quot;\n技术创新、质量先进、客户至上&quot;\n的经营理念，致力于为全球客户提供创新的技术产品和服务。我们的愿景是成为全球先进的芯片设计企业，推动科技进步，创造智能未来。</p><p><br/></p>', 1, 50, 1, 1761793573, 1762248515, 0, '芯科科技是一家专注于高端芯片设计与制造的高新技术企业。我们拥有完整的芯片研发产业链，从芯片设计、流片制造到封装测试，为客户提供一站式解决方案。', '', '', '', '专注芯片设计与制造的高新技术企业芯科科技成立于2010年，是一家专注于高端芯片设计与制造的高新技术企业。我们拥有完整的芯片研发产业链，从芯片设计、流片制造到封装测试，为客户提供一站式解决方案。公司总部位于北京中关村科技园区，在上海、深圳、成都设有研发中心，在美国硅谷、德国慕尼黑设有海外研发机构。我们的产品广泛应用于人工智能、物联网、汽车电子、消费电子、工业控...', 0, '', '', '', '', 0, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (261, 3, '公司成立', '', '', '', 1, 50, 1, 1761794586, 1762244686, 0, '芯科科技在北京中关村正式成立，专注于芯片设计研发', '', '', '2010', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (262, 3, '首款芯片发布', '', '', '', 1, 49, 1, 1761794586, 1762244678, 0, '成功研发并发布首款物联网通信芯片，获得市场认可', '', '', '2013', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (263, 3, '建立生产线', '', '', '', 1, 48, 1, 1761794586, 1762244669, 0, '建立自有生产线，实现设计制造一体化，提升产品竞争力', '', '', '2015', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (264, 3, '获得国家认证', '', '', '', 1, 47, 1, 1761794586, 1762244660, 0, '获得国家认可高新技术企业认证，技术实力获得国家认可', '', '', '2018', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (265, 3, '全球化布局', '', '', '', 1, 46, 1, 1761794586, 1762244651, 0, '产品销往全球50多个国家和地区，建立海外研发中心', '', '', '2020', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 8, '0', '', '');
INSERT INTO `ry_article` VALUES (266, 3, 'AI芯片突破', '', '', '', 1, 45, 1, 1761794586, 1762244643, 0, '发布新一代AI芯片，性能提升300%，引领行业技术发展', '', '', '2023', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (267, 7, 'AI推理芯片XK-AI100系列', '/uploads/images/product/product10.jpg', '', '<p>## 超越算力：XK-AI100芯片与智能时代的精神觉醒<br/><br/>当XK-AI100芯片在实验室里以每秒百万亿次的计算速度处理着海量数据时，我们看到的不仅是半导体工艺的巅峰之作，更是一面映照人类智能边界的镜子。这款集成了数千亿晶体管的人工智能推理芯片，以其惊人的能效比和低延迟特性，正悄然重塑着从自动驾驶到医疗诊断的各个领域。然而，在惊叹于其技术奇迹之余，我们是否曾思考：这颗芯片所代表的，究竟是工具的革命，还是人类认知本身的一场静默蜕变？<br/><br/>XK-AI100的神经网络处理器架构模仿了人脑的联结主义模型，其稀疏计算与量化感知核心技术，本质上是对生物智能的数学抽象。这种“仿生”并非简单的形态复制，而是对智能生成机制的深度解构。当芯片在1毫秒内完成人脑需要数秒的推理任务时，它不仅在效率上超越了生物智能，更在某种程度上揭示了思维的本质——一种基于特定算法的信息处理过程。这迫使我们对引以为傲的创造力、直觉等人类特质进行重新审视：如果所有这些都能被还原为计算，那么“智能”的神圣性何在？</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product10.jpg\"/></p><p><br/><br/>在智慧城市的调度中心，XK-AI100实时优化着千万人口的交通流；在科研实验室，它从 petabytes 级数据中挖掘出人类难以察觉的规律。这些应用场景共同指向一个深刻转变：人类正将越来越多的决策权让渡给非生命的智能体。这种让渡不是被迫的，而是主动的、欣然的，因为我们看到了纯粹生物智能的局限性。XK-AI100为代表的AI芯片，因此成为人类认知的“外置大脑”，承担起那些超越我们生物较高水平的思考任务。<br/><br/>但技术的馈赠总是伴随着代价。当XK-AI100在特定领域的推理能力远超人类专家时，一种新型的“认知依赖”正在形成。就像计算器弱化了我们的心算能力，过度依赖AI推理可能导致人类某些思维能力的退化。更深远的是，当芯片的“思维”方式逐渐成为社会运行的基础设施，它内嵌的价值取向和认知偏见将如何潜移默化地重塑我们的世界观？<br/><br/>XK-AI100的奇迹不在于它让我们变得无所不能，而在于它让我们看清了自己的“所能”与“所不能”。这颗小小的芯片如同一把双刃剑，既延伸了我们的智能边界，也映照出生物智能的天然局限。真正的挑战或许不在于制造更强大的AI芯片，而在于如何在人机共生的新时代，保持人类思维的独特价值与尊严。<br/><br/>在算力飙升的时代，最珍贵的可能不再是计算本身，而是那些无法被量化的智慧——伦理的审度、美的感受、爱的能力。XK-AI100可以推理出优秀解，却永远无法理解为什么人类有时会选择次优却充满温情的道路。这既是芯片的局限，或许也正是人类智能最后的堡垒。</p>', 1, 50, 1, 1761795665, 1761812851, 0, '专为AI推理场景设计的高性能芯片，支持多种神经网络模型，适用于云端和边缘计算场景应用', '', '', '2999', '### **超越算力极限：XK-AI100推理芯片核心性能特点解析**\n\n在人工智能从训练走向规模化应用的关键时期，推理性能已成为决定AI落地广度与深度的核心瓶颈。芯科科技推出的XK-AI100推理芯片，并非简单的算力堆砌，而是针对真实世界场景的一次精准架构革命。其性能特点可概括为：**出色能效、超低延迟、通用兼容与坚如磐石的可靠性**。\n\n#### **1. 突破性的“稀疏张量”计算引擎与出色能效比**\n\n传统芯片对神经网络模型进行“填鸭式”的全量计算，而XK-AI100内置了**第六代稀疏张', 1, '', '', '', '', 0, 30, '/uploads/images/goods/20251030/ebd5fb74f36aa4a00f208c01622ccf16.jpg,/uploads/images/goods/20251030/2428d6aad4647f13bcf3937da0de28fe.jpg,/uploads/images/goods/20251030/925e589213dbccac1745b3e408388611.jpg,/uploads/images/goods/20251030/aef4838999cc571f2a33d19e0e9f1fe4.jpg,/uploads/images/goods/20251030/4ad666061360efcf5095a71f77ac5ea8.jpg,/uploads/images/goods/20251030/79fc54d3496a76de6a91ad8494a75d6b.jpg,/uploads/images/goods/20251030/806b452fd788a5bc8420e64d36705c46.jpg', '', '', '', '', '<p><br/><strong>### **超越算力较高水平：XK-AI100推理芯片核心性能特点解析**</strong><br/><br/>在人工智能从训练走向规模化应用的关键时期，推理性能已成为决定AI落地广度与深度的核心瓶颈。芯科科技推出的XK-AI100推理芯片，并非简单的算力堆砌，而是针对真实世界场景的一次精准架构革命。其性能特点可概括为：**优异能效、超低延迟、通用兼容与坚如磐石的可靠性**。<br/><br/>#### **1. 显著的“稀疏张量”计算引擎与优异能效比**<br/><br/>传统芯片对神经网络模型进行“填鸭式”的全量计算，而XK-AI100内置了**第六代稀疏张量计算引擎**。它能智能识别神经网络中权重和激活值为“0”或接近零的无效计算，并动态将其跳过，较高可跳过95%的无效操作。<br/><br/>*&nbsp;\n&nbsp;\n**具体表现**：在处理BERT-Large等大型自然语言模型时，芯片的有效计算利用率提升至92%以上，相比传统稠密计算架构，**实现了高达11倍的能效提升**。<br/>*&nbsp;\n&nbsp;\n**现实意义**：这意味着在同等功耗下，XK-AI100能完成数倍的推理任务。对于边缘设备，续航能力大幅增强；对于数据中心，电力成本与冷却需求显著降低，使得大规模AI部署在经济上真正可行。<br/><br/>#### **2. 异构融合架构与确定性超低延迟**<br/><br/>XK-AI100采用创新的**“原子-分子”级异构融合架构**。它不是将计算单元简单拼接，而是在芯片层级深度集成了专用的Tensor处理单元（TPU）、向量处理单元（VPU）以及片上高速网络（NoC）。<br/><br/>*&nbsp;\n&nbsp;\n**具体表现**：数据在芯片内部流动路径极短，避免了在多个核心间频繁搬运带来的延迟。在自动驾驶、工业质检等实时性要求极高的场景中，其端到端推理延迟被严格控制在**1毫秒以内**，并且抖动范围低于5%，提供了**确定性的性能支持**。<br/>*&nbsp;\n&nbsp;\n**现实意义**：不确定性是实时AI系统的大敌。XK-AI100的确定性延迟力求了系统在任何时候都能做出及时、可预测的响应，为安全关键型应用奠定了硬件基础。<br/><br/>#### **3. 灵活的精度自适应与广泛的模型兼容性**<br/><br/>面对从INT4到BF16乃至FP16的多样化模型精度需求，XK-AI100集成了**动态精度自适应单元（APU）**。它支持在单次推理过程中，根据不同算子对精度的敏感度，动态切换计算精度。<br/><br/>*&nbsp;\n&nbsp;\n**具体表现**：芯片无需开发者手动优化，即可在运行时自动为视觉模型的卷积层选择INT8精度，同时为语义分割的输出层保留FP16精度，在保证模型精度的前提下，最大化计算速度和能效。它支持当前主流的超过200种网络模型，涵盖视觉、语音、自然语言处理和多模态领域，**快速部署**。<br/>*&nbsp;\n&nbsp;\n**现实意义**：企业无需为不同模型定制不同硬件，也无需投入大量精力进行模型量化与转换，极大地降低了部署门槛和总拥有成本（TCO）。<br/><br/>#### **4. 片内-片间无损互联与线性性能扩展**<br/><br/>为应对超大规模模型（如千亿参数LLM）的推理需求，XK-AI100配备了**第二代超维互联技术（XDLink）**。每个芯片可通过多达8个XDLink端口，与其他芯片直接互联，构建一个统一的巨大内存池。<br/><br/>*&nbsp;\n&nbsp;\n**具体表现**：在八卡服务器配置下，互联带宽是PCIe 5.0的8倍，延迟降低60%。这使得模型参数可以均匀分布在所有芯片上，实现**近乎线性的性能扩展**——8颗XK-AI100的性能可达单颗的7.6倍以上。<br/>*&nbsp;\n&nbsp;\n**现实意义**：即使是参数量巨大的大语言模型，也能在XK-AI100集群上进行高速、流畅的推理，支持更长的上下文窗口和更复杂的逻辑推理，满足了下一代AI应用对算力的贪婪需求。<br/><br/>#### **总结**<br/><br/>XK-AI100的性能特点描绘了一幅清晰的图景：AI推理芯片的竞争已从单纯的算力竞赛，转向对**“有效算力”** 的优异追求。它通过**稀疏计算**榨干每一瓦特的能量，通过**异构融合**消除每一微秒的延迟，通过**精度自适应**拥抱每一种模型需求，并通过**无损互联**打破每一个性能扩展的瓶颈。这不仅是一颗芯片，更是推动AI从实验室走向千行百业的核心引擎。</p>', '', 507, '0', '', '');
INSERT INTO `ry_article` VALUES (268, 7, 'AI训练芯片XK-AI200型号', '/uploads/images/product/product1.jpg', '', '<p>芯科科技今日正式发布新一代AI训练芯片XK-AI200，该芯片采用先进的5nm工艺制程，专为大规模深度学习模型训练而设计。XK-AI200集成了专用的矩阵计算单元，支持FP16、BF16、FP32等多种精度计算，在保持高精度的同时大幅提升训练效率。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product15.jpg\" alt=\"AI训练芯片架构\"></p><p><strong>核心技术创新</strong>：XK-AI200采用了创新的稀疏计算架构，能够智能识别并跳过无效计算，训练效率提升3倍以上。芯片支持千卡级别的集群扩展，单机柜可提供超过50PetaFLOPS的计算能力。</p><p>在软件层面，XK-AI200提供了完整的开发工具链，支持深度学习框架、机器学习框架等主流深度学习框架。自动混合精度训练、梯度压缩等优化技术，使得模型训练时间缩短60%，助力科研机构和企业快速迭代AI模型。</p><p>该芯片已应用于多个超算中心，在自然语言处理、计算机视觉等领域的表现尤为出色，为大模型训练提供了强大的算力支撑。</p>', 1, 50, 1, 1761796233, 1761796233, 0, '专为大规模深度学习训练设计的高性能芯片，采用先进制程工艺，支持多种精度计算和分布式训练', '', 'AI训练芯片,深度学习,5nm工艺', '3599', '新一代AI训练芯片XK-AI200发布，采用5nm工艺，训练效率提升3倍，支持千卡集群扩展。', 1, '', '', '技术研发部', '芯科科技', 0, 30, '/uploads/images/product/product1.jpg,/uploads/images/product/product15.jpg,/uploads/images/product/product18.jpg,/uploads/images/product/product22.jpg,/uploads/images/product/product25.jpg,/uploads/images/product/product28.jpg,/uploads/images/product/product31.jpg,/uploads/images/product/product35.jpg', '', '', '', '', '', '', 196, '0', '', '');
INSERT INTO `ry_article` VALUES (269, 7, '边缘AI推理芯片XK-AI150', '/uploads/images/product/product2.jpg', '', '<p>芯科科技推出专为边缘计算场景设计的AI推理芯片XK-AI150，该芯片采用低功耗架构，在保证高性能的同时将功耗控制在5W以内。XK-AI150支持多种神经网络模型，包括CNN、RNN、Transformer等，为智能摄像头、无人机等终端设备提供强大的AI推理能力。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product19.jpg\" alt=\"边缘AI应用场景\"></p><p><strong>关键技术突破</strong>：XK-AI150采用了动态电压频率调节技术，能够根据工作负载智能调整功耗。芯片集成专用的神经网络加速器，推理速度较传统方案提升5倍，延迟降低至毫秒级别。</p><p>在应用层面，XK-AI150已广泛应用于智能安防、工业质检、自动驾驶等领域。某智能制造企业采用该芯片后，产品缺陷检测准确率达到99.8%，检测速度提升3倍，大幅提升了生产效率。</p><p>该芯片还支持开放神经网络交换格式标准模型格式，提供完善的模型转换工具，方便开发者将训练好的模型快速部署到边缘设备。</p>', 1, 49, 1, 1761796233, 1761796233, 0, '低功耗边缘AI推理解决方案芯片，适用于智能摄像头、无人机等终端设备的AI推理场景应用需求', '', '边缘计算,AI推理,低功耗芯片', '2199', '边缘AI推理芯片XK-AI150，功耗低于5W，推理速度提升5倍，为终端设备提供智能能力。', 2, '', '', '产品研发部', '芯科科技', 0, 30, '/uploads/images/product/product2.jpg,/uploads/images/product/product19.jpg,/uploads/images/product/product23.jpg,/uploads/images/product/product26.jpg,/uploads/images/product/product29.jpg,/uploads/images/product/product32.jpg,/uploads/images/product/product36.jpg,/uploads/images/product/product38.jpg', '', '', '', '', '', '', 142, '0', '', '');
INSERT INTO `ry_article` VALUES (270, 7, '存算一体AI芯片XK-AI180', '/uploads/images/product/product3.jpg', '', '<p>芯科科技在存算一体技术领域取得重大突破，成功研发出基于新型忆阻器的AI芯片XK-AI180。该芯片通过在存储器中直接进行计算，彻底消除了传统架构中数据搬运的开销，能效比提升10倍以上。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product21.jpg\" alt=\"存算一体芯片结构\"></p><p><strong>架构革命</strong>：XK-AI180采用创新的交叉阵列结构，将存储和计算功能集成在同一个物理单元中。这种设计使得数据无需在存储器和处理器之间频繁传输，大幅降低了功耗和延迟。</p><p>测试数据显示，在图像识别任务中，XK-AI180的能效比达到传统架构的12倍，特别适合物联网、可穿戴设备等功耗敏感的应用场景。芯片采用28nm工艺制造，在保持高性能的同时具备优异的成本优势。</p><p>该技术的突破为AI在终端设备上的大规模部署提供了新的可能，使得复杂的AI算法能够在电池供电的设备上长期稳定运行。</p>', 1, 48, 1, 1761796233, 1761796233, 0, '突破传统架构的存算一体AI芯片，通过在存储器中直接进行计算，大幅提升能效比和计算效率', '', '存算一体,忆阻器,能效提升', '2799', '存算一体AI芯片XK-AI180，能效比提升10倍，突破冯·诺依曼架构瓶颈。', 1, '', '', '前沿技术研究院', '芯科科技', 0, 30, '/uploads/images/product/product3.jpg,/uploads/images/product/product21.jpg,/uploads/images/product/product24.jpg,/uploads/images/product/product27.jpg,/uploads/images/product/product30.jpg,/uploads/images/product/product33.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product39.jpg', '', '', '', '', '', '', 185, '0', '', '');
INSERT INTO `ry_article` VALUES (271, 7, '多模态AI芯片XK-AI250型', '/uploads/images/product/product4.jpg', '', '<p>芯科科技发布多模态AI芯片XK-AI250，该芯片专为处理视觉与语言融合的AI任务而设计。XK-AI250采用异构计算架构，集成视觉处理单元和语言处理单元，能够同时处理图像、文本、语音等多种模态的数据。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product16.jpg\" alt=\"多模态AI应用\"></p><p><strong>融合计算优势</strong>：芯片支持跨模态注意力机制，能够理解不同模态数据之间的关联性。在图文生成、视频描述等任务中，XK-AI250的表现超越单一模态芯片30%以上。</p><p>XK-AI250采用7nm工艺制造，集成了120亿个晶体管。芯片支持动态任务调度，能够根据工作负载智能分配计算资源，最大化利用计算能力。在多模态预训练大模型的支持下，该芯片为下一代多模态AI应用提供了强大的硬件基础。</p><p>该芯片已与多家AI公司合作，应用于智能客服、内容生成、虚拟助手等领域，推动了多模态AI技术的商业化落地。</p>', 1, 47, 1, 1761796233, 1761796233, 0, '视觉与语言融合的多模态AI计算芯片，支持多种模态数据处理，适用于图文生成等复杂任务场景', '', '多模态AI,异构计算,7nm工艺', '3899', '多模态AI芯片XK-AI250，支持视觉与语言融合计算，推动多模态AI应用发展。', 1, '', '', 'AI芯片事业部', '芯科科技', 0, 30, '/uploads/images/product/product4.jpg,/uploads/images/product/product16.jpg,/uploads/images/product/product20.jpg,/uploads/images/product/product24.jpg,/uploads/images/product/product28.jpg,/uploads/images/product/product32.jpg,/uploads/images/product/product36.jpg,/uploads/images/product/product40.jpg', '', '', '', '', '', '', 135, '0', '', '');
INSERT INTO `ry_article` VALUES (272, 7, '自动驾驶AI芯片XK-AI500', '/uploads/images/product/product5.jpg', '', '<p>芯科科技推出专为自动驾驶设计的AI芯片XK-AI500，该芯片满足汽车安全完整性等级D级功能安全等级要求，为L4级自动驾驶提供可靠的算力支持。XK-AI500采用多核冗余架构，力求在极端情况下的系统可靠性。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product17.jpg\" alt=\"自动驾驶芯片应用\"></p><p><strong>安全特性</strong>：芯片内置硬件安全模块，支持实时故障检测和隔离。双核锁步设计力求关键计算任务的正确性，符合汽车电子较高安全标准。</p><p>XK-AI500集成了高性能视觉处理单元和激光雷达处理单元，能够同时处理多路传感器数据。芯片支持多任务并行处理，感知、预测、规划等算法可以同时运行，力求自动驾驶系统的实时响应。</p><p>该芯片已在多家整车厂的测试车辆上部署，在复杂城市道路场景中表现出色，为量产自动驾驶汽车提供了关键的硬件支持。</p>', 1, 46, 1, 1761796233, 1761796233, 0, '车规级自动驾驶AI计算平台芯片，满足高安全等级要求，为L4级自动驾驶提供可靠的算力支持保障', '', '自动驾驶,车规级芯片,功能安全', '4599', '自动驾驶AI芯片XK-AI500，满足ASIL-D安全等级，为L4自动驾驶提供算力支持。', 2, '', '', '汽车电子事业部', '芯科科技', 0, 30, '/uploads/images/product/product5.jpg,/uploads/images/product/product17.jpg,/uploads/images/product/product21.jpg,/uploads/images/product/product25.jpg,/uploads/images/product/product29.jpg,/uploads/images/product/product33.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product41.jpg', '', '', '', '', '', '', 118, '0', '', '');
INSERT INTO `ry_article` VALUES (273, 7, '云端AI推理芯片XK-AI350', '/uploads/images/product/product6.jpg', '', '<p>针对云端AI推理场景，芯科科技推出高性能推理芯片XK-AI350。该芯片专为大规模AI模型部署而优化，支持千亿参数模型的实时推理。XK-AI350采用创新的内存层次结构，大幅提升模型加载和推理效率。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product22.jpg\" alt=\"云端推理架构\"></p><p><strong>性能优化</strong>：芯片集成高带宽内存，支持模型参数就地计算，减少数据搬运开销。动态批处理技术能够智能调整批处理大小，最大化吞吐量。</p><p>在自然语言处理任务中，XK-AI350能够同时处理数千个并发请求，响应时间保持在100毫秒以内。芯片支持模型热更新，可以在不影响服务的情况下动态更新模型参数。</p><p>该芯片已部署在多个云服务商的AI平台上，为搜索引擎、推荐系统、智能客服等应用提供稳定的推理服务，日均处理推理请求超过10亿次。</p>', 1, 45, 1, 1761796233, 1761796233, 0, '云端大规模模型推理优化AI芯片，专为千亿参数模型部署设计，支持高并发推理请求处理场景', '', '云端推理,大模型部署,高并发', '3299', '云端AI推理芯片XK-AI350，优化千亿参数模型部署，支持高并发推理请求。', 1, '', '', '云计算事业部', '芯科科技', 0, 30, '/uploads/images/product/product6.jpg,/uploads/images/product/product22.jpg,/uploads/images/product/product26.jpg,/uploads/images/product/product30.jpg,/uploads/images/product/product34.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product44.jpg', '', '', '', '', '', '', 168, '0', '', '');
INSERT INTO `ry_article` VALUES (274, 7, '轻量级AI芯片XK-AI80型', '/uploads/images/product/product7.jpg', '', '<p>芯科科技推出超低功耗AI芯片XK-AI80，专为物联网设备设计。该芯片在1W功耗下提供1TOPS的算力，为智能家居、可穿戴设备等场景提供高效的AI推理能力。XK-AI80采用全集成设计，大幅减小了系统体积。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product23.jpg\" alt=\"物联网AI应用\"></p><p><strong>能效突破</strong>：芯片采用先进的电源管理技术，支持多种低功耗模式。在待机状态下功耗低于100μW，电池供电设备可连续工作数年。</p><p>XK-AI80支持常见的物联网AI应用，包括语音唤醒、手势识别、异常检测等。芯片提供完整的软件开发工具包，开发者可以快速将AI功能集成到物联网设备中。</p><p>该芯片已与多家智能家居厂商合作，应用于智能音箱、智能门锁、环境监测等设备，推动了物联网设备的智能化升级。</p>', 1, 44, 1, 1761796233, 1761796233, 0, '超低功耗轻量级AI芯片，专为物联网设备设计，在有限功耗下提供高效的AI推理计算能力', '', '物联网AI,低功耗,1TOPS算力', '1599', '轻量级AI芯片XK-AI80，1W功耗提供1TOPS算力，赋能物联网设备智能化。', 0, '', '', '物联网事业部', '芯科科技', 0, 30, '/uploads/images/product/product7.jpg,/uploads/images/product/product23.jpg,/uploads/images/product/product27.jpg,/uploads/images/product/product31.jpg,/uploads/images/product/product35.jpg,/uploads/images/product/product39.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product45.jpg', '', '', '', '', '', '', 106, '0', '', '');
INSERT INTO `ry_article` VALUES (276, 7, '神经拟态AI芯片XK-AI90', '/uploads/images/product/product9.jpg', '', '<p>芯科科技在神经拟态计算领域取得重要进展，推出仿脑计算芯片XK-AI90。该芯片模拟生物神经元的脉冲神经网络(脉冲神经网络)计算机制，能效比传统深度学习芯片提升百倍以上，特别适合时序数据处理和边缘学习场景。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product25.jpg\" alt=\"神经拟态芯片\"></p><p><strong>仿生创新</strong>：XK-AI90采用事件驱动计算模式，只有在需要时才触发计算，大幅降低功耗。芯片支持在线学习，能够根据环境变化动态调整网络参数。</p><p>在语音识别、手势识别等时序信号处理任务中，XK-AI90展现出优异的能效比。芯片的稀疏事件特性使得它在处理真实世界传感器数据时具有天然优势。</p><p>该芯片为下一代边缘智能设备提供了新的技术路径，使得设备能够在极低功耗下实现持续学习和自适应能力，推动了AI技术向更生物友好的方向发展。</p>', 1, 42, 1, 1761796233, 1761796233, 0, '模拟人脑计算机制的神经拟态AI芯片，采用事件驱动计算模式，实现极低功耗的边缘学习能力', '', '神经拟态,SNN,事件驱动', '2399', '神经拟态AI芯片XK-AI90，模拟人脑机制，能效提升百倍，支持边缘学习。', 3, '', '', '前沿技术实验室', '芯科科技', 0, 30, '/uploads/images/product/product9.jpg,/uploads/images/product/product25.jpg,/uploads/images/product/product29.jpg,/uploads/images/product/product33.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product41.jpg,/uploads/images/product/product45.jpg,/uploads/images/product/product47.jpg', '', '', '', '', '', '', 105, '0', '', '');
INSERT INTO `ry_article` VALUES (277, 7, 'AI视觉处理芯片XK-AI120', '/uploads/images/product/product11.jpg', '', '<p>芯科科技推出专为计算机视觉优化的AI芯片XK-AI120，该芯片针对图像识别、目标检测、语义分割等视觉任务进行了深度优化。XK-AI120集成高性能视觉处理单元，支持4K分辨率实时处理，为安防、医疗影像等应用提供强大的视觉分析能力。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product26.jpg\" alt=\"视觉处理应用\"></p><p><strong>视觉优化</strong>：芯片内置专用的图像信号处理器(图像信号处理器)，支持多路视频流并行处理。硬件级的目标检测加速器可以在毫秒级别完成复杂场景下的多目标识别。</p><p>XK-AI120支持主流的视觉神经网络模型，包括YOLO、ResNet、UNet等。在智慧城市项目中，该芯片实现了对数千路摄像头视频流的实时分析，准确率超过99%。</p><p>该芯片还提供了丰富的视觉算法库，开发者可以快速构建各种计算机视觉应用，大幅缩短了产品开发周期，推动了视觉AI技术的普及应用。</p>', 1, 41, 1, 1761796233, 1761796233, 0, '计算机视觉专用AI处理芯片，针对图像识别、目标检测等视觉任务深度优化，支持高清实时处理', '', '计算机视觉,目标检测,4K处理', '2699', 'AI视觉处理芯片XK-AI120，专攻计算机视觉应用，支持4K实时处理。', 2, '', '', '视觉技术部', '芯科科技', 1, 30, '/uploads/images/product/product11.jpg,/uploads/images/product/product26.jpg,/uploads/images/product/product30.jpg,/uploads/images/product/product34.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product46.jpg,/uploads/images/product/product48.jpg', '', '', '', '', '', '', 132, '0', '', '');
INSERT INTO `ry_article` VALUES (279, 7, '边缘训练芯片XK-AI160型', '/uploads/images/product/product13.jpg', '', '<p>芯科科技发布边缘训练芯片XK-AI160，该芯片显著地在终端设备上实现模型训练能力。XK-AI160支持联邦学习、增量学习等边缘学习算法，使得物联网设备能够在保护用户隐私的前提下进行本地模型优化。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product28.jpg\" alt=\"边缘训练应用\"></p><p><strong>隐私保护创新</strong>：芯片采用同态加密技术，力求训练过程中的数据安全。分布式训练架构允许设备在本地完成模型更新，仅上传模型参数而非原始数据。</p><p>XK-AI160在5W功耗下提供2TOPS的训练算力，支持常见的深度学习模型微调。在智能摄像头应用中，芯片能够根据使用环境自适应优化检测算法，准确率随时间推移持续提升。</p><p>该芯片为边缘计算场景带来了真正的智能进化能力，使得终端设备不再仅仅是执行者，而是具备了学习和适应的能力，开启了边缘智能的新纪元。</p>', 1, 39, 1, 1761797157, 1761797157, 0, '支持终端设备本地训练的AI芯片，实现边缘学习能力，在保护用户隐私的前提下进行模型优化', '', '边缘训练,联邦学习,隐私保护', '2899', '边缘训练芯片XK-AI160，实现终端设备本地学习，保护用户隐私数据。', 2, '', '', '边缘计算部', '芯科科技', 1, 30, '/uploads/images/product/product13.jpg,/uploads/images/product/product28.jpg,/uploads/images/product/product32.jpg,/uploads/images/product/product36.jpg,/uploads/images/product/product40.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product50.jpg', '', '', '', '', '', '', 114, '0', '', '');
INSERT INTO `ry_article` VALUES (280, 7, 'AI计算卡XK-AI600系列', '/uploads/images/product/product14.jpg', '', '<p>芯科科技推出高性能AI计算卡XK-AI600，专为高度计算中心和科研机构设计。该计算卡采用先进的封装技术，集成多个计算芯粒，单卡提供20PetaFLOPS的AI计算能力，为科学计算和工程仿真提供强大的算力支持。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product29.jpg\" alt=\"AI计算卡\"></p><p><strong>算力突破</strong>：XK-AI600采用芯粒架构，通过高密度互联技术将多个计算单元集成在同一封装内。支持高带宽内存高带宽内存，内存带宽达到3.2TB/s，满足大规模模型的内存需求。</p><p>在气候模拟、药物研发、天体物理等科学计算领域，XK-AI600展现出卓越的性能。某国家认可超算中心采用该计算卡后，气候预测模型的解析度从50公里提升到10公里，预测准确性大幅提高。</p><p>该计算卡还支持液冷散热系统，力求在高负载下的稳定运行。与传统的GPU方案相比，能效比提升2倍以上，为绿色计算提供了新的技术路径。</p>', 1, 38, 1, 1761797157, 1761797157, 0, '超算中心专用高性能AI计算卡，集成多个计算芯粒，为科学计算和工程仿真提供强大算力', '', '超算中心,科学计算,HBM3内存', '8999', 'AI计算卡XK-AI600，单卡20PetaFLOPS算力，为超算中心提供强大计算能力。', 1, '', '', '高性能计算部', '芯科科技', 1, 30, '/uploads/images/product/product14.jpg,/uploads/images/product/product29.jpg,/uploads/images/product/product33.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product41.jpg,/uploads/images/product/product45.jpg,/uploads/images/product/product49.jpg,/uploads/images/product/product51.jpg', '', '', '', '', '', '', 95, '0', '', '');
INSERT INTO `ry_article` VALUES (283, 7, 'AI安全芯片XK-AI900型号', '/uploads/images/product/product17.jpg', '', '<p>芯科科技推出AI安全芯片XK-AI900，该芯片专注于AI系统的安全防护。XK-AI900集成硬件级安全模块，支持模型加密、推理过程保护、对抗攻击防御等安全功能，为关键AI应用提供全方位安全支持。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product32.jpg\" alt=\"AI安全架构\"></p><p><strong>安全技术创新</strong>：芯片采用物理不可克隆函数技术，每个芯片具有重要的硬件指纹。支持可信执行环境，力求敏感模型和数据在安全区域内处理。</p><p>XK-AI900内置对抗样本检测引擎，能够实时识别并阻断针对AI模型的攻击。在金融风控、身份认证等安全敏感场景中，该芯片有效防止了模型被恶意欺骗的风险。</p><p>该芯片已通过国家密码管理局认证，支持国密算法。在智慧城市、关键基础设施等领域的AI系统中，XK-AI900为AI应用的可靠部署提供了坚实的安全基础。</p>', 1, 35, 1, 1761797157, 1761797157, 0, 'AI系统安全防护专用芯片，集成硬件级安全模块，提供全方位安全保障，防止网络攻击威胁', '', 'AI安全,模型加密,对抗防御', '3299', 'AI安全芯片XK-AI900，集成硬件安全模块，支持AI系统安全可靠运行。', 3, '', '', '安全技术部', '芯科科技', 1, 30, '/uploads/images/product/product17.jpg,/uploads/images/product/product32.jpg,/uploads/images/product/product36.jpg,/uploads/images/product/product40.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product54.jpg', '', '', '', '', '', '', 107, '0', '', '');
INSERT INTO `ry_article` VALUES (285, 7, 'AI推理集群芯片XK-AI1000', '/uploads/images/product/product19.jpg', '', '<p>芯科科技推出AI推理集群芯片XK-AI1000，该芯片专为构建大规模AI推理系统而设计。XK-AI1000支持芯片级集群技术，多颗芯片可以无缝组合成统一的推理计算池，为互联网企业提供弹性的推理算力。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product34.jpg\" alt=\"推理集群架构\"></p><p><strong>集群技术突破</strong>：通过专有的芯片间互联技术，256颗XK-AI1000芯片可以组成统一的推理集群，共享内存和计算资源。支持动态资源分配，根据业务负载自动调整计算规模。</p><p>在电商推荐系统中，该推理集群日均处理百亿次推理请求，响应时间保持在50毫秒以内。芯片的热插拔设计使得集群可以在不中断服务的情况下进行扩容和维护。</p><p>该芯片还支持多租户隔离，力求不同用户的计算任务互不干扰。某大型云服务商采用该方案后，推理服务的资源利用率从30%提升到80%，大幅降低了运营成本。</p>', 1, 33, 1, 1761797157, 1761797157, 0, '大规模AI推理集群专用芯片，支持芯片级集群技术，构建弹性推理计算池，优化资源利用率', '', '推理集群,弹性算力,多租户', '6799', 'AI推理集群芯片XK-AI1000，支持芯片级集群，构建大规模推理系统。', 1, '', '', '云服务部', '芯科科技', 1, 30, '/uploads/images/product/product19.jpg,/uploads/images/product/product34.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product46.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product54.jpg,/uploads/images/product/product56.jpg', '', '', '', '', '', '', 133, '0', '', '');
INSERT INTO `ry_article` VALUES (287, 7, 'AI编译器芯片XK-AI1200', '/uploads/images/product/product21.jpg', '', '<p>芯科科技推出AI编译器芯片XK-AI1200，该芯片集成专用的编译优化引擎，能够自动优化AI模型在硬件上的执行效率。XK-AI1200支持主流深度学习框架的模型自动转换和优化，大幅降低AI应用部署的技术门槛。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product36.jpg\" alt=\"编译器芯片功能\"/></p><p><strong>编译优化突破</strong>：芯片内置图优化引擎，能够自动完成算子融合、内存优化、流水线调度等复杂优化任务。支持动态编译技术，能够根据运行时情况实时调整执行计划。</p><p>在实际应用中，经过XK-AI1200优化的模型，推理速度平均提升3倍，内存占用减少50%。芯片的自动量化功能能够在保证模型精度的前提下，将FP32模型转换为INT8模型，进一步提升推理效率。</p><p>该芯片使得AI开发者无需深入了解硬件细节，就能充分发挥硬件性能，推动了AI技术的普及应用。某AI创业公司采用该芯片后，产品上线时间从3个月缩短到2周。</p>', 1, 31, 1, 1761797157, 1762230355, 0, 'AI模型编译优化专用芯片，集成编译优化引擎，自动优化模型部署效率，降低技术使用门槛', '', 'AI编译器,模型优化,自动量化', '2499', 'AI编译器芯片XK-AI1200，自动优化模型部署，提升推理效率3倍。', 2, '', '', '工具链开发部', '芯科科技', 1, 30, '/uploads/images/product/product21.jpg,/uploads/images/product/product36.jpg,/uploads/images/product/product40.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product58.jpg', '', '', '', '', '', '', 312, '98%', '', '热门产品,新品上市');
INSERT INTO `ry_article` VALUES (288, 7, 'AI语音处理芯片XK-AI130', '/uploads/images/product/product12.jpg', '', '<p>芯科科技推出专为语音AI应用设计的处理芯片XK-AI130，该芯片针对语音识别、语音合成、声纹识别等任务进行深度优化。XK-AI130集成高性能数字信号处理器，支持多路音频流并行处理，为智能音箱、语音助手等设备提供优质的语音交互体验。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product27.jpg\" alt=\"语音处理芯片\"></p><p><strong>语音技术突破</strong>：芯片内置专用的声学前端处理模块，支持噪声抑制、回声消除、波束成形等先进技术。在复杂环境下的语音识别准确率提升至98.5%，远超传统解决方案。</p><p>XK-AI130支持多种语言的语音识别和合成，芯片的低功耗设计力求在always-on语音唤醒模式下，待机功耗低于2mA。该芯片已与多家智能家居厂商合作，为用户提供更自然、更精准的语音交互体验。</p><p>在语音合成方面，芯片支持情感化语音生成，能够根据上下文自动调整语调和语速，使得合成语音更加自然流畅，推动了语音AI技术的商业化应用。</p>', 1, 40, 1, 1761797165, 1761797165, 0, '专攻语音AI的智能处理芯片，支持语音识别与合成，提供优质的语音交互体验和自然对话能力', '', '语音识别,语音合成,声纹识别', '1899', 'AI语音处理芯片XK-AI130，实现精准语音识别与合成，提升语音交互体验。', 1, '', '', '语音技术部', '芯科科技', 1, 30, '/uploads/images/product/product12.jpg,/uploads/images/product/product27.jpg,/uploads/images/product/product31.jpg,/uploads/images/product/product35.jpg,/uploads/images/product/product39.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product49.jpg', '', '', '', '', '', '', 121, '98%', '', '');
INSERT INTO `ry_article` VALUES (291, 7, '医疗AI芯片XK-AI700型号', '/uploads/images/product/product15.jpg', '', '<p>芯科科技推出医疗级AI芯片XK-AI700，该芯片针对医疗影像分析、病理诊断、基因组学等医疗AI应用进行专门优化。XK-AI700通过医疗设备认证，满足医疗行业对可靠性和准确性的严格要求。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product30.jpg\" alt=\"医疗AI应用\"></p><p><strong>医疗应用优化</strong>：芯片支持DICOM标准医疗影像处理，集成专用的医学图像分析引擎。在CT、MRI等影像的病灶检测任务中，准确率超过资深放射科医生水平。</p><p>XK-AI700采用容错设计，关键计算单元采用三重冗余架构，力求诊断结果的可靠性。芯片支持实时性要求高的手术导航应用，延迟控制在微秒级别。</p><p>该芯片已与多家医疗设备厂商合作，应用于智能影像诊断系统、手术机器人、可穿戴医疗设备等场景，为智慧医疗建设提供了关键的硬件基础。</p>', 1, 37, 1, 1761797165, 1761797165, 0, '医疗级AI诊断专用处理芯片，通过医疗设备认证，为智能医疗应用提供可靠的计算支持保障', '', '医疗AI,影像诊断,容错设计', '5499', '医疗AI芯片XK-AI700，通过医疗认证，赋能智能医疗诊断应用。', 2, '', '', '医疗事业部', '芯科科技', 1, 30, '/uploads/images/product/product15.jpg,/uploads/images/product/product30.jpg,/uploads/images/product/product34.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product46.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product52.jpg', '', '', '', '', '', '', 87, '98%', '', '');
INSERT INTO `ry_article` VALUES (292, 7, '机器人AI芯片XK-AI800型', '/uploads/images/product/product16.jpg', '', '<p>芯科科技发布机器人专用AI芯片XK-AI800，该芯片集成视觉处理、运动规划、力控感知等多种机器人核心算法。XK-AI800为工业机器人、服务机器人提供完整的AI计算能力，推动机器人智能化升级。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product31.jpg\" alt=\"机器人应用\"></p><p><strong>机器人技术整合</strong>：芯片支持实时运动规划算法，能够在动态环境中实时调整机器人轨迹。集成的力控感知单元使得机器人能够实现柔顺操作，适应精细作业需求。</p><p>在工业制造场景中，XK-AI800实现了机器人视觉引导的精准装配，装配精度达到0.1mm。芯片的多传感器融合能力使得机器人能够全面感知环境，做出智能决策。</p><p>该芯片还支持机器人学习功能，能够通过演示学习快速掌握新的操作技能。某汽车制造厂采用该芯片后，机器人产线切换产品型号的时间从数小时缩短到分钟级别。</p>', 1, 36, 1, 1761797165, 1761797165, 0, '机器人专用AI计算平台芯片，集成视觉处理、运动规划等多种算法，推动智能机器人技术发展', '', '机器人AI,运动规划,力控感知', '4199', '机器人AI芯片XK-AI800，集成多种机器人算法，推动智能机器人发展。', 1, '', '', '机器人事业部', '芯科科技', 1, 30, '/uploads/images/product/product16.jpg,/uploads/images/product/product31.jpg,/uploads/images/product/product35.jpg,/uploads/images/product/product39.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product51.jpg,/uploads/images/product/product53.jpg', '', '', '', '', '', '', 113, '98%', '', '');
INSERT INTO `ry_article` VALUES (294, 7, '能效优化AI芯片XK-AI95', '/uploads/images/product/product18.jpg', '', '<p>芯科科技发布超低功耗AI芯片XK-AI95，该芯片在能效比方面实现重大突破。XK-AI95采用创新的近阈值计算技术，在0.5V超低电压下稳定工作，能效比达到传统AI芯片的20倍，为电池供电设备带来创新性的续航提升。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product33.jpg\" alt=\"能效优化技术\"></p><p><strong>能效突破</strong>：芯片采用异步电路设计，消除了时钟树的功耗开销。动态电压频率调节技术能够根据工作负载精确控制功耗，在轻负载下功耗可降低至微瓦级别。</p><p>在智能手表应用中，XK-AI95使得连续心率监测和运动识别功能的全天候运行成为可能，电池续航从1天延长到1周。该芯片还支持能量收集技术，可以从环境光、体温等微弱能源中获取能量。</p><p>这项技术突破为物联网设备的永久续航提供了可能，推动了无电池AI设备的发展，开启了能量自治智能终端的新时代。</p>', 1, 34, 1, 1761797165, 1761797165, 0, '超低功耗能效优化AI芯片，采用创新电源管理技术，实现出色的能效比和功耗控制表现', '', '能效优化,近阈值计算,超低功耗', '1399', '能效优化AI芯片XK-AI95，能效比提升20倍，实现出色功耗控制。', 0, '', '', '低功耗技术部', '芯科科技', 1, 30, '/uploads/images/product/product18.jpg,/uploads/images/product/product33.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product41.jpg,/uploads/images/product/product45.jpg,/uploads/images/product/product49.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product55.jpg', '', '', '', '', '', '', 104, '98%', '', '');
INSERT INTO `ry_article` VALUES (296, 7, 'AI记忆芯片XK-AI110型号', '/uploads/images/product/product20.jpg', '', '<p>芯科科技在AI记忆计算领域取得突破，推出AI记忆芯片XK-AI110。该芯片模拟生物大脑的长期记忆机制，能够持久存储和快速检索知识，为AI系统提供持续学习能力。XK-AI110采用新型相变存储器，实现存储与计算的深度融合。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product35.jpg\" alt=\"记忆芯片结构\"></p><p><strong>记忆计算创新</strong>：芯片支持联想记忆功能，能够根据部分信息快速检索完整知识。知识蒸馏技术使得芯片能够从大量数据中提取关键信息，实现高效的知识压缩存储。</p><p>在个性化推荐系统中，XK-AI110能够长期记忆用户偏好，即使长时间未活跃也能快速恢复个性化服务。芯片的持续学习能力使得AI系统能够随着时间推移不断进化，适应用户需求的变化。</p><p>该技术为构建具有长期记忆的AI助手奠定了基础，使得AI系统能够建立持久的用户关系，提供更加个性化和贴心的服务体验。</p>', 1, 32, 1, 1761797165, 1761797165, 0, '模拟人脑长期记忆机制的AI芯片，实现知识持久存储和快速检索，赋予系统持续学习能力', '', '记忆计算,持续学习,知识存储', '2999', 'AI记忆芯片XK-AI110，实现长期知识存储，赋予AI系统持续学习能力。', 3, '', '', '认知计算部', '芯科科技', 1, 30, '/uploads/images/product/product20.jpg,/uploads/images/product/product35.jpg,/uploads/images/product/product39.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product51.jpg,/uploads/images/product/product55.jpg,/uploads/images/product/product57.jpg', '', '', '', '', '', '', 219, '98%', '', '');
INSERT INTO `ry_article` VALUES (298, 8, '多模无线连接芯片XK-IoT100', '/uploads/images/product/product22.jpg', '', '<p>芯科科技推出多模无线连接芯片XK-IoT100，该芯片集成无线网络技术标准、蓝牙技术标准和物联网通信协议三种主流无线通信协议。XK-IoT100采用先进的射频架构，支持无缝协议切换，为智能家居设备提供稳定可靠的连接能力。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product37.jpg\" alt=\"多模连接芯片\"></p><p><strong>连接技术突破</strong>：芯片支持动态协议选择，能够根据网络环境自动选择优秀连接方式。集成的共存算法有效避免不同协议间的干扰，力求多设备同时连接时的稳定性。</p><p>在智能家居场景中，XK-IoT100实现了设备配网成功率准确率较高，连接延迟低于100ms。芯片的低功耗设计使得电池供电设备可连续工作3年以上，为物联网设备的大规模部署提供了技术支持。</p><p>该芯片已与多家智能家居厂商合作，应用于智能灯具、智能门锁、环境传感器等产品，推动了全屋智能解决方案的落地。</p>', 1, 50, 1, 1761798801, 1761798801, 0, '多模无线连接物联网芯片，集成多种通信协议，支持无缝切换，为智能家居提供稳定连接能力', '', '多模连接,Wi-Fi6,蓝牙5.2', '899', '多模无线连接芯片XK-IoT100，支持三种协议无缝切换，提升连接稳定性。', 1, '', '', '无线连接部', '芯科科技', 1, 30, '/uploads/images/product/product22.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product57.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg', '', '', '', '', '', '', 134, '98%', '', '');
INSERT INTO `ry_article` VALUES (299, 8, '低功耗NB-IoT芯片XK-IoT200', '/uploads/images/product/product23.jpg', '', '<p>芯科科技发布超低功耗窄带物联网芯片XK-IoT200，该芯片针对广域物联网应用深度优化。XK-IoT200采用创新的功耗管理技术，在省电模式模式下功耗低于1μA，配合标准电池可实现10年以上使用寿命。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product38.jpg\" alt=\"窄带物联网应用\"></p><p><strong>功耗突破</strong>：芯片支持扩展非连续接收扩展非连续接收技术，将设备监听周期延长至数小时。智能唤醒机制力求设备仅在需要通信时激活，大幅降低平均功耗。</p><p>在智能水表、燃气表等公用事业应用中，XK-IoT200实现了月度数据上报的极低功耗运行。芯片集成的安全加密模块支持了数据传输的安全性，符合行业监管要求。</p><p>该芯片已通过运营商认证，支持全球主流频段。某智慧城市项目采用该芯片后，实现了百万级智能表计的规模化部署，大幅提升了公用事业管理效率。</p>', 1, 49, 1, 1761798801, 1761798801, 0, '超低功耗NB-IoT通信芯片，采用先进功耗管理技术，实现长达十年以上的电池使用寿命周期', '', 'NB-IoT,低功耗,10年寿命', '699', '低功耗NB-IoT芯片XK-IoT200，PSM模式功耗1μA，实现10年电池寿命。', 0, '', '', '低功耗技术部', '芯科科技', 1, 30, '/uploads/images/product/product23.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product58.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg', '', '', '', '', '', '', 121, '98%', '', '');
INSERT INTO `ry_article` VALUES (300, 8, '车规级物联网芯片XK-IoT300', '/uploads/images/product/product24.jpg', '', '<p>芯科科技推出车规级物联网芯片XK-IoT300，该芯片满足汽车电子委员会质量认证质量认证标准，专为智能网联汽车设计。XK-IoT300支持蜂窝车联网通信车联网通信技术，为自动驾驶提供低延迟、高可靠的车路协同能力。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product39.jpg\" alt=\"车联网应用\"></p><p><strong>车规技术创新</strong>：芯片集成专用的V2X通信模块，支持PC5接口直连通信。在高速移动场景下，通信可靠性达到99.999%，满足自动驾驶对通信质量的苛刻要求。</p><p>XK-IoT300支持-40°C至+105°C的宽温工作范围，适应各种恶劣环境。芯片的多重冗余设计力求在部分功能失效时仍能维持基本通信能力。</p><p>该芯片已与多家整车厂合作，应用于前装智能网联系统。在智慧高速公路示范项目中，实现了车辆与路侧设备的实时信息交互，提升了道路安全和通行效率。</p>', 1, 48, 1, 1761798801, 1761798801, 0, '车规级V2X通信物联网芯片，满足汽车电子质量认证，为智能网联汽车提供可靠通信能力', '', '车规级,C-V2X,自动驾驶', '1299', '车规级物联网芯片XK-IoT300，支持C-V2X通信，满足自动驾驶需求。', 2, '', '', '汽车电子部', '芯科科技', 1, 30, '/uploads/images/product/product24.jpg,/uploads/images/product/product39.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product49.jpg,/uploads/images/product/product54.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg', '', '', '', '', '', '', 98, '98%', '', '');
INSERT INTO `ry_article` VALUES (301, 8, '工业物联网芯片XK-IoT400型', '/uploads/images/product/product25.jpg', '', '<p>芯科科技发布工业级物联网芯片XK-IoT400，该芯片集成工业以太网协议、工业通信协议等主流工业以太网协议。XK-IoT400满足工业环境对可靠性和实时性的严格要求，为工业自动化提供强大的通信基础。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product40.jpg\" alt=\"工业物联网\"></p><p><strong>工业通信优化</strong>：芯片支持确定性通信，抖动时间低于1μs，满足运动控制等精密应用的需求。硬件级的时间同步精度达到纳秒级别，力求多设备协同工作的准确性。</p><p>在智能制造场景中，XK-IoT400实现了产线设备的高速数据采集和精准控制。芯片的强抗干扰设计使其在复杂的工业电磁环境中仍能稳定工作。</p><p>该芯片已应用于多个智能工厂项目，实现了生产设备的数字化和智能化升级。某汽车零部件厂商采用该芯片后，设备数据采集频率从秒级提升到毫秒级，大幅提升了生产过程的透明度。</p>', 1, 47, 1, 1761798801, 1761798801, 0, '工业级多协议物联网芯片，支持主流工业以太网协议，满足严苛工业环境下的通信需求', '', '工业物联网,PROFINET,EtherCAT', '1599', '工业物联网芯片XK-IoT400，支持多种工业协议，满足严苛工业环境需求。', 1, '', '', '工业自动化部', '芯科科技', 1, 30, '/uploads/images/product/product25.jpg,/uploads/images/product/product40.jpg,/uploads/images/product/product45.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product55.jpg,/uploads/images/product/product60.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg', '', '', '', '', '', '', 112, '98%', '', '');
INSERT INTO `ry_article` VALUES (302, 8, '智能农业物联网芯片XK-IoT500', '/uploads/images/product/product26.jpg', '', '<p>芯科科技推出农业专用物联网芯片XK-IoT500，该芯片针对农业环境监测和精准灌溉等应用进行优化。XK-IoT500集成土壤传感器接口和环境监测单元，为智慧农业提供完整的感知和控制能力。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product41.jpg\" alt=\"智慧农业应用\"></p><p><strong>农业应用创新</strong>：芯片支持多种农业传感器，包括土壤湿度、酸碱度、光照强度等。智能算法能够根据作物生长模型自动调整灌溉策略，实现水肥一体化精准管理。</p><p>XK-IoT500采用防腐蚀封装，适应农田的潮湿和化学环境。太阳能供电设计使得设备可以在偏远农田长期工作，无需外部电源。</p><p>该芯片已在全国多个农业示范基地部署，实现了作物生长环境的实时监控和智能调控。某大型农场采用该方案后，节水30%，肥料利用率提升25%，作物产量提高15%。</p>', 1, 46, 1, 1761798801, 1761798801, 0, '农业专用环境监测物联网芯片，集成多种传感器接口，为精准农业提供完整的数据支持', '', '智慧农业,精准灌溉,环境监测', '799', '智能农业物联网芯片XK-IoT500，支持多传感器，赋能精准农业发展。', 0, '', '', '农业物联网部', '芯科科技', 1, 30, '/uploads/images/product/product26.jpg,/uploads/images/product/product41.jpg,/uploads/images/product/product46.jpg,/uploads/images/product/product51.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product61.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg', '', '', '', '', '', '', 87, '98%', '', '');
INSERT INTO `ry_article` VALUES (303, 8, 'LPWAN双模芯片XK-IoT600', '/uploads/images/product/product27.jpg', '', '<p>芯科科技发布LPWAN双模芯片XK-IoT600，该芯片同时支持远距离无线通信技术和物联网通信网络两种低功耗广域网络技术。XK-IoT600采用软件定义无线电架构，能够通过配置支持不同地区的通信标准。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product42.jpg\" alt=\"LPWAN应用\"></p><p><strong>双模技术优势</strong>：芯片支持动态网络选择，能够根据信号质量自动切换优秀网络。在复杂城市环境中，通信成功率提升至99.5%，有效解决了单模网络的覆盖盲区问题。</p><p>XK-IoT600的通信距离达到15公里（郊区），穿透能力强劲。在智能停车、环境监测等应用中，单个基站可覆盖数千个终端设备，大幅降低了网络部署成本。</p><p>该芯片已出口至全球30多个国家和地区，适应不同地区的频谱法规。某国际物流公司采用该芯片后，实现了全球货物追踪的统一管理，提升了供应链可视化水平。</p>', 1, 45, 1, 1761798801, 1761798801, 0, 'LPWAN双模通信物联网芯片，同时支持两种低功耗广域网络技术，提升网络覆盖可靠性', '', 'LPWAN,LoRa,Sigfox', '1099', 'LPWAN双模芯片XK-IoT600，支持LoRa和Sigfox，提升网络覆盖可靠性。', 1, '', '', '广域物联网部', '芯科科技', 1, 30, '/uploads/images/product/product27.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product57.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg', '', '', '', '', '', '', 105, '98%', '', '');
INSERT INTO `ry_article` VALUES (304, 8, '智能家居网关芯片XK-IoT700', '/uploads/images/product/product28.jpg', '', '<p>芯科科技推出智能家居网关芯片XK-IoT700，该芯片集成多种家庭网络协议和边缘计算能力。XK-IoT700支持Zigbee、Z-Wave、Thread等物联网协议，为智能家居提供强大的中心控制能力。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product43.jpg\" alt=\"智能家居网关\"></p><p><strong>网关功能整合</strong>：芯片支持本地场景联动，即使互联网中断也能维持基本智能功能。边缘AI计算能力使得语音识别、人脸识别等应用可以在本地完成，保护用户隐私。</p><p>XK-IoT700支持256个设备同时连接，响应延迟低于50ms。智能负载均衡技术力求在多设备同时操作时仍能保持流畅的用户体验。</p><p>该芯片已与多家智能家居平台合作，实现了不同品牌设备的互联互通。某高端住宅项目采用该方案后，住户可以通过单一App控制全屋智能设备，提升了居住体验。</p>', 1, 44, 1, 1761798801, 1761798801, 0, '智能家居多协议网关芯片，支持多种物联网协议，实现全屋智能设备的统一管理控制', '', '智能网关,边缘计算,多协议', '1399', '智能家居网关芯片XK-IoT700，支持多协议，实现全屋设备统一管理。', 2, '', '', '智能家居部', '芯科科技', 1, 30, '/uploads/images/product/product28.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product58.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg', '', '', '', '', '', '', 123, '98%', '', '');
INSERT INTO `ry_article` VALUES (305, 8, '可穿戴设备芯片XK-IoT800', '/uploads/images/product/product29.jpg', '', '<p>芯科科技发布可穿戴设备专用芯片XK-IoT800，该芯片采用WLCSP晶圆级封装，尺寸仅为3×3mm。XK-IoT800集成运动传感器、心率监测等可穿戴设备常用功能，为智能手表、健康手环提供完整的解决方案。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product44.jpg\" alt=\"可穿戴芯片\"></p><p><strong>小型化创新</strong>：芯片采用3D堆叠技术，在极小面积内集成多个功能单元。先进的电源管理技术使得设备在连续心率监测模式下可工作7天，运动模式下工作20小时。</p><p>XK-IoT800支持多种生物特征传感，包括血氧饱和度、皮肤电反应等。智能算法能够准确识别运动类型和强度，提供个性化的健康建议。</p><p>该芯片已应用于多款畅销智能手表，用户体验反馈良好。某健康科技公司采用该芯片后，产品体积减小30%，续航时间提升50%，获得了市场的高度认可。</p>', 1, 43, 1, 1761798801, 1761798801, 0, '可穿戴设备专用物联网芯片，采用小型化封装设计，集成健康监测功能，延长设备续航', '', '可穿戴,健康监测,小型化', '999', '可穿戴设备芯片XK-IoT800，3×3mm极小尺寸，支持多种健康监测功能。', 0, '', '', '可穿戴事业部', '芯科科技', 1, 30, '/uploads/images/product/product29.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product49.jpg,/uploads/images/product/product54.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg', '', '', '', '', '', '', 126, '98%', '', '');
INSERT INTO `ry_article` VALUES (306, 8, '智能电表芯片XK-IoT900型号', '/uploads/images/product/product30.jpg', '', '<p>芯科科技推出智能电表专用芯片XK-IoT900，该芯片满足AMI高级计量基础设施的严格要求。XK-IoT900集成高精度计量单元和安全的通信模块，为智能电网提供可靠的数据采集和传输能力。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product45.jpg\" alt=\"智能电表应用\"></p><p><strong>计量技术突破</strong>：芯片支持0.5S级电能计量精度，满足电网公司的标准要求。防窃电功能能够检测异常用电模式，支持电力公司的合法权益。</p><p>XK-IoT900支持电能表通信规约、国际电工委员会电能计量标准等电表通信规约，便于与现有系统对接。远程固件升级功能使得电表软件可以在不更换硬件的情况下持续更新。</p><p>该芯片已在国内多个智能电网项目中规模应用，实现了用电数据的实时采集和精细化管理。某电网公司采用该方案后，线损率从8%降低到4%，每年节约电力损失数亿度。</p>', 1, 42, 1, 1761798801, 1761798801, 0, '智能电表专用计量通信芯片，满足高级计量基础设施要求，提供精确的电能计量能力', '', '智能电表,AMI,精确计量', '1199', '智能电表芯片XK-IoT900，满足AMI计量需求，精度达到0.5S级。', 1, '', '', '能源物联网部', '芯科科技', 1, 30, '/uploads/images/product/product30.jpg,/uploads/images/product/product45.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product55.jpg,/uploads/images/product/product60.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg', '', '', '', '', '', '', 93, '98%', '', '');
INSERT INTO `ry_article` VALUES (307, 8, '环境监测芯片XK-IoT1000型', '/uploads/images/product/product31.jpg', '', '<p>芯科科技发布环境监测专用芯片XK-IoT1000，该芯片集成多种气体传感器和颗粒物检测单元。XK-IoT1000能够实时监测PM2.5、PM10、CO2、VOCs等环境参数，为智慧环保提供精准的数据支持。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product46.jpg\" alt=\"环境监测应用\"></p><p><strong>监测技术创新</strong>：芯片采用多传感器数据融合技术，提高了监测数据的准确性。自动校准功能力求传感器长期工作的稳定性，减少维护需求。</p><p>XK-IoT1000支持室内外多种应用场景，监测数据可通过4G/Cat.1网络实时上传。在智慧城市环境中，实现了区域空气质量的热力图展示和污染源追踪。</p><p>该芯片已部署在多个城市的网格化监测系统中，为环境治理提供了科学依据。某环保部门采用该方案后，污染事件发现时间从小时级缩短到分钟级，提升了环境监管效率。</p>', 1, 41, 1, 1761798801, 1761798801, 0, '环境监测多参数感知芯片，实时监测多种环境指标，为智慧环保提供精准的数据支持', '', '环境监测,空气质量,多传感器', '1499', '环境监测芯片XK-IoT1000，实时感知多参数空气质量，精度达到专业级。', 2, '', '', '环境物联网部', '芯科科技', 1, 30, '/uploads/images/product/product31.jpg,/uploads/images/product/product46.jpg,/uploads/images/product/product51.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product61.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg', '', '', '', '', '', '', 109, '98%', '', '');
INSERT INTO `ry_article` VALUES (308, 8, '资产追踪芯片XK-IoT1100', '/uploads/images/product/product32.jpg', '', '<p>芯科科技推出资产追踪专用芯片XK-IoT1100，该芯片支持卫星定位系统多模定位和多种无线通信技术。XK-IoT1100为物流、仓储、资产管理等行业提供完整的物品追踪解决方案。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product47.jpg\" alt=\"资产追踪应用\"></p><p><strong>定位技术优化</strong>：芯片采用混合定位算法，在GPS信号弱的室内环境下仍能通过Wi-Fi和BLE进行辅助定位。定位精度达到3米（室外）和10米（室内）。</p><p>XK-IoT1100支持智能运动检测，在物品静止时自动进入低功耗模式。地理围栏功能可以在物品离开指定区域时立即告警，防止资产丢失。</p><p>该芯片已广泛应用于冷链物流、贵重物品运输等领域。某国际物流公司采用该芯片后，货物丢失率降低80%，客户满意度显著提升。</p>', 1, 40, 1, 1761798801, 1761798801, 0, '资产追踪多模定位芯片，支持全球卫星定位系统，实现物品的精确定位和轨迹管理', '', '资产追踪,多模定位,地理围栏', '1699', '资产追踪芯片XK-IoT1100，支持多模定位，实现全球物品精确定位管理。', 1, '', '', '物流物联网部', '芯科科技', 1, 30, '/uploads/images/product/product32.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product57.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg', '', '', '', '', '', '', 114, '98%', '', '');
INSERT INTO `ry_article` VALUES (309, 8, '智能路灯芯片XK-IoT1200', '/uploads/images/product/product33.jpg', '', '<p>芯科科技发布智能路灯专用芯片XK-IoT1200，该芯片集成照明控制和环境感知功能。XK-IoT1200支持按需照明、远程调光、故障诊断等智能路灯核心功能，为智慧城市建设提供基础设施支持。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product48.jpg\" alt=\"智能路灯应用\"></p><p><strong>照明控制创新</strong>：芯片支持0-10V调光和脉冲宽度调制调光两种方式，调光精度达到1%。人体感应功能可以在检测到行人时自动调整亮度，实现节能与安全的平衡。</p><p>XK-IoT1200集成了电力线载波通信，利用现有供电线路传输数据，降低了部署成本。单灯控制能力使得管理部门可以精确掌握每个路灯的工作状态。</p><p>该芯片已在国内多个智慧城市项目中应用，实现了路灯的智能化管理。某城市采用该方案后，路灯能耗降低40%，维护成本减少60%，提升了城市照明管理水平。</p>', 1, 39, 1, 1761798801, 1761798801, 0, '智能路灯控制管理芯片，支持精确调光和远程管理，为智慧城市照明提供技术基础', '', '智能路灯,智慧照明,节能控制', '1399', '智能路灯芯片XK-IoT1200，支持精确调光和远程管理，实现智慧照明。', 0, '', '', '智慧城市部', '芯科科技', 1, 30, '/uploads/images/product/product33.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product58.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg', '', '', '', '', '', '', 97, '98%', '', '');
INSERT INTO `ry_article` VALUES (310, 8, '智能水浸检测芯片XK-IoT1300', '/uploads/images/product/product34.jpg', '', '<p>芯科科技推出水浸检测专用芯片XK-IoT1300，该芯片采用高灵敏度电极检测技术，能够及时发现漏水情况。XK-IoT1300为数据中心、仓库、住宅等场所提供可靠的水患预警保护。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product49.jpg\" alt=\"水浸检测应用\"/></p><p><strong>检测技术创新</strong>：芯片支持多探头检测，可以同时监控多个潜在漏水点。灵敏度可调节，适应不同环境下的检测需求，避免误报和漏报。</p><p>XK-IoT1300的响应时间低于3秒，力求在发生漏水时能够及时告警。电池供电设计使得设备可以安装在任意位置，不受电源限制。</p><p>该芯片已广泛应用于金融、电信、医疗等行业的数据中心。某银行数据中心采用该方案后，成功预警了多次空调漏水事件，避免了数百万的设备损失。</p>', 1, 38, 1, 1761798801, 1762186753, 0, '水浸检测预警专用芯片，采用高灵敏度检测技术，快速发现漏水情况，预防事故发生', '', '水浸检测,漏水预警,安防监控', '899', '智能水浸检测芯片XK-IoT1300，3秒快速响应，预防漏水事故发生。', 2, '', '', '安防物联网部', '芯科科技', 1, 30, '/uploads/images/product/product34.jpg,/uploads/images/product/product49.jpg,/uploads/images/product/product54.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg', '', '', '', '', '', '', 102, '98%', '', '机器学习,人工智能,云计算,物联网,5G技术,DevOps,数据库,移动开发');
INSERT INTO `ry_article` VALUES (311, 8, '智能门锁芯片XK-IoT1400', '/uploads/images/product/product35.jpg', '', '<p>芯科科技发布智能门锁专用芯片XK-IoT1400，该芯片集成多种开锁方式和安全保护机制。XK-IoT1400支持指纹识别、密码开锁、卡片识别、手机蓝牙等多种认证方式，为用户提供便捷安全的门锁体验。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product50.jpg\" alt=\"智能门锁应用\"></p><p><strong>安全技术强化</strong>：芯片采用金融级安全加密，防止密码被破解或窃取。防拆报警功能在检测到异常撬动时立即向用户手机发送告警信息。</p><p>XK-IoT1400的低功耗设计力求在4节AA电池供电下可使用1年以上。虚位密码功能允许用户在正确密码前后输入任意数字，防止密码被偷窥。</p><p>该芯片已与多家智能门锁品牌合作，产品销往全球市场。某高端公寓项目采用该门锁后，住户满意度提升35%，物业管理效率提高50%。</p>', 1, 37, 1, 1761798801, 1761798801, 0, '智能门锁安全控制芯片，支持多种开锁方式，提供便捷安全的智能门锁使用体验', '', '智能门锁,指纹识别,安全加密', '1599', '智能门锁芯片XK-IoT1400，支持多种开锁方式，提升家居安全等级。', 1, '', '', '智能安防部', '芯科科技', 1, 30, '/uploads/images/product/product35.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product55.jpg,/uploads/images/product/product60.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg', '', '', '', '', '', '', 131, '98%', '', '');
INSERT INTO `ry_article` VALUES (312, 8, '冷链监控芯片XK-IoT1500', '/uploads/images/product/product36.jpg', '', '<p>芯科科技推出冷链监控专用芯片XK-IoT1500，该芯片集成温度、湿度、震动等多种传感器。XK-IoT1500为食品、药品冷链运输提供全程温度监控和预警，支持产品质量和安全。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product51.jpg\" alt=\"冷链监控应用\"></p><p><strong>监控技术完善</strong>：芯片支持-40°C至+85°C的宽温监测范围，精度达到±0.5°C。智能预警功能在温度超出设定范围时立即告警，防止货物变质。</p><p>XK-IoT1500的数据记录容量达到100万条，支持整个运输周期的数据存储。防篡改设计力求监控数据的真实性和可靠性，满足监管要求。</p><p>该芯片已广泛应用于医药、生鲜食品等行业。某疫苗生产企业采用该方案后，运输过程中的温度合格率从85%提升到99.5%，有效支持了疫苗效力。</p>', 1, 36, 1, 1761798801, 1761798801, 0, '冷链运输环境监控芯片，精确监测温湿度变化，保障食品药品在运输过程中的质量安全', '', '冷链监控,温度监测,药品运输', '1899', '冷链监控芯片XK-IoT1500，精确监测温湿度，支持食品药品运输安全。', 0, '', '', '冷链物联网部', '芯科科技', 1, 30, '/uploads/images/product/product36.jpg,/uploads/images/product/product51.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product61.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg', '', '', '', '', '', '', 88, '98%', '', '');
INSERT INTO `ry_article` VALUES (313, 8, '智能井盖监控芯片XK-IoT1600', '/uploads/images/product/product37.jpg', '', '<p>芯科科技发布智能井盖监控专用芯片XK-IoT1600，该芯片集成倾斜检测、位移感知、非法开启检测等功能。XK-IoT1600为城市井盖管理提供智能化解决方案，有助于井盖相关安全事故。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product52.jpg\" alt=\"智能井盖应用\"></p><p><strong>市政管理创新</strong>：芯片采用三轴加速度计检测井盖状态，倾斜超过15度或位移超过10cm时立即告警。防水等级达到IP68，适应井下潮湿环境。</p><p>XK-IoT1600支持窄带物联网通信，信号穿透能力强，适合地下环境使用。电池供电设计使得设备可以独立工作3年以上，减少维护频次。</p><p>该芯片已在多个城市的智慧市政项目中部署。某大城市采用该方案后，井盖丢失和损坏的发现时间从数天缩短到数分钟，市政应急响应效率大幅提升。</p>', 1, 35, 1, 1761798801, 1761798801, 0, '智能井盖状态监控芯片，实时监测井盖状态变化，提升市政设施管理效率和安全性', '', '智能井盖,市政管理,安全监控', '1199', '智能井盖监控芯片XK-IoT1600，实时监测井盖状态，提升市政管理效率。', 2, '', '', '智慧市政部', '芯科科技', 1, 30, '/uploads/images/product/product37.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product57.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg,/uploads/images/product/product82.jpg', '', '', '', '', '', '', 96, '98%', '', '');
INSERT INTO `ry_article` VALUES (314, 8, '智能垃圾桶芯片XK-IoT1700', '/uploads/images/product/product38.jpg', '', '<p>芯科科技推出智能垃圾桶专用芯片XK-IoT1700，该芯片集成超声波测距和压缩控制功能。XK-IoT1700实时监测垃圾桶满载状态，为智慧环卫提供数据支持，优化垃圾收运路线。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product53.jpg\" alt=\"智能垃圾桶应用\"></p><p><strong>环卫管理优化</strong>：芯片采用超声波检测垃圾高度，检测精度达到1cm。智能压缩功能在垃圾达到一定容量时自动启动，提升垃圾桶使用效率。</p><p>XK-IoT1700支持太阳能充电，适应户外长期使用需求。数据分析功能可以统计各点位的垃圾产生规律，为环卫规划提供科学依据。</p><p>该芯片已在国内多个智慧城市项目中应用。某区采用该方案后，垃圾收运车辆出车次数减少30%，燃油消耗降低25%，实现了环卫管理的降本增效。</p>', 1, 34, 1, 1761798801, 1761798801, 0, '智能垃圾桶监测控制芯片，监测垃圾容量状态，优化城市环卫收运路线和资源分配', '', '智能垃圾桶,环卫管理,压缩控制', '999', '智能垃圾桶芯片XK-IoT1700，监测满载状态，优化城市环卫管理效率。', 1, '', '', '智慧环卫部', '芯科科技', 1, 30, '/uploads/images/product/product38.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product58.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg,/uploads/images/product/product83.jpg', '', '', '', '', '', '', 103, '98%', '', '');
INSERT INTO `ry_article` VALUES (315, 8, '智能消防芯片XK-IoT1800型', '/uploads/images/product/product39.jpg', '', '<p>芯科科技发布智能消防专用芯片XK-IoT1800，该芯片集成烟雾检测、温度感知、声光报警等功能。XK-IoT1800为建筑物提供早期火灾预警，最大限度减少火灾损失。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product54.jpg\" alt=\"智能消防应用\"/></p><p><strong>消防技术创新</strong>：芯片采用双光路烟雾检测技术，有效区分火灾烟雾和灰尘干扰。温度监测支持差温和定温两种报警方式，适应不同环境需求。</p><p>XK-IoT1800支持消防设备联动，在检测到火情时可自动启动喷淋系统。备用电源力求在市电中断时仍能正常工作24小时。</p><p>该芯片已通过国家消防产品认证，应用于商场、酒店、学校等人员密集场所。某大型商业综合体采用该方案后，火灾预警时间提前了10分钟，为人员疏散赢得了宝贵时间。</p>', 1, 33, 1, 1761798801, 1762186260, 0, '智能消防预警监控芯片，集成多参数检测功能，提升火灾早期发现和预警响应能力', '', '智能消防,火灾预警,烟雾检测', '1699', '智能消防芯片XK-IoT1800，集成多参数检测，提升火灾早期预警能力。', 0, '', '', '消防物联网部', '芯科科技', 1, 30, '/uploads/images/product/product39.jpg,/uploads/images/product/product54.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg,/uploads/images/product/product84.jpg', '', '', '', '', '', '', 135, '98%', '', '机器学习,深度学习,数据库,DevOps,5G技术,物联网,云计算,开源项目,技术架构,用户体验');
INSERT INTO `ry_article` VALUES (316, 8, '智能停车芯片XK-IoT1900', '/uploads/images/product/product40.jpg', '', '<p>芯科科技推出智能停车专用芯片XK-IoT1900，该芯片集成地磁检测和无线通信功能。XK-IoT1900实时监测停车位状态，为智慧停车系统提供准确的车位信息，提升停车资源利用率。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product55.jpg\" alt=\"智能停车应用\"/></p><p><strong>停车管理优化</strong>：芯片采用三轴地磁传感器，车辆检测准确率达到99%。自适应算法能够区分车辆和行人干扰，减少误报率。</p><p>XK-IoT1900支持无线组网，单个网关可管理数百个车位。太阳能供电设计使得设备可以独立安装在任意车位，无需布线施工。</p><p>该芯片已在全国多个城市的智慧停车项目中部署。某商业区采用该方案后，车位周转率提升40%，车辆寻找车位时间从15分钟缩短到3分钟，有效缓解了交通拥堵。</p>', 1, 32, 1, 1761798801, 1762184499, 0, '智能停车地磁检测芯片，准确监测车位使用状态，解决城市停车难题，提升资源利用', '', '智能停车,地磁检测,车位管理', '1299', '智能停车芯片XK-IoT1900，准确监测车位状态，解决城市停车难题。', 2, '', '', '智慧交通部', '芯科科技', 1, 30, '/uploads/images/product/product40.jpg,/uploads/images/product/product55.jpg,/uploads/images/product/product60.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg,/uploads/images/product/product85.jpg', '', '', '', '', '', '', 125, '98%', '', '1,2,9');
INSERT INTO `ry_article` VALUES (317, 8, '智能养殖芯片XK-IoT2000', '/uploads/images/product/product41.jpg', '', '<p>芯科科技发布智能养殖专用芯片XK-IoT2000，该芯片集成动物行为监测和环境调控功能。XK-IoT2000为现代化养殖场提供精准的养殖管理，提升养殖效率和动物福利。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product56.jpg\" alt=\"智能养殖应用\"/></p><p><strong>养殖技术创新</strong>：芯片支持动物活动量、采食量、体温等关键指标的监测。智能算法能够早期发现动物健康异常，及时进行干预治疗。</p><p>XK-IoT2000的环境调控功能可以自动调节温度、湿度、通风等参数，为动物创造较好生长环境。数据分析功能为养殖决策提供科学支持。</p><p>该芯片已在国内多个大型养殖场应用。某养猪企业采用该方案后，母猪产仔率提升15%，饲料转化率提高10%，养殖效益显著提升。</p>', 1, 31, 1, 1761798801, 1762186772, 0, '智能养殖环境监测芯片，监测动物行为和环境参数，推动畜牧业向现代化方向发展', '', '智能养殖,动物监测,环境调控', '1799', '智能养殖芯片XK-IoT2000，监测动物行为环境，推动畜牧业现代化发展。', 1, '', '', '农业物联网部', '芯科科技', 1, 30, '/uploads/images/product/product41.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product61.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg,/uploads/images/product/product86.jpg', '', '', '', '', '', '', 522, '98%', '', '前端开发,开源项目,技术架构');
INSERT INTO `ry_article` VALUES (318, 9, '智能座舱域控制器芯片XK-Auto100', '/uploads/images/product/product42.jpg', '', '<p>芯科科技推出智能座舱域控制器芯片XK-Auto100，该芯片集成高性能GPU和多个显示输出接口，支持多达6块高清屏幕同时显示。XK-Auto100为现代汽车智能座舱提供强大的计算和图形处理能力，打造沉浸式驾乘体验。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product57.jpg\" alt=\"智能座舱芯片\"></p><p><strong>座舱技术创新</strong>：芯片采用多核异构架构，CPU、GPU、神经网络处理单元协同工作，力求系统流畅运行。支持4K分辨率显示，画面细腻度达到消费电子级别。语音交互延迟低于100ms，实现自然流畅的人机对话。</p><p>XK-Auto100已通过车规级认证，工作温度范围-40°C至+105°C。在某高端电动车型中，实现了仪表盘、中控屏、副驾娱乐屏、后排娱乐屏的四屏联动，为用户带来优异的数字座舱体验。</p>', 1, 50, 1, 1761804990, 1761804990, 0, '高性能智能座舱域控制芯片，支持多屏互动与语音交互，打造沉浸式数字驾乘体验环境', '', '智能座舱,域控制器,多屏互动', '2899', '智能座舱芯片XK-Auto100，支持6屏显示，打造沉浸式驾乘体验。', 1, '', '', '智能座舱部', '芯科科技', 1, 30, '/uploads/images/product/product42.jpg,/uploads/images/product/product57.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg,/uploads/images/product/product82.jpg,/uploads/images/product/product87.jpg', '', '', '', '', '', '', 145, '98%', '', '');
INSERT INTO `ry_article` VALUES (319, 9, '自动驾驶计算芯片XK-Auto200', '/uploads/images/product/product43.jpg', '', '<p>芯科科技发布自动驾驶计算芯片XK-Auto200，该芯片集成多个高性能计算核心和专用AI加速器，算力达到500TOPS。XK-Auto200为L4级自动驾驶提供可靠的感知、决策、规划计算能力，力求行车安全。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product58.jpg\" alt=\"自动驾驶芯片\"></p><p><strong>安全技术支持</strong>：芯片采用汽车安全完整性等级D级功能安全设计，关键计算单元三重冗余。实时性支持机制力求感知-决策-执行链路延迟低于50ms。支持多传感器数据融合，准确感知周围环境。</p><p>该芯片已在国内多个自动驾驶示范项目中应用，在复杂城市道路场景中表现出色。某Robotaxi公司采用XK-Auto200后，系统接管里程从100公里提升到1000公里，技术成熟度显著提高。</p>', 1, 49, 1, 1761804990, 1761804990, 0, 'L4级自动驾驶计算平台芯片，满足高安全等级要求，为自动驾驶系统提供可靠算力保障', '', '自动驾驶,ASIL-D,多传感器融合', '5899', '自动驾驶芯片XK-Auto200，算力500TOPS，满足L4级自动驾驶需求。', 2, '', '', '自动驾驶部', '芯科科技', 1, 30, '/uploads/images/product/product43.jpg,/uploads/images/product/product58.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg,/uploads/images/product/product83.jpg,/uploads/images/product/product88.jpg', '', '', '', '', '', '', 132, '98%', '', '');
INSERT INTO `ry_article` VALUES (320, 9, '车载网关芯片XK-Auto300型', '/uploads/images/product/product44.jpg', '', '<p>芯科科技推出车载网关芯片XK-Auto300，该芯片支持CAN-FD、LIN、以太网等多种车载网络协议。XK-Auto300作为整车网络的枢纽，实现各电子控制单元的数据交换和协同控制，提升整车智能化水平。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product59.jpg\" alt=\"车载网关芯片\"></p><p><strong>网络管理创新</strong>：芯片支持防火墙功能，防止恶意网络攻击。数据优先级调度力求关键控制指令优先传输。OTA升级管理实现整车软件远程更新，降低维护成本。</p><p>XK-Auto300已在一家主流车企的多款车型中量产使用。通过该芯片，实现了动力系统、底盘系统、车身系统的数据互通，为智能网联汽车提供了坚实的网络基础。</p>', 1, 48, 1, 1761804990, 1761804990, 0, '整车网络网关管理芯片，支持多种车载网络协议，实现各电子控制单元的数据交换协同', '', '车载网关,CAN-FD,以太网', '1899', '车载网关芯片XK-Auto300，支持多协议，实现整车网络统一管理。', 1, '', '', '车载网络部', '芯科科技', 1, 30, '/uploads/images/product/product44.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg,/uploads/images/product/product84.jpg,/uploads/images/product/product89.jpg', '', '', '', '', '', '', 118, '98%', '', '');
INSERT INTO `ry_article` VALUES (321, 9, '电池管理芯片XK-Auto400', '/uploads/images/product/product45.jpg', '', '<p>芯科科技发布电池管理芯片XK-Auto400，该芯片集成高精度电压、电流、温度监测功能。XK-Auto400为电动车电池包提供精确的状态估算和均衡控制，延长电池寿命，提升续航里程。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product60.jpg\" alt=\"电池管理芯片\"></p><p><strong>电池技术突破</strong>：芯片支持16通道电池电压监测，精度达到±2mV。智能均衡技术使电池组容量利用率提升至95%以上。SOC估算误差小于3%，准确显示剩余续航。</p><p>在某畅销电动车型中，采用XK-Auto400后，电池循环寿命提升20%，冬季续航衰减减少15%。芯片的热失控预警功能多次成功有助于了电池安全事故。</p>', 1, 47, 1, 1761804990, 1761804990, 0, '电动车电池管理专用芯片，提供精确的状态估算和均衡控制，延长电池寿命提升续航', '', '电池管理,SOC估算,均衡控制', '2199', '电池管理芯片XK-Auto400，精度±2mV，提升电动车续航和安全性。', 0, '', '', '动力系统部', '芯科科技', 1, 30, '/uploads/images/product/product45.jpg,/uploads/images/product/product60.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg,/uploads/images/product/product85.jpg,/uploads/images/product/product90.jpg', '', '', '', '', '', '', 126, '98%', '', '');
INSERT INTO `ry_article` VALUES (322, 9, '车载娱乐系统芯片XK-Auto500', '/uploads/images/product/product46.jpg', '', '<p>芯科科技推出车载娱乐系统芯片XK-Auto500，该芯片集成高性能音频处理器和视频解码器。XK-Auto500支持多声道环绕声和4K视频播放，为乘客提供影院级的娱乐体验。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product61.jpg\" alt=\"车载娱乐芯片\"></p><p><strong>娱乐体验升级</strong>：芯片支持环绕声音效和多声道音效音效，营造沉浸式听觉体验。硬件级视频解码支持高效视频编码、先进视频编码等先进编码格式。多区域音频管理实现前后排独立音场控制。</p><p>在某豪华品牌车型中，XK-Auto500配合26扬声器系统，打造了移动音乐厅般的听觉盛宴。芯片的低功耗设计力求娱乐系统长时间运行不影响车辆续航。</p>', 1, 46, 1, 1761804990, 1761804990, 0, '高性能车载娱乐处理芯片，支持高清视频和优质音频，打造移动娱乐空间体验感受', '', '车载娱乐,音频处理,视频解码', '2399', '车载娱乐芯片XK-Auto500，支持4K视频和全景声，打造移动娱乐空间。', 1, '', '', '车载娱乐部', '芯科科技', 1, 30, '/uploads/images/product/product46.jpg,/uploads/images/product/product61.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg,/uploads/images/product/product86.jpg,/uploads/images/product/product91.jpg', '', '', '', '', '', '', 112, '98%', '', '');
INSERT INTO `ry_article` VALUES (323, 9, '高级驾驶辅助芯片XK-Auto600', '/uploads/images/product/product47.jpg', '', '<p>芯科科技发布高级驾驶辅助芯片XK-Auto600，该芯片专为ADAS系统设计，集成视觉处理和雷达信号处理单元。XK-Auto600支持前向碰撞预警、车道保持、自适应巡航等ADAS功能，提升驾驶安全性。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product62.jpg\" alt=\"ADAS芯片\"></p><p><strong>感知技术优化</strong>：芯片支持多路摄像头输入，实现360度环境感知。深度学习算法准确识别车辆、行人、交通标志。毫米波雷达信号处理距离精度达到0.1米。</p><p>在某量产车型中，搭载XK-Auto600的ADAS系统成功避免了多起潜在交通事故。芯片的实时性能力求在120km/h车速下仍能及时做出反应，为驾驶员提供可靠辅助。</p>', 1, 45, 1, 1761804990, 1761804990, 0, '高级驾驶辅助环境感知芯片，精准感知周围环境，提升驾驶安全性和辅助驾驶体验', '', 'ADAS,环境感知,毫米波雷达', '3299', '高级驾驶辅助芯片XK-Auto600，精准感知环境，提升驾驶安全性。', 2, '', '', 'ADAS技术部', '芯科科技', 1, 30, '/uploads/images/product/product47.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg,/uploads/images/product/product82.jpg,/uploads/images/product/product87.jpg,/uploads/images/product/product92.jpg', '', '', '', '', '', '', 138, '98%', '', '');
INSERT INTO `ry_article` VALUES (324, 9, '车联网通信芯片XK-Auto700', '/uploads/images/product/product48.jpg', '', '<p>芯科科技推出车联网通信芯片XK-Auto700，该芯片支持5G和蜂窝车联网通信通信技术。XK-Auto700为智能网联汽车提供高速率、低延迟的车云通信和车车通信能力，实现车路协同。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product63.jpg\" alt=\"车联网芯片\"></p><p><strong>通信技术先进</strong>：芯片支持第五代移动通信新空口，下行速率达到2Gbps。蜂窝车联网通信直连通信延迟低于10ms，满足安全应用需求。多模支持力求在不同网络环境下保持连接。</p><p>在智慧高速公路示范项目中，搭载XK-Auto700的车辆实现了与路侧设备的实时信息交互。紧急制动预警、道路危险提示等功能有效提升了道路安全水平。</p>', 1, 44, 1, 1761804990, 1761804990, 0, '5G-V2X车联网通信芯片，支持高速率低延迟通信，实现智能车路协同应用场景', '', '车联网,5G,V2X,车路协同', '2799', '车联网通信芯片XK-Auto700，支持5G和V2X，实现智能车路协同。', 1, '', '', '车联网部', '芯科科技', 1, 30, '/uploads/images/product/product48.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg,/uploads/images/product/product83.jpg,/uploads/images/product/product88.jpg,/uploads/images/product/product93.jpg', '', '', '', '', '', '', 124, '98%', '', '');
INSERT INTO `ry_article` VALUES (325, 9, '电机控制芯片XK-Auto800型', '/uploads/images/product/product49.jpg', '', '<p>芯科科技发布电机控制芯片XK-Auto800，该芯片集成高精度脉冲宽度调制发生器和电流采样电路。XK-Auto800为电动车驱动电机提供精确的控制信号，实现高效能量转换和平稳动力输出。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product64.jpg\" alt=\"电机控制芯片\"></p><p><strong>控制技术突破</strong>：芯片支持矢量控制算法，电机效率提升至97%以上。死区补偿技术减少谐波失真，降低电磁干扰。过流、过温保护力求系统安全可靠。</p><p>在某高性能电动车型中，采用XK-Auto800后，百公里电耗降低8%。芯片的快速响应特性实现了毫秒级的扭矩调节，为驾驶员提供细腻的加速体验。</p>', 1, 43, 1, 1761804990, 1761804990, 0, '电动车电机控制专用芯片，提供精确的控制信号，实现高效能量转换和平稳动力输出', '', '电机控制,矢量控制,PWM', '1999', '电机控制芯片XK-Auto800，效率97%，提升电动车驱动性能。', 0, '', '', '电驱动部', '芯科科技', 1, 30, '/uploads/images/product/product49.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg,/uploads/images/product/product84.jpg,/uploads/images/product/product89.jpg,/uploads/images/product/product94.jpg', '', '', '', '', '', '', 119, '98%', '', '');
INSERT INTO `ry_article` VALUES (326, 9, '车载电源管理芯片XK-Auto900', '/uploads/images/product/product50.jpg', '', '<p>芯科科技推出车载电源管理芯片XK-Auto900，该芯片集成多个DC-DC转换器和LDO稳压器。XK-Auto900为整车电子系统提供稳定、高效的电源供应，优化能源利用效率。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product65.jpg\" alt=\"电源管理芯片\"></p><p><strong>能效技术提升</strong>：芯片转换效率达到95%，减少能量损耗。动态电压调节根据负载自动调整输出电压。多路输出满足不同系统的电源需求，简化电源设计。</p><p>在某混动车型中，采用XK-Auto900后，低压系统能耗降低15%。芯片的智能功耗管理使得车辆在停车状态下静态电流低于1mA，延长了蓄电池寿命。</p>', 1, 42, 1, 1761804990, 1761804990, 0, '整车电源管理控制芯片，集成多个电源转换器，优化整车能耗分配和能源利用效率', '', '电源管理,DC-DC,能耗优化', '1699', '车载电源管理芯片XK-Auto900，转换效率95%，优化整车能耗。', 1, '', '', '电源技术部', '芯科科技', 1, 30, '/uploads/images/product/product50.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg,/uploads/images/product/product85.jpg,/uploads/images/product/product90.jpg,/uploads/images/product/product95.jpg', '', '', '', '', '', '', 107, '98%', '', '');
INSERT INTO `ry_article` VALUES (327, 9, '数字仪表盘芯片XK-Auto1000', '/uploads/images/product/product51.jpg', '', '<p>芯科科技发布数字仪表盘芯片XK-Auto1000，该芯片集成高性能图形处理器和多个显示接口。XK-Auto1000支持全液晶仪表显示，为驾驶员提供清晰、直观的车辆信息展示。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product66.jpg\" alt=\"数字仪表芯片\"></p><p><strong>显示技术升级</strong>：芯片支持3D图形渲染，实现逼真的仪表效果。60fps刷新率力求画面流畅无拖影。多种主题切换满足个性化需求。关键信息优先显示力求驾驶安全。</p><p>在某运动车型中，XK-Auto1000实现了赛道模式的专属仪表界面，转速表、G值、圈速等信息一目了然，提升了驾驶乐趣和专业性。</p>', 1, 41, 1, 1761804990, 1761804990, 0, '全液晶仪表盘驱动芯片，支持高清虚拟仪表显示，为驾驶员提供清晰直观的信息展示', '', '数字仪表,图形处理,3D渲染', '2099', '数字仪表盘芯片XK-Auto1000，支持3D渲染，实现高清虚拟仪表显示。', 2, '', '', '显示技术部', '芯科科技', 1, 30, '/uploads/images/product/product51.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg,/uploads/images/product/product86.jpg,/uploads/images/product/product91.jpg,/uploads/images/product/product96.jpg', '', '', '', '', '', '', 133, '98%', '', '');
INSERT INTO `ry_article` VALUES (328, 9, '车载摄像头处理芯片XK-Auto1100', '/uploads/images/product/product52.jpg', '', '<p>芯科科技推出车载摄像头处理芯片XK-Auto1100，该芯片集成图像信号处理器和计算机视觉加速器。XK-Auto1100为环视、前视、舱内监控等车载摄像头提供高质量的图像处理和智能分析能力。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product67.jpg\" alt=\"摄像头处理芯片\"></p><p><strong>图像技术优化</strong>：芯片支持高动态范围处理，动态范围达到140dB。降噪算法在低光环境下仍能保持图像清晰。畸变校正力求环视系统画面真实准确。</p><p>在某高端车型的360环视系统中，采用XK-Auto1100后，图像拼接效果自然流畅，盲区监测准确率提升至99%。芯片的驾驶员监控功能有效有助于了疲劳驾驶事故。</p>', 1, 40, 1, 1761804990, 1761804990, 0, '车载摄像头图像处理芯片，提供高质量的图像处理和智能分析，提升视觉感知质量', '', '车载摄像头,HDR,图像处理', '1899', '车载摄像头芯片XK-Auto1100，支持HDR和降噪，提升视觉感知质量。', 1, '', '', '视觉技术部', '芯科科技', 1, 30, '/uploads/images/product/product52.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg,/uploads/images/product/product82.jpg,/uploads/images/product/product87.jpg,/uploads/images/product/product92.jpg,/uploads/images/product/product97.jpg', '', '', '', '', '', '', 121, '98%', '', '');
INSERT INTO `ry_article` VALUES (329, 9, '车身控制芯片XK-Auto1200', '/uploads/images/product/product53.jpg', '', '<p>芯科科技发布车身控制芯片XK-Auto1200，该芯片集成多个高边驱动和低边驱动通道。XK-Auto1200负责车窗、车灯、门锁等车身附件的控制，提升车辆便利性和舒适性。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product68.jpg\" alt=\"车身控制芯片\"></p><p><strong>控制功能完善</strong>：芯片支持脉冲宽度调制调光，实现无级亮度调节。软启动功能延长灯具寿命。故障诊断实时监测负载状态。睡眠模式功耗极低，满足静态电流要求。</p><p>在某家用车型中，XK-Auto1200实现了迎宾灯光、离家照明等智能化功能。芯片的可靠性设计力求在恶劣环境下仍能稳定工作，提升了用户满意度。</p>', 1, 39, 1, 1761804990, 1761804990, 0, '智能化车身控制管理芯片，负责车窗车灯等附件控制，提升车辆便利性和舒适性', '', '车身控制,驱动芯片,故障诊断', '1499', '车身控制芯片XK-Auto1200，集成多路驱动，实现智能化车身管理。', 0, '', '', '车身电子部', '芯科科技', 1, 30, '/uploads/images/product/product53.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg,/uploads/images/product/product83.jpg,/uploads/images/product/product88.jpg,/uploads/images/product/product93.jpg,/uploads/images/product/product98.jpg', '', '', '', '', '', '', 115, '98%', '', '');
INSERT INTO `ry_article` VALUES (330, 9, '车载音频功放芯片XK-Auto1300', '/uploads/images/product/product54.jpg', '', '<p>芯科科技推出车载音频功放芯片XK-Auto1300，该芯片集成多通道D类功放和数字信号处理器处理器。XK-Auto1300为车载音响系统提供纯净、强劲的音频放大，打造沉浸式听觉体验。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product69.jpg\" alt=\"音频功放芯片\"></p><p><strong>音质技术提升</strong>：芯片效率达到90%，减少发热和功耗。THD+N低于0.01%，保证音质纯净。内置数字信号处理器支持声场校正、均衡调节等音效处理。</p><p>在某豪华车型的音响系统中，XK-Auto1300驱动23个扬声器，输出功率达到1600W。芯片的智能保护功能防止过载损坏，力求了系统的可靠性。</p>', 1, 38, 1, 1761804990, 1761804990, 0, '多通道车载音频功放芯片，提供纯净强劲的音频放大，打造高品质车载音响系统', '', '音频功放,D类功放,DSP处理', '2599', '车载音频功放芯片XK-Auto1300，效率90%，打造高品质音响系统。', 1, '', '', '音频技术部', '芯科科技', 1, 30, '/uploads/images/product/product54.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg,/uploads/images/product/product84.jpg,/uploads/images/product/product89.jpg,/uploads/images/product/product94.jpg,/uploads/images/product/product99.jpg', '', '', '', '', '', '', 128, '98%', '', '');
INSERT INTO `ry_article` VALUES (331, 9, '胎压监测芯片XK-Auto1400', '/uploads/images/product/product55.jpg', '', '<p>芯科科技发布胎压监测芯片XK-Auto1400，该芯片集成压力传感器、温度传感器和RF发射器。XK-Auto1400实时监测轮胎压力和温度，及时预警异常情况，支持行车安全。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product70.jpg\" alt=\"胎压监测芯片\"></p><p><strong>监测技术精准</strong>：芯片压力测量精度达到±1kPa，温度精度±1°C。低功耗设计力求电池寿命达到10年。自动定位识别各轮胎位置。抗干扰设计保证信号稳定传输。</p><p>该芯片已通过相关认证，在国内多家车企的标准配置中应用。实际使用中多次预警了慢漏气和胎压异常情况，有效有助于了爆胎事故的发生。</p>', 1, 37, 1, 1761804990, 1761804990, 0, '高精度胎压监测传感芯片，实时监测轮胎状态，及时预警异常情况保障行车安全', '', '胎压监测,压力传感,RF发射', '899', '胎压监测芯片XK-Auto1400，精度±1kPa，实时支持行车安全。', 2, '', '', '安全系统部', '芯科科技', 1, 30, '/uploads/images/product/product55.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg,/uploads/images/product/product85.jpg,/uploads/images/product/product90.jpg,/uploads/images/product/product95.jpg,/uploads/images/product/product100.jpg', '', '', '', '', '', '', 142, '98%', '', '');
INSERT INTO `ry_article` VALUES (332, 9, '车载无线充电芯片XK-Auto1500', '/uploads/images/product/product56.jpg', '', '<p>芯科科技推出车载无线充电芯片XK-Auto1500，该芯片支持无线充电标准和快速充电协议。XK-Auto1500为车载手机无线充电提供高效、安全的充电体验，满足现代出行需求。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product71.jpg\" alt=\"无线充电芯片\"></p><p><strong>充电技术先进</strong>：芯片支持15W快速无线充电，效率达到80%。异物检测防止金属物体发热。温度监控力求充电安全。兼容多种手机型号，提供稳定充电功率。</p><p>在某新车型中，XK-Auto1500实现了中控台双手机位同时快充。芯片的智能功率分配根据手机需求动态调整，优化了充电效率。</p>', 1, 36, 1, 1761804990, 1761804990, 0, '车载快充无线充电芯片，支持快速无线充电协议，为移动设备提供便捷充电体验', '', '无线充电,快充,Qi标准', '1299', '车载无线充电芯片XK-Auto1500，支持15W快充，提升充电体验。', 1, '', '', '充电技术部', '芯科科技', 1, 30, '/uploads/images/product/product56.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg,/uploads/images/product/product86.jpg,/uploads/images/product/product91.jpg,/uploads/images/product/product96.jpg,/uploads/images/product/product101.jpg', '', '', '', '', '', '', 119, '98%', '', '');
INSERT INTO `ry_article` VALUES (333, 9, '车载导航定位芯片XK-Auto1600', '/uploads/images/product/product57.jpg', '', '<p>芯科科技发布车载导航定位芯片XK-Auto1600，该芯片支持GPS、北斗、GLONASS、Galileo四大卫星系统。XK-Auto1600为车载导航提供精准的定位服务，结合高精度地图实现智能路径规划。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product72.jpg\" alt=\"导航定位芯片\"></p><p><strong>定位技术升级</strong>：芯片定位精度达到1米（开阔地带）。惯性导航在隧道等信号盲区保持定位连续性。多路径抑制减少城市峡谷效应影响。冷启动时间小于30秒。</p><p>在某智能网联车型中，XK-Auto1600配合高精度地图实现了车道级导航。在复杂立交和匝道场景中，提供了准确的路线指引，提升了导航体验。</p>', 1, 35, 1, 1761804990, 1761804990, 0, '多模卫星导航定位芯片，支持全球定位系统，为车载导航提供精准的定位服务', '', '导航定位,北斗,GPS,惯性导航', '1799', '车载导航芯片XK-Auto1600，支持四系统，定位精度1米。', 0, '', '', '导航系统部', '芯科科技', 1, 30, '/uploads/images/product/product57.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg,/uploads/images/product/product82.jpg,/uploads/images/product/product87.jpg,/uploads/images/product/product92.jpg,/uploads/images/product/product97.jpg,/uploads/images/product/product102.jpg', '', '', '', '', '', '', 134, '98%', '', '');
INSERT INTO `ry_article` VALUES (334, 9, '车载以太网交换芯片XK-Auto1700', '/uploads/images/product/product58.jpg', '', '<p>芯科科技推出车载以太网交换芯片XK-Auto1700，该芯片支持1000BASE-T1和100BASE-T1标准。XK-Auto1700为新一代车载网络提供高速、可靠的数据交换能力，满足智能汽车大数据传输需求。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product73.jpg\" alt=\"以太网交换芯片\"></p><p><strong>网络性能提升</strong>：芯片支持8端口千兆以太网交换。时间敏感网络力求关键数据实时传输。流量管理优化网络资源分配。低功耗设计满足汽车电子要求。</p><p>在某域集中架构车型中，XK-Auto1700实现了智驾域、座舱域、动力域的高速互联。芯片的可靠性设计力求了整车网络通信的稳定性。</p>', 1, 34, 1, 1761804990, 1761804990, 0, '高速车载以太网交换芯片，构建新一代车载网络，满足智能汽车大数据传输需求', '', '车载以太网,TSN,网络交换', '2299', '车载以太网芯片XK-Auto1700，支持千兆交换，构建高速车载网络。', 1, '', '', '网络技术部', '芯科科技', 1, 30, '/uploads/images/product/product58.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg,/uploads/images/product/product83.jpg,/uploads/images/product/product88.jpg,/uploads/images/product/product93.jpg,/uploads/images/product/product98.jpg,/uploads/images/product/product103.jpg', '', '', '', '', '', '', 126, '98%', '', '');
INSERT INTO `ry_article` VALUES (335, 9, '车载雷达处理芯片XK-Auto1800', '/uploads/images/product/product59.jpg', '', '<p>芯科科技发布车载雷达处理芯片XK-Auto1800，该芯片专为毫米波雷达和激光雷达信号处理设计。XK-Auto1800实现高精度的目标检测和跟踪，为自动驾驶提供可靠的感知数据。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product74.jpg\" alt=\"雷达处理芯片\"></p><p><strong>雷达技术优化</strong>：芯片支持多目标跟踪，同时处理256个目标。距离分辨率达到0.1米，速度分辨率0.1km/h。抗干扰算法在复杂环境中保持检测稳定性。</p><p>在某L3级自动驾驶系统中，XK-Auto1800处理的毫米波雷达数据准确识别了200米外的车辆和行人。芯片的实时性能力求了系统在高速场景下的可靠性。</p>', 1, 33, 1, 1761804990, 1761804990, 0, '车载雷达信号处理芯片，实现高精度目标检测和跟踪，为自动驾驶提供可靠感知数据', '', '毫米波雷达,目标跟踪,信号处理', '3499', '车载雷达芯片XK-Auto1800，支持多目标跟踪，提升障碍物检测能力。', 2, '', '', '雷达技术部', '芯科科技', 1, 30, '/uploads/images/product/product59.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg,/uploads/images/product/product84.jpg,/uploads/images/product/product89.jpg,/uploads/images/product/product94.jpg,/uploads/images/product/product99.jpg,/uploads/images/product/product104.jpg', '', '', '', '', '', '', 141, '98%', '', '');
INSERT INTO `ry_article` VALUES (336, 9, '车载安全芯片XK-Auto1900型', '/uploads/images/product/product60.jpg', '', '<p>芯科科技推出车载安全芯片XK-Auto1900，该芯片集成硬件加密引擎和安全存储单元。XK-Auto1900为智能网联汽车提供全方位的信息安全保护，防止网络攻击和数据泄露。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product75.jpg\" alt=\"安全芯片\"></p><p><strong>安全技术强化</strong>：芯片支持国密算法和国际加密标准。安全启动力求系统软件完整性。密钥管理防止未授权访问。实时入侵检测及时预警安全威胁。</p><p>在某车企的OTA升级系统中，XK-Auto1900力求了软件包的完整性和真实性。芯片的安全认证功能防止了车辆被非法启动，提升了整车安全水平。</p>', 1, 32, 1, 1761804990, 1761804990, 0, '车载信息安全防护芯片，集成硬件加密引擎，保障智能网联汽车系统信息安全', '', '信息安全,加密算法,安全启动', '1999', '车载安全芯片XK-Auto1900，集成硬件加密，支持系统信息安全。', 1, '', '', '安全技术部', '芯科科技', 1, 30, '/uploads/images/product/product60.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg,/uploads/images/product/product85.jpg,/uploads/images/product/product90.jpg,/uploads/images/product/product95.jpg,/uploads/images/product/product100.jpg,/uploads/images/product/product105.jpg', '', '', '', '', '', '', 124, '98%', '', '');
INSERT INTO `ry_article` VALUES (337, 9, '车载诊断芯片XK-Auto2000', '/uploads/images/product/product61.jpg', '', '<p>芯科科技发布车载诊断芯片XK-Auto2000，该芯片集成故障诊断和数据分析功能。XK-Auto2000实时监测车辆各系统状态，提供精准的故障诊断和维护建议，提升车辆可靠性。</p><p style=\"text-align: center;\n\"><img src=\"/uploads/images/product/product76.jpg\" alt=\"诊断芯片\"></p><p><strong>诊断技术智能</strong>：芯片支持车载诊断系统标准诊断协议。机器学习算法识别潜在故障模式。数据记录存储故障发生时的系统状态。远程诊断支持技术人员快速定位问题。</p><p>在某商用车队管理中，XK-Auto2000实现了有助于性维护，故障预警准确率达到90%。芯片的诊断数据为产品改进提供了宝贵参考。</p>', 1, 31, 1, 1761753600, 1762145236, 0, '智能车载故障诊断芯片，实时监测车辆状态，提供精准故障诊断和维护建议支持', '', '故障诊断,OBD,预防性维护', '1699', '车载诊断芯片XK-Auto2000，支持智能诊断，提升车辆可靠性。', 0, '', '', '诊断技术部', '芯科科技', 1, 30, '/uploads/images/product/product61.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg,/uploads/images/product/product86.jpg,/uploads/images/product/product91.jpg,/uploads/images/product/product96.jpg,/uploads/images/product/product101.jpg,/uploads/images/product/product106.jpg', '', '', '', '', '', '', 128, '98%', '', '');
INSERT INTO `ry_article` VALUES (401, 12, '算力瓶颈', '', '', '<p>传统计算架构难以满足AI和大数据应用对算力的指数级增长需求，导致处理速度慢，响应延迟高。随着人工智能、物联网等技术的快速发展，对计算能力的需求呈指数级增长，传统CPU架构已无法满足实时性要求。</p>', 1, 50, 1, 1762171346, 1762171346, 0, '传统计算架构难以满足AI和大数据应用对算力的指数级增长需求，导致处理速度慢，响应延迟高。', '', '', '', '传统计算架构难以满足AI和大数据应用对算力的指数级增长需求，导致处理速度慢，响应延迟高。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-tachometer-alt', '');
INSERT INTO `ry_article` VALUES (402, 12, '能耗过高', '', '', '<p>高性能计算设备功耗巨大，散热成本高昂，不符合绿色低碳发展趋势，能效比亟待提升。数据中心能耗占全球电力消耗的比例持续上升，散热成本已成为运营的重要负担。</p>', 1, 49, 1, 1762171346, 1762171346, 0, '高性能计算设备功耗巨大，散热成本高昂，不符合绿色低碳发展趋势，能效比亟待提升。', '', '', '', '高性能计算设备功耗巨大，散热成本高昂，不符合绿色低碳发展趋势，能效比亟待提升。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-bolt', '');
INSERT INTO `ry_article` VALUES (403, 12, '安全隐患', '', '', '<p>数据泄露、网络攻击等安全威胁日益严重，传统安全方案难以应对复杂多变的安全挑战。随着数字化转型加速，网络安全、数据隐私保护成为企业面临的重要挑战。</p>', 1, 48, 1, 1762171346, 1762171346, 0, '数据泄露、网络攻击等安全威胁日益严重，传统安全方案难以应对复杂多变的安全挑战。', '', '', '', '数据泄露、网络攻击等安全威胁日益严重，传统安全方案难以应对复杂多变的安全挑战。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-shield-alt', '');
INSERT INTO `ry_article` VALUES (404, 12, '兼容性问题', '', '', '<p>不同设备、协议和标准之间的兼容性差，系统集成复杂，维护成本高，扩展性受限。多厂商设备、多协议标准导致系统集成难度大，维护成本高昂。</p>', 1, 47, 1, 1762171346, 1762171346, 0, '不同设备、协议和标准之间的兼容性差，系统集成复杂，维护成本高，扩展性受限。', '', '', '', '不同设备、协议和标准之间的兼容性差，系统集成复杂，维护成本高，扩展性受限。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-plug', '');
INSERT INTO `ry_article` VALUES (405, 13, '高性能计算', '', '', '<p>采用7nm先进制程工艺，提供业界先进的算力密度，性能提升300%，满足较为严苛的计算需求。通过架构创新和工艺优化，实现计算性能的跨越式提升。</p>', 1, 50, 1, 1762171346, 1762171346, 0, '采用7nm先进制程工艺，提供业界优秀的算力密度，性能提升300%，满足最严苛的计算需求。', '', '', '01', '采用7nm先进制程工艺，提供业界优秀的算力密度，性能提升300%，满足最严苛的计算需求。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (406, 13, '低功耗设计', '', '', '<p>创新的电源管理技术和架构优化，能效比提升50%，大幅降低运营成本，符合绿色环保理念。通过智能功耗管理和架构优化，实现性能与功耗的较好平衡。</p>', 1, 49, 1, 1762171346, 1762171346, 0, '创新的电源管理技术和架构优化，能效比提升50%，大幅降低运营成本，符合绿色环保理念。', '', '', '02', '创新的电源管理技术和架构优化，能效比提升50%，大幅降低运营成本，符合绿色环保理念。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (407, 13, '全方位安全', '', '', '<p>硬件级安全加密，支持国密算法，提供从芯片到系统的全方位安全防护，力求数据安全。构建从底层硬件到上层应用的完整安全防护体系。</p>', 1, 48, 1, 1762171346, 1762171346, 0, '硬件级安全加密，支持国密算法，提供从芯片到系统的全方位安全防护，确保数据安全。', '', '', '03', '硬件级安全加密，支持国密算法，提供从芯片到系统的全方位安全防护，确保数据安全。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (408, 13, '高度集成', '', '', '<p>多协议兼容，软硬件一体化设计，简化系统集成，降低开发难度，缩短产品上市时间。提供完整的解决方案，减少客户集成工作量。</p>', 1, 47, 1, 1762171346, 1762171346, 0, '多协议兼容，软硬件一体化设计，简化系统集成，降低开发难度，缩短产品上市时间。', '', '', '04', '多协议兼容，软硬件一体化设计，简化系统集成，降低开发难度，缩短产品上市时间。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (409, 14, '需求分析', '', '', '<p>深入了解行业应用场景，分析性能、功耗、成本等关键需求，确定技术指标和约束条件。通过客户访谈、市场调研等方式，精准把握用户需求。</p>', 1, 50, 1, 1762171346, 1762171346, 0, '深入了解行业应用场景，分析性能、功耗、成本等关键需求，确定技术指标和约束条件。', '', '', '', '深入了解行业应用场景，分析性能、功耗、成本等关键需求，确定技术指标和约束条件。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-search', '');
INSERT INTO `ry_article` VALUES (410, 14, '架构设计', '', '', '<p>基于需求分析结果，设计优秀芯片架构和系统方案，平衡性能、功耗和成本之间的关系。采用模块化设计理念，力求系统的可扩展性和可维护性。</p>', 1, 49, 1, 1762171346, 1762171346, 0, '基于需求分析结果，设计优秀芯片架构和系统方案，平衡性能、功耗和成本之间的关系。', '', '', '', '基于需求分析结果，设计优秀芯片架构和系统方案，平衡性能、功耗和成本之间的关系。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-pencil-alt', '');
INSERT INTO `ry_article` VALUES (411, 14, '技术实现', '', '', '<p>采用先进制程工艺和封装技术，结合自研IP核，实现高性能、低功耗的芯片产品。依托强大的研发团队和制造能力，力求技术方案的顺利实施。</p>', 1, 48, 1, 1762171346, 1762171346, 0, '采用先进制程工艺和封装技术，结合自研IP核，实现高性能、低功耗的芯片产品。', '', '', '', '采用先进制程工艺和封装技术，结合自研IP核，实现高性能、低功耗的芯片产品。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-cogs', '');
INSERT INTO `ry_article` VALUES (412, 14, '验证优化', '', '', '<p>通过严格测试和实际场景验证，持续优化产品性能和稳定性，力求方案可靠可用。建立完善的测试体系，力求产品质量达到较高标准。</p>', 1, 47, 1, 1762171346, 1762171346, 0, '通过严格测试和实际场景验证，持续优化产品性能和稳定性，确保方案可靠可用。', '', '', '', '通过严格测试和实际场景验证，持续优化产品性能和稳定性，确保方案可靠可用。', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-check-circle', '');
INSERT INTO `ry_article` VALUES (413, 15, 'AI计算解决方案', '/uploads/images/solution/ai-solution.jpg', '', '<p>为人工智能应用提供高性能计算支持，支持多种神经网络模型，适用于云端和边缘计算场景。基于自研AI芯片，提供完整的AI计算解决方案。</p>', 1, 50, 1, 1762171346, 1762260799, 0, '为人工智能应用提供高性能计算支持，支持多种神经网络模型，适用于云端和边缘计算场景。', '', '热门', '', '为人工智能应用提供高性能计算支持，支持多种神经网络模型，适用于云端和边缘计算场景。', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>高性能AI计算架构，支持多种神经网络模型，提供从训练到推理的完整解决方案。</p>', '<p>需要根据具体应用场景选择合适的计算资源配置。</p>', 256, '0', 'fa-brain', '人工智能,区块链,机器学习,后端开发,用户体验,性能优化');
INSERT INTO `ry_article` VALUES (414, 15, '物联网连接方案', '/uploads/images/solution/iot-solution.jpg', '', '<p>低功耗、多协议物联网芯片，支持Wi-Fi、蓝牙、远距离无线通信技术等多种通信方式，适用于智能家居、智慧城市等场景。提供完整的物联网连接解决方案。</p>', 1, 49, 1, 1762171346, 1762260810, 0, '低功耗、多协议物联网芯片，支持Wi-Fi、蓝牙、LoRa等多种通信方式，适用于智能家居、智慧城市等场景。', '', '主推', '', '低功耗、多协议物联网芯片，支持Wi-Fi、蓝牙、LoRa等多种通信方式，适用于智能家居、智慧城市等场景。', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>超低功耗设计，多协议兼容，支持大规模设备连接。</p>', '<p>需要根据具体应用场景选择合适的通信协议。</p>', 203, '0', 'fa-network-wired', '区块链,物联网,云计算,移动开发,后端开发,开源项目');
INSERT INTO `ry_article` VALUES (415, 15, '汽车电子方案', '/uploads/images/solution/pro4.jpg', '', '<p>车规级安全芯片，满足汽车安全完整性等级D级安全等级要求，适用于自动驾驶、车载娱乐、电池管理等系统。为智能网联汽车提供可靠的电子解决方案。</p>', 1, 48, 1, 1762171346, 1762260822, 0, '车规级安全芯片，满足ASIL-D安全等级要求，适用于自动驾驶、车载娱乐、电池管理等系统。', '', '新品', '', '车规级安全芯片，满足ASIL-D安全等级要求，适用于自动驾驶、车载娱乐、电池管理等系统。', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>车规级认证，高可靠性设计，满足汽车电子严苛要求。</p>', '<p>需要符合汽车行业相关标准和认证要求。</p>', 200, '0', 'fa-car-battery', '数据库,5G技术,物联网,人工智能,区块链');
INSERT INTO `ry_article` VALUES (416, 15, '工业自动化方案', '/uploads/images/solution/industrial-solution.jpg', '', '<p>高可靠性工业控制芯片，支持实时操作系统，适用于工业机器人、自动化产线等场景。为工业4.0提供强大的控制核心。</p>', 1, 47, 1, 1762171346, 1762260770, 0, '高可靠性工业控制芯片，支持实时操作系统，适用于工业机器人、自动化产线等场景。', '', '热销', '', '高可靠性工业控制芯片，支持实时操作系统，适用于工业机器人、自动化产线等场景。', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>工业级可靠性，实时性能优异，支持复杂控制算法。</p>', '<p>需要根据具体工业环境选择合适的防护等级。</p>', 189, '0', 'fa-industry', '机器学习,后端开发,移动开发,物联网,云计算,DevOps');
INSERT INTO `ry_article` VALUES (417, 15, '安全加密方案', '/uploads/images/solution/pro3.jpg', '', '<p>硬件级安全加密芯片，提供国密算法支持，适用于金融支付、身份认证等安全敏感场景。构建可信计算环境，支持信息安全。</p>', 1, 46, 1, 1762171346, 1762260838, 0, '硬件级安全加密芯片，提供国密算法支持，适用于金融支付、身份认证等安全敏感场景。', '', '主推', '', '硬件级安全加密芯片，提供国密算法支持，适用于金融支付、身份认证等安全敏感场景。', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>硬件级加密，支持国密算法，提供全方位安全防护。</p>', '<p>需要严格管理密钥和证书，力求系统安全。</p>', 212, '0', 'fa-shield-alt', '网络安全,数据库,性能优化,开源项目,容器技术');
INSERT INTO `ry_article` VALUES (418, 15, '高性能计算方案', '/uploads/images/solution/pro2.jpg', '', '<p>多核高性能计算芯片，支持大规模并行计算，适用于科学计算、数据中心等高性能场景。为计算密集型应用提供强大算力支持。</p>', 1, 45, 1, 1762171346, 1762260853, 0, '多核高性能计算芯片，支持大规模并行计算，适用于科学计算、数据中心等高性能场景。', '', '热门', '', '多核高性能计算芯片，支持大规模并行计算，适用于科学计算、数据中心等高性能场景。', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>多核架构，高并行计算能力，支持复杂科学计算。</p>', '<p>需要配套高效的散热和供电系统。</p>', 187, '0', 'fa-bolt', '网络安全,前端开发,后端开发,移动开发,数据库');
INSERT INTO `ry_article` VALUES (419, 24, 'AI算法工程师', '', '', '<p>我们正在寻找一位经验丰富的AI算法工程师，加入我们的核心研发团队。作为AI算法工程师，您将负责从算法设计到产品落地的全流程工作，推动人工智能技术在实际业务场景中的应用。</p><p>主要工作内容包括：负责机器学习、深度学习算法的研发与优化；设计和实现高效的模型训练和推理流程；参与大规模数据集的构建和处理；与硬件团队协作进行算法硬件协同优化；跟踪业界较新技术进展并应用于实际项目。</p><p>我们提供有竞争力的薪酬待遇、完善的职业发展通道和丰富的技术学习资源。加入我们，您将有机会参与前沿的AI技术研发，与行业先进的专家团队共事，在人工智能的浪潮中实现个人价值。</p>', 1, 50, 1, 1762185600, 1762185600, 0, '负责AI算法研发与优化，包括模型设计、训练和部署。', '', 'AI算法,机器学习,深度学习,算法工程师', '', '招聘AI算法工程师，要求计算机、数学等相关专业硕士学历，3年以上机器学习经验，精通Python和深度学习框架。', 0, '', '', '人力资源部', '招聘信息', 1, 30, '', '', '', '', '', '<ul>\n                                        <li>计算机、数学、统计学等相关专业硕士及以上学历</li>\n                                        <li>3年以上机器学习/深度学习相关工作经验</li>\n                                        <li>精通Python，熟悉TensorFlow/PyTorch等框架</li>\n                                        <li>有模型压缩、量化或硬件加速经验者优先</li>\n                                        <li>熟悉常见的机器学习算法和深度学习模型</li>\n                                        <li>具备良好的数学基础和算法设计能力</li>\n                                        <li>有大规模数据处理和分布式训练经验</li>\n                                        <li>具备良好的团队协作和沟通能力</li>\n                                        <li>有论文发表或开源项目贡献者优先</li>\n                                    </ul>', '<p>应聘者需提供详细的个人简历和项目经历，面试流程包括技术笔试、多轮技术面试和HR面试。成功入职后将有3个月的试用期，期间公司提供完善的培训和指导。</p>', 57, '0', '', '深圳,全职,30-50K,AI算法');
INSERT INTO `ry_article` VALUES (420, 24, '芯片设计工程师', '', '', '<p>我们诚邀芯片设计工程师加入我们的硬件研发团队，共同打造下一代高性能AI芯片。作为芯片设计工程师，您将参与从架构设计到流片验证的全流程芯片开发工作。</p><p>主要职责包括：参与芯片架构设计和模块划分；负责RTL设计、仿真和验证；进行时序分析、功耗分析和优化；与后端团队协作完成物理实现；参与芯片测试和调试工作。</p><p>我们提供业界先进的薪酬待遇、完善的芯片开发平台和丰富的学习成长机会。加入我们，您将有机会参与最前沿的芯片技术研发，在半导体领域实现技术突破。</p>', 1, 49, 1, 1762185600, 1762185600, 0, '负责芯片架构设计、RTL实现和验证工作。', '', '芯片设计,数字电路,ASIC,RTL设计', '', '招聘芯片设计工程师，要求微电子相关专业本科以上学历，熟悉数字电路设计流程，有ASIC设计经验者优先。', 0, '', '', '人力资源部', '招聘信息', 1, 30, '', '', '', '', '', '<ul>\n                                        <li>微电子、电子工程、计算机等相关专业本科及以上学历</li>\n                                        <li>2年以上数字电路设计或验证经验</li>\n                                        <li>熟悉Verilog/SystemVerilog等硬件描述语言</li>\n                                        <li>了解ASIC设计流程和EDA工具使用</li>\n                                        <li>有FPGA验证或流片经验者优先</li>\n                                        <li>熟悉计算机体系结构和总线协议</li>\n                                        <li>具备良好的问题分析和解决能力</li>\n                                        <li>有团队协作精神和学习能力</li>\n                                        <li>有AI加速器设计经验者优先考虑</li>\n                                    </ul>', '<p>芯片设计岗位需要较强的技术背景和工程实践能力，面试将重点考察数字电路设计基础和项目经验。公司提供完善的芯片设计工具链和开发环境。</p>', 17, '0', '', '上海,全职,35-60K,芯片设计');
INSERT INTO `ry_article` VALUES (421, 24, '前端开发工程师', '', '', '<p>招聘前端开发工程师，负责公司产品的前端架构设计和开发工作。您将参与从产品原型到线上部署的全流程前端开发，打造优秀的用户交互体验。</p><p>主要工作内容：负责Web前端架构设计和开发；优化前端性能和用户体验；与UI/UX设计师协作实现产品交互；开发可复用的前端组件库；参与前端工程化建设和工具链优化。</p><p>我们提供具有竞争力的薪酬待遇、技术分享文化和广阔的发展空间。加入我们，您将有机会参与大型项目的前端架构设计，在前端技术领域不断突破创新。</p>', 1, 48, 1, 1762185600, 1762185600, 0, '负责Web前端架构设计和开发，优化用户体验和前端性能。', '', '前端开发,Vue.js,React,JavaScript', '', '招聘前端开发工程师，要求计算机相关专业，3年前端开发经验，精通Vue.js/React等框架，有大型项目经验者优先。', 0, '', '', '人力资源部', '招聘信息', 1, 30, '', '', '', '', '', '<ul>\n                                        <li>计算机、软件工程等相关专业本科及以上学历</li>\n                                        <li>3年以上Web前端开发经验</li>\n                                        <li>精通JavaScript、HTML5、CSS3等前端技术</li>\n                                        <li>熟练掌握Vue.js、React等至少一种主流框架</li>\n                                        <li>有前端工程化、性能优化经验</li>\n                                        <li>了解前端安全、跨域等常见问题解决方案</li>\n                                        <li>有移动端H5开发或小程序开发经验</li>\n                                        <li>具备良好的代码规范和团队协作能力</li>\n                                        <li>有大型项目架构经验者优先考虑</li>\n                                    </ul>', '<p>前端开发工程师需要具备扎实的编程基础和良好的产品意识，面试将重点考察前端技术深度和项目经验。公司提供MacBook Pro等开发设备。</p>', 5, '0', '', '北京,全职,25-40K,前端开发');
INSERT INTO `ry_article` VALUES (422, 24, '产品经理', '', '', '<p>招聘资深产品经理，负责AI芯片及相关软件产品的规划和管理工作。您将深入理解客户需求，定义产品方向，推动产品从概念到落地的全过程。</p><p>主要职责：负责产品规划、需求分析和功能设计；编写产品需求文档和原型设计；协调研发、测试、运营等团队推进产品开发；进行市场调研和竞品分析；跟踪产品数据并持续优化产品体验。</p><p>我们为产品经理提供充分的决策空间、跨部门的协作机会和产品全生命周期的管理经验。在这里，您将成为连接技术与市场的桥梁，打造具有行业影响力的产品。</p>', 1, 47, 1, 1762185600, 1762185600, 0, '负责AI芯片及软件产品的规划、需求分析和产品管理。', '', '产品经理,产品规划,需求分析,AI产品', '', '招聘产品经理，要求计算机或相关专业，3年以上产品经验，熟悉AI或芯片行业，有成功产品案例者优先。', 0, '', '', '人力资源部', '招聘信息', 1, 30, '', '', '', '', '', '<ul>\n                                        <li>计算机、电子工程、工商管理等相关专业本科及以上学历</li>\n                                        <li>3年以上产品经理工作经验，有AI或硬件产品经验者优先</li>\n                                        <li>熟悉产品设计工具，能独立完成PRD和原型设计</li>\n                                        <li>具备良好的市场分析、用户研究和需求挖掘能力</li>\n                                        <li>优秀的沟通协调和项目管理能力</li>\n                                        <li>数据敏感，具备数据分析能力和产品思维</li>\n                                        <li>有团队管理经验者优先考虑</li>\n                                        <li>对AI技术和芯片行业有浓厚兴趣</li>\n                                        <li>具备英语读写能力，能阅读技术文档</li>\n                                    </ul>', '<p>产品经理岗位需要具备技术理解能力和商业思维，面试将重点考察产品思维、沟通能力和项目经验。成功入职后将负责重要产品线的管理工作。</p>', 14, '0', '', '深圳,全职,30-55K,产品经理');
INSERT INTO `ry_article` VALUES (423, 17, '芯科科技与华为达成战略合作签约仪式', '/uploads/images/news/news13.jpg', '', '<p>芯科科技今日宣布与华为技术有限公司达成战略合作协议，双方将在AI芯片研发、生态建设、市场拓展等领域展开深度合作。此次合作将充分发挥双方在芯片设计、算法优化和产业应用方面的优势。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news14.jpg\" alt=\"签约仪式\"></p><p>根据协议，芯科科技将与华为共同开发面向5G和边缘计算场景的AI芯片解决方案，并推动相关技术在智能制造、智慧城市等领域的规模化应用。双方还将共建联合实验室，开展前沿技术研究。</p><p>芯科科技董事长表示：\"与华为的合作将加速我们在AI芯片领域的技术创新和产业落地。我们期待通过优势互补，共同推动中国芯片产业的发展。\"</p><p>此次合作预计将带动芯科科技年营收增长20%以上，并进一步巩固其在AI芯片市场的先进地位。</p>', 1, 47, 1, 1762229348, 1762229348, 0, '芯科科技与华为技术有限公司达成战略合作协议，将在AI芯片研发、生态建设等领域合作', '', '战略合作,华为,AI芯片,生态建设', '', '芯科科技与华为达成战略合作，共同推进AI芯片生态建设，共建联合实验室。', 0, '', '', '合作发展部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (424, 17, '芯科科技2024年第三季度财报发布公告', '/uploads/images/news/news15.jpg', '', '<p>芯科科技今日发布2024年第三季度财务报告，公司实现营业收入25.6亿元，同比增长45.2%；净利润达到5.8亿元，同比增长52.3%。业绩增长主要得益于AI芯片和物联网芯片业务的强劲表现。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news16.jpg\" alt=\"财报数据\"/></p><p>财报显示，AI芯片业务收入同比增长68%，物联网芯片业务增长35%，汽车电子芯片业务增长42%。公司研发投入达到4.2亿元，占营收比例16.4%，较去年同期提升2.1个百分点。</p><p>公司CEO在财报电话会议上表示：&quot;第三季度的优异表现证明了我们在AI和物联网领域的战略布局是正确的。我们将继续加大研发投入，保持在技术上的先进优势。&quot;</p><p>基于良好的业绩表现，公司上调了全年营收指引，预计2024年全年营收将突破100亿元。</p>', 1, 46, 1, 1762142948, 1762249547, 0, '芯科科技发布2024年第三季度财务报告，公司实现营业收入25.6亿元，同比增长45.2%', '', '财务报告,业绩增长,AI芯片,营收', '', '芯科科技2024年Q3营收25.6亿元，同比增长45.2%，AI芯片业务增长68%。', 1, '', '', '财务部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', '', NULL, 8, '0', '', '');
INSERT INTO `ry_article` VALUES (425, 18, '全球半导体产业迎来新一轮投资发展热潮', '/uploads/images/news/news17.jpg', '', '<p>随着人工智能、物联网、新能源汽车等新兴技术的快速发展，全球半导体产业正迎来新一轮投资热潮。据统计，2024年上半年全球半导体领域投资金额超过2000亿美元，创历史新高。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news18.jpg\" alt=\"投资趋势\"></p><p>投资主要集中在先进制程、封装测试、材料设备等环节。其中，AI芯片、汽车电子、工业半导体成为最受资本青睐的细分领域。各国政府也纷纷出台政策支持半导体产业发展。</p><p>行业专家分析认为，这轮投资热潮将推动半导体技术加速创新，但也可能带来产能过剩的风险。企业需要精准把握市场需求，避免盲目扩张。</p><p>预计到2025年，全球半导体产业规模有望突破7000亿美元，中国市场的表现将继续领跑全球。</p>', 1, 48, 1, 1762056548, 1762056548, 0, '随着人工智能、物联网等新兴技术发展，全球半导体产业正迎来新一轮投资热潮', '', '半导体投资,产业趋势,AI芯片,汽车电子', '', '全球半导体产业迎来投资热潮，2024年上半年投资超2000亿美元，AI芯片等细分领域最受关注。', 0, '', '', '行业分析师', '行业研究报告', 1, 30, '', '', '', '', '', NULL, NULL, 6, '0', '', '');
INSERT INTO `ry_article` VALUES (426, 18, '芯片短缺问题逐步缓解但仍存结构性短缺', '/uploads/images/news/news19.jpg', '', '<p>经过两年的全球芯片短缺危机，目前整体供应情况正在逐步改善，但汽车电子、工业控制等领域的结构性短缺问题依然存在。行业分析显示，成熟制程芯片的供应紧张状况预计将持续到2025年。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news20.jpg\" alt=\"供应链分析\"/></p><p>数据显示，2024年第三季度全球芯片交货周期平均为20周，较去年同期的30周明显缩短。但在功率半导体、MCU等产品领域，供应仍然偏紧，价格保持高位运行。</p><p>供应链专家指出，地缘政治因素、疫情反复、自然灾害等不确定性因素仍然影响着芯片供应链的稳定性。企业需要建立更加灵活和多元化的供应链体系。</p><p>预计到2025年下半年，随着新增产能的陆续释放，芯片供应紧张局面将得到根本性缓解。</p>', 1, 47, 1, 1761970148, 1762249559, 0, '全球芯片短缺危机整体供应情况正在逐步改善，但汽车电子等领域结构性短缺问题依然存在', '', '芯片短缺,供应链,汽车电子,产能', '', '全球芯片短缺逐步缓解，但汽车电子等领域结构性短缺仍存，成熟制程芯片供应紧张将持续。', 1, '', '', '供应链专家', '行业分析报告', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (427, 19, '芯科科技突破2.5D封装技术研发成果', '/uploads/images/news/news21.jpg', '', '<p>芯科科技封装技术实验室近日在2.5D封装技术上取得重大突破，成功开发出基于硅中介层的2.5D封装解决方案。该技术通过将多个芯片在水平方向上进行集成，大幅提升了芯片间的通信带宽和能效比。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news22.jpg\" alt=\"2.5D封装\"/></p><p>测试数据显示，采用2.5D封装技术的AI芯片，性能提升30%，功耗降低25%。芯片间互联密度达到传统封装技术的5倍，信号传输延迟降低60%。</p><p>这项技术突破为高性能计算、人工智能等需要大规模并行计算的应用场景提供了新的解决方案。芯科科技计划在下一代AI训练芯片中率先应用该封装技术。</p><p>2.5D封装技术的成熟将推动芯片集成度向更高水平发展，为摩尔定律的延续提供了新的技术路径。</p>', 1, 48, 1, 1761883748, 1762249571, 0, '芯科科技封装技术实验室在2.5D封装技术上取得重大突破，成功开发出基于硅中介层的解决方案', '', '2.5D封装,芯片集成,性能提升,先进封装', '', '芯科科技突破2.5D封装技术，芯片性能提升30%，功耗降低25%，推动芯片集成度提升。', 1, '', '', '封装实验室', '技术研发动态', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (428, 19, '新型量子点材料在芯片散热领域应用', '/uploads/images/news/news23.jpg', '', '<p>芯科科技材料研究中心与高校合作，在量子点材料应用于芯片散热领域取得重要进展。研究团队开发出一种基于石墨烯量子点的复合散热材料，热导率比传统材料提升5倍以上。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news24.jpg\" alt=\"量子点材料\"></p><p>这种新型散热材料通过在石墨烯基底上定向生长量子点，形成了高效的热传导通道。在相同厚度下，散热效果比传统导热硅脂提升300%，且具有良好的机械强度和稳定性。</p><p>该材料已在小批量试产中验证了其可靠性，预计将在下一代高性能计算芯片中规模化应用。研究团队正在进一步优化材料配方，争取在2025年实现量产。</p><p>量子点散热技术的突破将有效解决高性能芯片的散热瓶颈，为芯片性能的持续提升提供了重要支撑。</p>', 1, 47, 1, 1761797348, 1761797348, 0, '芯科科技材料研究中心与高校合作，在量子点材料应用于芯片散热领域取得重要进展', '', '量子点,散热材料,热导率,石墨烯', '', '芯科科技开发量子点散热材料，热导率提升5倍，有效解决高性能芯片散热瓶颈。', 0, '', '', '材料研究中心', '技术研发动态', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (429, 20, '芯科科技将举办2024技术创新大会活动', '/uploads/images/news/news25.jpg', '', '<p>芯科科技宣布将于下月在北京国家会议中心举办\"2024芯科技术创新大会\"。本次大会以\"智创未来，芯动世界\"为主题，将展示公司在AI芯片、物联网、汽车电子等领域的较新技术成果。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news26.jpg\" alt=\"大会预告\"></p><p>大会将设立主论坛和多个分论坛，涵盖AI芯片架构创新、边缘计算、自动驾驶、工业物联网等热点话题。公司CTO将发布新一代芯片技术路线图，多位行业专家将分享技术洞见。</p><p>参会者还可以亲身体验基于芯科芯片的各类创新应用，包括智能机器人、自动驾驶演示、工业物联网解决方案等。大会期间还将举办技术 workshops 和合作伙伴交流会。</p><p>预计将有超过2000名行业专家、客户代表、合作伙伴和媒体记者参加本次大会，成为年度最重要的行业技术盛会之一。</p>', 1, 48, 1, 1761710948, 1761710948, 0, '芯科科技宣布将举办2024技术创新大会，展示AI芯片、物联网、汽车电子等领域技术成果', '', '技术大会,创新展示,AI芯片,行业盛会', '', '芯科科技将举办2024技术创新大会，展示AI芯片、物联网、汽车电子等领域最新技术成果。', 0, '', '', '大会组委会', '活动预告', 1, 30, '', '', '', '', '', NULL, NULL, 5, '0', '', '');
INSERT INTO `ry_article` VALUES (430, 20, '芯科科技公益基金会正式成立仪式', '/uploads/images/news/news27.jpg', '', '<p>芯科科技今日宣布正式成立\"芯科科技公益基金会\"，初始捐赠资金1亿元。基金会将专注于科技教育、人才培养、产业扶贫三个方向，推动科技创新与社会责任的深度融合。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news28.jpg\" alt=\"基金会成立\"></p><p>基金会首批项目包括\"芯火计划\"——支持高校芯片人才培养；\"智惠乡村\"——用科技助力乡村振兴；\"科技启航\"——面向青少年的科普教育活动。预计每年将惠及超过10万人。</p><p>公司董事长在成立仪式上表示：\"作为科技企业，我们不仅要追求技术创新和商业成功，更要承担社会责任，回馈社会。基金会的成立是公司履行社会责任的重要里程碑。\"</p><p>芯科科技公益基金会将建立透明的管理机制，定期向社会公布项目进展和资金使用情况，力求公益项目的有效实施。</p>', 1, 47, 1, 1761624548, 1761624548, 0, '芯科科技宣布正式成立公益基金会，初始捐赠资金1亿元，专注科技教育、人才培养等方向', '', '公益基金会,社会责任,科技教育,人才培养', '', '芯科科技成立公益基金会，初始捐赠1亿元，专注科技教育、人才培养和产业扶贫。', 0, '', '', '公益事业部', '企业社会责任', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (431, 17, '芯科科技获得ISO26262功能安全认证', '/uploads/images/news/news29.jpg', '', '<p>芯科科技今日宣布，其汽车电子芯片研发体系成功通过道路车辆功能安全标准功能安全认证，这标志着公司在汽车电子领域的技术实力和管理水平达到了国际先进标准。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news30.jpg\" alt=\"认证证书\"/></p><p>道路车辆功能安全标准是汽车电子领域最重要的功能安全标准，涵盖了从概念设计到产品退役的全生命周期安全管理。获得该认证意味着芯科科技的汽车电子芯片在功能安全方面达到了车规级要求。</p><p>认证过程历时18个月，公司建立了完整的功能安全管理体系，培训了超过100名功能安全工程师。目前，已有多个基于该体系的汽车电子芯片项目在推进中。</p><p>这项认证将有力推动芯科科技在汽车电子市场的拓展，特别是在自动驾驶、智能座舱等安全要求高的应用领域。</p>', 1, 45, 1, 1761538148, 1762249538, 0, '芯科科技汽车电子芯片研发体系成功通过ISO26262功能安全认证，达到国际先进标准', '', 'ISO26262,功能安全,汽车电子,认证', '', '芯科科技获得ISO 26262功能安全认证，汽车电子芯片研发体系达到国际先进标准。', 1, '', '', '质量认证部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', '', NULL, 7, '0', '', '');
INSERT INTO `ry_article` VALUES (432, 19, '光计算芯片研发取得阶段性重要成果', '/uploads/images/news/news31.jpg', '', '<p>芯科科技前沿技术研究院在光计算芯片研发方面取得重要阶段性成果。研究团队成功开发出基于硅光子的矩阵计算单元原型，在特定AI推理任务中展现出巨大潜力。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news32.jpg\" alt=\"光计算芯片\"></p><p>光计算芯片利用光子代替电子进行信息处理，具有超高速度、超低功耗的优势。测试数据显示，光计算单元在矩阵乘法运算中的能效比达到传统电子芯片的100倍以上。</p><p>目前，研究团队正在解决光计算芯片的集成度和制造工艺等关键技术挑战。预计在3-5年内，光计算技术将在AI推理等特定场景实现商业化应用。</p><p>光计算被认为是后摩尔时代的重要技术方向之一，这项研究成果为芯科科技在下一代计算技术领域奠定了重要基础。</p>', 1, 46, 1, 1761451748, 1761451748, 0, '芯科科技前沿技术研究院在光计算芯片研发方面取得重要阶段性成果，开发出硅光子计算单元', '', '光计算,硅光子,AI推理,能效比', '', '芯科科技光计算芯片研发取得阶段性成果，能效比达传统芯片100倍，为AI推理提供新方案。', 0, '', '', '前沿技术研究院', '技术研发动态', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (500, 5, '国家认可高新技术企业', '', '', '2018年获得国家高新技术企业认证', 1, 60, 1, 1762246895, 1762246895, 0, '2018年获得国家高新技术企业认证', '', '高新技术企业,国家级认证,企业资质', '', '芯科科技于2018年获得国家认可高新技术企业认证，标志着公司在技术创新和研发实力方面达到国家认可标准。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>国家对企业技术创新能力的权威认可</p><p>体现公司在研发投入和技术成果转化方面的实力</p><p>为后续发展提供政策支持和品牌背书</p>', '<p>需要定期复审以保持认证资格</p>', 0, '0', 'fa-award', '');
INSERT INTO `ry_article` VALUES (501, 5, '中国芯片设计十强企业', '', '', '2020年入选中国芯片设计行业十强', 1, 59, 1, 1762246895, 1762246895, 0, '2020年入选中国芯片设计行业十强', '', '芯片设计十强,行业排名,领军企业', '', '芯科科技在2020年入选中国芯片设计行业十强企业，彰显了在芯片设计领域的综合实力和行业地位。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>行业权威机构评选的十强企业</p><p>体现公司在芯片设计领域的综合竞争力</p><p>获得行业和市场的广泛认可</p>', '<p>需要持续保持技术优秀和市场份额</p>', 0, '0', 'fa-trophy', '');
INSERT INTO `ry_article` VALUES (502, 5, '科技创新金奖', '', '', '2021年获得电子行业科技创新金奖', 1, 58, 1, 1762246895, 1762246895, 0, '2021年获得电子行业科技创新金奖', '', '科技创新金奖,电子行业,技术奖项', '', '芯科科技在2021年荣获电子行业科技创新金奖，表彰公司在技术创新和产品研发方面的突出贡献。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>电子行业权威科技创新奖项</p><p>认可公司在技术研发和创新应用方面的成就</p><p>提升品牌影响力和行业知名度</p>', '<p>需要持续创新以保持奖项含金量</p>', 0, '0', 'fa-medal', '');
INSERT INTO `ry_article` VALUES (503, 5, 'ISO9001质量体系认证', '', '', '通过国际标准化组织质量体系认证', 1, 57, 1, 1762246895, 1762246895, 0, '通过国际标准化组织质量体系认证', '', 'ISO9001,质量体系,国际认证', '', '芯科科技通过ISO9001国际质量体系认证，建立了完善的质量管理体系，确保产品和服务的高质量标准。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>国际通用的质量管理体系标准</p><p>力求产品研发和生产过程的质量控制</p><p>提升客户信任度和市场竞争力</p>', '<p>需要严格执行和维护质量管理体系</p>', 0, '0', 'fa-certificate', '');
INSERT INTO `ry_article` VALUES (504, 5, '优秀雇主企业', '', '', '2022年荣获较好雇主企业称号', 1, 56, 1, 1762246895, 1762246895, 0, '2022年荣获较好雇主企业称号', '', '较好雇主,人力资源管理,企业文化', '', '芯科科技在2022年荣获较好雇主企业称号，体现了公司在人才发展、企业文化和员工关怀方面的卓越表现。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>优秀的人才吸引和保留能力</p><p>良好的企业文化和员工发展环境</p><p>提升企业形象和人才竞争力</p>', '<p>需要持续投入人力资源建设</p>', 0, '0', 'fa-star', '');
INSERT INTO `ry_article` VALUES (505, 5, '行业领军企业', '', '', '2023年被评为芯片行业领军企业', 1, 55, 1, 1762246895, 1762246895, 0, '2023年被评为芯片行业领军企业', '', '行业领军,芯片行业,领导地位', '', '芯科科技在2023年被评为芯片行业领军企业，确立了在芯片设计制造领域的领导地位和行业影响力。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>行业领导地位和市场影响力</p><p>技术引领和产业带动作用</p><p>为行业发展做出重要贡献</p>', '<p>需要承担更多的行业责任和引领作用</p>', 0, '0', 'fa-crown', '');
INSERT INTO `ry_article` VALUES (506, 5, '专精特新小巨人企业', '', '', '2022年入选国家认可专精特新小巨人企业', 1, 54, 1, 1762246895, 1762246895, 0, '2022年入选国家认可专精特新小巨人企业', '', '专精特新,小巨人,专业化企业', '', '芯科科技在2022年入选国家认可专精特新小巨人企业，体现了公司在专业化、精细化、特色化、新颖化发展方面的突出表现。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>国家支持的专业化特色企业发展计划</p><p>在细分领域具有技术优势和市场份额</p><p>获得政策支持和资源倾斜</p>', '<p>需要持续专注细分领域的技术突破</p>', 0, '0', 'fa-rocket', '');
INSERT INTO `ry_article` VALUES (507, 5, '知识产权示范企业', '', '', '2021年被评为国家知识产权示范企业', 1, 53, 1, 1762246895, 1762246895, 0, '2021年被评为国家知识产权示范企业', '', '知识产权,示范企业,专利保护', '', '芯科科技在2021年被评为国家知识产权示范企业，展示了公司在知识产权创造、运用和保护方面的卓越能力。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>知识产权管理和保护体系完善</p><p>专利数量和质量行业先进</p><p>为技术创新提供法律支持</p>', '<p>需要持续加强知识产权布局和保护</p>', 0, '0', 'fa-gem', '');
INSERT INTO `ry_article` VALUES (508, 5, '绿色制造示范企业', '', '', '2023年获得绿色制造示范企业称号', 1, 52, 1, 1762246895, 1762246895, 0, '2023年获得绿色制造示范企业称号', '', '绿色制造,环保认证,可持续发展', '', '芯科科技在2023年获得绿色制造示范企业称号，体现了公司在环保生产和可持续发展方面的社会责任。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>生产过程中的环保和节能措施</p><p>绿色产品设计和制造理念</p><p>符合国家双碳战略要求</p>', '<p>需要持续投入环保技术和设备</p>', 0, '0', 'fa-leaf', '');
INSERT INTO `ry_article` VALUES (509, 5, '数字化转型示范企业', '', '', '2022年入选工业互联网数字化转型示范企业', 1, 51, 1, 1762246895, 1762246895, 0, '2022年入选工业互联网数字化转型示范企业', '', '数字化转型,工业互联网,智能制造', '', '芯科科技在2022年入选工业互联网数字化转型示范企业，展示了公司在智能制造和数字化管理方面的优秀实践。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>生产制造过程的数字化智能化</p><p>工业互联网平台的应用实践</p><p>提升生产效率和产品质量</p>', '<p>需要持续投入数字化技术升级</p>', 0, '0', 'fa-laptop-code', '');
INSERT INTO `ry_article` VALUES (510, 5, '社会责任优秀企业', '', '', '2023年获得企业社会责任优秀企业奖', 1, 50, 1, 1762246895, 1762246895, 0, '2023年获得企业社会责任优秀企业奖', '', '社会责任,企业公民,公益贡献', '', '芯科科技在2023年获得企业社会责任优秀企业奖，表彰公司在社会责任履行和公益事业方面的突出贡献。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>积极参与社会公益和慈善事业</p><p>关注员工福利和社区发展</p><p>践行企业公民责任</p>', '<p>需要持续投入社会责任项目</p>', 0, '0', 'fa-hand-holding-heart', '');
INSERT INTO `ry_article` VALUES (511, 5, '国际质量金奖', '', '', '2024年荣获国际质量金奖', 1, 49, 1, 1762246895, 1762246895, 0, '2024年荣获国际质量金奖', '', '国际质量金奖,质量管理,卓越绩效', '', '芯科科技在2024年荣获国际质量金奖，标志着公司在质量管理体系和产品品质方面达到国际先进水平。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>国际权威质量奖项认可</p><p>质量管理体系达到国际标准</p><p>产品品质获得全球客户信赖</p>', '<p>需要持续维护和提升质量标准</p>', 0, '0', 'fa-trophy', '');
INSERT INTO `ry_article` VALUES (512, 2, '研发团队', '', '', '', 1, 60, 1, 1762248029, 1762248356, 0, '500', '', '研发团队,技术人才,创新力量', '', '芯科科技拥有500人的专业研发团队，涵盖芯片设计、算法开发、系统架构等多个技术领域。', 1, '', '', '', '', 0, 30, '', '', '', '', '', '<p>专业的技术研发人才队伍</p><p>持续的技术创新和产品研发</p><p>为行业发展提供技术支撑</p>', '<p>需要持续吸引和培养技术人才</p>', 0, '0', 'fa-users', '');
INSERT INTO `ry_article` VALUES (513, 2, '行业经验', '', '', '', 1, 59, 1, 1762248029, 1762248364, 0, '15', '', '行业经验,技术积累,专业沉淀', '', '芯科科技在芯片行业拥有15年的深厚积累，积累了丰富的技术经验和行业洞察。', 1, '', '', '', '', 0, 30, '', '', '', '', '', '<p>15年行业深耕和技术沉淀</p><p>丰富的项目经验和成功案例</p><p>对行业发展趋势的深刻理解</p>', '<p>需要持续学习和适应技术变革</p>', 0, '0', 'fa-microchip', '');
INSERT INTO `ry_article` VALUES (514, 2, '全球业务', '', '', '', 1, 58, 1, 1762248029, 1762248332, 0, '50', '', '全球业务,国际市场,海外拓展', '', '芯科科技业务覆盖全球50多个国家和地区，建立了完善的国际营销和服务网络。', 1, '', '', '', '', 0, 30, '', '', '', '', '', '<p>产品和服务覆盖全球市场</p><p>国际化运营和管理能力</p><p>为全球客户提供技术支持</p>', '<p>需要适应不同国家和地区的市场需求</p>', 0, '0', 'fa-globe', '');
INSERT INTO `ry_article` VALUES (515, 2, '专利技术', '', '', '', 1, 57, 1, 1762248029, 1762248318, 0, '100', '', '专利技术,知识产权,技术创新', '100', '芯科科技拥有100多项核心专利技术，在芯片设计和制造领域建立了坚实的技术壁垒。', 1, '', '', '', '', 0, 30, '', '', '', '', '', '<p>自主知识产权的核心技术</p><p>持续的技术创新和专利布局</p><p>为产品竞争力提供支持</p>', '<p>需要持续投入研发和专利保护</p>', 0, '0', 'fa-award', '');
INSERT INTO `ry_article` VALUES (516, 2, '企业使命', '', '', '', 1, 56, 1, 1762248029, 1762248584, 0, '通过创新的芯片技术，推动科技进步，赋能智能世界', '', '企业使命,发展目标,社会责任', '', '芯科科技的企业使命是通过创新的芯片技术推动科技进步，为智能世界的发展提供核心动力。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>以技术创新驱动行业发展</p><p>为智能化转型提供技术支撑</p><p>履行企业的社会责任</p>', '<p>需要持续的技术投入和创新</p>', 0, '0', 'fa-bullseye', '');
INSERT INTO `ry_article` VALUES (517, 2, '企业愿景', '', '', '', 1, 55, 1, 1762248029, 1762248573, 0, '成为全球优秀的芯片设计企业，引领行业发展', '', '企业愿景,战略目标,行业领导', '', '芯科科技的企业愿景是成为全球优秀的芯片设计企业，在技术创新和产业发展中发挥引领作用。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>追求行业领导地位</p><p>引领技术发展方向</p><p>推动产业生态建设</p>', '<p>需要持续的创新和市场拓展</p>', 0, '0', 'fa-eye', '');
INSERT INTO `ry_article` VALUES (518, 2, '核心价值观', '', '', '', 1, 54, 1, 1762248029, 1762248560, 0, '创新、诚信、协作、担当、卓越', '', '核心价值观,企业文化,价值理念', '', '芯科科技的核心价值观是创新、诚信、协作、担当、卓越，这五个方面构成了企业的文化基石。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>创新驱动发展</p><p>诚信赢得信任</p><p>协作创造价值</p><p>担当体现责任</p><p>卓越追求良好</p>', '<p>需要全员践行和文化建设</p>', 0, '0', 'fa-handshake', '');
INSERT INTO `ry_article` VALUES (623, 4, '技术创新', '', '', '7nm先进制程工艺\n自主研发AI计算架构\n低功耗设计技术', 1, 50, 1, 1762245974, 1762245974, 0, '拥有100+项专利技术，持续投入研发，保持技术优秀优势', '', '技术创新,专利技术,7nm工艺,AI计算架构', '', '芯科科技拥有100+项专利技术，掌握7nm先进制程工艺和自主研发AI计算架构，在低功耗设计技术上保持行业优秀。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>7nm先进制程工艺带来更高的性能和更低的功耗</p><p>自主研发的AI计算架构针对人工智能应用深度优化</p><p>低功耗设计技术延长设备续航时间</p>', '<p>需要持续投入研发以保持技术优秀地位</p>', 0, '0', 'fa-lightbulb', '');
INSERT INTO `ry_article` VALUES (624, 4, '全产业链', '', '', '芯片设计与验证\n流片制造与封装\n测试与品质控制', 1, 49, 1, 1762245974, 1762245974, 0, '从芯片设计到制造测试的全产业链布局，确保产品质量可控', '', '全产业链,芯片设计,流片制造,品质控制', '', '芯科科技拥有从芯片设计、流片制造到封装测试的全产业链布局，确保产品质量全程可控，提供一站式解决方案。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>完整的芯片设计流程和验证体系</p><p>先进的流片制造和封装技术</p><p>严格的测试标准和品质控制流程</p>', '<p>全产业链布局需要大量资金和技术投入</p>', 0, '0', 'fa-cogs', '');
INSERT INTO `ry_article` VALUES (625, 4, '专业团队', '', '', '<p>资深芯片设计专家\n算法与架构工程师\n系统与应用工程师</p>', 1, 48, 1, 1762185600, 1764578094, 0, '500+研发团队，核心成员平均从业经验超过10年', '', '专业团队,研发团队,芯片设计专家,算法工程师', '', '芯科科技拥有500+人的专业研发团队，核心成员平均从业经验超过10年，涵盖芯片设计、算法架构和系统应用等多个领域。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>资深芯片设计专家力求产品技术先进</p><p>算法与架构工程师优化系统性能</p><p>系统与应用工程师支持产品落地应用</p>', '<p>需要持续的人才培养和团队建设</p>', 0, '0', 'fa-user-tie', '机器学习,人工智能,深度学习,大数据');
INSERT INTO `ry_article` VALUES (626, 4, '品质保证', '', '', '<p>ISO9001质量管理体系\n车规级汽车电子委员会质量认证认证\n工业级可靠性测试</p>', 1, 47, 1, 1762185600, 1764578027, 0, '严格的质量管理体系，产品通过多项国际认证', '', '品质保证,ISO9001,AEC-Q100,可靠性测试', '', '芯科科技建立严格的质量管理体系，产品通过ISO9001、车规级AEC-Q100等多项国际认证，确保产品的高可靠性和稳定性。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>ISO9001质量管理体系力求流程规范</p><p>车规级AEC-Q100认证满足汽车电子要求</p><p>工业级可靠性测试支持产品长期稳定运行</p>', '<p>认证和维护需要持续投入和管理</p>', 0, '0', 'fa-shield-alt', '');
INSERT INTO `ry_article` VALUES (627, 101, '联想', 'https://img.icons8.com/color/96/000000/lenovo.png', NULL, NULL, 1, 50, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (628, 101, '小米', 'https://img.icons8.com/color/96/000000/xiaomi.png', NULL, NULL, 1, 49, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (629, 101, '百度', 'https://img.icons8.com/color/96/000000/baidu.png', NULL, NULL, 1, 48, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (630, 101, '特斯拉', 'https://img.icons8.com/color/96/000000/tesla.png', NULL, NULL, 1, 47, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (631, 101, '奥迪', 'https://img.icons8.com/color/96/000000/audi.png', NULL, NULL, 1, 46, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (632, 101, '宝马', 'https://img.icons8.com/color/96/000000/bmw.png', NULL, NULL, 1, 45, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (633, 101, '奔驰', 'https://img.icons8.com/color/96/000000/mercedes-benz.png', NULL, NULL, 1, 44, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (634, 101, '大众', 'https://img.icons8.com/color/96/000000/volkswagen.png', NULL, NULL, 1, 43, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (635, 101, '丰田', 'https://img.icons8.com/color/96/000000/toyota.png', NULL, NULL, 1, 42, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (636, 101, '三星', 'https://img.icons8.com/color/96/000000/samsung.png', NULL, NULL, 1, 41, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (637, 101, '戴尔', 'https://img.icons8.com/color/96/000000/dell.png', NULL, NULL, 1, 40, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (638, 101, '惠普', 'https://img.icons8.com/color/96/000000/hp.png', NULL, NULL, 1, 39, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_article` VALUES (639, 10, '智能语音助手芯片', '/uploads/images/product/product31.jpg', '', '<p>智能语音助手芯片采用先进的语音处理架构，集成高性能音频处理单元和神经网络加速器。该芯片支持多语言语音识别和自然语言理解，在复杂环境下的语音识别准确率超过95%。芯片采用低功耗设计，在待机状态下的功耗控制在1mA以内，确保设备续航时间。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product32.jpg\" alt=\"语音助手芯片应用\"></p><p>在技术实现方面，芯片集成了专用的声学前端处理模块，支持噪声抑制、回声消除和波束成形等先进技术。远场语音唤醒功能使得用户在5米范围内也能实现准确的语音交互。芯片还支持离线语音指令识别，在网络连接不稳定的环境下仍能保持基本功能。</p><p>该芯片已与多家智能家居厂商合作，应用于智能音箱、智能电视、空调等产品。在实际使用中，语音交互响应时间小于200毫秒，为用户提供流畅的使用体验。芯片的兼容性设计支持多种语音助手平台，方便厂商进行产品开发。</p><p>随着智能家居市场的快速发展，该芯片凭借其优秀的性能和可靠性，已成为众多智能设备厂商的首选方案，推动了语音交互技术在家庭场景的普及应用。</p>', 1, 50, 1, 1762588037, 1762588037, 0, '支持多语言识别和自然语言理解的语音处理芯片，为智能家居提供流畅语音交互体验', '', '语音助手,智能家居,语音识别', '899', '智能语音助手芯片支持多语言识别，集成音频处理单元，为智能家居提供流畅语音交互。', 1, '', '', '语音技术部', '芯科科技', 0, 30, '/uploads/images/product/product31.jpg,/uploads/images/product/product32.jpg,/uploads/images/product/product33.jpg', '', '', '', '', '<p>芯片采用先进的语音处理架构，集成高性能音频处理单元和神经网络加速器，支持多语言语音识别和自然语言理解。在复杂环境下语音识别准确率超过95%，远场语音唤醒功能支持5米范围内准确交互。低功耗设计确保设备续航，待机功耗控制在1mA以内。</p><p>声学前端处理模块集成噪声抑制、回声消除和波束成形技术，提升语音交互质量。支持离线语音指令识别，在网络不稳定环境下保持基本功能。兼容多种语音助手平台，方便产品开发集成。</p><p>在实际应用中，语音交互响应时间小于200毫秒，为用户提供流畅体验。芯片已广泛应用于智能音箱、智能电视等产品，推动语音交互技术在家居场景的普及。</p>', '<p>使用过程中需注意环境噪声对识别效果的影响，建议在相对安静的环境下使用以获得最佳体验。定期更新语音模型可提升识别准确率。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (640, 10, '智能安防监控芯片', '/uploads/images/product/product34.jpg', '', '<p>智能安防监控芯片专为视频监控应用设计，集成高性能图像处理单元和智能分析引擎。芯片支持4K超高清视频编码处理，在人形检测、车辆识别等智能分析任务中表现出色。采用先进的计算机视觉算法，目标检测准确率超过98%。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product35.jpg\" alt=\"安防监控应用\"></p><p>芯片架构针对安防场景深度优化，支持多路视频流并行处理，单芯片可同时处理4路1080P视频流。智能分析引擎能够实时识别人形、车辆、人脸等目标，并支持异常行为检测和智能告警功能。在低光照环境下，芯片的图像增强技术能够有效提升画面质量。</p><p>功耗管理方面，芯片采用动态电压频率调节技术，根据工作负载智能调整功耗。在轻负载情况下，功耗可降低至标准模式的30%，适合需要长时间运行的安防设备。</p><p>该芯片已应用于智慧社区、商业安防、交通监控等多个领域。在某智慧城市项目中，基于该芯片的监控系统成功识别多起异常事件，提升了公共安全水平。</p>', 1, 49, 1, 1762588037, 1762588037, 0, '集成图像处理和智能分析功能的安防监控芯片，支持4K视频编码和人形车辆检测', '', '安防监控,图像处理,智能分析', '1299', '智能安防监控芯片支持4K视频编码和人形检测，为安防系统提供可靠视觉感知能力。', 1, '', '', '安防技术部', '芯科科技', 0, 30, '/uploads/images/product/product34.jpg,/uploads/images/product/product35.jpg,/uploads/images/product/product36.jpg', '', '', '', '', '<p>芯片集成高性能图像处理单元和智能分析引擎，支持4K超高清视频编码处理。在人形检测、车辆识别等任务中准确率超过98%，采用先进计算机视觉算法提升识别精度。支持多路视频流并行处理，单芯片可同时处理4路1080P视频流。</p><p>智能分析引擎实时识别人形、车辆、人脸等目标，支持异常行为检测和智能告警。低光照图像增强技术提升画面质量，动态电压频率调节技术优化功耗管理。在轻负载情况下功耗可降低至标准模式的30%。</p><p>芯片已应用于智慧社区、商业安防等领域，在智慧城市项目中成功识别多起异常事件，提升公共安全水平。</p>', '<p>安装时需确保摄像头位置合理，避免逆光和遮挡。定期清洁镜头保持图像清晰，更新算法模型可提升识别准确率。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (641, 10, '工业传感器芯片', '/uploads/images/product/product37.jpg', '', '<p>工业传感器芯片针对工业自动化应用设计，集成多类型传感器接口和高精度信号处理单元。芯片支持温度、压力、振动、位移等多种工业参数采集，测量精度达到行业先进水平。采用工业级可靠性设计，工作温度范围-40°C至+85°C。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product38.jpg\" alt=\"工业传感器应用\"></p><p>在信号处理方面，芯片集成24位高精度ADC和可编程增益放大器，支持多种传感器信号的直接接入。数字滤波算法有效抑制工业环境中的电磁干扰，确保数据采集的准确性。在振动监测应用中，频率响应范围达到0.1Hz-10kHz，精度误差小于1%。</p><p>芯片支持多种工业通信协议，包括4-20mA电流环、工业以太网协议、过程现场总线等，便于与现有工业系统集成。自诊断功能能够实时监测传感器状态，及时发现故障并告警。</p><p>该芯片已广泛应用于智能制造、设备状态监测、过程控制等领域。在某大型制造企业，基于该芯片的监测系统成功预警了多起设备异常，避免了生产中断。</p>', 1, 48, 1, 1762588037, 1762588037, 0, '工业级多参数传感器采集芯片，支持温度压力振动监测，满足工业自动化需求', '', '工业传感器,数据采集,信号处理', '1599', '工业传感器芯片集成多类型传感器接口，支持工业参数采集，满足自动化需求。', 2, '', '', '工业物联网部', '芯科科技', 0, 30, '/uploads/images/product/product37.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product39.jpg', '', '', '', '', '<p>芯片集成多类型传感器接口和高精度信号处理单元，支持温度、压力、振动、位移等工业参数采集。测量精度达到行业先进水平，工业级可靠性设计确保在-40°C至+85°C温度范围内稳定工作。24位高精度ADC和可编程增益放大器支持多种传感器信号直接接入。</p><p>数字滤波算法有效抑制工业环境电磁干扰，振动监测频率响应范围0.1Hz-10kHz，精度误差小于1%。支持4-20mA电流环、PROFINET、PROFIBUS等工业通信协议，便于系统集成。自诊断功能实时监测传感器状态，及时发现故障。</p><p>芯片已应用于智能制造、设备状态监测等领域，在大型制造企业成功预警多起设备异常，避免生产中断。</p>', '<p>安装时需注意传感器接线正确，避免信号干扰。定期校准确保测量精度，在恶劣工业环境下建议增加防护措施。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (642, 10, '智能医疗监测芯片', '/uploads/images/product/product40.jpg', '', '<p>智能医疗监测芯片专为可穿戴医疗设备设计，集成生理信号采集和健康数据分析功能。芯片支持心率、血氧饱和度、体温、心电图等关键生理参数监测，测量精度满足医疗级要求。采用低功耗架构，确保设备续航时间达到7天以上。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product41.jpg\" alt=\"医疗监测应用\"></p><p>在生理信号处理方面，芯片集成专业级心电信号采集电路，支持单导联心电图监测。光电容积脉搏波技术实现无创血氧监测，测量误差小于2%。运动伪影抑制算法有效消除日常活动对监测数据的影响，提升测量准确性。</p><p>健康数据分析引擎能够识别异常生理模式，提供健康风险预警。芯片支持本地数据分析和云端数据同步，在保护用户隐私的同时实现健康管理的连续性。数据加密传输确保个人信息安全。</p><p>该芯片已应用于智能手表、健康手环、便携式心电监测设备等产品。在临床验证中，心率监测准确率达到99%，为个人健康管理提供可靠的技术支持。</p>', 1, 47, 1, 1762588037, 1762588037, 0, '可穿戴医疗设备专用监测芯片，支持心率血氧等生理参数精准采集分析', '', '医疗监测,可穿戴设备,生理参数', '1399', '智能医疗监测芯片支持心率血氧监测，为可穿戴设备提供健康管理功能。', 1, '', '', '医疗电子部', '芯科科技', 0, 30, '/uploads/images/product/product40.jpg,/uploads/images/product/product41.jpg,/uploads/images/product/product42.jpg', '', '', '', '', '<p>芯片集成生理信号采集和健康数据分析功能，支持心率、血氧饱和度、体温、心电图等参数监测。测量精度满足医疗级要求，低功耗架构确保设备续航7天以上。专业级心电信号采集电路支持单导联心电图监测，光电容积脉搏波技术实现无创血氧监测。</p><p>运动伪影抑制算法消除日常活动对监测数据影响，健康数据分析引擎识别异常生理模式并提供预警。支持本地分析和云端数据同步，数据加密传输确保信息安全。在临床验证中，心率监测准确率99%，血氧测量误差小于2%。</p><p>芯片已应用于智能手表、健康手环等产品，为个人健康管理提供可靠技术支持。</p>', '<p>使用前需进行个人参数校准，佩戴时确保传感器与皮肤接触良好。剧烈运动可能影响监测准确性，建议在相对静止状态下进行测量。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (643, 10, '智能农业监测芯片', '/uploads/images/product/product43.jpg', '', '<p>智能农业监测芯片针对现代农业应用设计，集成环境传感器和作物生长监测功能。芯片支持土壤湿度、光照强度、空气温湿度、二氧化碳浓度等环境参数采集，为精准农业提供全面的数据支持。采用防腐蚀封装设计，适应农田潮湿和化学环境。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product44.jpg\" alt=\"农业监测应用\"></p><p>芯片集成智能算法，能够根据作物生长模型提供精准的灌溉和施肥建议。土壤水分传感器支持多点测量，准确反映土壤湿度分布情况。光照传感器监测光合有效辐射，为温室补光控制提供依据。环境数据融合分析帮助农户优化种植策略。</p><p>在通信方面，芯片支持低功耗广域网络技术通信和移动物联网通信，适应农田偏远地区的通信需求。太阳能供电设计使得监测设备可以长期独立工作，减少维护需求。数据加密传输确保农业数据安全。</p><p>该芯片已在全国多个智慧农业示范基地部署。实际应用数据显示，采用该芯片的精准农业系统可节水30%，肥料利用率提升25%，作物产量提高15%以上。</p>', 1, 46, 1, 1762588037, 1762588037, 0, '农业环境监测专用芯片，支持土壤湿度光照等参数采集，助力精准农业发展', '', '农业监测,精准农业,环境传感', '999', '智能农业监测芯片支持环境参数采集，为精准农业提供数据支持和管理建议。', 0, '', '', '农业物联网部', '芯科科技', 0, 30, '/uploads/images/product/product43.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product45.jpg', '', '', '', '', '<p>芯片集成环境传感器和作物生长监测功能，支持土壤湿度、光照强度、空气温湿度、二氧化碳浓度等参数采集。防腐蚀封装设计适应农田潮湿化学环境，智能算法根据作物生长模型提供灌溉施肥建议。土壤水分传感器支持多点测量，准确反映湿度分布。</p><p>光照传感器监测光合有效辐射，为温室补光控制提供依据。环境数据融合分析优化种植策略，支持LoRa和NB-IoT通信适应农田偏远地区需求。太阳能供电设计确保长期独立工作，数据加密传输保障农业数据安全。</p><p>在智慧农业示范基地应用中，精准农业系统实现节水30%，肥料利用率提升25%，作物产量提高15%以上。</p>', '<p>安装时需合理布置传感器位置，避免极端天气影响。定期校准传感器确保数据准确性，注意电池或太阳能板的维护保养。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (644, 10, '智能照明控制芯片', '/uploads/images/product/product46.jpg', '', '<p>智能照明控制芯片集成调光控制和环境感知功能，为智能照明系统提供完整的控制解决方案。芯片支持0-10V调光、脉冲宽度调制调光、可控硅调光等多种调光方式，调光精度达到1%。采用先进的光照度感知技术，能够根据环境光线自动调节亮度。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product47.jpg\" alt=\"照明控制应用\"></p><p>人体感应功能支持存在检测和移动检测两种模式，实现按需照明。场景化照明控制支持多种预设场景的一键切换，满足不同应用场景的照明需求。色彩调节功能支持2700K-6500K色温无级调节和RGB全彩控制，营造舒适的照明氛围。</p><p>在节能方面，芯片的智能调度算法能够根据使用习惯优化照明策略，在商业照明应用中节能效果达到30%以上。组网控制功能支持大规模照明系统的统一管理，简化运维工作。</p><p>该芯片已应用于智能家居、商业照明、办公照明等多个领域。在某大型商业综合体项目中，基于该芯片的智能照明系统年节电率达到35%，显著降低了运营成本。</p>', 1, 45, 1, 1762588037, 1762588037, 0, '智能照明系统控制芯片，支持精确调光和环境感知，实现节能舒适照明', '', '智能照明,调光控制,环境感知', '1099', '智能照明控制芯片支持多种调光方式和环境感知，实现智能节能照明管理。', 1, '', '', '智能照明部', '芯科科技', 0, 30, '/uploads/images/product/product46.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product48.jpg', '', '', '', '', '<p>芯片集成调光控制和环境感知功能，支持0-10V调光、PWM调光、可控硅调光等多种方式，调光精度1%。光照度感知技术根据环境光线自动调节亮度，人体感应支持存在检测和移动检测实现按需照明。场景化照明控制支持预设场景一键切换。</p><p>色彩调节功能支持2700K-6500K色温无级调节和RGB全彩控制，营造舒适照明氛围。智能调度算法根据使用习惯优化照明策略，商业照明应用中节能效果达30%以上。组网控制功能支持大规模照明系统统一管理。</p><p>在大型商业综合体项目中，智能照明系统年节电率35%，显著降低运营成本。芯片适用于智能家居、商业照明、办公照明等多个领域。</p>', '<p>调光系统需匹配兼容的灯具类型，安装时注意线路负载能力。定期检查传感器灵敏度，确保自动控制功能正常运作。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (645, 10, '智能门禁控制芯片', '/uploads/images/product/product49.jpg', '', '<p>智能门禁控制芯片集成多种身份认证方式和安全控制功能，为现代门禁系统提供可靠的技术支持。芯片支持指纹识别、人脸识别、IC卡、密码等多种认证方式，认证准确率超过99.5%。采用金融级安全加密技术，防止未授权访问。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product50.jpg\" alt=\"门禁控制应用\"></p><p>活体检测功能有效防止照片、视频等欺骗手段，提升系统安全性。多因素认证支持组合验证模式，满足高安全等级场景的需求。实时监控功能能够记录所有门禁事件，为安全管理提供完整的数据支持。</p><p>芯片支持远程授权和管理，管理员可以通过网络进行权限设置和状态监控。防拆报警功能在设备遭到破坏时立即发出告警。低功耗设计确保在断电情况下备用电源可维持系统运行24小时以上。</p><p>该芯片已广泛应用于写字楼、住宅小区、工厂园区等场所。在某高端写字楼项目中，基于该芯片的门禁系统实现了数千员工的精准权限管理，提升了安全管理效率。</p>', 1, 44, 1, 1762588037, 1762588037, 0, '多功能门禁系统控制芯片，支持指纹人脸等多种认证方式，保障出入安全', '', '门禁控制,身份认证,安全管理', '1499', '智能门禁控制芯片支持多种认证方式，采用安全加密技术保障出入安全。', 2, '', '', '安防技术部', '芯科科技', 0, 30, '/uploads/images/product/product49.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product51.jpg', '', '', '', '', '<p>芯片集成多种身份认证方式，支持指纹识别、人脸识别、IC卡、密码等，认证准确率超过99.5%。金融级安全加密技术防止未授权访问，活体检测功能有效防止照片视频欺骗。多因素认证支持组合验证模式，满足高安全等级需求。</p><p>实时监控功能记录所有门禁事件，远程授权管理支持网络权限设置和状态监控。防拆报警功能在设备破坏时立即告警，低功耗设计确保备用电源维持系统运行24小时以上。芯片适用于写字楼、住宅小区、工厂园区等场所。</p><p>在高端写字楼项目中，门禁系统实现数千员工精准权限管理，提升安全管理效率。完整的事件记录为安全审计提供数据支持。</p>', '<p>定期更新认证数据库，及时删除离职人员权限。建议设置多重认证方式提升安全性，定期检查设备运行状态。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (646, 10, '环境质量监测芯片', '/uploads/images/product/product52.jpg', '', '<p>环境质量监测芯片集成多种气体传感器和颗粒物检测单元，为环境监测提供全面的数据采集能力。芯片支持PM2.5、PM10、二氧化碳、甲醛、挥发性有机物等关键环境参数监测，测量精度达到专业级标准。采用多传感器数据融合技术，提升监测数据的准确性。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product53.jpg\" alt=\"环境监测应用\"></p><p>自动校准功能确保传感器长期工作的稳定性，减少维护需求。智能预警算法能够识别环境污染趋势，及时发出预警信息。数据记录功能支持历史数据存储和趋势分析，为环境治理提供科学依据。</p><p>芯片支持室内外多种应用场景，监测数据可通过无线网络实时上传至云平台。低功耗设计适合长期监测应用，电池供电设备可连续工作数月。防尘防水设计适应各种环境条件。</p><p>该芯片已应用于智慧城市环境监测、室内空气质量监测、工业环境监控等领域。在某城市网格化监测系统中，基于该芯片的监测设备实现了区域空气质量的实时监控和污染源追踪。</p>', 1, 43, 1, 1762588037, 1762588037, 0, '多参数环境质量监测芯片，实时监测空气质量，为环境管理提供数据支持', '', '环境监测,空气质量,气体传感', '1199', '环境质量监测芯片支持多参数环境监测，测量精度达到专业级标准。', 1, '', '', '环境物联网部', '芯科科技', 0, 30, '/uploads/images/product/product52.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product54.jpg', '', '', '', '', '<p>芯片集成多种气体传感器和颗粒物检测单元，支持PM2.5、PM10、二氧化碳、甲醛、VOCs等环境参数监测。测量精度达到专业级标准，多传感器数据融合技术提升数据准确性。自动校准功能确保传感器长期稳定性，智能预警算法识别环境污染趋势。</p><p>数据记录功能支持历史数据存储和趋势分析，为环境治理提供科学依据。支持室内外多种应用场景，监测数据通过无线网络实时上传云平台。低功耗设计适合长期监测，电池供电设备连续工作数月。防尘防水设计适应各种环境条件。</p><p>芯片应用于智慧城市环境监测、室内空气质量监测等领域，在城市网格化监测系统中实现空气质量实时监控和污染源追踪。</p>', '<p>安装位置应避开通风口和污染源，定期清洁传感器防止积尘影响测量。建议每半年进行一次专业校准，确保数据准确性。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (647, 10, '智能家电控制芯片', '/uploads/images/product/product55.jpg', '', '<p>智能家电控制芯片为家用电器提供智能化和联网控制功能，推动家电产品的智能化升级。芯片支持多种家电控制协议，包括红外、射频、电力线载波等，兼容主流家电品牌。采用统一的设备抽象层，简化不同家电设备的集成难度。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product56.jpg\" alt=\"家电控制应用\"></p><p>场景化控制功能支持家电设备的联动控制，实现一键开启多种家电的协同工作。能耗监测功能实时统计家电用电情况，帮助用户优化用电习惯。远程控制功能支持通过手机App对家电进行状态监控和远程操作。</p><p>语音控制集成支持主流语音助手平台，实现语音控制家电设备。定时任务功能支持预设家电工作时间和模式，提升使用便利性。设备状态反馈功能实时显示家电运行状态，及时发现异常情况。</p><p>该芯片已与多家家电厂商合作，应用于空调、冰箱、洗衣机、电视等产品。在智能家居系统中，基于该芯片的家电控制实现了设备的互联互通，提升了用户的生活品质。</p>', 1, 42, 1, 1762588037, 1762588037, 0, '家电智能化控制芯片，支持多种控制协议和场景联动，提升生活便利性', '', '家电控制,智能家居,设备联动', '899', '智能家电控制芯片支持多种控制协议和场景联动，实现家电智能化管理。', 0, '', '', '智能家居部', '芯科科技', 0, 30, '/uploads/images/product/product55.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product57.jpg', '', '', '', '', '<p>芯片支持多种家电控制协议，包括红外、射频、电力线载波等，兼容主流家电品牌。统一设备抽象层简化不同家电设备集成，场景化控制功能支持家电设备联动控制。能耗监测功能实时统计家电用电情况，帮助优化用电习惯。</p><p>远程控制功能支持手机App状态监控和远程操作，语音控制集成支持主流语音助手平台。定时任务功能支持预设家电工作时间和模式，设备状态反馈功能实时显示运行状态。芯片与多家家电厂商合作，应用于空调、冰箱、洗衣机等产品。</p><p>在智能家居系统中实现设备互联互通，提升用户生活品质。家电联动控制实现一键开启多种家电协同工作，提升使用便利性。</p>', '<p>使用前需进行设备配对和网络配置，确保控制信号覆盖范围。定期更新设备固件提升兼容性，注意网络安全防护。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (648, 10, '智慧校园管理芯片', '/uploads/images/product/product58.jpg', '', '<p>智慧校园管理芯片针对教育场景设计，集成校园卡管理、考勤统计、安全监控等多种功能。芯片支持学生证、教职工卡等多种校园卡类型的识别和管理，实现一卡通校园应用。考勤统计功能自动记录学生出勤情况，生成统计报表。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product59.jpg\" alt=\"校园管理应用\"></p><p>安全监控功能支持校园重点区域的访问控制和安全预警。电子围栏功能能够识别学生异常出入情况，及时通知相关人员。消费管理功能支持校园食堂、超市等场所的电子支付，方便校园生活。</p><p>数据统计分析功能为学校管理提供决策支持，识别校园运行中的问题和改进空间。多校区管理功能支持分布式校园系统的统一管理。数据加密传输确保学生信息安全。</p><p>该芯片已在全国多所中小学和高校部署应用。实际使用数据显示，基于该芯片的智慧校园系统提升了管理效率30%以上，减少了人工管理的工作量。</p>', 1, 41, 1, 1762588037, 1762588037, 0, '校园智能化管理芯片，支持一卡通应用和安全管理，提升校园管理效率', '', '智慧校园,一卡通,校园管理', '1699', '智慧校园管理芯片支持校园卡管理和安全监控，提升校园管理智能化水平。', 1, '', '', '教育物联网部', '芯科科技', 0, 30, '/uploads/images/product/product58.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product60.jpg', '', '', '', '', '<p>芯片针对教育场景设计，集成校园卡管理、考勤统计、安全监控等多种功能。支持学生证、教职工卡等多种校园卡类型识别管理，实现一卡通校园应用。考勤统计功能自动记录出勤情况生成统计报表，安全监控功能支持重点区域访问控制和安全预警。</p><p>电子围栏功能识别学生异常出入情况及时通知，消费管理功能支持校园食堂、超市电子支付。数据统计分析功能为学校管理提供决策支持，多校区管理功能支持分布式校园系统统一管理。数据加密传输确保学生信息安全。</p><p>芯片在全国多所中小学和高校部署应用，智慧校园系统提升管理效率30%以上，减少人工管理工作量。校园一卡通应用方便学生校园生活，提升管理便利性。</p>', '<p>系统部署需考虑校园网络覆盖，确保各区域设备连通性。定期备份系统数据，及时处理设备故障。加强数据安全管理，保护学生隐私信息。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (649, 10, '智能仓储管理芯片', '/uploads/images/product/product61.jpg', '', '<p>智能仓储管理芯片为现代物流仓储提供智能化管理解决方案，集成库存监控、货物追踪、环境监测等多种功能。芯片支持RFID、二维码等多种货物识别技术，实现库存的精准管理。货物定位功能支持实时追踪货物位置，提升仓储效率。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product62.jpg\" alt=\"仓储管理应用\"></p><p>环境监测功能实时监控仓库温度、湿度等参数，确保货物存储条件。智能货架管理支持库存自动统计和补货预警。出入库管理功能自动化记录货物流动情况，减少人工操作错误。</p><p>数据分析功能为仓储优化提供决策支持，识别库存周转率和空间利用率等问题。多仓库管理功能支持分布式仓储系统的协同运作。防碰撞算法优化货物存储布局，提升空间利用效率。</p><p>该芯片已应用于电商仓储、制造业仓库、冷链物流等多个领域。在某大型电商仓库中，基于该芯片的智能仓储系统将库存准确率提升至99.5%，大幅降低了仓储管理成本。</p>', 1, 40, 1, 1762588037, 1762588037, 0, '仓储智能化管理芯片，支持库存监控和货物追踪，提升仓储管理效率', '', '智能仓储,库存管理,货物追踪', '1899', '智能仓储管理芯片支持库存监控和货物追踪，提升仓储管理智能化水平。', 2, '', '', '物流物联网部', '芯科科技', 0, 30, '/uploads/images/product/product61.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product1.jpg', '', '', '', '', '<p>芯片集成库存监控、货物追踪、环境监测等多种功能，支持RFID、二维码等多种货物识别技术实现精准库存管理。货物定位功能实时追踪货物位置提升仓储效率，环境监测功能监控仓库温度湿度确保货物存储条件。智能货架管理支持库存自动统计和补货预警。</p><p>出入库管理功能自动化记录货物流动减少人工错误，数据分析功能为仓储优化提供决策支持。多仓库管理功能支持分布式仓储系统协同运作，防碰撞算法优化货物存储布局提升空间利用效率。芯片应用于电商仓储、制造业仓库、冷链物流等领域。</p><p>在大型电商仓库中，智能仓储系统将库存准确率提升至99.5%，大幅降低仓储管理成本。货物追踪功能提升物流效率，环境监测确保特殊货物存储安全。</p>', '<p>部署时需合理规划设备布局，确保信号覆盖整个仓储区域。定期维护识别设备，保持读取准确性。注意环境参数监控，及时调整仓储条件。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (650, 10, '智能电梯控制芯片', '/uploads/images/product/product2.jpg', '', '<p>智能电梯控制芯片为现代电梯系统提供智能化和安全控制功能，集成电梯调度、安全监测、能耗管理等多种能力。芯片支持智能派梯算法，根据乘客流量和目的地优化电梯运行策略，减少等待时间。安全监测功能实时监控电梯运行状态，及时发现异常。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product3.jpg\" alt=\"电梯控制应用\"></p><p>能耗管理功能优化电梯运行能耗，在空闲时段自动进入节能模式。预测性维护功能基于运行数据识别潜在故障，提前安排维护工作。紧急救援功能在发生故障时自动启动应急程序，确保乘客安全。</p><p>数据分析功能为电梯运行优化提供支持，识别使用高峰和运行瓶颈。远程监控功能支持电梯状态的实时监控和故障诊断。兼容性设计支持与楼宇管理系统的集成。</p><p>该芯片已应用于写字楼、商场、住宅小区等多种建筑类型。实际运行数据显示，基于该芯片的智能电梯系统将平均等待时间减少25%，能耗降低20%以上。</p>', 1, 39, 1, 1762588037, 1762588037, 0, '电梯智能化控制芯片，支持智能调度和安全监测，提升电梯运行效率', '', '电梯控制,智能调度,安全监测', '2199', '智能电梯控制芯片支持智能派梯和安全监测，提升电梯运行效率和安全性。', 1, '', '', '楼宇自动化部', '芯科科技', 0, 30, '/uploads/images/product/product2.jpg,/uploads/images/product/product3.jpg,/uploads/images/product/product4.jpg', '', '', '', '', '<p>芯片集成电梯调度、安全监测、能耗管理等多种能力，支持智能派梯算法优化电梯运行策略减少等待时间。安全监测功能实时监控电梯运行状态及时发现异常，能耗管理功能优化运行能耗在空闲时段自动节能。预测性维护功能基于运行数据识别潜在故障提前安排维护。</p><p>紧急救援功能在故障时自动启动应急程序确保乘客安全，数据分析功能为电梯运行优化提供支持识别使用高峰和运行瓶颈。远程监控功能支持电梯状态实时监控和故障诊断，兼容性设计支持与楼宇管理系统集成。芯片应用于写字楼、商场、住宅小区等多种建筑类型。</p><p>实际运行数据显示智能电梯系统将平均等待时间减少25%，能耗降低20%以上。安全监测功能提升运行可靠性，预测性维护减少故障发生率。</p>', '<p>定期进行安全检查和维护，确保控制系统正常运行。注意电梯负载监控，避免超载运行。及时更新控制算法，优化运行效率。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (651, 10, '智能停车场芯片', '/uploads/images/product/product5.jpg', '', '<p>智能停车场芯片为现代停车管理提供完整的解决方案，集成车位检测、车辆识别、支付管理等多种功能。芯片支持地磁、超声波、视频等多种车位检测技术，准确率超过99%。车牌识别功能支持自动识别车辆信息，实现无感支付。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product6.jpg\" alt=\"停车场应用\"></p><p>智能导航功能引导车辆快速找到空闲车位，减少寻找时间。支付管理功能支持多种支付方式，包括扫码支付、无感支付、月卡管理等。数据分析功能为停车场运营提供决策支持，优化车位利用率和收费标准。</p><p>远程管理功能支持停车场状态的实时监控和远程控制。应急处理功能在异常情况下自动启动应急程序。兼容性设计支持与城市停车平台的对接。</p><p>该芯片已应用于商业中心、机场、车站等多种停车场景。实际应用数据显示，基于该芯片的智能停车场将车位周转率提升40%，显著改善了停车体验。</p>', 1, 38, 1, 1762588037, 1762588037, 0, '停车场智能化管理芯片，支持车位检测和车辆识别，提升停车管理效率', '', '智能停车,车位检测,车辆识别', '1399', '智能停车场芯片支持车位检测和车辆识别，提升停车场管理智能化水平。', 1, '', '', '智慧交通部', '芯科科技', 0, 30, '/uploads/images/product/product5.jpg,/uploads/images/product/product6.jpg,/uploads/images/product/product7.jpg', '', '', '', '', '<p>芯片集成车位检测、车辆识别、支付管理等多种功能，支持地磁、超声波、视频等多种车位检测技术准确率超过99%。车牌识别功能自动识别车辆信息实现无感支付，智能导航功能引导车辆快速找到空闲车位减少寻找时间。支付管理功能支持扫码支付、无感支付、月卡管理等多种方式。</p><p>数据分析功能为停车场运营提供决策支持优化车位利用率和收费标准，远程管理功能支持停车场状态实时监控和远程控制。应急处理功能在异常情况下自动启动应急程序，兼容性设计支持与城市停车平台对接。芯片应用于商业中心、机场、车站等多种停车场景。</p><p>实际应用数据显示智能停车场将车位周转率提升40%，显著改善停车体验。车辆识别功能提升通行效率，多种支付方式方便用户使用。</p>', '<p>定期校准检测设备，确保车位状态准确性。注意系统网络安全，防止未授权访问。及时处理设备故障，保障系统稳定运行。</p>', 20, '50', '', '');
INSERT INTO `ry_article` VALUES (652, 10, '智能抄表芯片', '/uploads/images/product/product8.jpg', '', '<p>智能抄表芯片为公用事业提供自动抄表解决方案，集成高精度计量和远程通信功能。芯片支持水、电、气等多种公用事业计量，计量精度达到0.5级标准。远程抄表功能支持定时自动上报用量数据，减少人工抄表工作量。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product9.jpg\" alt=\"智能抄表应用\"></p><p>异常监测功能能够识别用量异常和设备故障，及时发出告警。数据存储功能支持用量历史记录的本地存储，防止数据丢失。远程控制功能支持阀门的远程开关，方便费用管理和紧急处理。</p><p>防窃功能能够检测异常用电用水模式，保护公用事业公司的合法权益。低功耗设计确保电池供电设备可工作10年以上。通信加密传输确保数据安全。</p><p>该芯片已在国内多个智慧城市项目中规模应用。实际运行数据显示，基于该芯片的智能抄表系统将抄表准确率提升至99.8%，大幅降低了运营成本。</p>', 1, 37, 1, 1762588037, 1762588037, 0, '公用事业智能抄表芯片，支持远程抄表和异常监测，提升抄表效率', '', '智能抄表,远程抄表,公用事业', '1099', '智能抄表芯片支持远程抄表和异常监测，提升公用事业管理效率。', 0, '', '', '能源物联网部', '芯科科技', 0, 30, '/uploads/images/product/product8.jpg,/uploads/images/product/product9.jpg,/uploads/images/product/product10.jpg', '', '', '', '', '<p>芯片集成高精度计量和远程通信功能，支持水、电、气等多种公用事业计量，计量精度达到0.5级标准。远程抄表功能支持定时自动上报用量数据减少人工抄表工作量，异常监测功能识别用量异常和设备故障及时告警。数据存储功能支持用量历史记录本地存储防止数据丢失。</p><p>远程控制功能支持阀门远程开关方便费用管理和紧急处理，防窃功能检测异常用电用水模式保护公司权益。低功耗设计确保电池供电设备工作10年以上，通信加密传输确保数据安全。芯片在国内多个智慧城市项目中规模应用。</p><p>实际运行数据显示智能抄表系统将抄表准确率提升至99.8%，大幅降低运营成本。自动抄表功能提升工作效率，异常监测有助于及时发现问题和减少损失。</p>', '<p>安装时需确保计量精度符合标准，定期进行设备校准。注意通信信号覆盖，确保数据正常上报。加强数据安全管理，防止信息泄露。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (653, 10, '智能灌溉控制芯片', '/uploads/images/product/product11.jpg', '', '<p>智能灌溉控制芯片为农业灌溉提供精准控制解决方案，集成土壤湿度监测和智能灌溉决策功能。芯片支持多点土壤湿度监测，准确反映土壤水分分布情况。智能算法根据作物需水特性和天气预报优化灌溉策略。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product12.jpg\" alt=\"灌溉控制应用\"></p><p>阀门控制功能支持精准的区域灌溉控制，减少水资源浪费。雨量监测功能在降雨时自动调整灌溉计划。远程管理功能支持灌溉系统的远程监控和控制，方便农户管理。</p><p>数据分析功能为灌溉优化提供决策支持，识别灌溉效果和改进空间。节水模式在干旱时期自动启动节水灌溉方案。兼容性设计支持与农业物联网平台的集成。</p><p>该芯片已在全国多个农业示范区部署应用。实际应用数据显示，基于该芯片的智能灌溉系统节水效果达到30%以上，作物产量提升15%，实现了水资源的高效利用。</p>', 1, 36, 1, 1762588037, 1762588037, 0, '农业智能灌溉控制芯片，支持精准灌溉和节水管理，提升农业用水效率', '', '智能灌溉,节水灌溉,农业物联网', '1299', '智能灌溉控制芯片支持精准灌溉和节水管理，提升农业用水效率。', 1, '', '', '农业物联网部', '芯科科技', 0, 30, '/uploads/images/product/product11.jpg,/uploads/images/product/product12.jpg,/uploads/images/product/product13.jpg', '', '', '', '', '<p>芯片集成土壤湿度监测和智能灌溉决策功能，支持多点土壤湿度监测准确反映水分分布。智能算法根据作物需水特性和天气预报优化灌溉策略，阀门控制功能支持精准区域灌溉控制减少水资源浪费。雨量监测功能在降雨时自动调整灌溉计划，远程管理功能支持灌溉系统远程监控和控制。</p><p>数据分析功能为灌溉优化提供决策支持识别灌溉效果和改进空间，节水模式在干旱时期自动启动节水灌溉方案。兼容性设计支持与农业物联网平台集成，芯片在全国多个农业示范区部署应用。实际应用数据显示智能灌溉系统节水效果达30%以上，作物产量提升15%。</p><p>精准灌溉控制提升水资源利用效率，智能决策功能优化灌溉效果。远程管理方便农户操作，数据分析支持农业管理决策。</p>', '<p>安装时合理布置土壤湿度传感器，确保监测数据代表性。定期检查灌溉设备，防止堵塞和泄漏。根据作物生长阶段调整灌溉策略。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (654, 10, '智能消防预警芯片', '/uploads/images/product/product14.jpg', '', '<p>智能消防预警芯片为建筑消防提供早期火灾预警功能，集成烟雾检测、温度感知、气体监测等多种传感能力。芯片采用双光路烟雾检测技术，有效区分火灾烟雾和灰尘干扰。温度监测支持差温和定温两种报警方式，适应不同环境需求。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product15.jpg\" alt=\"消防预警应用\"></p><p>一氧化碳监测功能能够早期发现不完全燃烧产生的有害气体。智能算法能够识别火灾特征模式，减少误报率。联动控制功能在检测到火情时自动启动喷淋系统和报警装置。</p><p>自检功能定期检查传感器状态，确保系统可靠性。远程监控功能支持消防设备状态的实时监控。备用电源设计确保在市电中断时系统仍能正常工作24小时。</p><p>该芯片已通过国家消防产品认证，应用于商场、酒店、学校等人员密集场所。在实际使用中，基于该芯片的消防预警系统多次成功预警初期火情，为人员疏散赢得了宝贵时间。</p>', 1, 35, 1, 1762588037, 1762588037, 0, '消防智能化预警芯片，支持多参数火灾检测，提升火灾早期预警能力', '', '消防预警,火灾检测,安全监控', '1799', '智能消防预警芯片支持多参数火灾检测，提升建筑消防安全水平。', 2, '', '', '消防物联网部', '芯科科技', 0, 30, '/uploads/images/product/product14.jpg,/uploads/images/product/product15.jpg,/uploads/images/product/product16.jpg', '', '', '', '', '<p>芯片集成烟雾检测、温度感知、气体监测等多种传感能力，采用双光路烟雾检测技术有效区分火灾烟雾和灰尘干扰。温度监测支持差温和定温两种报警方式适应不同环境需求，一氧化碳监测功能早期发现不完全燃烧产生的有害气体。智能算法识别火灾特征模式减少误报率，联动控制功能在检测到火情时自动启动喷淋系统和报警装置。</p><p>自检功能定期检查传感器状态确保系统可靠性，远程监控功能支持消防设备状态实时监控。备用电源设计确保市电中断时系统正常工作24小时，芯片通过国家消防产品认证应用于商场、酒店、学校等人员密集场所。在实际使用中多次成功预警初期火情，为人员疏散赢得宝贵时间。</p><p>多参数检测提升火灾识别准确性，智能算法减少误报提升可靠性。联动控制实现快速响应，自检功能确保系统长期稳定运行。</p>', '<p>定期测试报警功能，确保系统灵敏度。注意传感器清洁，防止灰尘影响检测。定期更换电池，确保备用电源正常。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (655, 10, '智能健康手环芯片', '/uploads/images/product/product17.jpg', '', '<p>智能健康手环芯片为可穿戴健康设备提供全面的生理监测功能，集成心率、血氧、运动监测等多种健康参数采集。芯片采用光电容积脉搏波技术，实现无创心率血氧监测，测量精度满足日常健康管理需求。运动监测功能支持步数、距离、卡路里等运动数据统计。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product18.jpg\" alt=\"健康手环应用\"></p><p>睡眠监测功能分析睡眠质量和睡眠阶段，提供改善建议。久坐提醒功能在长时间静止时提示用户活动。消息通知功能支持手机消息的振动提醒。低功耗设计确保设备续航时间达到7天以上。</p><p>防水设计支持日常生活中的汗水和水溅防护。数据同步功能支持与手机App的数据传输和云端备份。个性化表盘支持多种显示风格选择。</p><p>该芯片已与多家智能手环厂商合作，产品销往全球市场。用户反馈显示，基于该芯片的健康手环提供了准确的健康监测数据，帮助用户更好地了解自身健康状况。</p>', 1, 34, 1, 1762588037, 1762588037, 0, '可穿戴健康监测芯片，支持心率血氧运动监测，助力个人健康管理', '', '健康手环,生理监测,运动监测', '799', '智能健康手环芯片支持多种健康参数监测，为个人健康管理提供数据支持。', 0, '', '', '可穿戴事业部', '芯科科技', 0, 30, '/uploads/images/product/product17.jpg,/uploads/images/product/product18.jpg,/uploads/images/product/product19.jpg', '', '', '', '', '<p>芯片集成心率、血氧、运动监测等多种健康参数采集，采用光电容积脉搏波技术实现无创心率血氧监测，测量精度满足日常健康管理需求。运动监测功能支持步数、距离、卡路里等运动数据统计，睡眠监测功能分析睡眠质量和睡眠阶段提供改善建议。</p><p>久坐提醒功能在长时间静止时提示用户活动，消息通知功能支持手机消息振动提醒。低功耗设计确保设备续航时间7天以上，防水设计支持汗水和水溅防护。数据同步功能支持与手机App数据传输和云端备份，个性化表盘支持多种显示风格选择。</p><p>芯片与多家智能手环厂商合作，产品销往全球市场。用户反馈显示健康手环提供准确健康监测数据，帮助用户了解自身健康状况。运动数据统计支持健身目标设定，睡眠分析改善睡眠质量。</p>', '<p>佩戴时确保设备与手腕接触良好，避免过松影响监测准确性。定期清洁设备，防止汗液腐蚀。运动时注意设备防水等级，避免浸水。</p>', 17, '50', '', '');
INSERT INTO `ry_article` VALUES (656, 10, '智能宠物追踪芯片', '/uploads/images/product/product20.jpg', '', '<p>智能宠物追踪芯片为宠物管理提供位置追踪和健康监测功能，集成GPS定位和活动监测能力。芯片支持GPS、北斗、GLONASS多模定位，定位精度达到5米以内。活动监测功能记录宠物的日常活动量和休息时间。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product21.jpg\" alt=\"宠物追踪应用\"></p><p>电子围栏功能设定安全活动范围，在宠物超出范围时立即告警。健康监测功能通过活动模式分析宠物健康状况。远程定位功能支持通过手机App实时查看宠物位置。</p><p>低功耗设计确保设备续航时间达到30天以上。防水防尘设计适应宠物户外活动环境。小巧轻便的设计确保宠物佩戴舒适。数据加密传输保护宠物主人隐私。</p><p>该芯片已应用于宠物项圈、智能背心等宠物用品。用户使用反馈显示，基于该芯片的宠物追踪设备有效防止了宠物走失，让宠物主人更加安心。</p>', 1, 33, 1, 1762588037, 1762588037, 0, '宠物智能化管理芯片，支持位置追踪和健康监测，保障宠物安全', '', '宠物追踪,位置定位,健康监测', '999', '智能宠物追踪芯片支持位置追踪和健康监测，保障宠物安全和健康。', 1, '', '', '消费电子部', '芯科科技', 0, 30, '/uploads/images/product/product20.jpg,/uploads/images/product/product21.jpg,/uploads/images/product/product22.jpg', '', '', '', '', '<p>芯片集成GPS定位和活动监测能力，支持GPS、北斗、GLONASS多模定位，定位精度5米以内。活动监测功能记录宠物日常活动量和休息时间，电子围栏功能设定安全活动范围在宠物超出时立即告警。健康监测功能通过活动模式分析宠物健康状况，远程定位功能支持手机App实时查看宠物位置。</p><p>低功耗设计确保设备续航时间30天以上，防水防尘设计适应宠物户外活动环境。小巧轻便设计确保宠物佩戴舒适，数据加密传输保护宠物主人隐私。芯片应用于宠物项圈、智能背心等宠物用品，用户使用反馈显示宠物追踪设备有效防止宠物走失。</p><p>多模定位提升位置准确性，电子围栏功能保障宠物安全。健康监测帮助了解宠物状态，长续航设计减少充电频率。防水设计适应各种天气条件，轻便设计提升佩戴舒适度。</p>', '<p>定期检查设备电量，及时充电。注意设备防水性能，避免长时间浸水。根据宠物体型选择合适的佩戴方式，确保舒适性。</p>', 0, '50', '', '');
INSERT INTO `ry_article` VALUES (657, 20, '芯科科技2024年度技术峰会即将在京举办', '/uploads/images/news/news30.jpg', '', '<p>芯科科技宣布将于2024年12月在北京国家会议中心举办年度技术峰会，本次峰会以\"智能芯片，驱动未来\"为主题，将集中展示公司在人工智能、物联网、汽车电子等领域的最新技术成果和应用案例。届时将有来自全球的行业专家、合作伙伴和客户代表参加。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news31.jpg\" alt=\"技术峰会预告\"></p><p>峰会期间将设立主论坛和多个专题分论坛，涵盖AI芯片架构创新、边缘计算技术、自动驾驶解决方案、工业物联网应用等热点话题。公司首席技术官将发布新一代芯片技术路线图，分享公司在先进制程、封装技术和能效优化方面的技术规划。</p><p>参会者将有机会亲身体验基于芯科芯片的各类创新应用演示，包括智能机器人、自动驾驶测试平台、工业物联网解决方案等。大会还将举办多场技术研讨会和合作伙伴交流会，为与会者提供深入的技术交流和商业合作机会。</p><p>本次峰会预计将吸引超过2000名行业专业人士参加，包括来自学术界、产业界和投资界的代表。芯科科技希望通过此次盛会，与业界同仁共同探讨芯片技术的发展趋势，推动技术创新和产业升级。</p><p>参会报名工作已经启动，感兴趣的业内人士可以通过公司官网或官方微信公众号进行在线注册。早期注册者可享受优惠票价，学生参会还可申请特别优惠。组委会还将为优秀论文作者提供展示机会，促进学术交流和技术分享。</p>', 1, 50, 1, 1762588708, 1762588708, 0, '年度技术峰会聚焦AI芯片与物联网创新，汇聚行业专家共商技术发展路径', '', '技术峰会,行业盛会,AI芯片,创新展示', '', '芯科科技2024年度技术峰会将在北京举办，展示AI芯片、物联网等领域最新技术成果，促进行业交流合作。', 0, '', '', '大会组委会', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (658, 20, '芯科科技校园技术竞赛正式启动报名', '/uploads/images/news/news32.jpg', '', '<p>芯科科技2024校园技术竞赛于今日正式启动，面向全国高校在校学生征集创新项目。本次竞赛以\"芯片创新，智造未来\"为主题，旨在激发大学生对芯片技术的兴趣，培养创新型技术人才。竞赛设立芯片设计、算法优化、应用创新三个赛道。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news33.jpg\" alt=\"校园竞赛启动\"></p><p>竞赛组委会设立了总额100万元的奖金池，获奖团队除了获得丰厚奖金外，还将有机会获得芯科科技的实习offer和项目孵化支持。评审团由公司技术专家和高校教授组成，将从技术创新性、实用价值和完成度等多个维度进行评审。</p><p>参赛团队需要在三个月内完成项目设计和实现，提交完整的技术方案和演示视频。初赛将评选出50支队伍进入决赛，决赛将于明年3月在芯科科技研发中心举行。届时参赛队伍将进行现场演示和答辩。</p><p>芯科科技将为参赛团队提供技术支持和培训资源，包括在线技术讲座、开发工具使用指导和专家答疑等。公司还将在全国多所高校举办巡回宣讲会，详细介绍竞赛规则和技术要求。</p><p>本次竞赛是芯科科技人才发展计划的重要组成部分，公司希望通过此类活动，建立与高校的深度合作，发掘和培养优秀的芯片技术人才，为行业发展储备新生力量。</p>', 1, 49, 1, 1762588708, 1762588708, 0, '面向高校学生的技术竞赛启动，设立芯片设计算法优化应用创新三个赛道', '', '校园竞赛,技术创新,人才培养,高校合作', '', '芯科科技校园技术竞赛正式启动，面向全国高校征集创新项目，培养芯片技术人才。', 0, '', '', '竞赛组委会', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (659, 20, '芯科科技开放日活动邀请业界参观', '/uploads/images/news/news34.jpg', '', '<p>芯科科技将于下月举办年度开放日活动，向业界伙伴展示公司研发实力和技术成果。本次活动将开放公司研发中心、测试实验室和智能制造车间，让参观者深入了解芯片从设计到制造的全过程。活动为期三天，预计接待超过1000名参观者。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news35.jpg\" alt=\"开放日活动\"></p><p>开放日期间将安排多场技术讲座和产品演示，涵盖AI芯片架构、物联网解决方案、汽车电子平台等主题。参观者可以亲眼目睹芯片设计流程，了解先进的封装测试技术，还可以参与互动体验区的新产品试用。</p><p>本次活动特别设置了合作伙伴展示区，邀请生态伙伴展示基于芯科芯片的创新应用。同时还将举办多场技术交流会，为参观者提供与研发团队直接对话的机会。参会者还可以预约一对一的技术咨询，获取专业的技术建议。</p><p>芯科科技希望通过开放日活动，增强与业界的沟通交流，展示公司在技术创新方面的成果，同时收集市场反馈，为产品优化和技术升级提供参考。活动还将举办多场签约仪式，与合作伙伴达成新的合作协议。</p><p>参观预约通道已经开启，感兴趣的业界人士可以通过公司官网进行在线预约。由于场地限制，组委会建议尽早预约以确保参会名额。活动期间还将提供线上直播，方便无法到场的观众远程参与。</p>', 1, 48, 1, 1762588708, 1762588708, 0, '年度开放日展示研发实力，邀请业界参观研发中心和智能制造车间', '', '开放日,技术展示,研发中心,业界交流', '', '芯科科技举办开放日活动，展示研发实力和技术成果，促进与业界的交流合作。', 0, '', '', '活动组委会', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (660, 20, '芯科科技技术沙龙聚焦边缘计算', '/uploads/images/news/news36.jpg', '', '<p>芯科科技将于本月底在深圳举办边缘计算技术沙龙，邀请行业专家共同探讨边缘智能的技术挑战和发展机遇。本次沙龙将聚焦边缘AI芯片、低功耗设计、实时数据处理等关键技术话题，分享最新的技术进展和应用案例。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news37.jpg\" alt=\"技术沙龙活动\"></p><p>沙龙邀请了来自学术界和产业界的多位专家进行主题分享，包括边缘计算架构设计、算法优化、安全防护等热点议题。参会者将有机会深入了解边缘计算在不同行业的应用实践，包括工业物联网、智能安防、车联网等领域。</p><p>活动还将设置圆桌讨论环节，与会专家将就边缘计算的标准化、产业化和发展趋势进行深入交流。参会者可以就技术难题和行业痛点与专家进行面对面探讨，寻求解决方案和合作机会。</p><p>芯科科技将在沙龙上展示最新的边缘计算芯片和解决方案，包括低功耗AI推理芯片、多模通信芯片等产品。现场还将进行技术演示，展示边缘计算在真实场景中的应用效果。</p><p>本次沙龙是芯科科技技术交流系列活动的重要组成部分，公司希望通过此类活动，促进技术分享和产业协作，推动边缘计算技术的创新和应用。活动报名工作已经开始，名额有限，建议感兴趣的技术人员尽早注册。</p>', 1, 47, 1, 1762588708, 1762588708, 0, '边缘计算技术沙龙探讨边缘智能发展，分享最新技术进展和应用实践', '', '技术沙龙,边缘计算,AI芯片,行业交流', '', '芯科科技举办边缘计算技术沙龙，邀请专家探讨边缘智能技术挑战和发展机遇。', 0, '', '', '技术交流部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (661, 20, '芯科科技合作伙伴大会成功举办', '/uploads/images/news/news38.jpg', '', '<p>芯科科技2024年度合作伙伴大会在上海成功举办，来自全球的200多家合作伙伴代表参加了此次盛会。大会以\"携手创新，共赢未来\"为主题，回顾了过去一年的合作成果，展望了未来的合作机遇和发展方向。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news39.jpg\" alt=\"合作伙伴大会\"></p><p>大会期间，芯科科技发布了新的合作伙伴计划，包括技术培训、市场支持和联合创新等多个方面的内容。公司还与多家合作伙伴签署了战略合作协议，将在产品研发、市场拓展和生态建设等方面开展深度合作。</p><p>参会合作伙伴展示了基于芯科芯片的丰富应用案例，涵盖智能家居、工业自动化、汽车电子等多个领域。这些案例充分展示了芯科芯片在不同应用场景中的技术优势和实用价值。</p><p>大会还设立了合作伙伴颁奖环节，表彰在过去一年中表现突出的合作伙伴。奖项包括最佳技术创新奖、最佳市场开拓奖和最佳服务支持奖等，共有20家合作伙伴获得表彰。</p><p>芯科科技表示，合作伙伴是公司发展的重要支撑，未来将继续加大投入，完善合作生态，为合作伙伴提供更好的技术支持和商业机会。公司计划在未来三年内将合作伙伴数量扩大到500家，共同推动芯片技术的创新和应用。</p>', 1, 46, 1, 1762588708, 1762588708, 0, '年度合作伙伴大会汇聚全球合作伙伴，发布新合作计划展望未来发展', '', '合作伙伴,生态建设,战略合作,市场拓展', '', '芯科科技合作伙伴大会成功举办，发布新合作计划，与伙伴共商发展大计。', 0, '', '', '合作发展部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (662, 20, '芯科科技技术培训课程开始招生', '/uploads/images/news/news40.jpg', '', '<p>芯科科技2024年度技术培训课程正式开始招生，本次培训面向工程师和技术人员，提供芯片设计、嵌入式开发、AI算法等多个方向的课程。培训采用线上与线下相结合的方式，为期两个月，预计培训学员超过1000人。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news41.jpg\" alt=\"技术培训课程\"></p><p>培训课程由公司资深技术专家和外部特邀讲师共同授课，内容涵盖理论基础、实践案例和最新技术动态。学员将通过理论学习和项目实践，掌握芯片相关技术的核心知识和应用技能。</p><p>本次培训特别设置了AI芯片设计、物联网系统开发、汽车电子应用等热门方向的专项课程。学员可以根据自身需求选择合适的课程模块，还可以参与实际项目开发，积累实战经验。</p><p>培训结束后，学员将获得由芯科科技颁发的结业证书，优秀学员还有机会获得公司的实习或工作机会。公司还将为学员提供持续的技术支持和发展指导。</p><p>芯科科技希望通过技术培训，帮助技术人员提升专业技能，同时为行业培养更多的专业人才。培训报名工作已经启动，感兴趣的工程师可以通过公司官网查看详细课程安排并进行在线报名。</p>', 1, 45, 1, 1762588708, 1762588708, 0, '年度技术培训课程招生，提供芯片设计嵌入式开发AI算法等专业课程', '', '技术培训,人才培养,专业技能,工程师培训', '', '芯科科技技术培训课程开始招生，面向工程师提供芯片设计和AI算法等专业培训。', 0, '', '', '培训发展部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (663, 20, '芯科科技参与全球半导体展会', '/uploads/images/news/news42.jpg', '', '<p>芯科科技将参加下月在美国举办的全球半导体展览会，展示公司在先进制程和芯片创新方面的最新成果。本次参展将重点展示7nm AI训练芯片、边缘推理芯片和汽车电子平台等产品，与全球业界分享技术进展。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news43.jpg\" alt=\"半导体展会\"></p><p>展位设计采用开放式布局，设置产品展示区、技术交流区和商务洽谈区。参观者可以亲身体验基于芯科芯片的各类应用演示，包括智能视觉处理、语音交互、自动驾驶等场景。现场还将进行技术讲座，介绍芯片架构和创新特性。</p><p>公司技术专家将在展会期间参与多场技术论坛，分享在AI芯片设计、能效优化和系统集成方面的经验。同时还将与全球合作伙伴进行深入交流，探讨技术合作和市场机会。</p><p>芯科科技希望通过此次国际展会，展示中国芯片企业的技术实力，与国际同行交流学习，同时寻找新的合作机会。公司还将借此机会了解全球市场趋势和技术发展方向，为未来的产品规划提供参考。</p><p>展会期间，芯科科技将举办多场商务活动，包括合作伙伴招待会和技术研讨会。感兴趣的业界人士可以提前预约与公司代表的会面，进行深入的技术和商务交流。</p>', 1, 44, 1, 1762588708, 1762588708, 0, '参加全球半导体展会展示先进制程成果，与国际业界交流技术发展', '', '国际展会,技术展示,全球合作,半导体创新', '', '芯科科技参加全球半导体展会，展示7nm AI芯片等最新成果，促进国际技术交流。', 0, '', '', '国际市场部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (664, 20, '芯科科技创新大赛决赛圆满落幕', '/uploads/images/news/news44.jpg', '', '<p>芯科科技2024创新大赛决赛在公司总部圆满落幕，经过激烈角逐，最终有10支团队获得奖项。本次大赛共收到来自全国各地的300多个创新项目，涵盖AI芯片应用、物联网解决方案、智能硬件等多个领域。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news45.jpg\" alt=\"创新大赛决赛\"></p><p>决赛现场，入围团队进行了项目演示和答辩，评审团从技术创新性、市场前景、团队能力等多个维度进行评分。最终，\"基于AI芯片的智能医疗诊断系统\"项目获得大赛一等奖，并获得50万元的项目孵化资金。</p><p>获奖项目展现了丰富的创意和技术实力，包括智能农业监测系统、工业物联网平台、边缘计算设备等创新应用。这些项目不仅技术先进，而且具有良好的市场应用前景。</p><p>大赛组委会为获奖团队提供了丰富的奖励和支持，包括资金资助、技术指导、市场资源和投资对接等。芯科科技还将与优秀团队开展深度合作，共同推进项目的产业化和商业化。</p><p>创新大赛是芯科科技支持创新创业的重要举措，公司希望通过此类活动，激发创新活力，推动技术进步和产业发展。下一届创新大赛将于明年春季启动，届时将扩大参赛范围，增加更多创新赛道。</p>', 1, 43, 1, 1762588708, 1762588708, 0, '创新大赛决赛圆满结束，十支优秀团队获奖展示丰富创新成果', '', '创新大赛,创业支持,技术孵化,项目展示', '', '芯科科技创新大赛决赛落幕，十支团队获奖，展示AI芯片和物联网创新应用。', 0, '', '', '创新孵化部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (665, 20, '芯科科技技术交流会探讨AI芯片', '/uploads/images/news/news46.jpg', '', '<p>芯科科技在北京举办AI芯片技术交流会，邀请学术界和产业界专家共同探讨AI芯片的技术挑战和发展趋势。交流会聚焦神经网络加速、能效优化、模型压缩等关键技术话题，分享最新的研究成果和实践经验。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news47.jpg\" alt=\"技术交流会\"></p><p>会议邀请了多位知名学者和行业专家进行主题报告，内容包括AI芯片架构创新、算法硬件协同设计、大模型推理优化等前沿话题。参会者就技术难点和解决方案进行了深入讨论，交流了各自的研究成果和实践经验。</p><p>芯科科技在交流会上展示了最新的AI芯片产品和解决方案，包括训练芯片、推理芯片和边缘AI芯片等。技术团队还分享了在芯片设计、算法优化和系统集成方面的技术积累和实践心得。</p><p>交流会还设置了技术展示环节，多家合作伙伴展示了基于芯科AI芯片的创新应用，包括智能视觉分析、自然语言处理、推荐系统等场景。这些应用展示了AI芯片在实际业务中的价值和效果。</p><p>本次技术交流会是芯科科技技术分享系列活动的一部分，公司希望通过此类活动，促进技术交流和产业协作，推动AI芯片技术的创新和发展。未来还将举办更多专题技术交流活动，涵盖不同的技术领域和应用场景。</p>', 1, 42, 1, 1762588708, 1762588708, 0, 'AI芯片技术交流会探讨神经网络加速能效优化等关键技术发展', '', '技术交流,AI芯片,神经网络,能效优化', '', '芯科科技举办AI芯片技术交流会，专家探讨AI芯片技术挑战和发展趋势。', 0, '', '', '技术研发部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (666, 20, '芯科科技公益科普活动走进校园', '/uploads/images/news/news48.jpg', '', '<p>芯科科技公益科普活动本月走进多所中小学校园，通过生动有趣的科普讲座和实践活动，向学生们介绍芯片技术的基本原理和应用场景。活动旨在激发青少年对科技的兴趣，培养未来的科技创新人才。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news49.jpg\" alt=\"科普活动进校园\"></p><p>科普活动包括芯片知识讲座、动手实验和科技作品展示等环节。公司工程师用通俗易懂的语言讲解芯片的工作原理，展示芯片在智能手机、电脑、智能家居等日常产品中的应用。学生们还可以参与简单的电路实验，亲身体验电子技术的魅力。</p><p>活动还设置了科技创新工作坊，指导学生利用开源硬件制作简单的电子作品。通过动手实践，学生们不仅学习了电子知识，还培养了创新思维和解决问题的能力。优秀作品还在学校进行了展示和分享。</p><p>芯科科技为参与学校捐赠了科普书籍和实验器材，支持学校开展科技教育活动。公司还计划与学校建立长期合作关系，定期开展科普活动，为学生们提供持续的学习机会。</p><p>公益科普活动是芯科科技企业社会责任项目的重要组成部分，公司希望通过此类活动，推动科技教育普及，为培养未来的科技人才贡献力量。未来还将扩大活动范围，惠及更多学校和学生。</p>', 1, 41, 1, 1762588708, 1762588708, 0, '公益科普活动走进中小学校园，通过讲座实验激发青少年科技兴趣', '', '公益科普,科技教育,校园活动,人才培养', '', '芯科科技公益科普活动走进校园，向学生介绍芯片技术，培养科技创新兴趣。', 0, '', '', '公益事业部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (667, 20, '芯科科技技术研讨会聚焦汽车电子', '/uploads/images/news/news50.jpg', '', '<p>芯科科技在德国慕尼黑举办汽车电子技术研讨会，与欧洲汽车厂商和零部件供应商共同探讨智能网联汽车的技术需求和发展趋势。研讨会聚焦自动驾驶、智能座舱、车联网等关键技术领域，分享最新的技术进展和解决方案。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news29.jpg\" alt=\"汽车电子研讨会\"></p><p>会议邀请了欧洲多家知名汽车厂商的技术专家，就汽车电子的技术标准、安全要求和性能指标进行深入交流。芯科科技展示了最新的汽车电子芯片和平台解决方案，包括自动驾驶计算芯片、智能座舱处理器和车联网通信芯片等。</p><p>研讨会还设置了技术演示环节，展示了基于芯科芯片的自动驾驶原型系统和智能座舱解决方案。参会者可以亲身体验这些系统的功能和性能，并就技术细节与研发团队进行深入交流。</p><p>芯科科技与多家欧洲汽车厂商达成了技术合作意向，将在自动驾驶、智能网联等领域开展深度合作。公司还将设立欧洲研发中心，加强本地化技术支持和产品开发。</p><p>本次研讨会是芯科科技全球化战略的重要举措，公司希望通过与国际汽车厂商的合作，提升在汽车电子领域的技术实力和市场地位。未来还将在其他地区举办类似的技术交流活动，推动全球汽车电子技术的发展。</p>', 1, 40, 1, 1762588708, 1762588708, 0, '汽车电子技术研讨会在慕尼黑举办，探讨自动驾驶智能座舱发展', '', '技术研讨,汽车电子,自动驾驶,国际合作', '', '芯科科技在慕尼黑举办汽车电子技术研讨会，与欧洲厂商探讨智能网联汽车技术。', 0, '', '', '汽车电子部', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_article` VALUES (668, 20, '芯科科技年度技术论坛即将召开', '/uploads/images/news/news28.jpg', '', '<p>芯科科技年度技术论坛将于下季度在上海国际会议中心召开，本次论坛以\"芯片创新，智领未来\"为主题，将汇聚行业专家、学者和企业代表，共同探讨芯片技术的发展趋势和创新机遇。论坛预计参会人数超过1500人。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news27.jpg\" alt=\"技术论坛预告\"></p><p>论坛将设立主会场和多个平行分论坛，涵盖AI芯片、物联网、汽车电子、工业控制等多个技术领域。知名学者和行业领袖将发表主题演讲，分享最新的研究成果和行业洞察。参会者还可以参与技术工作坊和圆桌讨论，深入交流技术话题。</p><p>芯科科技将在论坛期间发布多项技术创新成果，包括新的芯片架构、算法优化和系统解决方案。技术团队还将进行现场演示，展示这些技术在真实场景中的应用效果和性能表现。</p><p>论坛还将举办创新项目展示和投资对接活动，为创业团队和投资者搭建交流平台。优秀创新项目将有机会获得芯科科技的技术支持和投资机会，加速技术转化和商业化进程。</p><p>参会注册工作即将启动，感兴趣的业内人士可以关注公司官网和官方社交媒体获取最新信息。组委会还将为早期注册者提供优惠，并为学生参会者设立特别通道。论坛期间还将举办多项社交活动，促进参会者之间的交流和合作。</p>', 1, 39, 1, 1762588708, 1762588708, 0, '年度技术论坛汇聚行业专家，探讨芯片技术创新发展趋势和机遇', '', '技术论坛,行业交流,创新成果,技术分享', '', '芯科科技年度技术论坛即将召开，探讨AI芯片、物联网等领域技术创新和发展趋势。', 0, '', '', '论坛组委会', '芯科科技新闻中心', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
COMMIT;

-- ----------------------------
-- Table structure for ry_auser
-- ----------------------------
DROP TABLE IF EXISTS `ry_auser`;
CREATE TABLE `ry_auser` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '管理员ID',
  `groupid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员所属组ID',
  `uname` varchar(128) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '管理员名称',
  `nickname` varchar(128) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '管理员昵称',
  `password` varchar(255) NOT NULL DEFAULT '' COMMENT '管理员密码',
  `thumb` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '管理员头像',
  `login_ip` varchar(45) DEFAULT '' COMMENT '登录IP',
  `session_id` varchar(128) DEFAULT '' COMMENT '会话ID',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1-启用 0-禁用',
  `login_time` int(11) NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT '删除时间',
  `last_active_time` int(11) NOT NULL DEFAULT '0' COMMENT '最后活动时间',
  `is_lang` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '多语言支持：1-启用 0-关闭',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uk_uname` (`uname`),
  KEY `groupid` (`groupid`),
  KEY `idx_status` (`status`),
  KEY `idx_login_time` (`login_time`),
  KEY `idx_create_time` (`create_time`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COMMENT='管理员用户表';

-- ----------------------------
-- Records of ry_auser
-- ----------------------------
BEGIN;
INSERT INTO `ry_auser` VALUES (1, 1, 'demo', 'royalcms', '2ae44709b8fc6266ae43d15d5111935588d2d581', '', '::1', 'ddd9034636b4fac327d3b59dbde94ed6', 1, 1764581599, 1741826086, 1764581599, 0, 1764581599, 0);
COMMIT;

-- ----------------------------
-- Table structure for ry_auth_group
-- ----------------------------
DROP TABLE IF EXISTS `ry_auth_group`;
CREATE TABLE `ry_auth_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '管理员组ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '上级管理员组ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '管理员组名称',
  `title_auth` varchar(255) NOT NULL DEFAULT '' COMMENT '管理员组描述',
  `rules` text NOT NULL COMMENT '管理员组权限列表',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1-启用 0-禁用',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `sort` smallint(6) unsigned NOT NULL DEFAULT '50' COMMENT '排序：数值越小越靠前',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_pid` (`pid`),
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COMMENT='权限组管理表';

-- ----------------------------
-- Records of ry_auth_group
-- ----------------------------
BEGIN;
INSERT INTO `ry_auth_group` VALUES (1, 0, '系统管理员', '拥有所有权限', '1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71', 1, 1656144972, 1764073544, 1);
INSERT INTO `ry_auth_group` VALUES (2, 0, '超级管理员', '拥有所有权限', '1,2,3,4,5,6,7,8,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,49,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71', 1, 1656144979, 1764073600, 2);
INSERT INTO `ry_auth_group` VALUES (3, 2, '文章管理员', '权限：文章添加｜编辑｜删除｜审核｜移动', '19,16,18,2,20,17,44,46,41,71,72,70,12,14,15,63,67,68,69,65,66,64', 1, 1740358593, 1744184665, 3);
INSERT INTO `ry_auth_group` VALUES (4, 2, '链接管理员', '权限：链接添加｜编辑｜删除｜显示', '5,34,35,36,37,63,64,65,66,67,68,69,70,71,72', 1, 1740358618, 1744184724, 4);
INSERT INTO `ry_auth_group` VALUES (5, 3, '文章编辑员', '权限：文章添加｜编辑｜', '', 1, 1740358662, 1740392484, 5);
COMMIT;

-- ----------------------------
-- Table structure for ry_auth_group_access
-- ----------------------------
DROP TABLE IF EXISTS `ry_auth_group_access`;
CREATE TABLE `ry_auth_group_access` (
  `uid` int(10) unsigned NOT NULL COMMENT '管理员ID',
  `group_id` int(10) unsigned NOT NULL COMMENT '管理员组ID',
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='管理员与权限组关联表';

-- ----------------------------
-- Records of ry_auth_group_access
-- ----------------------------
BEGIN;
INSERT INTO `ry_auth_group_access` VALUES (1, 1);
COMMIT;

-- ----------------------------
-- Table structure for ry_auth_rule
-- ----------------------------
DROP TABLE IF EXISTS `ry_auth_rule`;
CREATE TABLE `ry_auth_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限规则ID',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '权限标识',
  `rule` varchar(255) NOT NULL DEFAULT '' COMMENT '权限路由',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '权限名称',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父级权限ID',
  `icon` varchar(128) NOT NULL DEFAULT '' COMMENT '菜单图标',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '权限类型：1-菜单 2-操作',
  `show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示：1-显示 0-隐藏',
  `sort` int(10) unsigned NOT NULL DEFAULT '50' COMMENT '排序：数值越小越靠前',
  `condition` varchar(255) NOT NULL DEFAULT '' COMMENT '附加条件',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1-启用 0-禁用',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `name` (`name`) USING BTREE,
  KEY `idx_pid` (`pid`),
  KEY `idx_type` (`type`),
  KEY `idx_show` (`show`),
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COMMENT='权限规则表';

-- ----------------------------
-- Records of ry_auth_rule
-- ----------------------------
BEGIN;
INSERT INTO `ry_auth_rule` VALUES (1, 'RyCate/lst', 'cate/lst', '栏目管理', 0, 'layui-icon-component', 1, 1, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (2, 'RyArticle/lst', 'article/lst', '文档管理', 0, 'layui-icon-tabs', 1, 1, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (3, 'RyAdpos/lst', 'adpos/lst', '广告图片', 0, 'layui-icon-picture', 1, 1, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (4, 'RyConf/conf', 'conf/conf?is_en=0&model=1', '网站设置', 0, 'layui-icon-set', 1, 1, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (5, 'RyLink/lst', 'link/lst', '友情链接', 0, 'layui-icon-link', 1, 1, 6, '', 1);
INSERT INTO `ry_auth_rule` VALUES (6, 'RyForm/lst', 'form/lst', '表单留言', 0, 'layui-icon-dialogue', 1, 1, 7, '', 1);
INSERT INTO `ry_auth_rule` VALUES (7, 'RyBak/bak', 'bak/bak', '数据备份', 0, 'layui-icon-upload-drag', 1, 1, 11, '', 1);
INSERT INTO `ry_auth_rule` VALUES (8, 'RyAuser/lst', 'auser/lst', '用户管理', 0, 'layui-icon-friends', 1, 1, 8, '', 1);
INSERT INTO `ry_auth_rule` VALUES (9, 'RyAuthGroup/lst', 'group/lst', '用户组', 0, 'layui-icon-user', 1, 0, 9, '', 1);
INSERT INTO `ry_auth_rule` VALUES (10, 'RyAuthRule/lst', 'rule/lst', '权限列表', 0, 'layui-icon-password', 1, 1, 10, '', 1);
INSERT INTO `ry_auth_rule` VALUES (11, 'RyLog/lst', 'log/lst', '日志记录', 0, 'layui-icon-log', 1, 1, 9, '', 1);
INSERT INTO `ry_auth_rule` VALUES (12, 'RyCate/form', 'cate/form', '栏目操作', 1, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (13, 'RyCate/del', '', '栏目删除', 1, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (14, 'RyCate/getCateData', '', '栏目接口', 1, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (15, 'RyCate/lst', '', '栏目列表', 1, '', 1, 0, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (16, 'RyArticle/form', '', '文档操作', 2, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (17, 'RyArticle/moveAll', '', '批量移动', 2, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (18, 'RyArticle/getArtData', '', '文档接口', 2, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (19, 'RyArticle/del', '', '文档删除', 2, '', 1, 0, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (20, 'RyArticle/lst', '', '文档列表', 2, '', 1, 0, 5, '', 1);
INSERT INTO `ry_auth_rule` VALUES (21, 'RyAdpos/lst', '', '位置列表', 3, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (22, 'RyAdpos/form', '', '位置操作', 3, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (23, 'RyAdpos/getAdposData', '', '位置数据', 3, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (24, 'RyAdpos/baseDel', '', '位置删除', 3, '', 1, 0, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (25, 'RyAd/form', '', '图片操作', 3, '', 1, 0, 5, '', 1);
INSERT INTO `ry_auth_rule` VALUES (26, 'RyAd/getAdData', '', '图片数据', 3, '', 1, 0, 6, '', 1);
INSERT INTO `ry_auth_rule` VALUES (27, 'RyAd/baseDel', '', '图片删除', 3, '', 1, 0, 7, '', 1);
INSERT INTO `ry_auth_rule` VALUES (28, 'RyAd/lst', '', '图片列表', 3, '', 1, 0, 8, '', 1);
INSERT INTO `ry_auth_rule` VALUES (29, 'RyConf/lst', '', '字段列表', 4, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (30, 'RyConf/form', '', '字段操作', 4, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (31, 'RyConf/getConfData', '', '数据接口', 4, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (32, 'RyConf/del', '', '字段删除', 4, '', 1, 0, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (33, 'RyConf/conf', 'conf/conf?is_en=0', '配置表单', 4, 'layui-icon-set', 1, 0, 5, '', 1);
INSERT INTO `ry_auth_rule` VALUES (34, 'RyLink/form', '', '链接操作', 5, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (35, 'RyLink/getLinkData', '', '友链接口', 5, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (36, 'RyLink/baseDel', '', '链接删除', 5, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (37, 'RyLink/lst', '', '友链列表', 5, '', 1, 0, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (38, 'RyForm/getData', '', '表单数据', 6, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (39, 'RyForm/baseDel', '', '留言删除', 6, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (40, 'RyForm/lst', '', '留言列表', 6, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (41, 'RyBak/bak', '', '数据备份', 7, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (42, 'RyBak/delAll', '', '批量删除', 7, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (43, 'RyAuser/add', '', '用户添加', 8, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (44, 'RyAuser/edit', '', '用户修改', 8, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (45, 'RyAuser/del', '', '用户删除', 8, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (46, 'RyAuser/getUserData', '', '用户数据', 8, '', 1, 0, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (47, 'RyAuthGroup/form', '', '用户组操作', 9, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (48, 'RyAuthGroup/power', '', '权限分配', 9, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (49, 'RyAuthGroup/getGroupData', '', '用户组接口', 9, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (50, 'RyAuthGroup/del', '', '用户组删除', 9, '', 1, 0, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (51, 'RyAuthGroup/lst', '', '用户组列表', 9, '', 1, 0, 5, '', 1);
INSERT INTO `ry_auth_rule` VALUES (52, 'RyAuthRule/form', '', '权限操作', 10, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (53, 'RyAuthRule/getRuleData', '', '权限数据', 10, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (54, 'RyAuthRule/del', '', '权限删除', 10, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (55, 'RyAuthRule/lst', '', '权限列表', 10, '', 1, 0, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (56, 'RyLog/getLogData', '', '登陆日志', 11, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (57, 'RyLog/baseDel', '', '日志删除', 11, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (58, 'RyActionLog/lst', '', '操作日志', 11, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (59, 'RyActionLog/getLogData', '', '日志数据', 11, '', 1, 0, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (60, 'RyActionLog/baseDel', '', '日志删除', 11, '', 1, 0, 5, '', 1);
INSERT INTO `ry_auth_rule` VALUES (61, 'RyIndex/index', '', '公共权限', 0, 'layui-icon-home', 1, 0, 13, '', 1);
INSERT INTO `ry_auth_rule` VALUES (62, 'RyUpload/UploadImg', '', '图片上传', 61, '', 1, 0, 1, '', 1);
INSERT INTO `ry_auth_rule` VALUES (63, 'RyUpload/DeleteImg', '', '图片删除', 61, '', 1, 0, 2, '', 1);
INSERT INTO `ry_auth_rule` VALUES (64, 'RyUpload/uploadFile', '', '上传附件', 61, '', 1, 0, 3, '', 1);
INSERT INTO `ry_auth_rule` VALUES (65, 'RyUpload/uploadImages', '', '图集上传', 61, '', 1, 0, 4, '', 1);
INSERT INTO `ry_auth_rule` VALUES (66, 'RyLogin/index', '', '后台登录', 61, '', 1, 0, 5, '', 1);
INSERT INTO `ry_auth_rule` VALUES (67, 'RyLogin/logincheck', '', '登录验证', 61, '', 1, 0, 6, '', 1);
INSERT INTO `ry_auth_rule` VALUES (68, 'RyLogin/loginout', '', '退出登录', 61, '', 1, 0, 7, '', 1);
INSERT INTO `ry_auth_rule` VALUES (69, 'RyBase/clearCache', '', '清除缓存', 61, '', 1, 1, 8, '', 1);
INSERT INTO `ry_auth_rule` VALUES (70, 'RyBase/BaseSort', '', '修改排序', 61, '', 1, 0, 9, '', 1);
INSERT INTO `ry_auth_rule` VALUES (71, 'RyBase/changeStatus', '', '状态更新', 61, '', 1, 0, 10, '', 1);
COMMIT;

-- ----------------------------
-- Table structure for ry_cate
-- ----------------------------
DROP TABLE IF EXISTS `ry_cate`;
CREATE TABLE `ry_cate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '栏目ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父级栏目ID',
  `title` varchar(120) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `ename` varchar(120) DEFAULT '' COMMENT '英文名称/路由',
  `stitle` varchar(120) DEFAULT '' COMMENT '副标题',
  `thumb` varchar(500) DEFAULT '' COMMENT '缩略图',
  `background` varchar(500) DEFAULT '' COMMENT '背景图',
  `sort` int(10) unsigned NOT NULL DEFAULT '50' COMMENT '排序：数值越小越靠前',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '栏目类型：1-文章列表 2-单页 3-图片列表 4-产品 5-新闻',
  `navmenu` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '导航显示：1-显示 0-隐藏',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1-启用 0-禁用',
  `page_tmp` varchar(120) NOT NULL DEFAULT 'index_article.htm' COMMENT '单页模板',
  `lst_tmp` varchar(120) NOT NULL DEFAULT 'list_article.htm' COMMENT '列表模板',
  `article_tmp` varchar(120) NOT NULL DEFAULT 'article_article.htm' COMMENT '内容模板',
  `jump_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '跳转栏目ID',
  `keywords` varchar(255) DEFAULT '' COMMENT '关键词',
  `description` varchar(500) DEFAULT '' COMMENT '描述',
  `content` text COMMENT '栏目内容',
  `link` varchar(500) DEFAULT '' COMMENT '外部链接',
  `adminid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `annex` varchar(500) DEFAULT '' COMMENT '附件',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_pid` (`pid`),
  KEY `idx_type` (`type`),
  KEY `idx_navmenu` (`navmenu`),
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`),
  KEY `idx_create_time` (`create_time`),
  KEY `idx_adminid` (`adminid`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COMMENT='栏目表';

-- ----------------------------
-- Records of ry_cate
-- ----------------------------
BEGIN;
INSERT INTO `ry_cate` VALUES (1, 0, '关于我们', 'about', '成立于2010年，致力于芯片设计、研发、制造一体化服务', '', '/uploads/images/banner-about.jpg', 1, 1, 1, 1, 'index_article.htm', 'list_about.htm', 'article_article.htm', 2, '公司介绍,发展历程,企业文化', '了解芯科科技的发展历程和企业文化', '', 'about.html', 1, 1744273413, '', 1762248725, 0);
INSERT INTO `ry_cate` VALUES (2, 1, '公司介绍', 'company', '芯科科技 - 引领芯片科技，创造智能未来', '', '/uploads/images/banner-about.jpg', 1, 1, 1, 1, 'index_article.htm', 'list_about.htm', 'article_article.htm', 0, '公司简介,企业介绍', '芯科科技公司详细介绍', '<p>芯科科技是一家专注于高端芯片设计与制造的高新技术企业。我们拥有完整的芯片研发产业链，从芯片设计、流片制造到封装测试，为客户提供一站式解决方案。</p>', 'about.html', 1, 1744273949, '', 1762247140, 0);
INSERT INTO `ry_cate` VALUES (3, 1, '发展历程', 'history', '见证芯科科技的成长与蜕变', '', '/uploads/images/banner-about.jpg', 2, 1, 1, 1, 'index_article.htm', 'list_history.htm', 'article_article.htm', 0, '发展历程,里程碑', '芯科科技发展历程', '', 'about.html', 1, 1744273966, '', 1762244439, 0);
INSERT INTO `ry_cate` VALUES (4, 1, '公司优势', 'advantages', '芯科科技的核心竞争力', '', '/uploads/images/banner-about.jpg', 3, 1, 1, 1, 'index_article.htm', 'list_about_icon.htm', 'article_article.htm', 0, '核心优势,竞争优势', '芯科科技的核心竞争力介绍', '', 'about.html', 1, 1744273987, '', 1762245114, 0);
INSERT INTO `ry_cate` VALUES (5, 1, '荣誉资质', 'honors', '芯科科技获得的荣誉与认可', '', '/uploads/images/banner-about.jpg', 4, 1, 1, 1, 'index_article.htm', 'list_about_icon.htm', 'article_article.htm', 0, '荣誉资质,资质认证', '芯科科技获得的荣誉与资质', '', 'about.html', 1, 1744273988, '', 1762246972, 0);
INSERT INTO `ry_cate` VALUES (6, 0, '产品中心', 'products', '成为全球专业的芯片设计企业', '', '/uploads/images/banner-products.jpg', 2, 4, 1, 1, 'index_article.htm', 'list_product.htm', 'article_product.htm', 0, 'AI芯片,物联网芯片,汽车电子芯片', '芯科科技产品中心', '', 'product.html', 1, 1744273857, '', 1762249233, 0);
INSERT INTO `ry_cate` VALUES (7, 6, 'AI芯片', 'ai-chips', 'AI Chips', '', '/uploads/images/banner-products.jpg', 1, 4, 1, 1, 'index_article.htm', 'list_product.htm', 'article_product.htm', 0, '人工智能芯片,AI处理器', '人工智能专用芯片产品', '', 'product.html', 1, 1744274009, '', 1762589323, 0);
INSERT INTO `ry_cate` VALUES (8, 6, '物联网芯片', 'iot-chips', 'IoT Chips', '', '/uploads/images/banner-products-iot.jpg', 2, 4, 1, 1, 'index_article.htm', 'list_product.htm', 'article_product.htm', 0, '物联网芯片,连接芯片', '物联网连接芯片产品', '', 'product.html', 1, 1744430897, '', 1756654358, 0);
INSERT INTO `ry_cate` VALUES (9, 6, '汽车电子芯片', 'auto-chips', 'Auto Chips', '', '/uploads/images/banner-products-auto.jpg', 3, 4, 1, 1, 'index_article.htm', 'list_product.htm', 'article_product.htm', 0, '汽车芯片,车规级芯片', '汽车电子专用芯片', '', 'product.html', 1, 1744431455, '', 1753972616, 0);
INSERT INTO `ry_cate` VALUES (10, 6, '消费电子芯片', 'consumer-chips', 'Consumer Chips', '', '/uploads/images/banner-products-other.jpg', 4, 4, 1, 1, 'index_article.htm', 'list_product.htm', 'article_product.htm', 0, '消费电子,手机芯片', '消费电子类芯片产品', '', 'product.html', 1, 1744638366, '', 1750319055, 0);
INSERT INTO `ry_cate` VALUES (11, 0, '解决方案', 'solutions', '针对不同行业需求，提供定制化芯片解决方案', '', '/uploads/images/banner-solutions.jpg', 3, 1, 1, 1, 'index_article.htm', 'list_solutions_all.htm', 'article_article.htm', 0, '解决方案,应用方案', '行业解决方案', '', 'solutions.html', 1, 1756694600, '', 1762261396, 0);
INSERT INTO `ry_cate` VALUES (12, 11, '行业痛点', 'pain-points', '当前行业面临的技术挑战与瓶颈', '', '/uploads/images/banner-solutions.jpg', 1, 1, 1, 1, 'index_article.htm', 'list_solutions_one.htm', 'article_article.htm', 0, '行业痛点,技术挑战', '当前行业面临的技术挑战与瓶颈', '', 'solutions.html', 1, 1756694601, '', 1756694956, 0);
INSERT INTO `ry_cate` VALUES (13, 11, '核心优势', 'core-advantages', '芯科科技解决方案的独特价值', '', '/uploads/images/banner-solutions.jpg', 2, 1, 1, 1, 'index_article.htm', 'list_solutions_two.htm', 'article_article.htm', 0, '核心优势,独特价值', '芯科科技解决方案的独特价值', '', 'solutions.html', 1, 1756694602, '', 1756694957, 0);
INSERT INTO `ry_cate` VALUES (14, 11, '解决思路', 'solution-approach', '从芯片到系统的全方位技术路径', '', '/uploads/images/banner-solutions.jpg', 3, 1, 1, 1, 'index_article.htm', 'list_solutions_three.htm', 'article_article.htm', 0, '解决思路,技术路径', '从芯片到系统的全方位技术路径', '', 'solutions.html', 1, 1756694603, '', 1756694958, 0);
INSERT INTO `ry_cate` VALUES (15, 11, '解决方案', 'solutions-list', '针对不同行业需求的专业解决方案', '', '/uploads/images/banner-solutions.jpg', 4, 1, 1, 1, 'index_article.htm', 'list_solutions.htm', 'article_article.htm', 0, '专业解决方案,行业方案', '针对不同行业需求的专业解决方案', '', 'solutions.html', 1, 1756694604, '', 1756694959, 0);
INSERT INTO `ry_cate` VALUES (16, 0, '新闻资讯', 'news', '最新公司动态、行业资讯和技术解答', '', '/uploads/images/banner-news.jpg', 4, 5, 1, 1, 'index_article.htm', 'list_news.htm', 'article_news.htm', 0, '新闻,资讯,动态', '芯科科技最新新闻资讯', '', 'news.html', 1, 1744638407, '', 1762261412, 0);
INSERT INTO `ry_cate` VALUES (17, 16, '公司新闻', 'company-news', 'Company News', '', '/uploads/images/banner-news.jpg', 1, 5, 1, 1, 'index_article.htm', 'list_news.htm', 'article_news.htm', 0, '公司新闻,企业动态', '芯科科技公司内部新闻', '', 'news.html', 1, 1756654101, '', 1756654101, 0);
INSERT INTO `ry_cate` VALUES (18, 16, '行业资讯', 'industry-news', 'Industry News', '', '/uploads/images/banner-news.jpg', 2, 5, 1, 1, 'index_article.htm', 'list_news.htm', 'article_news.htm', 0, '行业资讯,市场动态', '芯片行业最新资讯', '', 'news.html', 1, 1756654116, '', 1756654116, 0);
INSERT INTO `ry_cate` VALUES (19, 16, '技术动态', 'tech-news', 'Technology News', '', '/uploads/images/banner-news.jpg', 3, 5, 1, 1, 'index_article.htm', 'list_news.htm', 'article_news.htm', 0, '技术动态,研发进展', '技术研发最新动态', '', 'news.html', 1, 1756654127, '', 1756654127, 0);
INSERT INTO `ry_cate` VALUES (20, 16, '活动资讯', 'event-news', 'Event News', '', '/uploads/images/banner-news.jpg', 4, 5, 1, 1, 'index_article.htm', 'list_news.htm', 'article_news.htm', 0, '活动,展会,会议', '公司活动及展会信息', '', 'news.html', 1, 1756694599, '', 1756694954, 0);
INSERT INTO `ry_cate` VALUES (21, 0, '联系我们', 'contact', 'Contact Us', '', '/uploads/images/banner-contact.jpg', 5, 2, 1, 1, 'index_contact.htm', 'list_contact.htm', 'article_article.htm', 22, '联系方式,联系我們', '联系我们页面', '', 'contact.html', 1, 1756694607, '', 1762224340, 0);
INSERT INTO `ry_cate` VALUES (22, 21, '联系方式', 'contact-info', '多种方式联系我们，我们随时为您服务', '', '/uploads/images/banner-contact.jpg', 1, 2, 1, 1, 'index_contact.htm', 'list_article.htm', 'article_article.htm', 0, '联系信息,地址电话', '联系方式详细信息', '<p>地址：北京市海淀区中关村科技园区芯科大厦</p><p>电话：400-123-4567</p><p>邮箱：contact@xinke-tech.com</p>', 'contact.html', 1, 1756694608, '', 1762224365, 0);
INSERT INTO `ry_cate` VALUES (23, 21, '在线留言', 'online-message', '填写表单，我们会尽快与您联系', '', '/uploads/images/banner-contact.jpg', 2, 2, 1, 1, 'index_form.htm', 'list_article.htm', 'article_article.htm', 0, '留言,反馈', '在线留言反馈', '', '', 1, 1756694609, '', 1762224427, 0);
INSERT INTO `ry_cate` VALUES (24, 21, '加入我们', 'jobs', '我们正在寻找优秀人才，共创美好未来', '', '/uploads/images/banner-contact.jpg', 3, 1, 1, 1, 'index_article.htm', 'list_jobs.htm', 'article_article.htm', 0, '招聘,职位,人才', '招聘信息页面', '', 'jobs.html', 1, 1756694610, '', 1756694965, 0);
INSERT INTO `ry_cate` VALUES (100, 0, '应用领域', 'applications', '我们的芯片技术广泛应用于各个高科技领域', '', '/uploads/images/banner-contact.jpg', 6, 1, 0, 0, 'index_article.htm', 'list_article.htm', 'article_article.htm', 0, '', '', '', '', 1, 1761792590, '', 1761792715, 0);
INSERT INTO `ry_cate` VALUES (101, 0, '合作伙伴', 'hezuohuoban', '我们与全球众多知名企业建立了长期合作关系', '', '', 50, 1, 0, 0, '', '', '', 0, '', '', '', '', 0, 1762260912, '', 1762260912, 0);
COMMIT;

-- ----------------------------
-- Table structure for ry_conf
-- ----------------------------
DROP TABLE IF EXISTS `ry_conf`;
CREATE TABLE `ry_conf` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '配置名称',
  `ename` varchar(255) NOT NULL DEFAULT '' COMMENT '配置标识',
  `value` text NOT NULL COMMENT '配置值',
  `values` varchar(1000) NOT NULL DEFAULT '' COMMENT '可选值列表',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '配置类型：1-单行文本 2-单选 3-复选 4-下拉 5-文本域 6-附件 7-浮点 8-整型 9-长文本',
  `model` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '配置分类：1-基本设置 2-SEO设置 3-联系方式 4-图片水印 5-其他',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1-启用 0-禁用',
  `is_en` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '多语言支持：1-启用 0-关闭',
  `is_os` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '系统字段：1-是 0-否',
  `sort` int(10) unsigned NOT NULL DEFAULT '50' COMMENT '排序：数值越小越靠前',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uk_ename` (`ename`),
  KEY `idx_model` (`model`),
  KEY `idx_status` (`status`),
  KEY `idx_type` (`type`),
  KEY `idx_is_os` (`is_os`),
  KEY `idx_sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COMMENT='系统配置表';

-- ----------------------------
-- Records of ry_conf
-- ----------------------------
BEGIN;
INSERT INTO `ry_conf` VALUES (1, '站点名称', 'sitename', '芯科科技 - 基于RoyalCMS（若伊）框架的芯片科技公司', '', 1, 1, 1, 0, 0, 1);
INSERT INTO `ry_conf` VALUES (2, '关键词语', 'keywords', '芯片,AI芯片,物联网芯片,汽车电子芯片,芯科科技', '', 1, 1, 1, 0, 0, 2);
INSERT INTO `ry_conf` VALUES (3, '网站描述', 'description', '芯科科技 - 专注于高端芯片设计与制造的高新技术企业，提供AI芯片、物联网芯片、汽车电子芯片等创新技术产品', '', 2, 1, 1, 0, 0, 3);
INSERT INTO `ry_conf` VALUES (4, '网站备案', 'beian', '京ICP备202400001号', '', 1, 1, 1, 0, 0, 4);
INSERT INTO `ry_conf` VALUES (5, '网站版权', 'banquan', '© 2025 芯科科技 版权所有', '', 1, 1, 1, 0, 0, 11);
INSERT INTO `ry_conf` VALUES (6, '网站域名', 'www', 'www.xinke-tech.com', '', 1, 3, 1, 0, 0, 8);
INSERT INTO `ry_conf` VALUES (7, '公司电话', 'tel', '400-123-4567', '', 1, 3, 1, 0, 0, 5);
INSERT INTO `ry_conf` VALUES (8, '公司传真', 'fax', '010-12345678', '', 1, 3, 1, 0, 0, 13);
INSERT INTO `ry_conf` VALUES (9, '公司邮箱', 'email', 'contact@xinke-tech.com', '', 1, 3, 1, 0, 0, 9);
INSERT INTO `ry_conf` VALUES (10, '公司地址', 'add', '北京市海淀区中关村科技园区芯科大厦', '', 1, 3, 1, 0, 0, 6);
INSERT INTO `ry_conf` VALUES (24, '网站logo', 'logo', '/uploads/images/logo.png', '', 6, 2, 1, 0, 0, 14);
INSERT INTO `ry_conf` VALUES (29, '公司名称', 'gsmc', '芯科科技', '', 1, 3, 1, 0, 0, 1);
INSERT INTO `ry_conf` VALUES (33, '联系人', 'lxr', '张先生', '', 1, 3, 1, 0, 0, 10);
INSERT INTO `ry_conf` VALUES (35, '网安备案', 'wangan', '京公网安备 11010802020088号', '', 1, 1, 1, 0, 0, 7);
INSERT INTO `ry_conf` VALUES (36, '站点开启', 'siteon', '1', '1,0', 3, 1, 1, 0, 1, 50);
INSERT INTO `ry_conf` VALUES (37, '技术支持邮箱', 'tech_email', 'support@xinke-tech.com', '', 1, 3, 1, 0, 0, 12);
INSERT INTO `ry_conf` VALUES (38, '销售咨询邮箱', 'sales_email', 'sales@xinke-tech.com', '', 1, 3, 1, 0, 0, 14);
INSERT INTO `ry_conf` VALUES (39, '合作洽谈邮箱', 'cooperation_email', 'partner@xinke-tech.com', '', 1, 3, 1, 0, 0, 15);
INSERT INTO `ry_conf` VALUES (48, '开启水印', 'water', '关闭', '开启,关闭', 3, 4, 1, 0, 1, 19);
INSERT INTO `ry_conf` VALUES (49, '水印图片', 'waterimg', '/uploads/images/watermark.png', '', 6, 4, 1, 0, 1, 18);
INSERT INTO `ry_conf` VALUES (50, '水印位置', 'water_position', '右下角', '左上角,右上角,左下角,右下角,居中', 4, 4, 1, 0, 1, 17);
INSERT INTO `ry_conf` VALUES (51, '水印透明度', 'water_opacity', '80', '', 8, 4, 1, 0, 1, 16);
INSERT INTO `ry_conf` VALUES (59, '微博链接', 'weibo', 'https://weibo.com/xinketech', '', 1, 5, 1, 0, 0, 20);
INSERT INTO `ry_conf` VALUES (60, '网站图标', 'favicon', '/uploads/images/favicon.png', '', 6, 2, 1, 0, 0, 16);
INSERT INTO `ry_conf` VALUES (61, '知乎链接', 'zhihu', 'https://www.zhihu.com/org/xin-ke-ke-ji', '', 1, 5, 1, 0, 0, 21);
INSERT INTO `ry_conf` VALUES (62, 'B站链接', 'bilibili', 'https://space.bilibili.com/xinketech', '', 1, 5, 1, 0, 0, 22);
INSERT INTO `ry_conf` VALUES (63, '领英链接', 'linkedin', 'https://www.linkedin.com/company/xinke-tech', '', 1, 5, 1, 0, 0, 23);
INSERT INTO `ry_conf` VALUES (64, 'GitHub链接', 'github', 'https://github.com/xinke-tech', '', 1, 5, 1, 0, 0, 24);
INSERT INTO `ry_conf` VALUES (69, '底部logo', 'footerlogo', '/uploads/images/footer-logo.png', '', 6, 2, 1, 0, 0, 17);
INSERT INTO `ry_conf` VALUES (72, '技术支持电话', 'tech_tel', '400-123-4567转1', '', 1, 5, 1, 0, 0, 31);
INSERT INTO `ry_conf` VALUES (73, '销售咨询电话', 'sales_tel', '400-123-4567转2', '', 1, 5, 1, 0, 0, 32);
INSERT INTO `ry_conf` VALUES (74, '合作洽谈电话', 'cooperation_tel', '400-123-4567转3', '', 1, 5, 1, 0, 0, 33);
INSERT INTO `ry_conf` VALUES (75, '服务时间', 'service_time', '周一至周五 9:00-18:00', '', 1, 5, 1, 0, 0, 34);
INSERT INTO `ry_conf` VALUES (76, '技术文档下载', 'doc_download', '/downloads/technical-docs/', '', 1, 5, 1, 0, 0, 35);
INSERT INTO `ry_conf` VALUES (77, 'SDK下载', 'sdk_download', '/downloads/sdk/', '', 1, 5, 1, 0, 0, 36);
INSERT INTO `ry_conf` VALUES (78, '驱动下载', 'driver_download', '/downloads/drivers/', '', 1, 5, 1, 0, 0, 37);
INSERT INTO `ry_conf` VALUES (79, '白皮书下载', 'whitepaper_download', '/downloads/whitepapers/', '', 1, 5, 1, 0, 0, 38);
INSERT INTO `ry_conf` VALUES (80, '在线咨询QQ', 'consult_qq', '123456789', '', 1, 5, 1, 0, 0, 39);
INSERT INTO `ry_conf` VALUES (81, '在线咨询微信', 'consult_wechat', 'xinke_tech', '', 1, 5, 1, 0, 0, 40);
INSERT INTO `ry_conf` VALUES (82, '咨询工作时间', 'consult_time', '周一至周日 9:00-21:00', '', 1, 5, 1, 0, 0, 41);
INSERT INTO `ry_conf` VALUES (83, '紧急技术支持', 'emergency_support', '13800138000', '', 1, 5, 1, 0, 0, 42);
INSERT INTO `ry_conf` VALUES (85, '微信公众号', 'wechat', '/uploads/images/wechat-qrcode.png', '', 6, 2, 1, 0, 0, 7);
INSERT INTO `ry_conf` VALUES (91, '微信咨询', 'wechatt', '/uploads/images/wechat-service.png', '', 6, 2, 1, 0, 0, 22);
INSERT INTO `ry_conf` VALUES (99, '抖音二维码', 'douyin', '/uploads/images/douyin-qrcode.png', '', 6, 2, 1, 0, 0, 15);
INSERT INTO `ry_conf` VALUES (100, '工作时间', 'worktime', '周一至周五: 9:00-18:00', '', 1, 1, 1, 0, 0, 50);
COMMIT;

-- ----------------------------
-- Table structure for ry_en_action_log
-- ----------------------------
DROP TABLE IF EXISTS `ry_en_action_log`;
CREATE TABLE `ry_en_action_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uname` varchar(50) NOT NULL DEFAULT '' COMMENT '操作人用户名',
  `module` varchar(2048) NOT NULL DEFAULT '' COMMENT '操作模块名称',
  `action` varchar(30) NOT NULL DEFAULT '' COMMENT '操作类型',
  `data_id` int(11) NOT NULL DEFAULT '0' COMMENT '操作数据ID',
  `description` varchar(255) NOT NULL DEFAULT '' COMMENT '操作描述',
  `ip` varchar(45) NOT NULL DEFAULT '' COMMENT '操作IP地址(支持IPv6)',
  `os` varchar(50) NOT NULL DEFAULT '' COMMENT '客户端操作系统',
  `create_time` int(11) NOT NULL COMMENT '操作时间戳',
  `groupid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '管理员用户组ID',
  `adminid` mediumint(9) unsigned NOT NULL DEFAULT '1' COMMENT '管理员用户ID',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_create_time` (`create_time`),
  KEY `idx_uname` (`uname`),
  KEY `idx_action` (`action`),
  KEY `idx_data_id` (`data_id`),
  KEY `idx_groupid` (`groupid`),
  KEY `idx_adminid` (`adminid`),
  KEY `idx_module_prefix` (`module`(100)) COMMENT '模块名前缀索引',
  KEY `idx_group_admin` (`groupid`,`adminid`),
  KEY `idx_module_action` (`module`(50),`action`),
  KEY `idx_ip_time` (`ip`,`create_time`),
  KEY `idx_os_time` (`os`,`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='系统操作日志表';

-- ----------------------------
-- Records of ry_en_action_log
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for ry_en_ad
-- ----------------------------
DROP TABLE IF EXISTS `ry_en_ad`;
CREATE TABLE `ry_en_ad` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT COMMENT '图片广告ID',
  `adposid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告名称',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告缩略图',
  `detailimg` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告详情图',
  `content` text COMMENT '图片广告详情内容',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1启用，0关闭',
  `sort` mediumint(9) unsigned NOT NULL DEFAULT '50' COMMENT '排序权重(数字越小越靠前)',
  `adminid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '创建者管理员ID',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间戳',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间戳',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT '软删除时间戳(0表示未删除)',
  `jump_cate` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '跳转栏目ID',
  `jump_article` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '跳转文章ID',
  `stitle` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告简略标题',
  `link` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告链接',
  `video` varchar(255) NOT NULL DEFAULT '' COMMENT '图片广告视频链接地址',
  `desc` varchar(2048) NOT NULL DEFAULT '' COMMENT '图片广告简介',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_adposid` (`adposid`),
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`),
  KEY `idx_create_time` (`create_time`),
  KEY `idx_delete_time` (`delete_time`),
  KEY `idx_jump_cate` (`jump_cate`),
  KEY `idx_jump_article` (`jump_article`),
  KEY `idx_adminid` (`adminid`),
  KEY `idx_update_time` (`update_time`),
  KEY `idx_title_prefix` (`title`(100)),
  KEY `idx_stitle` (`stitle`(100)),
  KEY `idx_link` (`link`(100)),
  KEY `idx_video` (`video`(100))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='广告内容表';

-- ----------------------------
-- Records of ry_en_ad
-- ----------------------------
BEGIN;
INSERT INTO `ry_en_ad` VALUES (1, 1, 'Chip Innovation Leader', '/uploads/images/banner.jpg', '', '', 1, 50, 1, 1762758391, 1762758391, 0, 2, 0, 'Dedicated to high-end chip R&D and solutions, providing professional technical products and services globally.', '', '', '');
INSERT INTO `ry_en_ad` VALUES (2, 1, 'Advanced Chip Technology', '/uploads/images/banner1.jpg', '', '', 1, 50, 1, 1762758391, 1762758391, 0, 0, 0, 'Utilizing cutting-edge process technology to create high-performance chips for AI and diverse application needs.', '', '', '');
INSERT INTO `ry_en_ad` VALUES (3, 1, 'Smart Chip Solutions', '/uploads/images/banner2.jpg', '', '', 1, 50, 1, 1762758391, 1762758391, 0, 0, 0, 'Providing specialized chips for machine learning scenarios, delivering excellent performance and energy efficiency.', '', '', '');
COMMIT;

-- ----------------------------
-- Table structure for ry_en_adpos
-- ----------------------------
DROP TABLE IF EXISTS `ry_en_adpos`;
CREATE TABLE `ry_en_adpos` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT COMMENT '图片位置ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '广告位置名称',
  `width` varchar(120) NOT NULL DEFAULT '' COMMENT '广告位置宽度(单位:px)',
  `height` varchar(120) NOT NULL DEFAULT '' COMMENT '广告位置高度(单位:px)',
  `sort` mediumint(9) unsigned NOT NULL DEFAULT '50' COMMENT '排序权重(数字越小越靠前)',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1启用，0禁用',
  `adminid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '创建者管理员ID',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间戳',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间戳',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT '软删除时间戳(0表示未删除)',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`),
  KEY `idx_create_time` (`create_time`),
  KEY `idx_delete_time` (`delete_time`),
  KEY `idx_title` (`title`(50)) COMMENT '标题前缀索引',
  KEY `idx_adminid` (`adminid`),
  KEY `idx_update_time` (`update_time`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='广告位置表';

-- ----------------------------
-- Records of ry_en_adpos
-- ----------------------------
BEGIN;
INSERT INTO `ry_en_adpos` VALUES (1, '首页banner', '1920', '1080', 50, 1, 0, 0, 0, 0);
COMMIT;

-- ----------------------------
-- Table structure for ry_en_article
-- ----------------------------
DROP TABLE IF EXISTS `ry_en_article`;
CREATE TABLE `ry_en_article` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章ID',
  `cateid` mediumint(9) NOT NULL DEFAULT '0' COMMENT '文章对应栏目ID',
  `title` varchar(1024) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '文章标题',
  `thumb` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章缩略图',
  `annex` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章附件',
  `content` longtext CHARACTER SET utf8 COMMENT '文章内容',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '文章启用状态',
  `sort` smallint(6) unsigned NOT NULL DEFAULT '50' COMMENT '文章排序:默认50',
  `adminid` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '文章对应管理员ID',
  `create_time` int(10) NOT NULL DEFAULT '0' COMMENT '发布时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT '删除时间',
  `stitle` varchar(1024) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章简略标题',
  `class` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文档级别',
  `keywords` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章关键词',
  `price` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章权重',
  `description` varchar(2048) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章描述',
  `type` tinyint(1) DEFAULT '0' COMMENT '文章属性',
  `link` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章外链链接',
  `video` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章视频地址',
  `author` varchar(120) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章作者',
  `source` varchar(120) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章来源',
  `is_index` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否首页显示:0-否,1-是',
  `star` mediumint(9) unsigned NOT NULL DEFAULT '30' COMMENT '文章初始点赞数',
  `images` varchar(2048) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章图集',
  `catesub` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '文章对应子栏目ID',
  `area` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '建筑面积',
  `coverarea` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '占地面积',
  `openrate` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '商业开业率',
  `content_xn` longtext CHARACTER SET utf8 COMMENT '性能优势',
  `content_notice` longtext CHARACTER SET utf8 COMMENT '注意事项',
  `click` mediumint(9) unsigned NOT NULL DEFAULT '0' COMMENT '文章初始点击数',
  `like_count` varchar(9) CHARACTER SET utf8 NOT NULL DEFAULT '50' COMMENT '文章初始点击数',
  `icon` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT '图片广告详情图',
  `tag` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '标签ID集合，逗号分隔',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_cateid` (`cateid`),
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`),
  KEY `idx_create_time` (`create_time`),
  KEY `idx_update_time` (`update_time`),
  KEY `idx_delete_time` (`delete_time`),
  KEY `idx_adminid` (`adminid`),
  KEY `idx_is_index` (`is_index`),
  KEY `idx_click` (`click`),
  KEY `idx_like_count` (`like_count`),
  KEY `idx_star` (`star`),
  KEY `idx_type` (`type`),
  KEY `idx_author` (`author`(50)),
  KEY `idx_source` (`source`(50)),
  KEY `idx_title_prefix` (`title`(100)),
  KEY `idx_stitle` (`stitle`(100)),
  KEY `idx_keywords` (`keywords`(100)),
  KEY `idx_tag` (`tag`(100)),
  KEY `idx_cate_status_time` (`cateid`,`status`,`create_time`),
  KEY `idx_status_delete_time` (`status`,`delete_time`,`sort`),
  KEY `idx_cate_isindex` (`cateid`,`is_index`,`sort`),
  KEY `idx_type_status_time` (`type`,`status`,`create_time`)
) ENGINE=InnoDB AUTO_INCREMENT=669 DEFAULT CHARSET=utf8mb4 COMMENT='文章管理表';

-- ----------------------------
-- Records of ry_en_article
-- ----------------------------
BEGIN;
INSERT INTO `ry_en_article` VALUES (101, 17, 'Silicon Core Technology Releases New Generation 7nm AI Inference Chip XK-AI300 Series', '/uploads/images/news/news1.jpg', '', '<p>Silicon Core Technology today officially released the new generation 7nm AI inference chip XK-AI300. This chip adopts advanced 7nm process technology, with performance improved by 300% and energy efficiency ratio increased by 50% compared to the previous generation. The XK-AI300 is specifically designed for edge computing and cloud AI inference scenarios, supporting various neural network models including CNN, RNN, Transformer, etc.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news5.jpg\" alt=\"AI Chip Product Image\"></p><p>The chip integrates a dedicated Tensor Processing Unit (TPU), supporting multiple precision calculations such as INT8, INT16, FP16, significantly improving computational efficiency while maintaining high accuracy. The XK-AI300 is also equipped with an advanced cooling system and power management module, ensuring stable operation even under high load.</p><p>Zhang Ming, CEO of Silicon Core Technology, stated: \"The release of XK-AI300 marks a new level of our technical strength in the field of AI chips. This chip will provide powerful computing support for smart manufacturing, autonomous driving, intelligent security, and other fields.\"</p><p>Currently, the XK-AI300 has begun mass production and has reached cooperation intentions with several industry leading enterprises. The first batch of products is expected to be delivered to customers next quarter.</p>', 1, 50, 1, 1756655748, 1756655748, 0, 'Silicon Core Tech releases new 7nm AI inference chip, significant performance boost, designed for edge and cloud AI inference', '', 'AI Chip,7nm Process,Inference Chip,Silicon Core Tech', '', 'Silicon Core Tech releases XK-AI300, a 7nm AI inference chip with 300% performance boost and 50% better energy efficiency, designed for edge and cloud AI inference.', 0, '', '', 'Zhang Ming', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 272, '0', '', '');
INSERT INTO `ry_en_article` VALUES (102, 17, 'Silicon Core Technology Wins 2024 Technology Innovation Enterprise Award', '/uploads/images/news/news2.jpg', '', '<p>At the recently held 2024 China Semiconductor Industry Innovation Conference, Silicon Core Technology won the \"2024 Technology Innovation Enterprise Award\" for its outstanding contributions in the field of chip design. This is the third consecutive year the company has received this award, fully reflecting industry recognition of its innovation capabilities.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news8.jpg\" alt=\"Award Ceremony Scene\"></p><p>The judging panel stated in the award citation that Silicon Core Technology has achieved significant innovative results in AI chips, IoT chips, and other fields, especially with breakthroughs in 7nm process technology, making important contributions to the development of China\'s semiconductor industry. The company\'s R&D investment has remained above 20% of operating revenue for many consecutive years, establishing a sound innovation system.</p><p>Li Qiang, CTO of Silicon Core Technology, said while accepting the award: \"This award is an affirmation of our team\'s relentless efforts. We will continue to increase R&D investment, make continuous breakthroughs in more advanced processes like 3nm and 2nm, and contribute to the development of China\'s chip industry.\"</p><p>As of now, Silicon Core Technology has accumulated over 500 patent grants, with invention patents accounting for over 60%. The company has established full-industry-chain innovation capabilities from chip design, manufacturing to packaging and testing.</p>', 1, 49, 1, 1756569348, 1756569348, 0, 'Silicon Core Tech wins Tech Innovation Enterprise Award for third consecutive year, recognized by industry', '', 'Technology Innovation Award,Semiconductor Industry,Silicon Core Tech,Industry Recognition', '', 'Silicon Core Tech wins the 2024 Technology Innovation Enterprise Award, marking the third consecutive year, reflecting full industry recognition of the company\'s innovation capability.', 0, '', '', 'Li Qiang', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 537, '0', '', '');
INSERT INTO `ry_en_article` VALUES (103, 17, 'Silicon Core Technology and Tsinghua University Establish Joint Laboratory', '/uploads/images/news/news3.jpg', '', '<p>Silicon Core Technology and Tsinghua University\'s Microelectronics School recently signed a strategic cooperation agreement to jointly establish an \"Advanced Chip Technology Joint Laboratory\". This laboratory will focus on the research and development of next-generation chip technologies, including 3nm process, new memory technologies, photoelectric integration, and other cutting-edge fields.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news12.jpg\" alt=\"Signing Ceremony Scene\"></p><p>According to the agreement, Silicon Core Technology will invest 200 million RMB over the next five years for laboratory construction and technology R&D. The laboratory will be equipped with internationally advanced R&D equipment, including electron beam lithography machines, atomic layer deposition systems, etc. Both parties will also jointly cultivate doctoral and master\'s students to supply high-end talent for the chip industry.</p><p>Professor Wang, Dean of Tsinghua University\'s Microelectronics School, said: \"The cooperation with Silicon Core Technology will fully leverage the advantages of both university and enterprise, promoting innovative development in chip technology. We look forward to achieving significant results in both basic research and industrial applications.\"</p><p>The first batch of research projects for the joint laboratory has already started, including high-performance processor design based on open-source instruction set architecture, computing-in-memory chip technology, etc. These research results will be directly applied to Silicon Core Technology\'s future products.</p>', 1, 48, 1, 1756482948, 1756482948, 0, 'Silicon Core Tech and Tsinghua University sign strategic cooperation to establish Advanced Chip Technology Joint Lab', '', 'University-Enterprise Cooperation,Joint Laboratory,Tsinghua University,Chip R&D', '', 'Silicon Core Tech and Tsinghua University establish Advanced Chip Technology Joint Laboratory, investing 200 million over five years, focusing on next-gen chip tech R&D.', 0, '', '', 'Professor Wang', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 652, '0', '', '');
INSERT INTO `ry_en_article` VALUES (121, 18, 'Global Chip Market Size Expected to Reach $600 Billion in 2024', '/uploads/images/news/news4.jpg', '', '<p>According to the latest \"2024 Global Semiconductor Market Report\", the global chip market size is expected to break through $600 billion in 2024, a year-on-year increase of 8.5%. This growth is mainly driven by the rapid development of emerging technologies such as artificial intelligence, Internet of Things, and 5G.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news9.jpg\" alt=\"Global Chip Market Trend Chart\"></p><p>The report shows that the AI chip market has the most significant growth, with an expected annual growth rate of over 25%. The demand for automotive electronic chips also continues to be strong. With the development of intelligent connected vehicles and autonomous driving technology, the market size of automotive-grade chips is expected to exceed $50 billion.</p><p>From a regional distribution perspective, the Asia-Pacific region remains the world\'s largest chip market, accounting for over 60%. The Chinese market performs particularly well. Driven by both policy support and market demand, China\'s chip industry maintains rapid growth.</p><p>Expert analysis suggests that despite challenges from geopolitics and supply chains, the long-term growth trend of the chip industry will not change. Technological innovation and industrial upgrading will continue to drive market development, especially in emerging fields such as high-performance computing and edge AI.</p>', 1, 50, 1, 1756396548, 1756396548, 0, 'According to latest global semiconductor market report, AI chips and automotive electronics chips become main growth drivers', '', 'Chip Market,Semiconductor Industry,Market Size,Industry Trends', '', '2024 global chip market size expected to break $600 billion, with AI chips and automotive electronics chips as main growth drivers.', 0, '', '', 'Industry Analyst', 'Industry Research Report', 1, 30, '', '', '', '', '', NULL, NULL, 291, '0', '', '');
INSERT INTO `ry_en_article` VALUES (122, 18, 'Important Breakthrough in 3nm Chip Process Technology', '/uploads/images/news/news5.jpg', '', '<p>The global semiconductor industry has achieved important breakthroughs in 3nm process technology, with multiple chip manufacturers announcing that 3nm process is about to enter mass production. Compared to the 5nm process, the 3nm process improves performance by 30% while reducing power consumption by 35%, with transistor density increasing by about 70%.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news15.jpg\" alt=\"3nm Chip Structure Diagram\"></p><p>Technological breakthroughs are mainly reflected in innovations in transistor structure, including the mature application of Gate-All-Around transistor technology, the use of new materials, and optimization of manufacturing processes. These technological advances enable more transistors to be integrated in the same area, providing stronger computing power for high-performance computing and AI applications.</p><p>Industry experts stated that the breakthrough in 3nm technology will drive the development of the entire electronics industry. Performance in fields such as smartphones, data centers, and autonomous driving will be significantly improved. It is expected that by 2025, 3nm chips will occupy an important share of the high-end chip market.</p><p>Meanwhile, the development of 2nm process is also accelerating. Major chip manufacturers are increasing R&D investment, striving to gain leading advantages in next-generation process technology.</p>', 1, 49, 1, 1756310148, 1756310148, 0, 'Global semiconductor industry achieves important breakthrough in 3nm process, multiple manufacturers announce mass production readiness', '', '3nm Process,Process Technology,Semiconductor Manufacturing,Technology Breakthrough', '', '3nm chip process technology achieves important breakthrough, 30% performance improvement, 35% power reduction, driving new round of electronics industry upgrade.', 0, '', '', 'Technology Expert', 'Industry Technology Trends', 1, 30, '', '', '', '', '', NULL, NULL, 261, '0', '', '');
INSERT INTO `ry_en_article` VALUES (141, 19, 'Silicon Core Technology Breaks Through Key Computing-in-Memory Chip Technology R&D', '/uploads/images/news/news6.jpg', '', '<p>Silicon Core Technology\'s R&D team has achieved a major breakthrough in computing-in-memory chip technology, successfully developing a computing-in-memory chip prototype based on new memristors. This technology can significantly improve AI computing energy efficiency, especially suitable for edge computing and IoT application scenarios.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news18.jpg\" alt=\"Computing-in-Memory Chip Schematic\"></p><p>In traditional computing architectures, data needs to be frequently transferred between memory and processors, generating significant power consumption and latency. Computing-in-memory technology performs calculations directly in memory, eliminating data movement overhead, improving energy efficiency by over 10 times.</p><p>Silicon Core Technology\'s first computing-in-memory chip uses 28nm process manufacturing, performing excellently in image recognition tasks with power consumption only one-tenth of traditional architectures. The R&D team is optimizing the design and plans to adopt more advanced process technology in the next-generation product.</p><p>This technological breakthrough will provide new possibilities for AI deployment on terminal devices, enabling complex AI algorithms to run efficiently on power-constrained devices, promoting the widespread application of AI technology.</p>', 1, 50, 1, 1756223748, 1756223748, 0, 'Silicon Core Tech R&D team achieves major breakthrough in computing-in-memory chip tech, successfully develops memristor-based prototype', '', 'Computing-in-Memory,Memristor,AI Chip,Technology Innovation', '', 'Silicon Core Tech breaks through key computing-in-memory chip technology, 10x energy efficiency improvement, provides new solution for edge AI computing.', 0, '', '', 'R&D Team', 'Technology R&D Trends', 1, 30, '', '', '', '', '', NULL, NULL, 184, '0', '', '');
INSERT INTO `ry_en_article` VALUES (142, 19, 'New Chip Cooling Technology Effectively Improves Chip Performance', '/uploads/images/news/news7.jpg', '', '<p>Silicon Core Technology\'s Materials Laboratory has developed a new chip cooling technology using graphene composite materials and microfluidic cooling systems, capable of reducing chip operating temperature by over 20°C and improving performance by 30%. This technological breakthrough solves the heat dissipation bottleneck problem of high-performance chips.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news22.jpg\" alt=\"Cooling Technology Schematic\"></p><p>Traditional cooling solutions are approaching their limits under the background of continuously increasing chip power consumption. Silicon Core Technology\'s new technology achieves efficient heat conduction and dissipation through the synergistic effect of multi-layer graphene thermal conductive films and microchannel liquid cooling.</p><p>Test data shows that under the same power consumption, chips using the new cooling technology can maintain higher operating frequencies with significant performance improvement. Meanwhile, chip reliability and lifespan are also greatly enhanced.</p><p>This technology has applied for multiple patents and is expected to be first applied in next-generation high-performance computing chips. Silicon Core Technology is cooperating with heat dissipation module suppliers to promote the industrialization process of this technology.</p>', 1, 49, 1, 1756137348, 1756137348, 0, 'Silicon Core Tech Materials Lab develops new chip cooling tech using graphene composites and microfluidic cooling', '', 'Cooling Technology,Graphene,Chip Performance,Thermal Management', '', 'Silicon Core Tech develops new chip cooling technology, 20°C temperature reduction, 30% performance improvement, breaking through heat dissipation bottleneck.', 0, '', '', 'Materials Laboratory', 'Technology R&D Trends', 1, 30, '', '', '', '', '', NULL, NULL, 246, '0', '', '');
INSERT INTO `ry_en_article` VALUES (161, 20, 'Silicon Core Technology to Participate in 2024 Global Semiconductor Exhibition', '/uploads/images/news/news8.jpg', '', '<p>Silicon Core Technology confirms participation in the 2024 Global Semiconductor Technology Exhibition, which will be held next month at the Shanghai International Convention and Exhibition Center. Silicon Core Technology will showcase the latest chip products and solutions at the exhibition, including 7nm AI chips, IoT chips, and automotive electronic chips.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news25.jpg\" alt=\"Exhibition Preview\"></p><p>During the exhibition, Silicon Core Technology will set up a 500-square-meter special booth, divided into product display area, technical exchange area, and business negotiation area. Visitors can personally experience various application solutions based on Silicon Core chips, including smart home, industrial automation, autonomous driving, and other scenarios.</p><p>Company CTO Li Qiang will deliver a keynote speech titled \"AI Chip Technology Development Trends and Innovation Paths\" at the main forum, sharing Silicon Core Technology\'s technical insights and R&D achievements in the AI chip field.</p><p>Additionally, Silicon Core Technology will host multiple technical seminars and partner exchange meetings during the exhibition, deeply discussing chip technology development and application innovation with industry experts, customers, and partners.</p>', 1, 50, 1, 1756050948, 1756050948, 0, 'Silicon Core Tech confirms participation in 2024 Global Semiconductor Exhibition, will showcase latest chip products and solutions', '', 'Semiconductor Exhibition,Product Showcase,Industry Exchange', '', 'Silicon Core Tech to participate in 2024 Global Semiconductor Exhibition, showcasing latest chip products and solutions, CTO to deliver keynote speech.', 0, '', '', 'Exhibition Organizing Committee', 'Event Preview', 1, 30, '', '', '', '', '', NULL, NULL, 281, '0', '', '');
INSERT INTO `ry_en_article` VALUES (162, 20, 'Silicon Core Technology 2024 Campus Recruitment Officially Launched', '/uploads/images/news/news9.jpg', '', '<p>Silicon Core Technology\'s 2024 campus recruitment activity is officially launched. This recruitment targets outstanding graduates from key universities nationwide, providing over a hundred positions including chip design, software development, algorithm research, etc. The company will provide new employees with comprehensive training systems and career development channels.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news28.jpg\" alt=\"Recruitment Promotion Image\"></p><p>Recruitment positions cover multiple directions including digital chip design, analog chip design, FPGA development, embedded software, AI algorithms, testing engineering, etc. Silicon Core Technology particularly values the cultivation of R&D talent. Newly hired R&D engineers will participate in actual projects and quickly grow under the guidance of senior engineers.</p><p>The company\'s HR Director stated: \"We are looking for young people passionate about technology with an innovative spirit. Silicon Core Technology provides competitive compensation benefits and broad development platforms to help outstanding talent achieve career dreams.\"</p><p>Campus recruitment will cover key universities in Beijing, Shanghai, Nanjing, Wuhan, Chengdu, etc., including Tsinghua University, Peking University, Shanghai Jiao Tong University, Zhejiang University, etc. Applicants can submit resumes through the company\'s official website or recruitment platforms.</p>', 1, 49, 1, 1755964548, 1755964548, 0, 'Silicon Core Tech 2024 campus recruitment officially launched, providing chip design, software development positions nationwide', '', 'Campus Recruitment,Talent Acquisition,Career Development', '', 'Silicon Core Tech launches 2024 campus recruitment, providing over 100 positions in chip design, software development, covering key universities nationwide.', 0, '', '', 'Human Resources Department', 'Recruitment Information', 1, 30, '', '', '', '', '', NULL, NULL, 153, '0', '', '');
INSERT INTO `ry_en_article` VALUES (181, 15, 'Cloud AI Training Platform Solution', '/uploads/images/news/news10.jpg', '', '<p>Silicon Core Technology launches a complete cloud AI training platform solution based on self-developed AI training chips and optimized software stack, providing efficient AI model training services for enterprises and research institutions. This solution supports large-scale distributed training, significantly shortening model training time.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news32.jpg\" alt=\"AI Training Platform Architecture\"/></p><p>The solution core includes XK-AI200 training chip clusters, distributed training framework, model management system, and monitoring platform. Single cabinet can provide over 10 PetaFLOPS computing power, supporting thousand-card level cluster expansion.</p><p>At software level, the solution provides optimization technologies like automatic mixed precision training, gradient compression, model parallelism, etc., improving training efficiency by over 3 times. Simultaneously supports mainstream deep learning frameworks like TensorFlow, PyTorch, etc., users can obtain performance improvement without modifying code.</p><p>This solution has been successfully applied to multiple industry leading customers, performing excellently in scenarios like natural language processing, computer vision, recommendation systems, etc. Customer feedback shows training costs reduced by 40%, model iteration speed improved 2 times.</p>', 1, 50, 1, 1755878148, 1762229343, 0, 'Silicon Core Tech launches complete cloud AI training platform solution', '', 'AI Training,Cloud Computing,Distributed Training,Deep Learning', '', 'Silicon Core Tech cloud AI training platform solution provides efficient AI model training services, training efficiency improved over 3 times.', 0, '', '', 'Solution Team', 'Technical Solutions', 0, 30, '', '', '', '', '', '', NULL, 167, '0', '', 'Artificial Intelligence,Cybersecurity,Frontend Development,Backend Development,Database');
INSERT INTO `ry_en_article` VALUES (182, 15, 'Edge AI Inference Solution', '/uploads/images/news/news11.jpg', '', '<p>Targeting edge computing scenario AI inference demands, Silicon Core Technology launches complete edge AI inference solution. This solution is based on low-power AI inference chip XK-AI100, combined with lightweight inference framework, achieving efficient AI inference on terminal devices.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news35.jpg\" alt=\"Edge AI Application Scenarios\"/></p><p>The solution supports multiple edge device forms, including embedded modules, edge servers, and smart gateways. Under power-constrained conditions, still can provide excellent AI inference performance, meeting high real-time requirement application scenarios.</p><p>Key technical characteristics include model quantization compression, operator fusion optimization, dynamic power management, etc. Supports ONNX standard model format, provides model conversion tools, facilitating users to deploy trained models to edge devices.</p><p>This solution has been widely applied in intelligent security, industrial quality inspection, autonomous driving, etc. In a smart manufacturing project, achieved production line product defect detection accuracy 99.5%, detection speed reaching millisecond level.</p>', 1, 49, 1, 1755705600, 1762229387, 0, 'Silicon Core Tech launches complete edge AI inference solution for edge computing scenarios', '', 'Edge Computing,AI Inference,Edge Intelligence,Real-time Processing', '', 'Silicon Core Tech edge AI inference solution, based on low-power AI chips, achieves efficient AI inference on terminal devices, meeting real-time application requirements.', 0, '', '', 'Solution Team', 'Technical Solutions', 0, 30, '', '', '', '', '', '', NULL, 195, '0', '', 'Cybersecurity,Frontend Development,Big Data,Database,5G Technology,DevOps');
INSERT INTO `ry_en_article` VALUES (254, 100, 'Artificial Intelligence', '', '', NULL, 1, 50, 1, 1761793322, 1761793322, 0, 'Providing high-performance computing chip support for machine learning and deep learning', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-robot', '');
INSERT INTO `ry_en_article` VALUES (255, 100, 'Internet of Things', '', '', NULL, 1, 49, 1, 1761793322, 1761793322, 0, 'Low-power connectivity chips supporting multiple wireless communication protocol standards', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-wifi', '');
INSERT INTO `ry_en_article` VALUES (256, 100, 'Automotive Electronics', '', '', NULL, 1, 48, 1, 1761793322, 1761793322, 0, 'Automotive-grade safety chips supporting autonomous driving system safety and reliability', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-car', '');
INSERT INTO `ry_en_article` VALUES (257, 100, 'Consumer Electronics', '', '', NULL, 1, 47, 1, 1761793322, 1761793322, 0, 'High-performance low-power chips enhancing smart terminal user experience', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-mobile-alt', '');
INSERT INTO `ry_en_article` VALUES (258, 100, 'Industrial Control', '', '', NULL, 1, 46, 1, 1761793322, 1761793322, 0, 'High-reliability industrial chips suitable for harsh working environments', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-industry', '');
INSERT INTO `ry_en_article` VALUES (259, 100, '5G Communication', '', '', NULL, 1, 45, 1, 1761793322, 1761793322, 0, 'High-speed data transmission chips supporting millimeter wave communication technology', '', '', '', '', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-satellite', '');
INSERT INTO `ry_en_article` VALUES (260, 2, 'Company Introduction', '/uploads/images/about.jpg', '', '<h3>High-tech Enterprise Focused on Chip Design and Manufacturing</h3><p>Silicon Core Technology was founded in 2010, focusing on high-end chip design and manufacturing as a high-tech enterprise. We possess a complete chip R&D industry chain, from chip design, tape-out manufacturing to packaging and testing, providing customers with one-stop solutions.</p><p>Company headquarters is located in Beijing Zhongguancun Science Park, with R&D centers in Shanghai, Shenzhen, Chengdu, and overseas R&D institutions in Silicon Valley, USA and Munich, Germany. Our products are widely used in artificial intelligence, Internet of Things, automotive electronics, consumer electronics, industrial control, and 5G communication fields.</p><p>Silicon Core Technology always adheres to the business philosophy of \"Technological Innovation, Quality First, Customer Supreme\", committed to providing global customers with innovative technology products and services. Our vision is to become a world-leading chip design enterprise, promoting technological progress and creating an intelligent future.</p><p><br/></p>', 1, 50, 1, 1761793573, 1762248515, 0, 'Silicon Core Tech is a high-tech enterprise focused on high-end chip design and manufacturing', '', '', '', 'Silicon Core Technology is a high-tech enterprise focused on chip design and manufacturing, founded in 2010, with complete chip R&D industry chain and global business layout.', 0, '', '', '', '', 0, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (261, 3, 'Company Establishment', '', '', '', 1, 50, 1, 1761794586, 1762244686, 0, 'Silicon Core Tech officially established in Beijing Zhongguancun, focusing on chip design R&D', '', '', '2010', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (262, 3, 'First Chip Release', '', '', '', 1, 49, 1, 1761794586, 1762244678, 0, 'Successfully developed and released first IoT communication chip, gaining market recognition', '', '', '2013', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (263, 3, 'Production Line Establishment', '', '', '', 1, 48, 1, 1761794586, 1762244669, 0, 'Established own production line, achieving design-manufacturing integration, enhancing product competitiveness', '', '', '2015', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (264, 3, 'National Certification Obtained', '', '', '', 1, 47, 1, 1761794586, 1762244660, 0, 'Obtained National High-tech Enterprise certification, technical strength recognized by national level', '', '', '2018', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (265, 3, 'Globalization Layout', '', '', '', 1, 46, 1, 1761794586, 1762244651, 0, 'Products sold to over 50 countries and regions worldwide, established overseas R&D centers', '', '', '2020', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 8, '0', '', '');
INSERT INTO `ry_en_article` VALUES (266, 3, 'AI Chip Breakthrough', '', '', '', 1, 45, 1, 1761794586, 1762244643, 0, 'Released new generation AI chip, 300% performance improvement, leading industry technology development', '', '', '2023', '', 0, '', '', '', '', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (267, 7, 'AI Inference Chip XK-AI100 Series', '/uploads/images/product/product10.jpg', '', '<p>Silicon Core Technology today officially released the new generation AI inference chip XK-AI100. This chip adopts advanced 7nm process technology, with performance improved by 300% compared to previous generation products, energy efficiency ratio increased by 50%. XK-AI100 is specifically designed for edge computing and cloud AI inference scenarios, supporting various neural network models including CNN, RNN, Transformer, etc.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product10.jpg\"/></p><p>The chip integrates dedicated Tensor Processing Units (TPU), supporting multiple precision calculations such as INT8, INT16, FP16, significantly improving computational efficiency while maintaining high accuracy. XK-AI100 is also equipped with advanced cooling systems and power management modules, ensuring stable operation even under high load.</p><p>Zhang Ming, CEO of Silicon Core Technology, stated: \"The release of XK-AI100 marks a new level of our technical strength in the AI chip field. This chip will provide powerful computing support for smart manufacturing, autonomous driving, intelligent security, and other fields.\"</p><p>Currently, XK-AI100 has begun mass production and reached cooperation intentions with several industry leading enterprises. The first batch of products is expected to be delivered to customers next quarter.</p>', 1, 50, 1, 1761795665, 1761812851, 0, 'High-performance chip designed for AI inference scenarios, supporting multiple neural network models, suitable for cloud and edge computing applications', '', '', '2999', 'AI inference chip XK-AI100 designed for AI inference scenarios, supporting multiple neural network models, suitable for cloud and edge computing applications.', 1, '', '', '', '', 0, 30, '/uploads/images/goods/20251030/ebd5fb74f36aa4a00f208c01622ccf16.jpg,/uploads/images/goods/20251030/2428d6aad4647f13bcf3937da0de28fe.jpg,/uploads/images/goods/20251030/925e589213dbccac1745b3e408388611.jpg,/uploads/images/goods/20251030/aef4838999cc571f2a33d19e0e9f1fe4.jpg,/uploads/images/goods/20251030/4ad666061360efcf5095a71f77ac5ea8.jpg,/uploads/images/goods/20251030/79fc54d3496a76de6a91ad8494a75d6b.jpg,/uploads/images/goods/20251030/806b452fd788a5bc8420e64d36705c46.jpg', '', '', '', '', '<p><strong>Beyond Computing Power: XK-AI100 Inference Chip Core Performance Features Analysis</strong><br/><br/>In the critical period when artificial intelligence moves from training to large-scale applications, inference performance has become the core bottleneck determining the breadth and depth of AI implementation. The XK-AI100 inference chip launched by Silicon Core Technology is not simple computing power stacking but precise architectural revolution targeting real-world scenarios. Its performance characteristics can be summarized as: excellent energy efficiency, ultra-low latency, universal compatibility and rock-solid reliability.<br/><br/><strong>1. Breakthrough \"Sparse Tensor\" Computing Engine and Excellent Energy Efficiency Ratio</strong><br/><br/>Traditional chips perform full calculations on neural network models, while XK-AI100 has built-in sixth-generation sparse tensor computing engine. It intelligently identifies invalid calculations with weights and activation values of \"0\" or close to zero in neural networks and dynamically skips them, up to 95% of invalid operations.<br/><br/>Specific Performance: When processing large natural language models like BERT-Large, the chip\'s effective computing utilization rate increases to over 92%, achieving up to 11x energy efficiency improvement compared to traditional dense computing architectures.<br/><br/>Practical Significance: This means under the same power consumption, XK-AI100 can complete several times more inference tasks. For edge devices, battery life is greatly enhanced; for data centers, power costs and cooling requirements are significantly reduced.</p>', '<p>Need to select appropriate computing resource configuration according to specific application scenarios.</p>', 507, '30', '', '');
INSERT INTO `ry_en_article` VALUES (268, 7, 'AI Training Chip XK-AI200 Model', '/uploads/images/product/product1.jpg', '', '<p>Silicon Core Technology today officially released the new generation AI training chip XK-AI200, adopting advanced 5nm process technology, specifically designed for large-scale deep learning model training. XK-AI200 integrates dedicated matrix computing units, supporting FP16, BF16, FP32 and other precision calculations, significantly improving training efficiency while maintaining high accuracy.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product15.jpg\" alt=\"AI Training Chip Architecture\"></p><p><strong>Core Technology Innovation</strong>: XK-AI200 adopts innovative sparse computing architecture, intelligently identifying and skipping invalid calculations, improving training efficiency by over 3 times. The chip supports cluster expansion at thousand-card level, single cabinet providing over 50 PetaFLOPS computing power.</p><p>At software level, XK-AI200 provides complete development toolchain, supporting mainstream deep learning frameworks like TensorFlow and PyTorch. Optimization technologies like automatic mixed precision training, gradient compression, etc., reduce model training time by 60%, helping research institutions and enterprises quickly iterate AI models.</p><p>This chip has been applied in multiple supercomputing centers, performing particularly well in natural language processing, computer vision and other fields, providing powerful computing support for large model training.</p>', 1, 50, 1, 1761796233, 1761796233, 0, 'High-performance chip designed for large-scale deep learning training, adopting advanced process technology, supporting multiple precision calculations and distributed training', '', 'AI Training Chip,Deep Learning,5nm Process', '3599', 'New generation AI training chip XK-AI200 released, using 5nm process, training efficiency improved 3 times, supporting thousand-card cluster expansion.', 1, '', '', 'Technology R&D Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product1.jpg,/uploads/images/product/product15.jpg,/uploads/images/product/product18.jpg,/uploads/images/product/product22.jpg,/uploads/images/product/product25.jpg,/uploads/images/product/product28.jpg,/uploads/images/product/product31.jpg,/uploads/images/product/product35.jpg', '', '', '', '', '<p>High-performance AI computing architecture, supporting multiple neural network models, providing complete solutions from training to inference.</p>', '<p>Need to select appropriate computing resource configuration according to specific application scenarios.</p>', 196, '30', '', '');
INSERT INTO `ry_en_article` VALUES (269, 7, 'Edge AI Inference Chip XK-AI150', '/uploads/images/product/product2.jpg', '', '<p>Silicon Core Technology launches edge AI inference chip XK-AI150 designed for edge computing scenarios, adopting low-power architecture, ensuring high performance while controlling power consumption within 5W. XK-AI150 supports multiple neural network models including CNN, RNN, Transformer, etc., providing powerful AI inference capabilities for terminal devices like smart cameras, drones, etc.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product19.jpg\" alt=\"Edge AI Application Scenarios\"></p><p><strong>Key Technology Breakthrough</strong>: XK-AI150 adopts dynamic voltage frequency scaling technology, intelligently adjusting power consumption according to workload. The chip integrates dedicated neural network accelerators, inference speed improved 5 times compared to traditional solutions, latency reduced to millisecond level.</p><p>At application level, XK-AI150 has been widely used in intelligent security, industrial quality inspection, autonomous driving, etc. After adopting this chip, a smart manufacturing enterprise achieved 99.8% product defect detection accuracy, detection speed improved 3 times, significantly enhancing production efficiency.</p><p>The chip also supports ONNX standard model format, providing complete model conversion tools, facilitating developers to quickly deploy trained models to edge devices.</p>', 1, 49, 1, 1761796233, 1761796233, 0, 'Low-power edge AI inference solution chip, suitable for AI inference scenarios in terminal devices like smart cameras, drones', '', 'Edge Computing,AI Inference,Low-power Chip', '2199', 'Edge AI inference chip XK-AI150, power consumption below 5W, inference speed improved 5 times, providing intelligent capabilities for terminal devices.', 2, '', '', 'Product R&D Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product2.jpg,/uploads/images/product/product19.jpg,/uploads/images/product/product23.jpg,/uploads/images/product/product26.jpg,/uploads/images/product/product29.jpg,/uploads/images/product/product32.jpg,/uploads/images/product/product36.jpg,/uploads/images/product/product38.jpg', '', '', '', '', '<p>Ultra-low power design, multi-protocol compatibility, supporting large-scale device connections.</p>', '<p>Need to select appropriate communication protocols according to specific application scenarios.</p>', 142, '30', '', '');
INSERT INTO `ry_en_article` VALUES (270, 7, 'Computing-in-Memory AI Chip XK-AI180', '/uploads/images/product/product3.jpg', '', '<p>Silicon Core Technology achieves major breakthrough in computing-in-memory technology field, successfully developing AI chip XK-AI180 based on new memristors. This chip performs calculations directly in memory, completely eliminating data movement overhead in traditional architectures, improving energy efficiency ratio by over 10 times.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product21.jpg\" alt=\"Computing-in-Memory Chip Structure\"></p><p><strong>Architecture Revolution</strong>: XK-AI180 adopts innovative crossbar array structure, integrating storage and computing functions in the same physical unit. This design eliminates frequent data transmission between memory and processors, greatly reducing power consumption and latency.</p><p>Test data shows that in image recognition tasks, XK-AI180 energy efficiency ratio reaches 12 times that of traditional architectures, particularly suitable for power-sensitive application scenarios like IoT and wearable devices. The chip uses 28nm process manufacturing, possessing excellent cost advantages while maintaining high performance.</p><p>This technological breakthrough provides new possibilities for large-scale AI deployment on terminal devices, enabling complex AI algorithms to run stably long-term on battery-powered devices.</p>', 1, 48, 1, 1761796233, 1761796233, 0, 'Computing-in-memory AI chip breaking traditional architecture, performing calculations directly in memory, greatly improving energy efficiency ratio and computing efficiency', '', 'Computing-in-Memory,Memristor,Energy Efficiency Improvement', '2799', 'Computing-in-memory AI chip XK-AI180, energy efficiency ratio improved 10 times, breaking von Neumann architecture bottleneck.', 1, '', '', 'Frontier Technology Research Institute', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product3.jpg,/uploads/images/product/product21.jpg,/uploads/images/product/product24.jpg,/uploads/images/product/product27.jpg,/uploads/images/product/product30.jpg,/uploads/images/product/product33.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product39.jpg', '', '', '', '', '<p>Hardware-level encryption, supporting national cryptographic algorithms, providing comprehensive security protection.</p>', '<p>Need strict management of keys and certificates to ensure system security.</p>', 185, '30', '', '');
INSERT INTO `ry_en_article` VALUES (271, 7, 'Multimodal AI Chip XK-AI250 Type', '/uploads/images/product/product4.jpg', '', '<p>Silicon Core Technology releases multimodal AI chip XK-AI250, specifically designed for AI tasks integrating vision and language. XK-AI250 adopts heterogeneous computing architecture, integrating visual processing units and language processing units, capable of simultaneously processing multimodal data including images, text, speech, etc.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product16.jpg\" alt=\"Multimodal AI Application\"></p><p><strong>Fusion Computing Advantage</strong>: The chip supports cross-modal attention mechanisms, capable of understanding correlations between different modal data. In tasks like image-text generation, video description, etc., XK-AI250 performance surpasses single-modal chips by over 30%.</p><p>XK-AI250 uses 7nm process manufacturing, integrating 12 billion transistors. The chip supports dynamic task scheduling, intelligently allocating computing resources according to workload, maximizing computing capability utilization. Supported by multimodal pre-training large models, this chip provides powerful hardware foundation for next-generation multimodal AI applications.</p><p>This chip has cooperated with multiple AI companies, applied in intelligent customer service, content generation, virtual assistants, etc., promoting commercialization of multimodal AI technology.</p>', 1, 47, 1, 1761796233, 1761796233, 0, 'Multimodal AI computing chip integrating vision and language, supporting multiple modal data processing, suitable for complex tasks like image-text generation', '', 'Multimodal AI,Heterogeneous Computing,7nm Process', '3899', 'Multimodal AI chip XK-AI250, supporting vision and language fusion computing, promoting multimodal AI application development.', 1, '', '', 'AI Chip Business Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product4.jpg,/uploads/images/product/product16.jpg,/uploads/images/product/product20.jpg,/uploads/images/product/product24.jpg,/uploads/images/product/product28.jpg,/uploads/images/product/product32.jpg,/uploads/images/product/product36.jpg,/uploads/images/product/product40.jpg', '', '', '', '', '<p>Multi-protocol compatibility, integrated hardware-software design, simplifying system integration.</p>', '<p>Need to provide complete solutions, reducing customer integration workload.</p>', 135, '30', '', '');
INSERT INTO `ry_en_article` VALUES (272, 7, 'Autonomous Driving AI Chip XK-AI500', '/uploads/images/product/product5.jpg', '', '<p>Silicon Core Technology launches autonomous driving AI chip XK-AI500 specifically designed for autonomous driving, meeting ASIL-D functional safety level requirements, providing reliable computing power support for L4 autonomous driving. XK-AI500 adopts multi-core redundant architecture, ensuring system reliability under extreme conditions.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product17.jpg\" alt=\"Autonomous Driving Chip Application\"></p><p><strong>Safety Features</strong>: The chip has built-in hardware security modules, supporting real-time fault detection and isolation. Dual-core lockstep design ensures correctness of critical computing tasks, complying with automotive electronics highest safety standards.</p><p>XK-AI500 integrates high-performance visual processing units and lidar processing units, capable of simultaneously processing multiple sensor data. The chip supports multi-task parallel processing, perception, prediction, planning and other algorithms can run simultaneously, ensuring real-time response of autonomous driving systems.</p><p>This chip has been deployed in test vehicles of multiple vehicle manufacturers, performing excellently in complex urban road scenarios, providing key hardware support for mass-produced autonomous vehicles.</p>', 1, 46, 1, 1761796233, 1761796233, 0, 'Automotive-grade autonomous driving AI computing platform chip, meeting high safety level requirements, providing reliable computing power support guarantee for L4 autonomous driving', '', 'Autonomous Driving,Automotive-grade Chip,Functional Safety', '4599', 'Autonomous driving AI chip XK-AI500, meeting ASIL-D safety level, providing computing power support for L4 autonomous driving.', 2, '', '', 'Automotive Electronics Business Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product5.jpg,/uploads/images/product/product17.jpg,/uploads/images/product/product21.jpg,/uploads/images/product/product25.jpg,/uploads/images/product/product29.jpg,/uploads/images/product/product33.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product41.jpg', '', '', '', '', '<p>Automotive-grade certification, high reliability design, meeting stringent automotive electronics requirements.</p>', '<p>Need to comply with automotive industry related standards and certification requirements.</p>', 118, '30', '', '');
INSERT INTO `ry_en_article` VALUES (273, 7, 'Cloud AI Inference Chip XK-AI350', '/uploads/images/product/product6.jpg', '', '<p>Targeting cloud AI inference scenarios, Silicon Core Technology launches high-performance inference chip XK-AI350. This chip is specifically optimized for large-scale AI model deployment, supporting real-time inference of hundred-billion parameter models. XK-AI350 adopts innovative memory hierarchy structure, significantly improving model loading and inference efficiency.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product22.jpg\" alt=\"Cloud Inference Architecture\"></p><p><strong>Performance Optimization</strong>: The chip integrates high-bandwidth memory, supporting in-place computation of model parameters, reducing data movement overhead. Dynamic batching technology intelligently adjusts batch size, maximizing throughput.</p><p>In natural language processing tasks, XK-AI350 can simultaneously process thousands of concurrent requests, response time maintained within 100 milliseconds. The chip supports model hot updates, dynamically updating model parameters without affecting services.</p><p>This chip has been deployed in multiple cloud service providers AI platforms, providing stable inference services for applications like search engines, recommendation systems, intelligent customer service, etc., processing over 1 billion inference requests daily.</p>', 1, 45, 1, 1761796233, 1761796233, 0, 'Cloud large-scale model inference optimized AI chip, specifically designed for hundred-billion parameter model deployment, supporting high-concurrency inference request processing scenarios', '', 'Cloud Inference,Large Model Deployment,High Concurrency', '3299', 'Cloud AI inference chip XK-AI350, optimized for hundred-billion parameter model deployment, supporting high-concurrency inference requests.', 1, '', '', 'Cloud Computing Business Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product6.jpg,/uploads/images/product/product22.jpg,/uploads/images/product/product26.jpg,/uploads/images/product/product30.jpg,/uploads/images/product/product34.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product44.jpg', '', '', '', '', '<p>Multi-core architecture, high parallel computing capability, supporting complex scientific computing.</p>', '<p>Need supporting efficient cooling and power supply systems.</p>', 168, '30', '', '');
INSERT INTO `ry_en_article` VALUES (274, 7, 'Lightweight AI Chip XK-AI80 Type', '/uploads/images/product/product7.jpg', '', '<p>Silicon Core Technology launches ultra-low power AI chip XK-AI80, specifically designed for IoT devices. This chip provides 1TOPS computing power under 1W power consumption, providing efficient AI inference capabilities for scenarios like smart home, wearable devices, etc. XK-AI80 adopts fully integrated design, significantly reducing system volume.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product23.jpg\" alt=\"IoT AI Application\"></p><p><strong>Energy Efficiency Breakthrough</strong>: The chip adopts advanced power management technology, supporting multiple low-power modes. In standby state power consumption below 100μW, battery-powered devices can work continuously for several years.</p><p>XK-AI80 supports common IoT AI applications, including voice wake-up, gesture recognition, anomaly detection, etc. The chip provides complete software development kit, developers can quickly integrate AI functions into IoT devices.</p><p>This chip has cooperated with multiple smart home manufacturers, applied in smart speakers, smart door locks, environmental monitoring, etc., promoting intelligent upgrade of IoT devices.</p>', 1, 44, 1, 1761796233, 1761796233, 0, 'Ultra-low power lightweight AI chip, specifically designed for IoT devices, providing efficient AI inference computing capability under limited power', '', 'IoT AI,Low Power,1TOPS Computing Power', '1599', 'Lightweight AI chip XK-AI80, 1W power consumption providing 1TOPS computing power, empowering IoT device intelligence.', 1, '', '', 'IoT Business Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product7.jpg,/uploads/images/product/product23.jpg,/uploads/images/product/product27.jpg,/uploads/images/product/product31.jpg,/uploads/images/product/product35.jpg,/uploads/images/product/product39.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product45.jpg', '', '', '', '', '<p>Industrial-grade reliability, excellent real-time performance, supporting complex control algorithms.</p>', '<p>Need to select appropriate protection levels according to specific industrial environments.</p>', 106, '30', '', '');
INSERT INTO `ry_en_article` VALUES (276, 7, 'Neuromorphic AI Chip XK-AI90', '/uploads/images/product/product9.jpg', '', '<p>Silicon Core Technology achieves important progress in neuromorphic computing field, launching brain-inspired computing chip XK-AI90. This chip simulates biological neuron spiking neural network (SNN) computing mechanisms, energy efficiency ratio improved over 100 times compared to traditional deep learning chips, particularly suitable for time series data processing and edge learning scenarios.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product25.jpg\" alt=\"Neuromorphic Chip\"></p><p><strong>Bionic Innovation</strong>: XK-AI90 adopts event-driven computing mode, triggering calculations only when needed, greatly reducing power consumption. The chip supports online learning, dynamically adjusting network parameters according to environmental changes.</p><p>In time series signal processing tasks like speech recognition, gesture recognition, etc., XK-AI90 demonstrates excellent energy efficiency ratio. The chip sparse event characteristics give it natural advantages when processing real-world sensor data.</p><p>This chip provides new technical paths for next-generation edge intelligent devices, enabling devices to achieve continuous learning and adaptive capabilities under extremely low power consumption, promoting AI technology development towards more biologically friendly directions.</p>', 1, 42, 1, 1761796233, 1761796233, 0, 'Neuromorphic AI chip simulating human brain computing mechanisms, adopting event-driven computing mode, achieving extremely low power consumption edge learning capability', '', 'Neuromorphic,SNN,Event-Driven', '2399', 'Neuromorphic AI chip XK-AI90, simulating human brain mechanisms, energy efficiency improved 100 times, supporting edge learning.', 3, '', '', 'Frontier Technology Laboratory', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product9.jpg,/uploads/images/product/product25.jpg,/uploads/images/product/product29.jpg,/uploads/images/product/product33.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product41.jpg,/uploads/images/product/product45.jpg,/uploads/images/product/product47.jpg', '', '', '', '', '<p>Event-driven computing, supporting edge learning and adaptive capabilities.</p>', '<p>Need to adapt to specific edge computing scenarios and requirements.</p>', 105, '30', '', '');
INSERT INTO `ry_en_article` VALUES (277, 7, 'AI Vision Processing Chip XK-AI120', '/uploads/images/product/product11.jpg', '', '<p>Silicon Core Technology launches AI vision processing chip XK-AI120 specifically optimized for computer vision tasks. This chip is deeply optimized for vision tasks like image recognition, object detection, semantic segmentation, etc. XK-AI120 integrates high-performance visual processing units, supporting 4K resolution real-time processing, providing powerful visual analysis capabilities for applications like security, medical imaging, etc.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product26.jpg\" alt=\"Vision Processing Application\"></p><p><strong>Vision Optimization</strong>: The chip has built-in dedicated Image Signal Processor (ISP), supporting multi-channel video stream parallel processing. Hardware-level object detection accelerator can complete multi-object recognition in complex scenes at millisecond level.</p><p>XK-AI120 supports mainstream visual neural network models, including YOLO, ResNet, UNet, etc. In smart city projects, this chip achieved real-time analysis of thousands of camera video streams, accuracy over 99%.</p><p>The chip also provides rich vision algorithm libraries, developers can quickly build various computer vision applications, significantly shortening product development cycles, promoting widespread application of visual AI technology.</p>', 1, 41, 1, 1761796233, 1761796233, 0, 'Computer vision dedicated AI processing chip, deeply optimized for vision tasks like image recognition, object detection, supporting HD real-time processing', '', 'Computer Vision,Object Detection,4K Processing', '2699', 'AI vision processing chip XK-AI120, specializing in computer vision applications, supporting 4K real-time processing.', 2, '', '', 'Vision Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product11.jpg,/uploads/images/product/product26.jpg,/uploads/images/product/product30.jpg,/uploads/images/product/product34.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product46.jpg,/uploads/images/product/product48.jpg', '', '', '', '', '<p>High-performance visual processing, supporting multiple vision models and real-time analysis.</p>', '<p>Need appropriate lighting conditions and image quality for optimal performance.</p>', 132, '30', '', '');
INSERT INTO `ry_en_article` VALUES (279, 7, 'Edge Training Chip XK-AI160 Type', '/uploads/images/product/product13.jpg', '', '<p>Silicon Core Technology releases edge training chip XK-AI160, achieving model training capability on terminal devices for the first time. XK-AI160 supports edge learning algorithms like federated learning, incremental learning, etc., enabling IoT devices to optimize local models while protecting user privacy.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product28.jpg\" alt=\"Edge Training Application\"></p><p><strong>Privacy Protection Innovation</strong>: The chip adopts homomorphic encryption technology, ensuring data security during training process. Distributed training architecture allows devices to complete model updates locally, uploading only model parameters rather than raw data.</p><p>XK-AI160 provides 2TOPS training computing power under 5W power consumption, supporting fine-tuning of common deep learning models. In smart camera applications, the chip can adaptively optimize detection algorithms according to usage environment, accuracy continuously improving over time.</p><p>This chip brings true intelligent evolution capability to edge computing scenarios, making terminal devices no longer just executors but possessing learning and adaptation capabilities, opening new era of edge intelligence.</p>', 1, 39, 1, 1761797157, 1761797157, 0, 'AI chip supporting local training on terminal devices, achieving edge learning capability, performing model optimization while protecting user privacy', '', 'Edge Training,Federated Learning,Privacy Protection', '2899', 'Edge training chip XK-AI160, achieving local learning on terminal devices, protecting user privacy data.', 2, '', '', 'Edge Computing Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product13.jpg,/uploads/images/product/product28.jpg,/uploads/images/product/product32.jpg,/uploads/images/product/product36.jpg,/uploads/images/product/product40.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product50.jpg', '', '', '', '', '<p>Supporting federated learning and incremental learning, enabling local model training.</p>', '<p>Need to ensure data privacy and security during training process.</p>', 114, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (280, 7, 'AI Computing Card XK-AI600 Series', '/uploads/images/product/product14.jpg', '', '<p>Silicon Core Technology launches high-performance AI computing card XK-AI600, specifically designed for supercomputing centers and research institutions. This computing card adopts advanced packaging technology, integrating multiple computing chiplets, single card providing 20 PetaFLOPS AI computing power, providing powerful computing support for scientific computing and engineering simulation.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product29.jpg\" alt=\"AI Computing Card\"></p><p><strong>Computing Power Breakthrough</strong>: XK-AI600 adopts chiplet architecture, integrating multiple computing units in same package through high-density interconnection technology. Supporting HBM3 memory, memory bandwidth reaches 3.2TB/s, meeting memory requirements of large-scale models.</p><p>In scientific computing fields like climate simulation, drug research, astrophysics, etc., XK-AI600 demonstrates excellent performance. After adopting this computing card, a national supercomputing center improved climate prediction model resolution from 50km to 10km, prediction accuracy significantly improved.</p><p>This computing card also supports liquid cooling systems, ensuring stable operation under high load. Compared to traditional GPU solutions, energy efficiency ratio improved over 2 times, providing new technical path for green computing.</p>', 1, 38, 1, 1761797157, 1761797157, 0, 'Supercomputing center dedicated high-performance AI computing card, integrating multiple computing chiplets, providing powerful computing power for scientific computing and engineering simulation', '', 'Supercomputing Center,Scientific Computing,HBM3 Memory', '8999', 'AI computing card XK-AI600, single card 20 PetaFLOPS computing power, providing powerful computing capability for supercomputing centers.', 1, '', '', 'High Performance Computing Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product14.jpg,/uploads/images/product/product29.jpg,/uploads/images/product/product33.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product41.jpg,/uploads/images/product/product45.jpg,/uploads/images/product/product49.jpg,/uploads/images/product/product51.jpg', '', '', '', '', '<p>High-performance computing architecture, supporting large-scale scientific computing and simulation.</p>', '<p>Requires professional cooling and power supply infrastructure.</p>', 95, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (283, 7, 'AI Security Chip XK-AI900 Model', '/uploads/images/product/product17.jpg', '', '<p>Silicon Core Technology launches AI security chip XK-AI900, focusing on AI system security protection. XK-AI900 integrates hardware-level security modules, supporting security functions like model encryption, inference process protection, adversarial attack defense, etc., providing comprehensive security support for critical AI applications.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product32.jpg\" alt=\"AI Security Architecture\"></p><p><strong>Security Technology Innovation</strong>: The chip adopts Physical Unclonable Function (PUF) technology, each chip having unique hardware fingerprint. Supporting Trusted Execution Environment, ensuring sensitive models and data processed in secure areas.</p><p>XK-AI900 has built-in adversarial sample detection engine, capable of real-time identifying and blocking attacks targeting AI models. In security-sensitive scenarios like financial risk control, identity authentication, etc., this chip effectively prevents model deception risks.</p><p>This chip has passed National Cryptography Administration certification, supporting national cryptographic algorithms. In AI systems in fields like smart cities, critical infrastructure, etc., XK-AI900 provides solid security foundation for reliable deployment of AI applications.</p>', 1, 35, 1, 1761797157, 1761797157, 0, 'AI system security protection dedicated chip, integrating hardware-level security modules, providing comprehensive security protection, preventing network attack threats', '', 'AI Security,Model Encryption,Adversarial Defense', '3299', 'AI security chip XK-AI900, integrating hardware security modules, supporting AI system security reliable operation.', 3, '', '', 'Security Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product17.jpg,/uploads/images/product/product32.jpg,/uploads/images/product/product36.jpg,/uploads/images/product/product40.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product54.jpg', '', '', '', '', '<p>Hardware-level security protection, supporting model encryption and secure inference.</p>', '<p>Requires proper key management and security protocols.</p>', 99, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (285, 7, 'AI Inference Cluster Chip XK-AI1000', '/uploads/images/product/product19.jpg', '', '<p>Silicon Core Technology launches AI inference cluster chip XK-AI1000, specifically designed for building large-scale AI inference systems. XK-AI1000 supports chip-level clustering technology, multiple chips can seamlessly combine into unified inference computing pool, providing elastic inference computing power for internet enterprises.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product34.jpg\" alt=\"Inference Cluster Architecture\"></p><p><strong>Cluster Technology Breakthrough</strong>: Through proprietary inter-chip interconnection technology, 256 XK-AI1000 chips can form unified inference cluster, sharing memory and computing resources. Supporting dynamic resource allocation, automatically adjusting computing scale according to business load.</p><p>In e-commerce recommendation systems, this inference cluster processes tens of billions of inference requests daily, response time maintained within 50 milliseconds. Chip hot-plug design enables cluster expansion and maintenance without service interruption.</p><p>The chip also supports multi-tenant isolation, ensuring computing tasks of different users do not interfere with each other. After adopting this solution, a large cloud service provider improved inference service resource utilization from 30% to 80%, significantly reducing operating costs.</p>', 1, 33, 1, 1761797157, 1761797157, 0, 'Large-scale AI inference cluster dedicated chip, supporting chip-level clustering technology, building elastic inference computing pool, optimizing resource utilization', '', 'Inference Cluster,Elastic Computing Power,Multi-tenant', '6799', 'AI inference cluster chip XK-AI1000, supporting chip-level clustering, building large-scale inference systems.', 1, '', '', 'Cloud Service Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product19.jpg,/uploads/images/product/product34.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product46.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product54.jpg,/uploads/images/product/product56.jpg', '', '', '', '', '<p>Supporting large-scale cluster deployment and elastic resource allocation.</p>', '<p>Requires proper cluster management and load balancing.</p>', 149, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (287, 7, 'AI Compiler Chip XK-AI1200', '/uploads/images/product/product21.jpg', '', '<p>Silicon Core Technology launches AI compiler chip XK-AI1200, integrating dedicated compilation optimization engines, automatically optimizing AI model execution efficiency on hardware. XK-AI1200 supports automatic conversion and optimization of models from mainstream deep learning frameworks, significantly reducing technical barriers for AI application deployment.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product36.jpg\" alt=\"Compiler Chip Function\"/></p><p><strong>Compilation Optimization Breakthrough</strong>: The chip has built-in graph optimization engine, automatically completing complex optimization tasks like operator fusion, memory optimization, pipeline scheduling, etc. Supporting dynamic compilation technology, real-time adjusting execution plans according to runtime conditions.</p><p>In practical applications, models optimized by XK-AI1200 achieve average inference speed improvement of 3 times, memory usage reduced by 50%. Chip automatic quantization function can convert FP32 models to INT8 models while ensuring model accuracy, further improving inference efficiency.</p><p>This chip enables AI developers to fully utilize hardware performance without deep understanding of hardware details, promoting widespread application of AI technology. After adopting this chip, an AI startup company shortened product launch time from 3 months to 2 weeks.</p>', 1, 31, 1, 1761797157, 1762230355, 0, 'AI model compilation optimization dedicated chip, integrating compilation optimization engine, automatically optimizing model deployment efficiency, reducing technical usage barriers', '', 'AI Compiler,Model Optimization,Automatic Quantization', '2499', 'AI compiler chip XK-AI1200, automatically optimizing model deployment, improving inference efficiency 3 times.', 2, '', '', 'Toolchain Development Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product21.jpg,/uploads/images/product/product36.jpg,/uploads/images/product/product40.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product58.jpg', '', '', '', '', '<p>Automatic model optimization and compilation, improving deployment efficiency.</p>', '<p>Requires compatible model formats and frameworks.</p>', 302, '98%', '', 'Hot Products,New Arrivals');
INSERT INTO `ry_en_article` VALUES (288, 7, 'AI Voice Processing Chip XK-AI130', '/uploads/images/product/product12.jpg', '', '<p>Silicon Core Technology launches voice processing chip XK-AI130 specifically designed for voice AI applications. This chip is deeply optimized for tasks like speech recognition, speech synthesis, voiceprint recognition, etc. XK-AI130 integrates high-performance digital signal processor, supporting multi-channel audio stream parallel processing, providing excellent voice interaction experience for devices like smart speakers, voice assistants, etc.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product27.jpg\" alt=\"Voice Processing Chip\"></p><p><strong>Voice Technology Breakthrough</strong>: The chip has built-in dedicated acoustic front-end processing modules, supporting advanced technologies like noise suppression, echo cancellation, beamforming, etc. Speech recognition accuracy in complex environments improved to 98.5%, far exceeding traditional solutions.</p><p>XK-AI130 supports speech recognition and synthesis in multiple languages, chip low-power design ensures standby power consumption below 2mA in always-on voice wake-up mode. This chip has cooperated with multiple smart home manufacturers, providing users with more natural, accurate voice interaction experience.</p><p>In speech synthesis aspect, the chip supports emotional speech generation, automatically adjusting tone and speed according to context, making synthesized speech more natural and smooth, promoting commercial application of voice AI technology.</p>', 1, 40, 1, 1761797165, 1761797165, 0, 'Voice AI dedicated intelligent processing chip, supporting speech recognition and synthesis, providing excellent voice interaction experience and natural conversation capability', '', 'Voice Technology,Smart Assistant,Audio Processing', '1899', 'AI voice processing chip XK-AI130, achieving accurate speech recognition and synthesis, improving voice interaction experience.', 1, '', '', 'Voice Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product12.jpg,/uploads/images/product/product27.jpg,/uploads/images/product/product31.jpg,/uploads/images/product/product35.jpg,/uploads/images/product/product39.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product49.jpg', '', '', '', '', '<p>High-quality voice processing, supporting multiple languages and acoustic enhancements.</p>', '<p>Requires appropriate acoustic environment for optimal performance.</p>', 121, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (291, 7, 'Medical AI Chip XK-AI700 Model', '/uploads/images/product/product15.jpg', '', '<p>Silicon Core Technology launches medical-grade AI chip XK-AI700, specifically optimized for medical AI applications like medical image analysis, pathological diagnosis, genomics, etc. XK-AI700 passes medical device certification, meeting strict reliability and accuracy requirements of medical industry.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product30.jpg\" alt=\"Medical AI Application\"></p><p><strong>Medical Application Optimization</strong>: The chip supports DICOM standard medical image processing, integrating dedicated medical image analysis engines. In lesion detection tasks of CT, MRI and other images, accuracy exceeds experienced radiologist level.</p><p>XK-AI700 adopts fault-tolerant design, critical computing units using triple redundant architecture, ensuring diagnostic result reliability. The chip supports real-time demanding surgical navigation applications, latency controlled at microsecond level.</p><p>This chip has cooperated with multiple medical equipment manufacturers, applied in intelligent image diagnosis systems, surgical robots, wearable medical devices, etc., providing key hardware foundation for smart healthcare construction.</p>', 1, 37, 1, 1761797165, 1761797165, 0, 'Medical-grade AI diagnosis dedicated processing chip, passing medical device certification, providing reliable computing support guarantee for intelligent medical applications', '', 'Medical Electronics,Diagnostic Imaging,Healthcare', '5499', 'Medical AI chip XK-AI700, passing medical certification, empowering intelligent medical diagnosis applications.', 2, '', '', 'Medical Business Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product15.jpg,/uploads/images/product/product30.jpg,/uploads/images/product/product34.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product46.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product52.jpg', '', '', '', '', '<p>Medical-grade reliability, supporting diagnostic applications and real-time processing.</p>', '<p>Requires compliance with medical regulations and quality standards.</p>', 102, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (292, 7, 'Robot AI Chip XK-AI800 Type', '/uploads/images/product/product16.jpg', '', '<p>Silicon Core Technology releases robot dedicated AI chip XK-AI800, integrating various robot core algorithms like visual processing, motion planning, force control perception, etc. XK-AI800 provides complete AI computing capability for industrial robots, service robots, promoting robot intelligent upgrade.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product31.jpg\" alt=\"Robot Application\"></p><p><strong>Robot Technology Integration</strong>: The chip supports real-time motion planning algorithms, capable of real-time adjusting robot trajectories in dynamic environments. Integrated force control perception units enable robots to achieve compliant operations, adapting to fine operation requirements.</p><p>In industrial manufacturing scenarios, XK-AI800 achieves vision-guided precise robot assembly, assembly accuracy reaching 0.1mm. Chip multi-sensor fusion capability enables robots to comprehensively perceive environment, make intelligent decisions.</p><p>The chip also supports robot learning function, capable of quickly mastering new operation skills through demonstration learning. After adopting this chip, an automobile manufacturing factory shortened robot production line product model switching time from several hours to minutes.</p>', 1, 36, 1, 1761797165, 1761797165, 0, 'Robot dedicated AI computing platform chip, integrating various algorithms like visual processing, motion planning, promoting intelligent robot technology development', '', 'Robotics,Motion Control,Automation', '4199', 'Robot AI chip XK-AI800, integrating various robot algorithms, promoting intelligent robot development.', 1, '', '', 'Robot Business Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product16.jpg,/uploads/images/product/product31.jpg,/uploads/images/product/product35.jpg,/uploads/images/product/product39.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product51.jpg,/uploads/images/product/product53.jpg', '', '', '', '', '<p>Integrated robot control algorithms, supporting motion planning and force control.</p>', '<p>Requires proper calibration and safety measures.</p>', 113, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (294, 7, 'Energy Efficiency Optimized AI Chip XK-AI95', '/uploads/images/product/product18.jpg', '', '<p>Silicon Core Technology releases ultra-low power AI chip XK-AI95, achieving major breakthrough in energy efficiency ratio. XK-AI95 adopts innovative near-threshold computing technology, stable operation under 0.5V ultra-low voltage, energy efficiency ratio reaching 20 times traditional AI chips, bringing revolutionary battery life improvement for battery-powered devices.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product33.jpg\" alt=\"Energy Efficiency Optimization Technology\"></p><p><strong>Energy Efficiency Breakthrough</strong>: The chip adopts asynchronous circuit design, eliminating clock tree power consumption overhead. Dynamic voltage frequency scaling technology precisely controls power consumption according to workload, power consumption can reduce to microwatt level under light load.</p><p>In smart watch applications, XK-AI95 enables continuous heart rate monitoring and motion recognition function all-day operation, battery life extended from 1 day to 1 week. The chip also supports energy harvesting technology, can obtain energy from weak energy sources like ambient light, body temperature, etc.</p><p>This technological breakthrough provides possibility for permanent battery life of IoT devices, promoting development of battery-free AI devices, opening new era of energy-autonomous intelligent terminals.</p>', 1, 34, 1, 1761797165, 1761797165, 0, 'Ultra-low power energy efficiency optimized AI chip, adopting innovative power management technology, achieving excellent energy efficiency ratio and power consumption control performance', '', 'Energy Efficiency,Low Power,Green Technology', '1399', 'Energy efficiency optimized AI chip XK-AI95, energy efficiency ratio improved 20 times, achieving excellent power consumption control.', 1, '', '', 'Low Power Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product18.jpg,/uploads/images/product/product33.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product41.jpg,/uploads/images/product/product45.jpg,/uploads/images/product/product49.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product55.jpg', '', '', '', '', '<p>Ultra-low power design, supporting energy harvesting and long battery life.</p>', '<p>Requires proper power management and energy optimization.</p>', 104, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (296, 7, 'AI Memory Chip XK-AI110 Model', '/uploads/images/product/product20.jpg', '', '<p>Silicon Core Technology achieves breakthrough in AI memory computing field, launching AI memory chip XK-AI110. This chip simulates biological brain long-term memory mechanisms, capable of persistent storage and fast retrieval of knowledge, providing continuous learning capability for AI systems. XK-AI110 adopts new phase-change memory, achieving deep integration of storage and computing.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product35.jpg\" alt=\"Memory Chip Structure\"></p><p><strong>Memory Computing Innovation</strong>: The chip supports associative memory function, capable of quickly retrieving complete knowledge based on partial information. Knowledge distillation technology enables chip to extract key information from large amounts of data, achieving efficient knowledge compression storage.</p><p>In personalized recommendation systems, XK-AI110 can long-term memorize user preferences, quickly restoring personalized service even after long inactive periods. Chip continuous learning capability enables AI systems to continuously evolve over time, adapting to changes in user needs.</p><p>This technology lays foundation for building AI assistants with long-term memory, enabling AI systems to establish lasting user relationships, providing more personalized and considerate service experience.</p>', 1, 32, 1, 1761797165, 1761797165, 0, 'AI chip simulating human brain long-term memory mechanisms, achieving knowledge persistent storage and fast retrieval, endowing systems with continuous learning capability', '', 'Memory Computing,Cognitive AI,Brain-inspired Computing', '2999', 'AI memory chip XK-AI110, achieving long-term knowledge storage, endowing AI systems with continuous learning capability.', 3, '', '', 'Cognitive Computing Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product20.jpg,/uploads/images/product/product35.jpg,/uploads/images/product/product39.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product51.jpg,/uploads/images/product/product55.jpg,/uploads/images/product/product57.jpg', '', '', '', '', '<p>Long-term knowledge storage and associative memory capabilities.</p>', '<p>Requires proper memory management and knowledge organization.</p>', 224, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (298, 8, 'Multi-mode Wireless Connectivity Chip XK-IoT100', '/uploads/images/product/product22.jpg', '', '<p>Silicon Core Technology launches multi-mode wireless connectivity chip XK-IoT100, integrating three mainstream wireless communication protocols: Wi-Fi, Bluetooth, and LoRa. XK-IoT100 adopts advanced RF architecture, supporting seamless protocol switching, providing stable and reliable connectivity capabilities for smart home devices.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product37.jpg\" alt=\"Multi-mode Connectivity Chip\"></p><p><strong>Connectivity Technology Breakthrough</strong>: The chip supports dynamic protocol selection, automatically choosing optimal connection method according to network environment. Integrated coexistence algorithms effectively avoid interference between different protocols, ensuring stability when multiple devices connect simultaneously.</p><p>In smart home scenarios, XK-IoT100 achieves over 99% device pairing success rate, connection latency below 100ms. Chip low-power design enables battery-powered devices to work continuously for over 3 years, providing technical support for large-scale deployment of IoT devices.</p><p>This chip has cooperated with multiple smart home manufacturers, applied in products like smart lights, smart door locks, environmental sensors, etc., promoting implementation of whole-house smart solutions.</p>', 1, 50, 1, 1761798801, 1761798801, 0, 'Multi-mode wireless connectivity IoT chip, integrating multiple communication protocols, supporting seamless switching, providing stable connectivity capability for smart home', '', 'Multi-mode Connectivity,Wi-Fi6,Bluetooth5.2', '899', 'Multi-mode wireless connectivity chip XK-IoT100, supporting three protocol seamless switching, improving connection stability.', 1, '', '', 'Wireless Connectivity Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product22.jpg,/uploads/images/product/product37.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product57.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg', '', '', '', '', '<p>Multi-protocol support, seamless connectivity switching.</p>', '<p>Requires proper network configuration and protocol selection.</p>', 134, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (299, 8, 'Low Power NB-IoT Chip XK-IoT200', '/uploads/images/product/product23.jpg', '', '<p>Silicon Core Technology releases ultra-low power Narrowband IoT chip XK-IoT200, deeply optimized for wide-area IoT applications. XK-IoT200 adopts innovative power management technology, power consumption below 1μA in PSM mode, achieving over 10 years service life with standard batteries.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product38.jpg\" alt=\"Narrowband IoT Application\"></p><p><strong>Power Consumption Breakthrough</strong>: The chip supports eDRX technology, extending device listening cycle to several hours. Smart wake-up mechanism ensures devices activate only when communication needed, significantly reducing average power consumption.</p><p>In utility applications like smart water meters, gas meters, etc., XK-IoT200 achieves extremely low power operation for monthly data reporting. Integrated security encryption module ensures data transmission security, complying with industry regulatory requirements.</p><p>This chip has passed operator certification, supporting global mainstream frequency bands. After adopting this chip, a smart city project achieved large-scale deployment of millions of smart meters, significantly improving utility management efficiency.</p>', 1, 49, 1, 1761798801, 1761798801, 0, 'Ultra-low power NB-IoT communication chip, adopting advanced power management technology, achieving battery life cycle over ten years', '', 'NB-IoT,Low Power,10 Year Life', '699', 'Low power NB-IoT chip XK-IoT200, PSM mode power consumption 1μA, achieving 10 year battery life.', 1, '', '', 'Low Power Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product23.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product58.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg', '', '', '', '', '<p>Ultra-low power design for long-term battery operation.</p>', '<p>Requires proper power management and network coverage.</p>', 121, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (300, 8, 'Automotive Grade IoT Chip XK-IoT300', '/uploads/images/product/product24.jpg', '', '<p>Silicon Core Technology launches automotive grade IoT chip XK-IoT300, meeting AEC-Q100 quality certification standards, specifically designed for intelligent connected vehicles. XK-IoT300 supports C-V2X communication technology, providing low-latency, high-reliability vehicle-to-everything coordination capability for autonomous driving.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product39.jpg\" alt=\"Vehicle Networking Application\"></p><p><strong>Automotive Technology Innovation</strong>: The chip integrates dedicated V2X communication modules, supporting PC5 interface direct connection communication. In high-speed mobile scenarios, communication reliability reaches 99.999%, meeting stringent communication quality requirements for autonomous driving.</p><p>XK-IoT300 supports wide temperature operating range from -40°C to +105°C, adapting to various harsh environments. Chip multiple redundant design ensures basic communication capability maintained even when partial functions fail.</p><p>This chip has cooperated with multiple vehicle manufacturers, applied in pre-installed intelligent connected systems. In smart highway demonstration projects, achieved real-time information exchange between vehicles and roadside equipment, improving road safety and traffic efficiency.</p>', 1, 48, 1, 1761798801, 1761798801, 0, 'Automotive grade V2X communication IoT chip, meeting automotive electronics quality certification, providing reliable communication capability for intelligent connected vehicles', '', 'Automotive Grade,C-V2X,Autonomous Driving', '1299', 'Automotive grade IoT chip XK-IoT300, supporting C-V2X communication, meeting autonomous driving requirements.', 2, '', '', 'Automotive Electronics Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product24.jpg,/uploads/images/product/product39.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product49.jpg,/uploads/images/product/product54.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg', '', '', '', '', '<p>Automotive-grade reliability, supporting V2X communication.</p>', '<p>Requires compliance with automotive standards and certifications.</p>', 98, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (301, 8, 'Industrial IoT Chip XK-IoT400 Type', '/uploads/images/product/product25.jpg', '', '<p>Silicon Core Technology releases industrial grade IoT chip XK-IoT400, integrating mainstream industrial Ethernet protocols like PROFINET, EtherCAT, etc. XK-IoT400 meets strict reliability and real-time requirements of industrial environments, providing powerful communication foundation for industrial automation.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product40.jpg\" alt=\"Industrial IoT\"></p><p><strong>Industrial Communication Optimization</strong>: The chip supports deterministic communication, jitter time below 1μs, meeting precision application requirements like motion control. Hardware-level time synchronization accuracy reaches nanosecond level, ensuring accuracy of multi-device collaborative work.</p><p>In smart manufacturing scenarios, XK-IoT400 achieves high-speed data acquisition and precise control of production line equipment. Chip strong anti-interference design enables stable operation in complex industrial electromagnetic environments.</p><p>This chip has been applied in multiple smart factory projects, achieving digitalization and intelligent upgrade of production equipment. After adopting this chip, an automotive parts manufacturer improved equipment data acquisition frequency from second level to millisecond level, significantly enhancing production process transparency.</p>', 1, 47, 1, 1761798801, 1761798801, 0, 'Industrial grade multi-protocol IoT chip, supporting mainstream industrial Ethernet protocols, meeting communication requirements in harsh industrial environments', 'Industrial Grade', 'Industrial IoT,PROFINET,EtherCAT', '1599', 'Industrial IoT chip XK-IoT400, supporting multiple industrial protocols, meeting harsh industrial environment requirements.', 1, '', '', 'Industrial Automation Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product25.jpg,/uploads/images/product/product40.jpg,/uploads/images/product/product45.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product55.jpg,/uploads/images/product/product60.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg', '', '', '', '', '<p>Industrial-grade reliability, supporting real-time communication protocols.</p>', '<p>Requires proper industrial network configuration.</p>', 112, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (302, 8, 'Smart Agriculture IoT Chip XK-IoT500', '/uploads/images/product/product26.jpg', '', '<p>Silicon Core Technology launches agriculture specific IoT chip XK-IoT500, optimized for agricultural environment monitoring and precision irrigation applications. XK-IoT500 integrates soil sensor interfaces and environmental monitoring units, providing complete sensing and control capabilities for smart agriculture.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product41.jpg\" alt=\"Smart Agriculture Application\"></p><p><strong>Agricultural Application Innovation</strong>: The chip supports multiple agricultural sensors, including soil moisture, pH, light intensity, etc. Intelligent algorithms automatically adjust irrigation strategies according to crop growth models, achieving precision management of water and fertilizer integration.</p><p>XK-IoT500 adopts anti-corrosion packaging, adapting to humid and chemical environments of farmland. Solar power design enables devices to work long-term in remote farmland without external power.</p><p>This chip has been deployed in multiple agricultural demonstration bases nationwide. After adopting this solution, a large farm achieved 30% water saving, 25% fertilizer utilization improvement, 15% crop yield increase.</p>', 1, 46, 1, 1761798801, 1761798801, 0, 'Agriculture specific environment monitoring IoT chip, integrating multiple sensor interfaces, providing complete data support for precision agriculture', '', 'Smart Agriculture,Precision Irrigation,Environmental Monitoring', '799', 'Smart agriculture IoT chip XK-IoT500, supporting multiple sensors, empowering precision agriculture development.', 1, '', '', 'Agricultural IoT Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product26.jpg,/uploads/images/product/product41.jpg,/uploads/images/product/product46.jpg,/uploads/images/product/product51.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product61.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg', '', '', '', '', '<p>Agricultural environment monitoring and precision control capabilities.</p>', '<p>Requires proper sensor calibration and maintenance.</p>', 87, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (303, 8, 'LPWAN Dual-mode Chip XK-IoT600', '/uploads/images/product/product27.jpg', '', '<p>Silicon Core Technology releases LPWAN dual-mode chip XK-IoT600, simultaneously supporting LoRa and Sigfox two low-power wide-area network technologies. XK-IoT600 adopts software-defined radio architecture, capable of supporting different regional communication standards through configuration.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product42.jpg\" alt=\"LPWAN Application\"></p><p><strong>Dual-mode Technology Advantage</strong>: The chip supports dynamic network selection, automatically switching optimal networks according to signal quality. In complex urban environments, communication success rate improved to 99.5%, effectively solving coverage blind spot problems of single-mode networks.</p><p>XK-IoT600 communication distance reaches 15km (suburban), strong penetration capability. In applications like smart parking, environmental monitoring, etc., single base station can cover thousands of terminal devices, significantly reducing network deployment costs.</p><p>This chip has been exported to over 30 countries and regions worldwide, adapting to different regional spectrum regulations. After adopting this chip, an international logistics company achieved unified global cargo tracking management, improving supply chain visibility.</p>', 1, 45, 1, 1761798801, 1761798801, 0, 'LPWAN dual-mode communication IoT chip, simultaneously supporting two low-power wide-area network technologies, improving network coverage reliability', '', 'LPWAN,LoRa,Sigfox', '1099', 'LPWAN dual-mode chip XK-IoT600, supporting LoRa and Sigfox, improving network coverage reliability.', 1, '', '', 'Wide Area IoT Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product27.jpg,/uploads/images/product/product42.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product57.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg', '', '', '', '', '<p>Dual-mode LPWAN support for flexible network connectivity.</p>', '<p>Requires proper network planning and coverage assessment.</p>', 105, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (304, 8, 'Smart Home Gateway Chip XK-IoT700', '/uploads/images/product/product28.jpg', '', '<p>Silicon Core Technology launches smart home gateway chip XK-IoT700, integrating multiple home network protocols and edge computing capabilities. XK-IoT700 supports IoT protocols like Zigbee, Z-Wave, Thread, etc., providing powerful central control capability for smart home.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product43.jpg\" alt=\"Smart Home Gateway\"></p><p><strong>Gateway Function Integration</strong>: The chip supports local scene linkage, maintaining basic smart functions even when internet interrupted. Edge AI computing capability enables applications like voice recognition, face recognition, etc., to complete locally, protecting user privacy.</p><p>XK-IoT700 supports 256 devices simultaneous connection, response latency below 50ms. Smart load balancing technology ensures smooth user experience when multiple devices operate simultaneously.</p><p>This chip has cooperated with multiple smart home platforms, achieving interoperability between different brand devices. After adopting this solution, a high-end residential project enabled residents to control whole-house smart devices through single App, improving living experience.</p>', 1, 44, 1, 1761798801, 1761798801, 0, 'Smart home multi-protocol gateway chip, supporting multiple IoT protocols, achieving unified management control of whole-house smart devices', '', 'Smart Gateway,Edge Computing,Multi-protocol', '1399', 'Smart home gateway chip XK-IoT700, supporting multi-protocol, achieving whole-house device unified management.', 2, '', '', 'Smart Home Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product28.jpg,/uploads/images/product/product43.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product58.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg', '', '', '', '', '<p>Multi-protocol gateway with edge computing capabilities.</p>', '<p>Requires proper network configuration and device compatibility.</p>', 123, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (305, 8, 'Wearable Device Chip XK-IoT800', '/uploads/images/product/product29.jpg', '', '<p>Silicon Core Technology releases wearable device specific chip XK-IoT800, adopting WLCSP wafer-level packaging, size only 3×3mm. XK-IoT800 integrates wearable device common functions like motion sensors, heart rate monitoring, etc., providing complete solutions for smart watches, health bracelets.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product44.jpg\" alt=\"Wearable Chip\"></p><p><strong>Miniaturization Innovation</strong>: The chip adopts 3D stacking technology, integrating multiple functional units in extremely small area. Advanced power management technology enables devices to work 7 days in continuous heart rate monitoring mode, 20 hours in exercise mode.</p><p>XK-IoT800 supports multiple biometric sensing, including blood oxygen saturation, skin electrical response, etc. Intelligent algorithms accurately identify exercise types and intensity, providing personalized health suggestions.</p><p>This chip has been applied in multiple popular smart watches, receiving good user feedback. After adopting this chip, a health technology company reduced product volume by 30%, battery life improved 50%, gaining high market recognition.</p>', 1, 43, 1, 1761798801, 1761798801, 0, 'Wearable device specific IoT chip, adopting miniaturized packaging design, integrating health monitoring functions, extending device battery life', '', 'Wearable,Health Monitoring,Miniaturization', '999', 'Wearable device chip XK-IoT800, 3×3mm extremely small size, supporting multiple health monitoring functions.', 1, '', '', 'Wearable Business Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product29.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product49.jpg,/uploads/images/product/product54.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg', '', '', '', '', '<p>Miniaturized design with comprehensive health monitoring.</p>', '<p>Requires proper wearing and usage for accurate monitoring.</p>', 126, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (306, 8, 'Smart Meter Chip XK-IoT900 Model', '/uploads/images/product/product30.jpg', '', '<p>Silicon Core Technology launches smart meter specific chip XK-IoT900, meeting AMI strict requirements. XK-IoT900 integrates high-precision metering units and secure communication modules, providing reliable data acquisition and transmission capabilities for smart grids.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product45.jpg\" alt=\"Smart Meter Application\"></p><p><strong>Metering Technology Breakthrough</strong>: The chip supports 0.5S level electricity metering accuracy, meeting utility company standard requirements. Anti-tampering function can detect abnormal electricity usage patterns, protecting utility company legitimate rights.</p><p>XK-IoT900 supports meter communication protocols like DLMS/COSEM, IEC, etc., facilitating integration with existing systems. Remote firmware upgrade function enables meter software continuous updates without hardware replacement.</p><p>This chip has been applied in multiple domestic smart grid projects. Actual operation data shows smart meter systems based on this chip improved meter reading accuracy to 99.8%, significantly reducing operating costs.</p>', 1, 42, 1, 1761798801, 1761798801, 0, 'Smart meter specific metering communication chip, meeting advanced metering infrastructure requirements, providing accurate electricity metering capability', '', 'Smart Meter,AMI,Accurate Metering', '1199', 'Smart meter chip XK-IoT900, meeting AMI metering requirements, accuracy reaching 0.5S level.', 1, '', '', 'Energy IoT Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product30.jpg,/uploads/images/product/product45.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product55.jpg,/uploads/images/product/product60.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg', '', '', '', '', '<p>High-precision metering with secure communication.</p>', '<p>Requires proper installation and calibration.</p>', 93, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (307, 8, 'Environmental Monitoring Chip XK-IoT1000 Type', '/uploads/images/product/product31.jpg', '', '<p>Silicon Core Technology releases environmental monitoring specific chip XK-IoT1000, integrating multiple gas sensors and particulate matter detection units. XK-IoT1000 supports monitoring key environmental parameters like PM2.5, PM10, CO2, formaldehyde, VOCs, etc., measurement accuracy reaching professional level standards. Adopting multi-sensor data fusion technology, improving monitoring data accuracy.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product46.jpg\" alt=\"Environmental Monitoring Application\"></p><p>Automatic calibration function ensures sensor long-term operation stability, reducing maintenance requirements. Intelligent warning algorithms can identify environmental pollution trends, timely issuing warning information. Data recording function supports historical data storage and trend analysis, providing scientific basis for environmental governance.</p><p>The chip supports indoor and outdoor multiple application scenarios, monitoring data can be uploaded to cloud platform in real-time through wireless networks. Low-power design suitable for long-term monitoring applications, battery-powered devices can work continuously for months. Dustproof and waterproof design adapts to various environmental conditions.</p>', 1, 41, 1, 1761798801, 1761798801, 0, 'Multi-parameter environmental quality monitoring chip, real-time monitoring air quality, providing data support for environmental management', '', 'Environmental Monitoring,Air Quality,Gas Sensing', '1499', 'Environmental quality monitoring chip XK-IoT1000, supporting multi-parameter environmental monitoring, measurement accuracy reaching professional level standards.', 2, '', '', 'Environmental IoT Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product31.jpg,/uploads/images/product/product46.jpg,/uploads/images/product/product51.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product61.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg', '', '', '', '', '<p>Multi-parameter environmental monitoring with data fusion.</p>', '<p>Requires proper sensor placement and maintenance.</p>', 109, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (308, 8, 'Asset Tracking Chip XK-IoT1100', '/uploads/images/product/product32.jpg', '', '<p>Silicon Core Technology launches asset tracking specific chip XK-IoT1100, supporting multi-mode positioning and multiple wireless communication technologies. XK-IoT1100 provides complete item tracking solutions for logistics, warehousing, asset management industries.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product47.jpg\" alt=\"Asset Tracking Application\"></p><p><strong>Positioning Technology Optimization</strong>: The chip adopts hybrid positioning algorithms, still capable of auxiliary positioning through Wi-Fi and BLE in indoor environments with weak GPS signals. Positioning accuracy reaches 3 meters (outdoor) and 10 meters (indoor).</p><p>XK-IoT1100 supports intelligent motion detection, automatically entering low-power mode when items stationary. Geo-fencing function can immediately alert when items leave designated areas, preventing asset loss.</p><p>This chip has been widely used in cold chain logistics, valuable goods transportation, etc. After adopting this chip, an international logistics company reduced cargo loss rate by 80%, customer satisfaction significantly improved.</p>', 1, 40, 1, 1761798801, 1761798801, 0, 'Asset tracking multi-mode positioning chip, supporting global satellite positioning systems, achieving precise item positioning and trajectory management', '', 'Asset Tracking,Multi-mode Positioning,Geo-fencing', '1699', 'Asset tracking chip XK-IoT1100, supporting multi-mode positioning, achieving global item precise positioning management.', 1, '', '', 'Logistics IoT Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product32.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product57.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg', '', '', '', '', '<p>Multi-mode positioning with asset tracking capabilities.</p>', '<p>Requires proper network coverage for accurate tracking.</p>', 114, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (309, 8, 'Smart Street Light Chip XK-IoT1200', '/uploads/images/product/product33.jpg', '', '<p>Silicon Core Technology releases smart street light specific chip XK-IoT1200, integrating lighting control and environmental sensing functions. XK-IoT1200 supports smart street light core functions like on-demand lighting, remote dimming, fault diagnosis, etc., providing infrastructure support for smart city construction.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product48.jpg\" alt=\"Smart Street Light Application\"></p><p><strong>Lighting Control Innovation</strong>: The chip supports 0-10V dimming and PWM dimming two methods, dimming accuracy reaching 1%. Human body sensing function can automatically adjust brightness when detecting pedestrians, achieving balance between energy saving and safety.</p><p>XK-IoT1200 integrates power line carrier communication, transmitting data using existing power lines, reducing deployment costs. Single light control capability enables management departments to accurately grasp each street light working status.</p><p>This chip has been applied in multiple domestic smart city projects, achieving intelligent management of street lights. After adopting this solution, a city reduced street light energy consumption by 40%, maintenance costs reduced 60%, improving urban lighting management level.</p>', 1, 39, 1, 1761798801, 1761798801, 0, 'Smart street light control management chip, supporting precise dimming and remote management, providing technical foundation for smart city lighting', '', 'Smart Street Light,Smart Lighting,Energy Saving Control', '1399', 'Smart street light chip XK-IoT1200, supporting precise dimming and remote management, achieving smart lighting.', 1, '', '', 'Smart City Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product33.jpg,/uploads/images/product/product48.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product58.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg', '', '', '', '', '<p>Smart lighting control with energy saving features.</p>', '<p>Requires proper lighting system integration.</p>', 97, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (310, 8, 'Smart Water Leak Detection Chip XK-IoT1300', '/uploads/images/product/product34.jpg', '', '<p>Silicon Core Technology launches water leak detection specific chip XK-IoT1300, adopting high-sensitivity electrode detection technology, capable of timely discovering water leakage situations. XK-IoT1300 provides reliable water hazard early warning protection for data centers, warehouses, residential, etc.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product49.jpg\" alt=\"Water Leak Detection Application\"/></p><p><strong>Detection Technology Innovation</strong>: The chip supports multi-probe detection, can simultaneously monitor multiple potential leakage points. Sensitivity adjustable, adapting to detection requirements in different environments, avoiding false alarms and missed detections.</p><p>XK-IoT1300 response time below 3 seconds, ensuring timely alarm when water leakage occurs. Battery-powered design enables devices installed anywhere,不受电源限制.</p><p>This chip has been widely used in financial, telecommunications, medical and other industry data centers. After adopting this solution, a bank data center successfully warned multiple air conditioning leakage incidents, avoiding millions equipment losses.</p>', 1, 38, 1, 1761798801, 1762186753, 0, 'Water leak detection warning specific chip, adopting high-sensitivity detection technology, quickly discovering water leakage situations, preventing accidents', '', 'Water Leak Detection,Leakage Warning,Security Monitoring', '899', 'Smart water leak detection chip XK-IoT1300, 3-second quick response, preventing water leakage accidents.', 2, '', '', 'Security IoT Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product34.jpg,/uploads/images/product/product49.jpg,/uploads/images/product/product54.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg', '', '', '', '', '<p>High-sensitivity water leak detection with quick response.</p>', '<p>Requires proper sensor placement and maintenance.</p>', 102, '98%', '', 'Machine Learning,Artificial Intelligence,Cloud Computing,IoT,5G Technology,DevOps,Database,Mobile Development');
INSERT INTO `ry_en_article` VALUES (311, 8, 'Smart Door Lock Chip XK-IoT1400', '/uploads/images/product/product35.jpg', '', '<p>Silicon Core Technology releases smart door lock specific chip XK-IoT1400, integrating multiple unlocking methods and security protection mechanisms. XK-IoT1400 supports multiple authentication methods like fingerprint recognition, password unlocking, card recognition, mobile Bluetooth, etc., providing convenient and secure door lock experience for users.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product50.jpg\" alt=\"Smart Door Lock Application\"></p><p><strong>Security Technology Enhancement</strong>: The chip adopts financial-grade security encryption, preventing password cracking or theft. Anti-tamper alarm function immediately sends alert information to user mobile when detecting abnormal prying.</p><p>XK-IoT1400 low-power design ensures over 1 year usage with 4 AA batteries. Virtual password function allows users to input任意digital before and after correct password, preventing password peeping.</p><p>This chip has cooperated with multiple smart door lock brands, products sold to global market. After adopting this door lock, a high-end apartment project improved resident satisfaction 35%, property management efficiency improved 50%.</p>', 1, 37, 1, 1761798801, 1761798801, 0, 'Smart door lock security control chip, supporting multiple unlocking methods, providing convenient and secure smart door lock usage experience', '', 'Smart Door Lock,Fingerprint Recognition,Security Encryption', '1599', 'Smart door lock chip XK-IoT1400, supporting multiple unlocking methods, improving home security level.', 1, '', '', 'Smart Security Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product35.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product55.jpg,/uploads/images/product/product60.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg', '', '', '', '', '<p>Multi-authentication methods with enhanced security.</p>', '<p>Requires proper installation and user management.</p>', 131, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (312, 8, 'Cold Chain Monitoring Chip XK-IoT1500', '/uploads/images/product/product36.jpg', '', '<p>Silicon Core Technology launches cold chain monitoring specific chip XK-IoT1500, integrating multiple sensors like temperature, humidity, vibration, etc. XK-IoT1500 provides全程温度监控和预警 for food, pharmaceutical cold chain transportation, ensuring product quality and safety.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product51.jpg\" alt=\"Cold Chain Monitoring Application\"></p><p><strong>Monitoring Technology Improvement</strong>: The chip supports wide temperature monitoring range from -40°C to +85°C, accuracy reaching ±0.5°C. Intelligent warning function immediately alerts when temperature exceeds set range, preventing goods deterioration.</p><p>XK-IoT1500 data recording capacity reaches 1 million records, supporting entire transportation cycle data storage. Anti-tamper design ensures monitoring data authenticity and reliability, meeting regulatory requirements.</p><p>This chip has been widely used in pharmaceutical, fresh food industries. After adopting this solution, a vaccine manufacturer improved temperature qualification rate during transportation from 85% to 99.5%, effectively ensuring vaccine efficacy.</p>', 1, 36, 1, 1761798801, 1761798801, 0, 'Cold chain transportation environment monitoring chip, accurately monitoring temperature and humidity changes, ensuring food and drug quality safety during transportation', '', 'Cold Chain Monitoring,Temperature Monitoring,Pharmaceutical Transportation', '1899', 'Cold chain monitoring chip XK-IoT1500, accurately monitoring temperature and humidity, ensuring food and drug transportation safety.', 1, '', '', 'Cold Chain IoT Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product36.jpg,/uploads/images/product/product51.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product61.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg', '', '', '', '', '<p>Precise temperature and humidity monitoring for cold chain.</p>', '<p>Requires proper calibration and maintenance.</p>', 88, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (313, 8, 'Smart Manhole Cover Monitoring Chip XK-IoT1600', '/uploads/images/product/product37.jpg', '', '<p>Silicon Core Technology releases smart manhole cover monitoring specific chip XK-IoT1600, integrating functions like tilt detection, displacement sensing, illegal opening detection, etc. XK-IoT1600 provides intelligent solutions for urban manhole cover management, helping prevent manhole cover related safety accidents.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product52.jpg\" alt=\"Smart Manhole Cover Application\"></p><p><strong>Municipal Management Innovation</strong>: The chip adopts triaxial accelerometer detecting manhole cover status, immediately alerting when tilt exceeds 15 degrees or displacement exceeds 10cm. Waterproof rating reaching IP68, adapting to humid underground environments.</p><p>XK-IoT1600 supports NB-IoT communication, strong signal penetration capability, suitable for underground environment use. Battery-powered design enables devices independent work over 3 years, reducing maintenance frequency.</p><p>This chip has been deployed in multiple city smart municipal projects. After adopting this solution, a large city shortened manhole cover loss and damage discovery time from several days to minutes, municipal emergency response efficiency significantly improved.</p>', 1, 35, 1, 1761798801, 1761798801, 0, 'Smart manhole cover status monitoring chip, real-time monitoring manhole cover status changes, improving municipal facility management efficiency and safety', '', 'Smart Manhole Cover,Municipal Management,Security Monitoring', '1199', 'Smart manhole cover monitoring chip XK-IoT1600, real-time monitoring manhole cover status, improving municipal management efficiency.', 2, '', '', 'Smart Municipal Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product37.jpg,/uploads/images/product/product52.jpg,/uploads/images/product/product57.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg,/uploads/images/product/product82.jpg', '', '', '', '', '<p>Manhole cover status monitoring with security features.</p>', '<p>Requires proper installation and network coverage.</p>', 96, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (314, 8, 'Smart Trash Bin Chip XK-IoT1700', '/uploads/images/product/product38.jpg', '', '<p>Silicon Core Technology launches smart trash bin specific chip XK-IoT1700, integrating ultrasonic ranging and compression control functions. XK-IoT1700 real-time monitors trash bin full status, providing data support for smart sanitation, optimizing garbage collection routes.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product53.jpg\" alt=\"Smart Trash Bin Application\"></p><p><strong>Sanitation Management Optimization</strong>: The chip adopts ultrasonic detection garbage height, detection accuracy reaching 1cm. Intelligent compression function automatically starts when garbage reaches certain capacity, improving trash bin usage efficiency.</p><p>XK-IoT1700 supports solar charging, adapting to outdoor long-term use requirements. Data analysis function can statistics garbage generation patterns at various points, providing scientific basis for sanitation planning.</p><p>This chip has been applied in multiple domestic smart city projects. After adopting this solution, a district reduced garbage collection vehicle trips 30%, fuel consumption reduced 25%, achieving sanitation management cost reduction and efficiency improvement.</p>', 1, 34, 1, 1761798801, 1761798801, 0, 'Smart trash bin monitoring control chip, monitoring garbage capacity status, optimizing urban sanitation collection routes and resource allocation', '', 'Smart Trash Bin,Sanitation Management,Compression Control', '999', 'Smart trash bin chip XK-IoT1700, monitoring full status, optimizing urban sanitation management efficiency.', 1, '', '', 'Smart Sanitation Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product38.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product58.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg,/uploads/images/product/product83.jpg', '', '', '', '', '<p>Smart waste management with compression control.</p>', '<p>Requires proper maintenance and cleaning.</p>', 103, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (315, 8, 'Smart Fire Protection Chip XK-IoT1800 Type', '/uploads/images/product/product39.jpg', '', '<p>Silicon Core Technology releases smart fire protection specific chip XK-IoT1800, integrating functions like smoke detection, temperature sensing, sound-light alarm, etc. XK-IoT1800 provides early fire warning for buildings, minimizing fire losses.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product54.jpg\" alt=\"Smart Fire Protection Application\"/></p><p><strong>Fire Protection Technology Innovation</strong>: The chip adopts dual-optical path smoke detection technology, effectively distinguishing fire smoke and dust interference. Temperature monitoring supports differential temperature and fixed temperature two alarm methods, adapting to different environmental requirements.</p><p>XK-IoT1800 supports fire equipment linkage, automatically starting sprinkler systems when detecting fire. Backup power ensures 24-hour normal operation when mains power interrupted.</p><p>This chip has passed national fire product certification, applied in crowded places like shopping malls, hotels, schools, etc. After adopting this solution, a large commercial complex advanced fire warning time by 10 minutes, winning precious time for personnel evacuation.</p>', 1, 33, 1, 1761798801, 1762186260, 0, 'Smart fire protection warning monitoring chip, integrating multi-parameter detection functions, improving early fire discovery and warning response capabilities', '', 'Smart Fire Protection,Fire Warning,Smoke Detection', '1699', 'Smart fire protection chip XK-IoT1800, integrating multi-parameter detection, improving early fire warning capabilities.', 1, '', '', 'Fire Protection IoT Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product39.jpg,/uploads/images/product/product54.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg,/uploads/images/product/product84.jpg', '', '', '', '', '<p>Multi-parameter fire detection with early warning.</p>', '<p>Requires regular testing and maintenance.</p>', 135, '98%', '', 'Machine Learning,Deep Learning,Database,DevOps,5G Technology,IoT,Cloud Computing,Open Source Projects,Technical Architecture,User Experience');
INSERT INTO `ry_en_article` VALUES (316, 8, 'Smart Parking Chip XK-IoT1900', '/uploads/images/product/product40.jpg', '', '<p>Silicon Core Technology launches smart parking specific chip XK-IoT1900, integrating geomagnetic detection and wireless communication functions. XK-IoT1900 real-time monitors parking space status, providing accurate parking space information for smart parking systems, improving parking resource utilization.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product55.jpg\" alt=\"Smart Parking Application\"/></p><p><strong>Parking Management Optimization</strong>: The chip adopts triaxial geomagnetic sensor, vehicle detection accuracy rate reaching 99%. Adaptive algorithm can distinguish vehicles and pedestrian interference, reducing false alarm rate.</p><p>XK-IoT1900 supports wireless networking, single gateway managing hundreds of parking spaces. Solar power design enables devices independently installed anywhere,无需布线施工.</p><p>This chip has been deployed in multiple city smart parking projects nationwide. After adopting this solution, a commercial area improved parking space turnover rate 40%, vehicle finding parking space time reduced from 15 minutes to 3 minutes, effectively alleviating traffic congestion.</p>', 1, 32, 1, 1761798801, 1762184499, 0, 'Smart parking geomagnetic detection chip, accurately monitoring parking space usage status, solving urban parking problems, improving resource utilization', '', 'Smart Parking,Geomagnetic Detection,Parking Space Management', '1299', 'Smart parking chip XK-IoT1900, accurately monitoring parking space status, solving urban parking problems.', 2, '', '', 'Smart Transportation Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product40.jpg,/uploads/images/product/product55.jpg,/uploads/images/product/product60.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg,/uploads/images/product/product85.jpg', '', '', '', '', '<p>Geomagnetic parking detection with smart management.</p>', '<p>Requires proper installation and calibration.</p>', 125, '98%', '', '1,2,9');
INSERT INTO `ry_en_article` VALUES (317, 8, 'Smart Farming Chip XK-IoT2000', '/uploads/images/product/product41.jpg', '', '<p>Silicon Core Technology releases smart farming specific chip XK-IoT2000, integrating animal behavior monitoring and environmental regulation functions. XK-IoT2000 provides precise farming management for modern farms, improving farming efficiency and animal welfare.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product56.jpg\" alt=\"Smart Farming Application\"/></p><p><strong>Farming Technology Innovation</strong>: The chip supports monitoring key indicators like animal activity, feed intake, body temperature, etc. Intelligent algorithms can early discover animal health abnormalities, timely intervention treatment.</p><p>XK-IoT2000 environmental regulation function can automatically adjust parameters like temperature, humidity, ventilation, etc., creating optimal growth environment for animals. Data analysis function provides scientific support for farming decisions.</p><p>This chip has been applied in multiple domestic large farms. After adopting this solution, a pig farming enterprise improved sow farrowing rate 15%, feed conversion rate improved 10%, farming benefits significantly improved.</p>', 1, 31, 1, 1761798801, 1762186772, 0, 'Smart farming environment monitoring chip, monitoring animal behavior and environmental parameters, promoting animal husbandry towards modern development', '', 'Smart Farming,Animal Monitoring,Environmental Regulation', '1799', 'Smart farming chip XK-IoT2000, monitoring animal behavior environment, promoting animal husbandry modernization development.', 1, '', '', 'Agricultural IoT Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product41.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product61.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg,/uploads/images/product/product86.jpg', '', '', '', '', '<p>Animal behavior monitoring and environmental control.</p>', '<p>Requires proper farm management practices.</p>', 520, '98%', '', 'Frontend Development,Open Source Projects,Technical Architecture');
INSERT INTO `ry_en_article` VALUES (318, 9, 'Smart Cockpit Domain Controller Chip XK-Auto100', '/uploads/images/product/product42.jpg', '', '<p>Silicon Core Technology launches smart cockpit domain controller chip XK-Auto100, this chip integrates high-performance GPU and multiple display output interfaces, supporting up to 6 HD screens simultaneous display. XK-Auto100 provides powerful computing and graphics processing capabilities for modern automotive smart cockpits, creating immersive driving experience.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product57.jpg\" alt=\"Smart Cockpit Chip\"></p><p><strong>Cockpit Technology Innovation</strong>: Chip adopts multi-core heterogeneous architecture, CPU, GPU, neural network processing units协同工作,力求system流畅运行. Supports 4K resolution display, picture细腻度 reaching consumer electronics level. Voice interaction latency below 100ms, achieving natural smooth human-machine dialogue.</p><p>XK-Auto100 has passed automotive-grade certification, operating temperature range -40°C to +105°C. In a high-end electric vehicle model, achieved instrument cluster, central control screen, co-pilot entertainment screen, rear entertainment screen four-screen linkage, bringing users excellent digital cockpit experience.</p>', 1, 50, 1, 1761804990, 1761804990, 0, 'High-performance smart cockpit domain control chip, supporting multi-screen interaction and voice interaction, creating immersive digital driving experience environment', 'Automotive Grade', 'Smart Cockpit,Domain Controller,Multi-screen Interaction', '2899', 'Smart cockpit chip XK-Auto100, supports 6-screen display, creating immersive driving experience.', 1, '', '', 'Smart Cockpit Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product42.jpg,/uploads/images/product/product57.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg,/uploads/images/product/product82.jpg,/uploads/images/product/product87.jpg', '', '', '', '', '<p>Advanced cockpit technology with multi-screen interaction and voice control capabilities.</p>', '<p>Requires compatible display systems and audio hardware.</p>', 145, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (319, 9, 'Autonomous Driving Computing Chip XK-Auto200', '/uploads/images/product/product43.jpg', '', '<p>Silicon Core Technology releases autonomous driving computing chip XK-Auto200, this chip integrates multiple high-performance computing cores and dedicated AI accelerators, computing power reaching 500TOPS. XK-Auto200 provides reliable perception, decision, planning computing capabilities for L4 autonomous driving,力求行车safe.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product58.jpg\" alt=\"Autonomous Driving Chip\"></p><p><strong>Safety Technology Support</strong>: Chip adopts ASIL-D functional safety design, critical computing units triple redundancy. Real-time support mechanism力求 perception-decision-execution chain latency below 50ms. Supports multi-sensor data fusion, accurately perceiving surrounding environment.</p><p>This chip has been applied in multiple domestic autonomous driving demonstration projects, performing excellently in complex urban road scenarios. After a Robotaxi company adopted XK-Auto200, system takeover mileage increased from 100km to 1000km, technical maturity significantly improved.</p>', 1, 49, 1, 1761804990, 1761804990, 0, 'L4 autonomous driving computing platform chip, meeting high safety level requirements, providing reliable computing power support guarantee for autonomous driving system', 'Automotive Grade', 'Autonomous Driving,ASIL-D,Multi-sensor Fusion', '5899', 'Autonomous driving chip XK-Auto200, computing power 500TOPS, meeting L4 autonomous driving requirements.', 2, '', '', 'Autonomous Driving Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product43.jpg,/uploads/images/product/product58.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg,/uploads/images/product/product83.jpg,/uploads/images/product/product88.jpg', '', '', '', '', '<p>High-performance computing for autonomous driving with functional safety design.</p>', '<p>Requires strict compliance with automotive safety standards.</p>', 132, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (320, 9, 'In-Vehicle Gateway Chip XK-Auto300', '/uploads/images/product/product44.jpg', '', '<p>Silicon Core Technology launches in-vehicle gateway chip XK-Auto300, this chip supports multiple in-vehicle network protocols including CAN-FD, LIN, Ethernet, etc. XK-Auto300 serves as vehicle network hub, achieving data exchange and协同 control between various electronic control units, enhancing vehicle intelligent level.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product59.jpg\" alt=\"In-Vehicle Gateway Chip\"/></p><p><strong>Network Management Innovation</strong>: Chip supports firewall function, preventing malicious network attacks. Data priority scheduling ensures critical control instructions priority transmission. OTA upgrade management achieves vehicle software remote updates, reducing maintenance costs.</p><p>XK-Auto300 has been mass-produced in multiple models of a mainstream automaker. Through this chip, achieved data communication between powertrain system, chassis system, body system, providing solid network foundation for intelligent connected vehicles.</p>', 1, 48, 1, 1761804990, 1761804990, 0, 'Vehicle network gateway management chip, supporting multiple in-vehicle network protocols, achieving data exchange coordination between electronic control units', 'Automotive Grade', 'In-vehicle Gateway,CAN-FD,Ethernet', '1899', 'In-vehicle gateway chip XK-Auto300, supports multi-protocol, achieving unified vehicle network management.', 1, '', '', 'In-Vehicle Network Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product44.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg,/uploads/images/product/product84.jpg,/uploads/images/product/product89.jpg', '', '', '', '', '<p>Multi-protocol in-vehicle network gateway with firewall functionality.</p>', '<p>Requires proper network configuration and security settings.</p>', 118, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (321, 9, 'Battery Management Chip XK-Auto400', '/uploads/images/product/product45.jpg', '', '<p>Silicon Core Technology releases battery management chip XK-Auto400, this chip integrates high-precision voltage, current, temperature monitoring functions. XK-Auto400 provides accurate state estimation and balance control for electric vehicle battery packs, extending battery life, improving range.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product60.jpg\" alt=\"Battery Management Chip\"/></p><p><strong>Battery Technology Breakthrough</strong>: Chip supports 16-channel battery voltage monitoring, accuracy reaching ±2mV. Intelligent balance technology improves battery pack capacity utilization to over 95%. SOC estimation error less than 3%, accurately displaying remaining range.</p><p>In a popular electric vehicle model, after adopting XK-Auto400, battery cycle life improved 20%, winter range衰减 reduced 15%. Chip thermal runaway预警功能多次success prevented battery safety accidents.</p>', 1, 47, 1, 1761804990, 1761804990, 0, 'Electric vehicle battery management dedicated chip, providing accurate state estimation and balance control, extending battery life improving range', 'Automotive Grade', 'Battery Management,SOC Estimation,Balancing Control', '2199', 'Battery management chip XK-Auto400, accuracy ±2mV, improving electric vehicle range and safety.', 1, '', '', 'Powertrain System Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product45.jpg,/uploads/images/product/product60.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg,/uploads/images/product/product85.jpg,/uploads/images/product/product90.jpg', '', '', '', '', '<p>High-precision battery monitoring with intelligent balancing technology.</p>', '<p>Requires proper battery system integration and calibration.</p>', 126, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (322, 9, 'In-Vehicle Entertainment System Chip XK-Auto500', '/uploads/images/product/product46.jpg', '', '<p>Silicon Core Technology launches in-vehicle entertainment system chip XK-Auto500, this chip integrates high-performance audio processor and video decoder. XK-Auto500 supports multi-channel surround sound and 4K video playback, providing cinema-level entertainment experience for passengers.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product61.jpg\" alt=\"In-Vehicle Entertainment Chip\"></p><p><strong>Entertainment Experience Upgrade</strong>: Chip supports surround sound effects and multi-channel audio effects, creating immersive auditory experience. Hardware-level video decoding supports H.265, AV1 and other advanced encoding formats. Multi-zone audio management achieves front and rear row independent sound field control.</p><p>In a luxury brand model, XK-Auto500配合 26 speaker system, created mobile concert hall-like auditory feast. Chip low-power design ensures entertainment system long-term operation不impact vehicle range.</p>', 1, 46, 1, 1761804990, 1761804990, 0, 'High-performance in-vehicle entertainment processing chip, supporting HD video and quality audio, creating mobile entertainment space experience', 'Automotive Grade', '车载娱乐,音频处理,视频解码', '2399', 'In-vehicle entertainment chip XK-Auto500, supports 4K video and surround sound, creating mobile entertainment space.', 1, '', '', 'In-Vehicle Entertainment Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product46.jpg,/uploads/images/product/product61.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg,/uploads/images/product/product86.jpg,/uploads/images/product/product91.jpg', '', '', '', '', '<p>High-quality audio and video processing for in-vehicle entertainment.</p>', '<p>Requires compatible audio systems and display interfaces.</p>', 112, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (323, 9, 'Advanced Driver Assistance Chip XK-Auto600', '/uploads/images/product/product47.jpg', '', '<p>Silicon Core Technology releases advanced driver assistance chip XK-Auto600, this chip specifically designed for ADAS systems, integrating visual processing and radar signal processing units. XK-Auto600 supports ADAS functions like forward collision warning, lane keeping, adaptive cruise control, etc., improving driving safety.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product62.jpg\" alt=\"ADAS Chip\"></p><p><strong>Perception Technology Optimization</strong>: Chip supports multiple camera inputs, achieving 360-degree environment perception. Deep learning algorithms accurately recognize vehicles, pedestrians, traffic signs. Millimeter wave radar signal processing distance accuracy reaching 0.1 meter.</p><p>In a mass-produced vehicle model, ADAS system equipped with XK-Auto600 successfully avoided multiple potential traffic accidents. Chip real-time capability ensures timely response even at 120km/h speed, providing reliable assistance for drivers.</p>', 1, 45, 1, 1761804990, 1761804990, 0, 'Advanced driver assistance environment perception chip, accurately perceiving surrounding environment, improving driving safety and assistance experience', 'Automotive Grade', 'ADAS,环境感知,毫米波雷达', '3299', 'Advanced driver assistance chip XK-Auto600, accurately perceiving environment, improving driving safety.', 2, '', '', 'ADAS Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product47.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg,/uploads/images/product/product82.jpg,/uploads/images/product/product87.jpg,/uploads/images/product/product92.jpg', '', '', '', '', '<p>Advanced environment perception with multi-sensor data fusion.</p>', '<p>Requires proper sensor calibration and system integration.</p>', 138, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (324, 9, 'Vehicle Networking Communication Chip XK-Auto700', '/uploads/images/product/product48.jpg', '', '<p>Silicon Core Technology launches vehicle networking communication chip XK-Auto700, this chip supports 5G and C-V2X communication technologies. XK-Auto700 provides high-speed, low-latency vehicle-cloud communication and vehicle-vehicle communication capabilities for intelligent connected vehicles, achieving vehicle-road coordination.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product63.jpg\" alt=\"Vehicle Networking Chip\"></p><p><strong>Communication Technology Advanced</strong>: Chip supports 5G NR, downlink rate reaching 2Gbps. C-V2X direct communication latency below 10ms, meeting safety application requirements. Multi-mode support ensures connection maintained in different network environments.</p><p>In smart highway demonstration projects, vehicles equipped with XK-Auto700 achieved real-time information exchange with roadside equipment. Functions like emergency brake warning, road hazard提示 effectively improved road safety level.</p>', 1, 44, 1, 1761804990, 1761804990, 0, '5G-V2X vehicle networking communication chip, supporting high-speed low-latency communication, achieving intelligent vehicle-road coordination application scenarios', 'Automotive Grade', '车联网,5G,V2X,车路协同', '2799', 'Vehicle networking communication chip XK-Auto700, supporting 5G and V2X, achieving intelligent vehicle-road coordination.', 1, '', '', 'Vehicle Networking Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product48.jpg,/uploads/images/product/product63.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg,/uploads/images/product/product83.jpg,/uploads/images/product/product88.jpg,/uploads/images/product/product93.jpg', '', '', '', '', '<p>High-speed vehicle networking communication with low latency.</p>', '<p>Requires compatible network infrastructure and protocols.</p>', 124, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (325, 9, 'Motor Control Chip XK-Auto800', '/uploads/images/product/product49.jpg', '', '<p>Silicon Core Technology releases motor control chip XK-Auto800, this chip integrates high-precision PWM generators and current sampling circuits. XK-Auto800 provides precise control signals for electric vehicle drive motors, achieving efficient energy conversion and smooth power output.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product64.jpg\" alt=\"Motor Control Chip\"></p><p><strong>Control Technology Breakthrough</strong>: Chip supports vector control algorithms, motor efficiency improved to over 97%. Dead time compensation technology reduces harmonic distortion, lowering electromagnetic interference. Overcurrent, overtemperature protection ensures system safety and reliability.</p><p>In a high-performance electric vehicle model, after adopting XK-Auto800, electricity consumption per 100km reduced 8%. Chip fast response characteristics achieved millisecond-level torque adjustment, providing细腻 acceleration experience for drivers.</p>', 1, 43, 1, 1761804990, 1761804990, 0, 'Electric vehicle motor control dedicated chip, providing precise control signals, achieving efficient energy conversion and smooth power output', 'Automotive Grade', '电机控制,矢量控制,PWM', '1999', 'Motor control chip XK-Auto800, efficiency 97%, improving electric vehicle drive performance.', 1, '', '', 'Electric Drive Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product49.jpg,/uploads/images/product/product64.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg,/uploads/images/product/product84.jpg,/uploads/images/product/product89.jpg,/uploads/images/product/product94.jpg', '', '', '', '', '<p>Precise motor control with high efficiency and fast response.</p>', '<p>Requires proper motor system integration and thermal management.</p>', 119, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (326, 9, 'In-Vehicle Power Management Chip XK-Auto900', '/uploads/images/product/product50.jpg', '', '<p>Silicon Core Technology launches in-vehicle power management chip XK-Auto900, this chip integrates multiple DC-DC converters and LDO regulators. XK-Auto900 provides stable, efficient power supply for vehicle electronic systems, optimizing energy utilization efficiency.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product65.jpg\" alt=\"Power Management Chip\"></p><p><strong>Energy Efficiency Technology Improvement</strong>: Chip conversion efficiency reaches 95%, reducing energy loss. Dynamic voltage regulation automatically adjusts output voltage according to load. Multiple outputs meet different system power requirements, simplifying power design.</p><p>In a hybrid vehicle model, after adopting XK-Auto900, low-voltage system energy consumption reduced 15%. Chip intelligent power management enables vehicle static current below 1mA in parking state, extending battery life.</p>', 1, 42, 1, 1761804990, 1761804990, 0, 'Vehicle power management control chip, integrating multiple power converters, optimizing vehicle energy consumption distribution and energy utilization efficiency', 'Automotive Grade', '电源管理,DC-DC,能耗优化', '1699', 'In-vehicle power management chip XK-Auto900, conversion efficiency 95%, optimizing vehicle energy consumption.', 1, '', '', 'Power Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product50.jpg,/uploads/images/product/product65.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg,/uploads/images/product/product85.jpg,/uploads/images/product/product90.jpg,/uploads/images/product/product95.jpg', '', '', '', '', '<p>Efficient power management with multiple output channels.</p>', '<p>Requires proper power system design and load management.</p>', 107, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (327, 9, 'Digital Instrument Cluster Chip XK-Auto1000', '/uploads/images/product/product51.jpg', '', '<p>Silicon Core Technology releases digital instrument cluster chip XK-Auto1000, this chip integrates high-performance graphics processor and multiple display interfaces. XK-Auto1000 supports full LCD instrument display, providing clear, intuitive vehicle information display for drivers.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product66.jpg\" alt=\"Digital Instrument Chip\"></p><p><strong>Display Technology Upgrade</strong>: Chip supports 3D graphics rendering, achieving realistic instrument effects. 60fps refresh rate ensures smooth画面无拖影. Multiple theme switching meetspersonalization需求. Critical information priority display ensures driving safety.</p><p>In a sports car model, XK-Auto1000 achieved exclusive instrument interface for track mode, tachometer, G-value, lap time and other information一目了然, enhancing driving pleasure and professionalism.</p>', 1, 41, 1, 1761804990, 1761804990, 0, 'Full LCD instrument cluster drive chip, supporting HD virtual instrument display, providing clear intuitive information display for drivers', 'Automotive Grade', '数字仪表,图形处理,3D渲染', '2099', 'Digital instrument cluster chip XK-Auto1000, supports 3D rendering, achieving HD virtual instrument display.', 2, '', '', 'Display Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product51.jpg,/uploads/images/product/product66.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg,/uploads/images/product/product86.jpg,/uploads/images/product/product91.jpg,/uploads/images/product/product96.jpg', '', '', '', '', '<p>High-performance graphics processing with 3D rendering capabilities.</p>', '<p>Requires compatible display systems and graphics interfaces.</p>', 133, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (328, 9, 'In-Vehicle Camera Processing Chip XK-Auto1100', '/uploads/images/product/product52.jpg', '', '<p>Silicon Core Technology launches in-vehicle camera processing chip XK-Auto1100, this chip integrates image signal processor and computer vision accelerator. XK-Auto1100 provides high-quality image processing and intelligent analysis capabilities for in-vehicle cameras like surround view, forward view, cabin monitoring, etc.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product67.jpg\" alt=\"Camera Processing Chip\"></p><p><strong>Image Technology Optimization</strong>: Chip supports HDR processing, dynamic range reaching 140dB. Noise reduction algorithms maintain image clarity in low light environments. Distortion correction ensures surround view system画面真实准确.</p><p>In a high-end vehicle model 360 surround view system, after adopting XK-Auto1100, image stitching effect natural and smooth, blind spot monitoring accuracy improved to 99%. Chip driver monitoring function effectively prevented fatigue driving accidents.</p>', 1, 40, 1, 1761804990, 1761804990, 0, 'In-vehicle camera image processing chip, providing high-quality image processing and intelligent analysis, improving visual perception quality', 'Automotive Grade', '车载摄像头,HDR,图像处理', '1899', 'In-vehicle camera chip XK-Auto1100, supports HDR and noise reduction, improving visual perception quality.', 1, '', '', 'Vision Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product52.jpg,/uploads/images/product/product67.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg,/uploads/images/product/product82.jpg,/uploads/images/product/product87.jpg,/uploads/images/product/product92.jpg,/uploads/images/product/product97.jpg', '', '', '', '', '<p>Advanced image processing with HDR and noise reduction.</p>', '<p>Requires proper camera calibration and lens quality.</p>', 121, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (329, 9, 'Body Control Chip XK-Auto1200', '/uploads/images/product/product53.jpg', '', '<p>Silicon Core Technology releases body control chip XK-Auto1200, this chip integrates multiple high-side drivers and low-side driver channels. XK-Auto1200 responsible for window, lights, door locks and other body accessory control, improving vehicle convenience and comfort.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product68.jpg\" alt=\"Body Control Chip\"></p><p><strong>Control Function Complete</strong>: Chip supports PWM dimming, achieving stepless brightness adjustment. Soft start function extends lamp life. Fault diagnosis real-time monitors load status. Sleep mode power consumption extremely low, meeting static current requirements.</p><p>In a family car model, XK-Auto1200 achieved intelligent functions like welcome lights, home lighting, etc. Chip reliability design ensures stable operation in harsh environments, improving user satisfaction.</p>', 1, 39, 1, 1761804990, 1761804990, 0, 'Intelligent body control management chip, responsible for window lights and other accessory control, improving vehicle convenience and comfort', 'Automotive Grade', '车身控制,驱动芯片,故障诊断', '1499', 'Body control chip XK-Auto1200, integrating multiple drivers, achieving intelligent body management.', 1, '', '', 'Body Electronics Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product53.jpg,/uploads/images/product/product68.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg,/uploads/images/product/product83.jpg,/uploads/images/product/product88.jpg,/uploads/images/product/product93.jpg,/uploads/images/product/product98.jpg', '', '', '', '', '<p>Comprehensive body control with multiple driver channels.</p>', '<p>Requires proper electrical system integration and load protection.</p>', 115, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (330, 9, 'In-Vehicle Audio Amplifier Chip XK-Auto1300', '/uploads/images/product/product54.jpg', '', '<p>Silicon Core Technology launches in-vehicle audio amplifier chip XK-Auto1300, this chip integrates multi-channel Class D amplifiers and DSP processor. XK-Auto1300 provides pure, powerful audio amplification for in-vehicle audio systems, creating immersive auditory experience.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product69.jpg\" alt=\"Audio Amplifier Chip\"></p><p><strong>Sound Quality Technology Improvement</strong>: Chip efficiency reaches 90%, reducing heat and power consumption. THD+N below 0.01%, ensuring pure sound quality. Built-in DSP supports sound field correction, equalizer adjustment and other audio processing.</p><p>In a luxury vehicle audio system, XK-Auto1300 drives 23 speakers, output power reaching 1600W. Chip intelligent protection function prevents overload damage, ensuring system reliability.</p>', 1, 38, 1, 1761804990, 1761804990, 0, 'Multi-channel in-vehicle audio amplifier chip, providing pure powerful audio amplification, creating high-quality in-vehicle audio system', 'Automotive Grade', '音频功放,D类功放,DSP处理', '2599', 'In-vehicle audio amplifier chip XK-Auto1300, efficiency 90%, creating high-quality audio system.', 1, '', '', 'Audio Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product54.jpg,/uploads/images/product/product69.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg,/uploads/images/product/product84.jpg,/uploads/images/product/product89.jpg,/uploads/images/product/product94.jpg,/uploads/images/product/product99.jpg', '', '', '', '', '<p>High-efficiency audio amplification with DSP processing.</p>', '<p>Requires compatible audio systems and speaker configurations.</p>', 128, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (331, 9, 'Tire Pressure Monitoring Chip XK-Auto1400', '/uploads/images/product/product55.jpg', '', '<p>Silicon Core Technology releases tire pressure monitoring chip XK-Auto1400, this chip integrates pressure sensor, temperature sensor and RF transmitter. XK-Auto1400 real-time monitors tire pressure and temperature, timely warning abnormal situations, ensuring driving safety.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product70.jpg\" alt=\"Tire Pressure Monitoring Chip\"></p><p><strong>Monitoring Technology Precise</strong>: Chip pressure measurement accuracy reaching ±1kPa, temperature accuracy ±1°C. Low-power design ensures battery life reaching 10 years. Automatic positioning识别各轮胎位置. Anti-interference design ensures signal stable transmission.</p><p>This chip has passed relevant certification, applied in standard configurations of multiple domestic vehicle manufacturers. In actual use,多次预警 slow leaks and tire pressure abnormalities, effectively preventing tire blowout accidents.</p>', 1, 37, 1, 1761804990, 1761804990, 0, 'High-precision tire pressure monitoring sensor chip, real-time monitoring tire status, timely warning abnormal situations ensuring driving safety', 'Automotive Grade', '胎压监测,压力传感,RF发射', '899', 'Tire pressure monitoring chip XK-Auto1400, accuracy ±1kPa, real-time ensuring driving safety.', 2, '', '', 'Safety System Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product55.jpg,/uploads/images/product/product70.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg,/uploads/images/product/product85.jpg,/uploads/images/product/product90.jpg,/uploads/images/product/product95.jpg,/uploads/images/product/product100.jpg', '', '', '', '', '<p>High-precision tire pressure monitoring with long battery life.</p>', '<p>Requires proper sensor installation and periodic maintenance.</p>', 142, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (332, 9, 'In-Vehicle Wireless Charging Chip XK-Auto1500', '/uploads/images/product/product56.jpg', '', '<p>Silicon Core Technology launches in-vehicle wireless charging chip XK-Auto1500, this chip supports Qi wireless charging standard and fast charging protocol. XK-Auto1500 provides efficient, safe charging experience for in-vehicle phone wireless charging, meeting modern travel needs.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product71.jpg\" alt=\"Wireless Charging Chip\"></p><p><strong>Charging Technology Advanced</strong>: Chip supports 15W fast wireless charging, efficiency reaching 80%. Foreign object detection prevents metal objects heating. Temperature monitoring ensures charging safety. Compatible with multiple phone models, providing stable charging power.</p><p>In a new vehicle model, XK-Auto1500 achieved dual phone positions simultaneous fast charging on center console. Chip intelligent powerminute配根据 phone需求 dynamic adjustment, optimizing charging efficiency.</p>', 1, 36, 1, 1761804990, 1761804990, 0, 'In-vehicle fast wireless charging chip, supporting fast wireless charging protocol, providing convenient charging experience for mobile devices', 'Automotive Grade', '无线充电,快充,Qi标准', '1299', 'In-vehicle wireless charging chip XK-Auto1500, supporting 15W fast charging, improving charging experience.', 1, '', '', 'Charging Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product56.jpg,/uploads/images/product/product71.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg,/uploads/images/product/product86.jpg,/uploads/images/product/product91.jpg,/uploads/images/product/product96.jpg,/uploads/images/product/product101.jpg', '', '', '', '', '<p>Fast wireless charging with foreign object detection.</p>', '<p>Requires compatible charging devices and proper installation.</p>', 119, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (333, 9, 'In-Vehicle Navigation Positioning Chip XK-Auto1600', '/uploads/images/product/product57.jpg', '', '<p>Silicon Core Technology releases in-vehicle navigation positioning chip XK-Auto1600, this chip supports four major satellite systems: GPS, BeiDou, GLONASS, Galileo. XK-Auto1600 provides precise positioning services for in-vehicle navigation, combining high-precision maps achieving intelligent route planning.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product72.jpg\" alt=\"Navigation Positioning Chip\"></p><p><strong>Positioning Technology Upgrade</strong>: Chip positioning accuracy reaching 1 meter (open area). Inertial navigation maintains positioning continuity in tunnels and other signal blind areas. Multipath suppression reduces urban canyon effect impact. Cold start time less than 30 seconds.</p><p>In an intelligent connected vehicle model, XK-Auto1600配合 high-precision maps achieved lane-level navigation. In complex interchange and ramp scenarios, provided accurate route guidance, improving navigation experience.</p>', 1, 35, 1, 1761804990, 1761804990, 0, 'Multi-mode satellite navigation positioning chip, supporting global positioning systems, providing precise positioning services for in-vehicle navigation', 'Automotive Grade', '导航定位,北斗,GPS,惯性导航', '1799', 'In-vehicle navigation chip XK-Auto1600, supporting four systems, positioning accuracy 1 meter.', 1, '', '', 'Navigation System Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product57.jpg,/uploads/images/product/product72.jpg,/uploads/images/product/product77.jpg,/uploads/images/product/product82.jpg,/uploads/images/product/product87.jpg,/uploads/images/product/product92.jpg,/uploads/images/product/product97.jpg,/uploads/images/product/product102.jpg', '', '', '', '', '<p>Multi-system satellite navigation with high precision positioning.</p>', '<p>Requires proper antenna installation and signal reception.</p>', 134, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (334, 9, 'In-Vehicle Ethernet Switch Chip XK-Auto1700', '/uploads/images/product/product58.jpg', '', '<p>Silicon Core Technology launches in-vehicle Ethernet switch chip XK-Auto1700, this chip supports 1000BASE-T1 and 100BASE-T1 standards. XK-Auto1700 provides high-speed, reliable data exchange capabilities for new generation in-vehicle networks, meeting intelligent vehicle big data transmission requirements.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product73.jpg\" alt=\"Ethernet Switch Chip\"></p><p><strong>Network Performance Improvement</strong>: Chip supports 8-port Gigabit Ethernet switching. TSN ensures critical data real-time transmission. Traffic management optimizes network resource allocation. Low-power design meets automotive electronics requirements.</p><p>In a domain集中 architecture vehicle model, XK-Auto1700 achieved high-speed interconnection between intelligent driving domain, cockpit domain, power domain. Chip reliability design ensures vehicle network communication stability.</p>', 1, 34, 1, 1761804990, 1761804990, 0, 'High-speed in-vehicle Ethernet switch chip, building new generation in-vehicle network, meeting intelligent vehicle big data transmission requirements', 'Automotive Grade', '车载以太网,TSN,网络交换', '2299', 'In-vehicle Ethernet chip XK-Auto1700, supporting Gigabit switching, building high-speed in-vehicle network.', 1, '', '', 'Network Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product58.jpg,/uploads/images/product/product73.jpg,/uploads/images/product/product78.jpg,/uploads/images/product/product83.jpg,/uploads/images/product/product88.jpg,/uploads/images/product/product93.jpg,/uploads/images/product/product98.jpg,/uploads/images/product/product103.jpg', '', '', '', '', '<p>High-speed Ethernet switching with TSN support.</p>', '<p>Requires proper network configuration and cable quality.</p>', 126, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (335, 9, 'In-Vehicle Radar Processing Chip XK-Auto1800', '/uploads/images/product/product59.jpg', '', '<p>Silicon Core Technology releases in-vehicle radar processing chip XK-Auto1800, this chip specifically designed for millimeter wave radar and lidar signal processing. XK-Auto1800 achieves high-precision target detection and tracking, providing reliable perception data for autonomous driving.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product74.jpg\" alt=\"Radar Processing Chip\"></p><p><strong>Radar Technology Optimization</strong>: Chip supports multi-target tracking, simultaneously processing 256 targets. Distance resolution reaching 0.1 meter, speed resolution 0.1km/h. Anti-interference algorithms maintain detection stability in complex environments.</p><p>In an L3 autonomous driving system, XK-Auto1800 processed millimeter wave radar data accurately识别了 200米外的 vehicles and pedestrians. Chip real-time capability ensures system reliability in high-speed scenarios.</p>', 1, 33, 1, 1761804990, 1761804990, 0, 'In-vehicle radar signal processing chip, achieving high-precision target detection and tracking, providing reliable perception data for autonomous driving', 'Automotive Grade', '毫米波雷达,目标跟踪,信号处理', '3499', 'In-vehicle radar chip XK-Auto1800, supporting multi-target tracking, improving obstacle detection capability.', 2, '', '', 'Radar Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product59.jpg,/uploads/images/product/product74.jpg,/uploads/images/product/product79.jpg,/uploads/images/product/product84.jpg,/uploads/images/product/product89.jpg,/uploads/images/product/product94.jpg,/uploads/images/product/product99.jpg,/uploads/images/product/product104.jpg', '', '', '', '', '<p>Advanced radar signal processing with multi-target tracking.</p>', '<p>Requires proper radar calibration and system integration.</p>', 141, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (336, 9, 'In-Vehicle Security Chip XK-Auto1900', '/uploads/images/product/product60.jpg', '', '<p>Silicon Core Technology launches in-vehicle security chip XK-Auto1900, this chip integrates hardware encryption engine and secure storage unit. XK-Auto1900 provides comprehensive information security protection for intelligent connected vehicles, preventing network attacks and data leaks.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product75.jpg\" alt=\"Security Chip\"></p><p><strong>Security Technology Strengthening</strong>: Chip supports national cryptographic algorithms and international encryption standards. Secure boot ensures system software integrity. Key management prevents unauthorized access. Real-time intrusion detection timely warns security threats.</p><p>In a vehicle manufacturer OTA upgrade system, XK-Auto1900 ensured software package integrity and authenticity. Chip security authentication function prevented vehicles from illegal startup, improving vehicle security level.</p>', 1, 32, 1, 1761804990, 1761804990, 0, 'In-vehicle information security protection chip, integrating hardware encryption engine, ensuring intelligent connected vehicle system information security', 'Automotive Grade', '信息安全,加密算法,安全启动', '1999', 'In-vehicle security chip XK-Auto1900, integrating hardware encryption, supporting system information security.', 1, '', '', 'Security Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product60.jpg,/uploads/images/product/product75.jpg,/uploads/images/product/product80.jpg,/uploads/images/product/product85.jpg,/uploads/images/product/product90.jpg,/uploads/images/product/product95.jpg,/uploads/images/product/product100.jpg,/uploads/images/product/product105.jpg', '', '', '', '', '<p>Hardware-level security encryption with secure boot.</p>', '<p>Requires proper key management and security protocols.</p>', 124, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (337, 9, 'In-Vehicle Diagnostic Chip XK-Auto2000', '/uploads/images/product/product61.jpg', '', '<p>Silicon Core Technology releases in-vehicle diagnostic chip XK-Auto2000, this chip integrates fault diagnosis and data analysis functions. XK-Auto2000 real-time monitors vehicle各system状态, providing precise fault diagnosis and maintenance suggestions, improving vehicle reliability.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product76.jpg\" alt=\"Diagnostic Chip\"></p><p><strong>Diagnostic Technology Intelligent</strong>: Chip supports OBD standard diagnostic protocols. Machine learning algorithms identify potential fault patterns. Data recording stores system status when faults occur. Remote diagnosis supports technicians快速定位 problems.</p><p>In a commercial vehicle fleet management, XK-Auto2000 achieved predictive maintenance, fault warning accuracy rate reaching 90%. Chip diagnostic data provided valuable reference for product improvement.</p>', 1, 31, 1, 1761753600, 1762145236, 0, 'Intelligent in-vehicle fault diagnostic chip, real-time monitoring vehicle status, providing precise fault diagnosis and maintenance suggestions support', 'Automotive Grade', '故障诊断,OBD,预防性维护', '1699', 'In-vehicle diagnostic chip XK-Auto2000, supporting intelligent diagnosis, improving vehicle reliability.', 1, '', '', 'Diagnostic Technology Department', 'Silicon Core Technology', 1, 30, '/uploads/images/product/product61.jpg,/uploads/images/product/product76.jpg,/uploads/images/product/product81.jpg,/uploads/images/product/product86.jpg,/uploads/images/product/product91.jpg,/uploads/images/product/product96.jpg,/uploads/images/product/product101.jpg,/uploads/images/product/product106.jpg', '', '', '', '', '<p>Intelligent fault diagnosis with predictive maintenance capabilities.</p>', '<p>Requires proper system configuration and data analysis.</p>', 128, '98%', '', '');
INSERT INTO `ry_en_article` VALUES (401, 12, 'Computing Power Bottleneck', '', '', '<p>Traditional computing architectures struggle to meet the exponential growth demands for computing power from AI and big data applications, resulting in slow processing speeds and high response latency. With the rapid development of technologies like artificial intelligence and Internet of Things, the demand for computing power is growing exponentially, and traditional CPU architectures can no longer meet real-time requirements.</p>', 1, 50, 1, 1762171346, 1762171346, 0, 'Traditional computing architectures struggle to meet the exponential growth demands for computing power from AI and big data applications, resulting in slow processing speeds and high response latency.', '', '', '', 'Traditional computing architectures struggle to meet the exponential growth demands for computing power from AI and big data applications, resulting in slow processing speeds and high response latency.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-tachometer-alt', '');
INSERT INTO `ry_en_article` VALUES (402, 12, 'High Energy Consumption', '', '', '<p>High-performance computing devices consume enormous power, with high cooling costs, not conforming to green low-carbon development trends, energy efficiency ratio urgently needs improvement. Data center energy consumption proportion in global electricity consumption continues to rise, cooling costs have become important operational burden.</p>', 1, 49, 1, 1762171346, 1762171346, 0, 'High-performance computing devices consume enormous power, with high cooling costs, not conforming to green low-carbon development trends, energy efficiency ratio urgently needs improvement.', '', '', '', 'High-performance computing devices consume enormous power, with high cooling costs, not conforming to green low-carbon development trends, energy efficiency ratio urgently needs improvement.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-bolt', '');
INSERT INTO `ry_en_article` VALUES (403, 12, 'Security Risks', '', '', '<p>Security threats like data breaches, network attacks are increasingly severe, traditional security solutions struggle to应对complex多变的safechallenge. With accelerated digital transformation, network security, data privacy protection become important challenges enterprises face.</p>', 1, 48, 1, 1762171346, 1762171346, 0, 'Data breaches, network attacks and other security threats are increasingly severe, traditional security solutions struggle to应对复杂多变的安全挑战.', '', '', '', 'Data breaches, network attacks and other security threats are increasingly severe, traditional security solutions struggle to应对复杂多变的安全挑战.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-shield-alt', '');
INSERT INTO `ry_en_article` VALUES (404, 12, 'Compatibility Issues', '', '', '<p>Poor compatibility between different devices, protocols and standards, complex system integration, high maintenance costs, limited scalability. Multi-vendor equipment, multi-protocol standards lead to difficult system integration, high maintenance costs.</p>', 1, 47, 1, 1762171346, 1762171346, 0, 'Poor compatibility between different devices, protocols and standards, complex system integration, high maintenance costs, limited scalability.', '', '', '', 'Poor compatibility between different devices, protocols and standards, complex system integration, high maintenance costs, limited scalability.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-plug', '');
INSERT INTO `ry_en_article` VALUES (405, 13, 'High Performance Computing', '', '', '<p>Adopting 7nm advanced process technology, providing industry-leading computing power density, performance improved 300%, meeting most stringent computing requirements. Through architectural innovation and process optimization, achieving leapfrog improvement in computing performance.</p>', 1, 50, 1, 1762171346, 1762171346, 0, 'Adopting 7nm advanced process technology, providing industry-leading computing power density, performance improved 300%, meeting most stringent computing requirements.', '', '', '01', 'Adopting 7nm advanced process technology, providing industry-leading computing power density, performance improved 300%, meeting most stringent computing requirements.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (406, 13, 'Low Power Design', '', '', '<p>Innovative power management technology and architectural optimization, energy efficiency ratio improved 50%, significantly reducing operating costs,符合绿色environmental protection理念. Through intelligent power management and architectural optimization, achieving optimal balance between performance and power consumption.</p>', 1, 49, 1, 1762171346, 1762171346, 0, 'Innovative power management technology and architectural optimization, energy efficiency ratio improved 50%, significantly reducing operating costs,符合绿色环保理念.', '', '', '02', 'Innovative power management technology and architectural optimization, energy efficiency ratio improved 50%, significantly reducing operating costs,符合绿色环保理念.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (407, 13, 'Comprehensive Security', '', '', '<p>Hardware-level security encryption, supporting national cryptographic algorithms, providing comprehensive security protection from chip to system, ensuring data security. Building complete security protection system from底层hardware to上层application.</p>', 1, 48, 1, 1762171346, 1762171346, 0, 'Hardware-level security encryption, supporting national cryptographic algorithms, providing comprehensive security protection from chip to system, ensuring data security.', '', '', '03', 'Hardware-level security encryption, supporting national cryptographic algorithms, providing comprehensive security protection from chip to system, ensuring data security.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (408, 13, 'High Integration', '', '', '<p>Multi-protocol compatibility, integrated hardware-software design, simplifying system integration, reducing development difficulty, shortening product time-to-market. Providing complete solutions, reducing customer integration workload.</p>', 1, 47, 1, 1762171346, 1762171346, 0, 'Multi-protocol compatibility, integrated hardware-software design, simplifying system integration, reducing development difficulty, shortening product time-to-market.', '', '', '04', 'Multi-protocol compatibility, integrated hardware-software design, simplifying system integration, reducing development difficulty, shortening product time-to-market.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (409, 14, 'Requirements Analysis', '', '', '<p>Deeply understanding industry application scenarios, analyzing key requirements like performance, power consumption, cost, etc., determining technical indicators and constraints. Through customer interviews, market research, etc., accurately grasping user requirements.</p>', 1, 50, 1, 1762171346, 1762171346, 0, 'Deeply understanding industry application scenarios, analyzing key requirements like performance, power consumption, cost, etc., determining technical indicators and constraints.', '', '', '', 'Deeply understanding industry application scenarios, analyzing key requirements like performance, power consumption, cost, etc., determining technical indicators and constraints.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-search', '');
INSERT INTO `ry_en_article` VALUES (410, 14, 'Architecture Design', '', '', '<p>Based on requirements analysis results, designing optimal chip architecture and system solutions, balancing relationships between performance, power consumption and cost. Adopting modular design理念, ensuring system scalability and maintainability.</p>', 1, 49, 1, 1762171346, 1762171346, 0, 'Based on requirements analysis results, designing optimal chip architecture and system solutions, balancing relationships between performance, power consumption and cost.', '', '', '', 'Based on requirements analysis results, designing optimal chip architecture and system solutions, balancing relationships between performance, power consumption and cost.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-pencil-alt', '');
INSERT INTO `ry_en_article` VALUES (411, 14, 'Technical Implementation', '', '', '<p>Adopting advanced process technology and packaging technology, combining self-developed IP cores, achieving high-performance, low-power chip products. Relying on strong R&D team and manufacturing capabilities, ensuring smooth implementation of technical solutions.</p>', 1, 48, 1, 1762171346, 1762171346, 0, 'Adopting advanced process technology and packaging technology, combining self-developed IP cores, achieving high-performance, low-power chip products.', '', '', '', 'Adopting advanced process technology and packaging technology, combining self-developed IP cores, achieving high-performance, low-power chip products.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-cogs', '');
INSERT INTO `ry_en_article` VALUES (412, 14, 'Verification Optimization', '', '', '<p>Through strict testing and actual scenario verification, continuously optimizing product performance and stability, ensuring solution reliability and usability. Establishing complete testing system, ensuring product quality reaches highest standards.</p>', 1, 47, 1, 1762171346, 1762171346, 0, 'Through strict testing and actual scenario verification, continuously optimizing product performance and stability, ensuring solution reliability and usability.', '', '', '', 'Through strict testing and actual scenario verification, continuously optimizing product performance and stability, ensuring solution reliability and usability.', 0, '', '', '', '', 0, 30, '', '', '', '', '', NULL, NULL, 0, '0', 'fa-check-circle', '');
INSERT INTO `ry_en_article` VALUES (413, 15, 'AI Computing Solution', '/uploads/images/solution/ai-solution.jpg', '', '<p>Providing high-performance computing support for artificial intelligence applications, supporting multiple neural network models, suitable for cloud and edge computing scenarios. Based on self-developed AI chips, providing complete AI computing solutions.</p>', 1, 50, 1, 1762171346, 1762260799, 0, 'Providing high-performance computing support for artificial intelligence applications, supporting multiple neural network models, suitable for cloud and edge computing scenarios', '', 'Hot', '', 'Providing high-performance computing support for artificial intelligence applications, supporting multiple neural network models, suitable for cloud and edge computing scenarios.', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>High-performance AI computing architecture, supporting multiple neural network models, providing complete solutions from training to inference.</p>', '<p>Need to select appropriate computing resource configuration according to specific application scenarios.</p>', 280, '0', 'fa-brain', 'Artificial Intelligence,Blockchain,Machine Learning,Backend Development,User Experience,Performance Optimization');
INSERT INTO `ry_en_article` VALUES (414, 15, 'IoT Connectivity Solution', '/uploads/images/solution/iot-solution.jpg', '', '<p>Low-power, multi-protocol IoT chips, supporting multiple communication methods like Wi-Fi, Bluetooth, LoRa, etc., suitable for scenarios like smart home, smart city, etc. Providing complete IoT connectivity solutions.</p>', 1, 49, 1, 1762171346, 1762260810, 0, 'Low-power, multi-protocol IoT chips, supporting multiple communication methods like Wi-Fi, Bluetooth, LoRa, etc., suitable for scenarios like smart home, smart city, etc.', '', 'Main Promotion', '', 'Low-power, multi-protocol IoT chips, supporting multiple communication methods like Wi-Fi, Bluetooth, LoRa, etc., suitable for scenarios like smart home, smart city, etc.', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>Ultra-low power design, multi-protocol compatibility, supporting large-scale device connections.</p>', '<p>Need to select appropriate communication protocols according to specific application scenarios.</p>', 203, '0', 'fa-network-wired', 'Blockchain,IoT,Cloud Computing,Mobile Development,Backend Development,Open Source Projects');
INSERT INTO `ry_en_article` VALUES (415, 15, 'Automotive Electronics Solution', '/uploads/images/solution/pro4.jpg', '', '<p>Automotive-grade safety chips, meeting ASIL-D safety level requirements, suitable for systems like autonomous driving, in-vehicle entertainment, battery management, etc. Providing reliable electronic solutions for intelligent connected vehicles.</p>', 1, 48, 1, 1762171346, 1762260822, 0, 'Automotive-grade safety chips, meeting ASIL-D safety level requirements, suitable for systems like autonomous driving, in-vehicle entertainment, battery management, etc.', '', 'New Product', '', 'Automotive-grade safety chips, meeting ASIL-D safety level requirements, suitable for systems like autonomous driving, in-vehicle entertainment, battery management, etc.', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>Automotive-grade certification, high reliability design, meeting stringent automotive electronics requirements.</p>', '<p>Need to comply with automotive industry related standards and certification requirements.</p>', 200, '0', 'fa-car-battery', 'Database,5G Technology,IoT,Artificial Intelligence,Blockchain');
INSERT INTO `ry_en_article` VALUES (416, 15, 'Industrial Automation Solution', '/uploads/images/solution/industrial-solution.jpg', '', '<p>High-reliability industrial control chips, supporting real-time operating systems, suitable for scenarios like industrial robots, automated production lines, etc. Providing powerful control core for Industry 4.0.</p>', 1, 47, 1, 1762171346, 1762260770, 0, 'High-reliability industrial control chips, supporting real-time operating systems, suitable for scenarios like industrial robots, automated production lines, etc.', '', 'Hot Sale', '', 'High-reliability industrial control chips, supporting real-time operating systems, suitable for scenarios like industrial robots, automated production lines, etc.', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>Industrial-grade reliability, excellent real-time performance, supporting complex control algorithms.</p>', '<p>Need to select appropriate protection levels according to specific industrial environments.</p>', 189, '0', 'fa-industry', 'Machine Learning,Backend Development,Mobile Development,IoT,Cloud Computing,DevOps');
INSERT INTO `ry_en_article` VALUES (417, 15, 'Security Encryption Solution', '/uploads/images/solution/pro3.jpg', '', '<p>Hardware-level security encryption chips, providing national cryptographic algorithm support, suitable for security-sensitive scenarios like financial payments, identity authentication, etc. Building trusted computing environment, ensuring information security.</p>', 1, 46, 1, 1762171346, 1762260838, 0, 'Hardware-level security encryption chips, providing national cryptographic algorithm support, suitable for security-sensitive scenarios like financial payments, identity authentication, etc.', '', 'Main Promotion', '', 'Hardware-level security encryption chips, providing national cryptographic algorithm support, suitable for security-sensitive scenarios like financial payments, identity authentication, etc.', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>Hardware-level encryption, supporting national cryptographic algorithms, providing comprehensive security protection.</p>', '<p>Need strict management of keys and certificates to ensure system security.</p>', 212, '0', 'fa-shield-alt', 'Cybersecurity,Database,Performance Optimization,Open Source Projects,Container Technology');
INSERT INTO `ry_en_article` VALUES (418, 15, 'High Performance Computing Solution', '/uploads/images/solution/pro2.jpg', '', '<p>Multi-core high-performance computing chips, supporting large-scale parallel computing, suitable for high-performance scenarios like scientific computing, data centers, etc. Providing powerful computing power support for compute-intensive applications.</p>', 1, 45, 1, 1762171346, 1762260853, 0, 'Multi-core high-performance computing chips, supporting large-scale parallel computing, suitable for high-performance scenarios like scientific computing, data centers, etc.', '', 'Hot', '', 'Multi-core high-performance computing chips, supporting large-scale parallel computing, suitable for high-performance scenarios like scientific computing, data centers, etc.', 0, '', '', '', '', 1, 30, '', '', '', '', '', '<p>Multi-core architecture, high parallel computing capability, supporting complex scientific computing.</p>', '<p>Need supporting efficient cooling and power supply systems.</p>', 188, '0', 'fa-bolt', 'Cybersecurity,Frontend Development,Backend Development,Mobile Development,Database');
INSERT INTO `ry_en_article` VALUES (419, 24, 'AI Algorithm Engineer', '', '', '<p>We are looking for an experienced AI algorithm engineer to join our core R&D team. As an AI algorithm engineer, you will be responsible for the entire process from algorithm design to product implementation, promoting artificial intelligence technology application in actual business scenarios.</p><p>Main work content includes: responsible for machine learning, deep learning algorithm R&D and optimization; designing and implementing efficient model training and inference processes; participating in large-scale dataset construction and processing; collaborating with hardware team for algorithm-hardware协同 optimization; tracking industry latest technology progress and applying to actual projects.</p><p>We provide competitive salary待遇, complete career development channels and rich technical learning resources. Join us, you will have opportunity to participate in cutting-edge AI technology R&D, work with industry leading expert teams, realize personal value in artificial intelligence wave.</p>', 1, 50, 1, 1762185600, 1762185600, 0, 'Responsible for AI algorithm R&D and optimization, including model design, training and deployment', '', 'AI Algorithm,Machine Learning,Deep Learning,Algorithm Engineer', '', 'Recruiting AI algorithm engineer, requires computer, mathematics等相关专业硕士学历, 3+ years machine learning experience, proficient in Python and deep learning frameworks.', 0, '', '', 'Human Resources Department', 'Recruitment Information', 1, 30, '', '', '', '', '', '<ul>\n                                        <li>Computer, Mathematics, Statistics and other related majors master degree or above</li>\n                                        <li>3+ years machine learning/deep learning related work experience</li>\n                                        <li>Proficient in Python, familiar with TensorFlow/PyTorch and other frameworks</li>\n                                        <li>Experience in model compression, quantization or hardware acceleration preferred</li>\n                                        <li>Familiar with common machine learning algorithms and deep learning models</li>\n                                        <li>Good mathematical foundation and algorithm design ability</li>\n                                        <li>Experience in large-scale data processing and distributed training</li>\n                                        <li>Good team collaboration and communication skills</li>\n                                        <li>Paper publications or open source project contributions preferred</li>\n                                    </ul>', '<p>Candidates need to provide detailed resume and project experience, interview process includes technical written test, multiple technical interviews and HR interview. After successful onboarding, there will be 3 months probation period, during which company provides complete training and guidance.</p>', 57, '0', '', 'Shenzhen,Full-time,30-50K,AI Algorithm');
INSERT INTO `ry_en_article` VALUES (420, 24, 'Chip Design Engineer', '', '', '<p>We sincerely invite chip design engineers to join our hardware R&D team,共同打造 next-generation high-performance AI chips. As chip design engineer, you will participate in full-process chip development from architecture design to tape-out verification.</p><p>Main responsibilities include: participating in chip architecture design and module partitioning; responsible for RTL design, simulation and verification; performing timing analysis, power analysis and optimization; collaborating with backend team to complete physical implementation; participating in chip testing and debugging work.</p><p>We provide industry-leading salary待遇, complete chip development platform and rich learning growth opportunities. Join us, you will have opportunity to participate in most cutting-edge chip technology R&D, achieve technical breakthrough in semiconductor field.</p>', 1, 49, 1, 1762185600, 1762185600, 0, 'Responsible for chip architecture design, RTL implementation and verification work', '', 'Chip Design,Digital Circuit,ASIC,RTL Design', '', 'Recruiting chip design engineer, requires microelectronics等相关专业本科以上学历, familiar with digital circuit design process, ASIC design experience preferred.', 0, '', '', 'Human Resources Department', 'Recruitment Information', 1, 30, '', '', '', '', '', '<ul>\n                                        <li>Microelectronics, Electronic Engineering, Computer and other related majors bachelor degree or above</li>\n                                        <li>2+ years digital circuit design or verification experience</li>\n                                        <li>Familiar with Verilog/SystemVerilog and other hardware description languages</li>\n                                        <li>Understand ASIC design process and EDA tool usage</li>\n                                        <li>FPGA verification or tape-out experience preferred</li>\n                                        <li>Familiar with computer architecture and bus protocols</li>\n                                        <li>Good problem analysis and solving ability</li>\n                                        <li>Team collaboration spirit and learning ability</li>\n                                        <li>AI accelerator design experience preferred</li>\n                                    </ul>', '<p>Chip design position requires strong technical background and engineering practice ability, interview will focus on digital circuit design foundation and project experience. Company provides complete chip design toolchain and development environment.</p>', 17, '0', '', 'Shanghai,Full-time,35-60K,Chip Design');
INSERT INTO `ry_en_article` VALUES (421, 24, 'Frontend Development Engineer', '', '', '<p>Recruiting frontend development engineer, responsible for company product frontend architecture design and development work. You will participate in full-process frontend development from product prototype to online deployment, creating excellent user interaction experience.</p><p>Main work content: responsible for Web frontend architecture design and development; optimizing frontend performance and user experience; collaborating with UI/UX designers achieving product interaction; developing reusable frontend component libraries; participating in frontend engineering construction and toolchain optimization.</p><p>We provide competitive salary待遇, technical sharing culture and broad development space. Join us, you will have opportunity to participate in large project frontend architecture design, continuously突破innovation in frontend technology field.</p>', 1, 48, 1, 1762185600, 1762185600, 0, 'Responsible for Web frontend architecture design and development, optimizing user experience and frontend performance', '', 'Frontend Development,Vue.js,React,JavaScript', '', 'Recruiting frontend development engineer, requires computer相关专业, 3 years frontend development experience, proficient in Vue.js/React and other frameworks, large project experience preferred.', 0, '', '', 'Human Resources Department', 'Recruitment Information', 1, 30, '', '', '', '', '', '<ul>\n                                        <li>Computer, Software Engineering and other related majors bachelor degree or above</li>\n                                        <li>3+ years Web frontend development experience</li>\n                                        <li>Proficient in JavaScript, HTML5, CSS3 and other frontend technologies</li>\n                                        <li>Master at least one mainstream framework like Vue.js, React</li>\n                                        <li>Experience in frontend engineering, performance optimization</li>\n                                        <li>Understand frontend security, cross-domain and other common problem solutions</li>\n                                        <li>Mobile H5 development or mini-program development experience</li>\n                                        <li>Good code standards and team collaboration ability</li>\n                                        <li>Large project architecture experience preferred</li>\n                                    </ul>', '<p>Frontend development engineer needs solid programming foundation and good product awareness, interview will focus on frontend technology depth and project experience. Company provides MacBook Pro and other development equipment.</p>', 5, '0', '', 'Beijing,Full-time,25-40K,Frontend Development');
INSERT INTO `ry_en_article` VALUES (422, 24, 'Product Manager', '', '', '<p>Recruiting senior product manager, responsible for AI chip and related software product planning and management work. You will deeply understand customer needs, define product direction, promoting product entire process from concept to implementation.</p><p>Main responsibilities: responsible for product planning, requirements analysis and function design; writing product requirement documents and prototype design; coordinating R&D, testing, operation and other teams promoting product development; conducting market research and competitive analysis; tracking product data and continuously optimizing product experience.</p><p>We provide product managers sufficient decision space, cross-department collaboration opportunities and product full lifecycle management experience. Here, you will become bridge connecting technology and market, creating industry influential products.</p>', 1, 47, 1, 1762185600, 1762185600, 0, 'Responsible for AI chip and software product planning, requirements analysis and product management', '', 'Product Manager,Product Planning,Requirements Analysis,AI Product', '', 'Recruiting product manager, requires computer or相关专业, 3+ years product experience, familiar with AI or chip industry, successful product cases preferred.', 0, '', '', 'Human Resources Department', 'Recruitment Information', 1, 30, '', '', '', '', '', '<ul>\n                                        <li>Computer, Electronic Engineering, Business Administration and other related majors bachelor degree or above</li>\n                                        <li>3+ years product manager work experience, AI or hardware product experience preferred</li>\n                                        <li>Familiar with product design tools, able to independently complete PRD and prototype design</li>\n                                        <li>Good market analysis, user research and requirements mining ability</li>\n                                        <li>Excellent communication coordination and project management ability</li>\n                                        <li>Data sensitive, data analysis ability and product thinking</li>\n                                        <li>Team management experience preferred</li>\n                                        <li>Strong interest in AI technology and chip industry</li>\n                                        <li>English reading and writing ability, able to read technical documents</li>\n                                    </ul>', '<p>Product manager position requires technical understanding ability and business thinking, interview will focus on product thinking, communication ability and project experience. After successful onboarding, will be responsible for important product line management work.</p>', 14, '0', '', 'Shenzhen,Full-time,30-55K,Product Manager');
INSERT INTO `ry_en_article` VALUES (423, 17, 'Silicon Core Technology and Huawei Reach Strategic Cooperation Signing Ceremony', '/uploads/images/news/news13.jpg', '', '<p>Silicon Core Technology today announced strategic cooperation agreement with Huawei Technologies Co., Ltd., both parties will conduct deep cooperation in AI chip R&D, ecosystem construction, market expansion and other fields. This cooperation will fully leverage both parties advantages in chip design, algorithm optimization and industrial application.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news14.jpg\" alt=\"Signing Ceremony\"></p><p>According to agreement, Silicon Core Technology will jointly develop AI chip solutions for 5G and edge computing scenarios with Huawei, and promote related technologyscale化 application in smart manufacturing, smart city and other fields. Both parties will also共建 joint laboratory, conduct cutting-edge technology research.</p><p>Silicon Core Technology chairman stated: \"Cooperation with Huawei will accelerate our technology innovation and industrial implementation in AI chip field. We look forward to promoting Chinese chip industry development throughadvantage互补.\"</p><p>This cooperation is expected to drive Silicon Core Technology annual revenue growth over 20%, further consolidating its leading position in AI chip market.</p>', 1, 47, 1, 1762229348, 1762229348, 0, 'Silicon Core Technology and Huawei Technologies Co., Ltd. reach strategic cooperation agreement, will cooperate in AI chip R&D, ecosystem construction and other fields', '', 'Strategic Cooperation,Huawei,AI Chip,Ecosystem Construction', '', 'Silicon Core Technology and Huawei reach strategic cooperation, jointly promote AI chip ecosystem construction,共建 joint laboratory.', 0, '', '', 'Cooperation Development Department', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (424, 17, 'Silicon Core Technology 2024 Q3 Financial Report Released', '/uploads/images/news/news15.jpg', '', '<p>Silicon Core Technology今day发布2024year第三quarter财务报告，company实现营业revenue25.6亿元，同比growth45.2%；净profit达到5.8亿元，同比growth52.3%。业绩growth主要得益于AIchip和Internet of Thingschip业务的强劲表现。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news16.jpg\" alt=\"财报data\"/></p><p>财报显示，AIchip业务revenue同比growth68%，Internet of Thingschip业务growth35%，automotive electronicschip业务growth42%。companyR&D投入达到4.2亿元，占营收比例16.4%，较去year同期enhance2.1个百minute点。</p><p>companyCEO在财报电话会议上表示：&quot;第三quarter的优异表现证明了我们在AI和Internet of Things领域的strategy布局是正确的。我们将continue加大R&D投入，maintain在technology上的advancedadvantage。&quot;</p><p>基于良好的业绩表现，company上调了全year营收指引，预计2024year全year营收将突破100亿元。</p>', 1, 46, 1, 1762142948, 1762249547, 0, 'Silicon Core Tech releases 2024 Q3 financial report, company achieves revenue of 25.6 billion yuan, year-on-year growth of 45.2%', '', 'Financial Report,Performance Growth,AI Chip,Revenue', '', 'Silicon Core Tech 2024 Q3 revenue 25.6 billion yuan, year-on-year growth 45.2%, AI chip business growth 68%.', 1, '', '', 'Finance Department', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (425, 18, 'Global Semiconductor Industry Welcomes New Round of Investment Development Boom', '/uploads/images/news/news17.jpg', '', '<p>随着artificial intelligence、Internet of Things、新energy汽车等新兴technology的快速development，全球semiconductor产业正迎来新一轮investment热潮。据统计，2024year上半year全球semiconductor领域investment金额超过2000亿美元，创历史新高。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news18.jpg\" alt=\"investmenttrend\"></p><p>investment主要集中在advancedprocess technology、packagingtesting、材料equipment等环节。其中，AIchip、automotive electronics、industrysemiconductor成为最受资本青睐的细minute领域。各国政府也纷纷出台政策supportsemiconductor产业development。</p><p>industry专家minute析认为，这轮investment热潮将推动semiconductortechnology加速innovation，但也possibly带来产能过剩的risk。enterpriseneed精准把握market需求，避免盲目扩张。</p><p>预计到2025year，全球semiconductor产业scale有望突破7000亿美元，中国market的表现将continue领跑全球。</p>', 1, 48, 1, 1762056548, 1762056548, 0, 'With development of emerging technologies like AI and IoT, global semiconductor industry is welcoming new round of investment boom', '', 'Semiconductor Investment,Industry Trends,AI Chip,Automotive Electronics', '', 'Global semiconductor industry welcomes investment boom, 2024 first half investment exceeds $200 billion, AI chip and other segments most concerned.', 0, '', '', 'Industry Analyst', 'Industry Research Report', 1, 30, '', '', '', '', '', NULL, NULL, 6, '0', '', '');
INSERT INTO `ry_en_article` VALUES (426, 18, 'Chip Shortage Problem Gradually Easing But Structural Shortages Remain', '/uploads/images/news/news19.jpg', '', '<p>经过两year的全球chip短缺危机，目前整体供应情况currently逐步改善，但automotive electronics、industry控制等领域的结构性短缺problem依然存在。industryminute析显示，成熟process technologychip的供应紧张状况预计将持续到2025year。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news20.jpg\" alt=\"supply chainminute析\"/></p><p>data显示，2024year第三quarter全球chip交货cycle平均为20周，较去year同期的30周明显缩短。但在功率semiconductor、MCU等product领域，供应仍然偏紧，pricemaintain高位运行。</p><p>supply chain专家指出，地缘politics因素、疫情反复、natural灾害等不确定性因素仍然impact着chipsupply chain的stability。enterpriseneed建立更加灵活和diversification的supply chain体系。</p><p>预计到2025year下半year，随着新增产能的陆续释放，chip供应紧张局面将得到根本性缓解。</p>', 1, 47, 1, 1761970148, 1762249559, 0, 'Global chip shortage crisis overall supply situation gradually improving, but structural shortages in automotive electronics and other fields still exist', '', 'Chip Shortage,Supply Chain,Automotive Electronics,Capacity', '', 'Global chip shortage gradually easing, but structural shortages in automotive electronics and other fields remain, mature process chip supply tightness will continue.', 1, '', '', 'Supply Chain Expert', 'Industry Analysis Report', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (427, 19, 'Silicon Core Tech Breaks Through 2.5D Packaging Technology R&D Achievement', '/uploads/images/news/news21.jpg', '', '<p>Silicon Core Technologypackagingtechnology实验室近day在2.5Dpackagingtechnology上取得重大突破，successdevelopment出基于硅中介层的2.5Dpackagingsolution。该technology通过将多个chip在level方向上进行集成，大幅enhance了chip间的communication带宽和energy efficiency比。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news22.jpg\" alt=\"2.5Dpackaging\"/></p><p>testingdata显示，采用2.5Dpackagingtechnology的AIchip，performanceenhance30%，power consumptionreduce25%。chip间互联密度达到传统packagingtechnology的5倍，信号传输延迟reduce60%。</p><p>这项technology突破为高performance计算、artificial intelligence等need大scale并行计算的application场景提供了新的solution。Silicon Core Technologyplan在next generationAI训练chip中率先application该packagingtechnology。</p><p>2.5Dpackagingtechnology的成熟将推动chip集成度向更高leveldevelopment，为摩尔定律的延续提供了新的technology路径。</p>', 1, 48, 1, 1761883748, 1762249571, 0, 'Silicon Core Tech packaging technology laboratory achieves major breakthrough in 2.5D packaging technology, successfully develops silicon interposer-based solution', '', '2.5D Packaging,Chip Integration,Performance Improvement,Advanced Packaging', '', 'Silicon Core Tech breaks through 2.5D packaging technology, chip performance improved 30%, power consumption reduced 25%, promoting chip integration level improvement.', 1, '', '', 'Packaging Laboratory', 'Technology R&D Trends', 1, 30, '', '', '', '', '', '', NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (428, 19, 'New Quantum Dot Material Application in Chip Heat Dissipation Field', '/uploads/images/news/news23.jpg', '', '<p>Silicon Core Technology材料research中心与高校cooperation，在量子点材料application于chipheat dissipation领域取得important进展。researchteamdevelopment出一种基于石墨烯量子点的复合heat dissipation材料，热导率比传统材料enhance5倍以上。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news24.jpg\" alt=\"量子点材料\"></p><p>这种新型heat dissipation材料通过在石墨烯基底上定向生长量子点，形成了efficient的heat conduction通道。在相同厚度下，heat dissipationeffect比传统导热硅脂enhance300%，且具有良好的机械强度和stability。</p><p>该材料已在小批量试产中验证了其reliability，预计将在next generation高performance计算chip中scale化application。researchteamcurrently进一步optimize材料配方，争取在2025year实现mass production。</p><p>量子点heat dissipationtechnology的突破将有效解决高performancechip的heat dissipation bottleneck，为chipperformance的持续enhance提供了important支撑。</p>', 1, 47, 1, 1761797348, 1761797348, 0, 'Silicon Core Tech Materials Research Center cooperates with universities, achieves important progress in quantum dot material application in chip heat dissipation field', '', 'Quantum Dot,Heat Dissipation Material,Thermal Conductivity,Graphene', '', 'Silicon Core Tech develops quantum dot heat dissipation material, thermal conductivity improved 5 times, effectively solving high-performance chip heat dissipation bottleneck.', 0, '', '', 'Materials Research Center', 'Technology R&D Trends', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (429, 20, 'Silicon Core Technology to Host 2024 Technology Innovation Conference', '/uploads/images/news/news25.jpg', '', '<p>Silicon Core Technology announces will host \"2024 Silicon Core Technology Innovation Conference\" at Beijing National Convention Center next month. This conference with theme \"Intelligent Creation Future, Chip Moves World\" will showcase company\'s latest technology achievements in AI chips, IoT, automotive electronics and other fields.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news26.jpg\" alt=\"Conference Preview\"></p><p>Conference will set up main forum and multiple sub-forums, covering hot topics like AI chip architecture innovation, edge computing, autonomous driving, industrial IoT, etc. Company CTO will release new generation chip technology roadmap, multiple industry experts will share technical insights.</p><p>Participants can also personally experience various innovative applications based on Silicon Core chips, including smart robots, autonomous driving demonstrations, industrial IoT solutions, etc. During conference will also host technical workshops and partner exchange meetings.</p><p>Expected over 2000 industry experts, customer representatives, partners and media reporters will attend this conference, becoming one of most important industry technology events of the year.</p>', 1, 48, 1, 1761710948, 1761710948, 0, 'Silicon Core Tech announces will host 2024 Technology Innovation Conference, showcasing latest technology achievements', '', 'Technology Conference,Innovation Showcase,Industry Event', '', 'Silicon Core Tech to host 2024 Technology Innovation Conference, showcasing latest technology achievements in AI chips, IoT, automotive electronics and other fields.', 0, '', '', 'Conference Organizing Committee', 'Event Preview', 1, 30, '', '', '', '', '', NULL, NULL, 5, '0', '', '');
INSERT INTO `ry_en_article` VALUES (430, 20, 'Silicon Core Technology Public Welfare Foundation Officially Established', '/uploads/images/news/news27.jpg', '', '<p>Silicon Core Technology today announces official establishment of \"Silicon Core Technology Public Welfare Foundation\", initial donation funds 100 million yuan. Foundation will focus on three directions: technology education, talent cultivation, industrial poverty alleviation, promoting deep integration of technological innovation and social responsibility.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news28.jpg\" alt=\"Foundation Establishment\"></p><p>Foundation first batch projects include \"Chip Spark Plan\" - supporting university chip talent cultivation; \"Smart Benefiting Villages\" - using technology to assist rural revitalization; \"Technology Sailing\" - science education activities for teenagers. Expected to benefit over 100,000 people annually.</p><p>Company chairman stated at establishment ceremony: \"As technology enterprise, we not only pursue technological innovation and commercial success, but also bear social responsibility, give back to society. Foundation establishment is important milestone for company fulfilling social responsibility.\"</p><p>Silicon Core Technology Public Welfare Foundation will establish transparent management mechanism, regularly publish project progress and fund usage to society, striving for effective implementation of public welfare projects.</p>', 1, 47, 1, 1761624548, 1761624548, 0, 'Silicon Core Tech announces official establishment of public welfare foundation, initial donation 100 million yuan', '', 'Public Welfare Foundation,Social Responsibility,Technology Education', '', 'Silicon Core Tech establishes public welfare foundation, initial donation 100 million yuan, focusing on technology education, talent cultivation and industrial poverty alleviation.', 0, '', '', 'Public Welfare Department', 'Corporate Social Responsibility', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (431, 17, 'Silicon Core Tech Obtains ISO26262 Functional Safety Certification', '/uploads/images/news/news29.jpg', '', '<p>Silicon Core Technology今day宣布，其automotive electronicschipR&D体系success通过道路车辆功能safestandard功能safecertification，这标志着company在automotive electronics领域的technology实力和managementlevel达到了国际advancedstandard。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news30.jpg\" alt=\"certification证书\"/></p><p>道路车辆功能safestandard是automotive electronics领域最important的功能safestandard，涵盖了从概念design到product退役的全生命cyclesafemanagement。获得该certification意味着Silicon Core Technology的automotive electronicschip在功能safe方面达到了车规级require。</p><p>certification过程历hour18个month，company建立了完整的功能safemanagement体系，training了超过100名功能safeengineering师。目前，已有多个基于该体系的automotive electronicschipproject在推进中。</p><p>这项certification将有力推动Silicon Core Technology在automotive electronicsmarket的拓展，特别是在autonomous driving、intelligent座舱等saferequire高的application领域。</p>', 1, 45, 1, 1761538148, 1762249538, 0, 'Silicon Core Tech automotive electronics chip R&D system successfully passes ISO26262 functional safety certification, reaching international advanced standards', '', 'ISO26262,Functional Safety,Automotive Electronics,Certification', '', 'Silicon Core Tech obtains ISO 26262 functional safety certification, automotive electronics chip R&D system reaches international advanced standards.', 1, '', '', 'Quality Certification Department', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', '', NULL, 10, '0', '', '');
INSERT INTO `ry_en_article` VALUES (432, 19, 'Optical Computing Chip R&D Achieves Important Stage Results', '/uploads/images/news/news31.jpg', '', '<p>Silicon Core Technology前沿technologyresearch院在光计算chipR&D方面取得importantstage性achievement。researchteamsuccessdevelopment出基于硅光子的矩阵计算单元原型，在特定AI推理task中展现出巨大潜力。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news32.jpg\" alt=\"光计算chip\"></p><p>光计算chip利用光子代替电子进行information处理，具有超高speed、超低power consumption的advantage。testingdata显示，光计算单元在矩阵乘法运算中的energy efficiency比达到传统电子chip的100倍以上。</p><p>目前，researchteamcurrently解决光计算chip的集成度和manufacturingprocess等keytechnologychallenge。预计在3-5year内，光计算technology将在AI推理等特定场景实现商业化application。</p><p>光计算被认为是后摩尔hour代的importanttechnology方向之一，这项researchachievement为Silicon Core Technology在next generation计算technology领域奠定了importantbasic。</p>', 1, 46, 1, 1761451748, 1761451748, 0, 'Silicon Core Tech Frontier Technology Research Institute achieves important stage results in optical computing chip R&D, develops silicon photonics computing unit', '', 'Optical Computing,Silicon Photonics,AI Inference,Energy Efficiency Ratio', '', 'Silicon Core Tech optical computing chip R&D achieves stage results, energy efficiency ratio reaches 100x traditional chips, providing new solutions for AI inference.', 0, '', '', 'Frontier Technology Research Institute', 'Technology R&D Trends', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (500, 5, 'Nationally Recognized High-tech Enterprise', '', '', '2018 obtained National High-tech Enterprise certification', 1, 60, 1, 1762246895, 1762246895, 0, '2018 obtained National High-tech Enterprise certification', '', 'High-tech Enterprise,National Certification,Enterprise Qualification', '', 'Silicon Core Technology obtained nationally recognized high-tech enterprise certification in 2018, marking company\'s technology innovation and R&D strength reaching nationally recognized standards.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>National authoritative recognition of enterprise technology innovation capability</p><p>Reflects company strength in R&D investment and technology achievement transformation</p><p>Provides policy support and brand endorsement for subsequent development</p>', '<p>Need periodic review to maintain certification qualification</p>', 0, '0', 'fa-award', '');
INSERT INTO `ry_en_article` VALUES (501, 5, 'Top 10 Chinese Chip Design Enterprises', '', '', '2020入选 Chinese chip design industry top 10', 1, 59, 1, 1762246895, 1762246895, 0, '2020入选 Chinese chip design industry top 10', '', 'Chip Design Top 10,Industry Ranking,Leading Enterprise', '', 'Silicon Core Technology入选 Chinese chip design industry top 10 enterprises in 2020, demonstrating comprehensive strength and industry position in chip design field.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Industry authoritative organization selected top 10 enterprises</p><p>Reflects company comprehensive competitiveness in chip design field</p><p>Gains wide recognition from industry and market</p>', '<p>Need to continuously maintain technology excellence and market share</p>', 0, '0', 'fa-trophy', '');
INSERT INTO `ry_en_article` VALUES (502, 5, 'Technology Innovation Gold Award', '', '', '2021 won electronics industry technology innovation gold award', 1, 58, 1, 1762246895, 1762246895, 0, '2021 won electronics industry technology innovation gold award', '', 'Technology Innovation Gold Award,Electronics Industry,Technology Award', '', 'Silicon Core Technology won electronics industry technology innovation gold award in 2021, recognizing company outstanding contributions in technology innovation and product R&D.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Electronics industry authoritative technology innovation award</p><p>Recognizes company achievements in technology R&D and innovative applications</p><p>Enhances brand influence and industry知名度</p>', '<p>Need continuous innovation to maintain award value</p>', 0, '0', 'fa-medal', '');
INSERT INTO `ry_en_article` VALUES (503, 5, 'ISO9001 Quality System Certification', '', '', 'Passed International Organization for Standardization quality system certification', 1, 57, 1, 1762246895, 1762246895, 0, 'Passed International Organization for Standardization quality system certification', '', 'ISO9001,Quality System,International Certification', '', 'Silicon Core Technology passed ISO9001 international quality system certification, established complete quality management system, ensuring high quality standards for products and services.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Internationally recognized quality management system standard</p><p>Ensures quality control in product R&D and production process</p><p>Enhances customer trust and market competitiveness</p>', '<p>Need strict execution and maintenance of quality management system</p>', 0, '0', 'fa-certificate', '');
INSERT INTO `ry_en_article` VALUES (504, 5, 'Excellent Employer Enterprise', '', '', '2022year荣获较好雇主enterprise称号', 1, 56, 1, 1762246895, 1762246895, 0, '2022年荣获较好雇主企业称号', '', '较好雇主,人力资源管理,企业文化', '', 'Silicon Core Technology在2022年荣获较好雇主企业称号，体现了公司在人才发展、企业文化和员工关怀方面的卓越表现。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>优秀的人才吸引和保留能力</p><p>良好的企业文化和员工发展环境</p><p>提升企业形象和人才竞争力</p>', '<p>需要持续投入人力资源建设</p>', 0, '0', 'fa-star', '');
INSERT INTO `ry_en_article` VALUES (505, 5, 'Industry Leading Enterprise', '', '', '2023year被评为chipindustry领军enterprise', 1, 55, 1, 1762246895, 1762246895, 0, '2023年被评为芯片行业领军企业', '', '行业领军,芯片行业,领导地位', '', 'Silicon Core Technology在2023年被评为chip行业领军企业，确立了在chip设计制造领域的领导地位和行业影响力。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>行业领导地位和市场影响力</p><p>技术引领和产业带动作用</p><p>为行业发展做出重要贡献</p>', '<p>需要承担更多的行业责任和引领作用</p>', 0, '0', 'fa-crown', '');
INSERT INTO `ry_en_article` VALUES (506, 5, 'Specialized, Refined, Unique, Innovative Little Giant Enterprise', '', '', '2022year入选国家认可专精特新小巨人enterprise', 1, 54, 1, 1762246895, 1762246895, 0, '2022年入选国家认可专精特新小巨人企业', '', '专精特新,小巨人,专业化企业', '', 'Silicon Core Technology在2022年入选国家认可专精特新小巨人企业，体现了公司在专业化、精细化、特色化、新颖化发展方面的突出表现。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>国家支持的专业化特色企业发展计划</p><p>在细分领域具有技术优势和市场份额</p><p>获得政策支持和资源倾斜</p>', '<p>需要持续专注细分领域的技术突破</p>', 0, '0', 'fa-rocket', '');
INSERT INTO `ry_en_article` VALUES (507, 5, 'Intellectual Property Demonstration Enterprise', '', '', '2021year被评为国家intellectual property示范enterprise', 1, 53, 1, 1762246895, 1762246895, 0, '2021年被评为国家知识产权示范企业', '', '知识产权,示范企业,专利保护', '', 'Silicon Core Technology在2021年被评为国家知识产权示范企业，展示了公司在知识产权创造、运用和保护方面的卓越能力。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>知识产权管理和保护体系完善</p><p>专利数量和质量行业先进</p><p>为技术创新提供法律支持</p>', '<p>需要持续加强知识产权布局和保护</p>', 0, '0', 'fa-gem', '');
INSERT INTO `ry_en_article` VALUES (508, 5, 'Green Manufacturing Demonstration Enterprise', '', '', '2023year获得绿色manufacturing示范enterprise称号', 1, 52, 1, 1762246895, 1762246895, 0, '2023年获得绿色制造示范企业称号', '', '绿色制造,环保认证,可持续发展', '', 'Silicon Core Technology在2023年获得绿色制造示范企业称号，体现了公司在环保生产和可持续发展方面的社会责任。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>生产过程中的环保和节能措施</p><p>绿色产品设计和制造理念</p><p>符合国家双碳战略要求</p>', '<p>需要持续投入环保技术和设备</p>', 0, '0', 'fa-leaf', '');
INSERT INTO `ry_en_article` VALUES (509, 5, 'Digital Transformation Demonstration Enterprise', '', '', '2022year入选industryinternetdigital转型示范enterprise', 1, 51, 1, 1762246895, 1762246895, 0, '2022年入选工业互联网数字化转型示范企业', '', '数字化转型,工业互联网,智能制造', '', 'Silicon Core Technology在2022年入选工业互联网数字化转型示范企业，展示了公司在smart manufacturing和数字化管理方面的优秀实践。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>生产制造过程的数字化智能化</p><p>工业互联网平台的应用实践</p><p>提升生产效率和产品质量</p>', '<p>需要持续投入数字化技术升级</p>', 0, '0', 'fa-laptop-code', '');
INSERT INTO `ry_en_article` VALUES (510, 5, 'Social Responsibility Excellent Enterprise', '', '', '2023year获得enterprisesocietyresponsibilityexcellententerprise奖', 1, 50, 1, 1762246895, 1762246895, 0, '2023年获得企业社会责任优秀企业奖', '', '社会责任,企业公民,公益贡献', '', 'Silicon Core Technology在2023年获得企业社会责任优秀企业奖，表彰公司在社会责任履行和公益事业方面的突出贡献。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>积极参与社会公益和慈善事业</p><p>关注员工福利和社区发展</p><p>践行企业公民责任</p>', '<p>需要持续投入社会责任项目</p>', 0, '0', 'fa-hand-holding-heart', '');
INSERT INTO `ry_en_article` VALUES (511, 5, 'International Quality Gold Award', '', '', '2024year荣获国际quality金奖', 1, 49, 1, 1762246895, 1762246895, 0, '2024年荣获国际质量金奖', '', '国际质量金奖,质量管理,卓越绩效', '', 'Silicon Core Technology在2024年荣获国际质量金奖，标志着公司在质量管理体系和产品品质方面达到国际先进水平。', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>国际权威质量奖项认可</p><p>质量管理体系达到国际标准</p><p>产品品质获得全球客户信赖</p>', '<p>需要持续维护和提升质量标准</p>', 0, '0', 'fa-trophy', '');
INSERT INTO `ry_en_article` VALUES (512, 2, 'R&D Team', '', '', '', 1, 60, 1, 1762248029, 1762248356, 0, '500', '', 'R&D Team,Technical Talent,Innovation Power', '', 'Silicon Core Technology has 500 professional R&D team members, covering multiple technical fields including chip design, algorithm development, system architecture.', 1, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Professional technical R&D talent team</p><p>Continuous technology innovation and product R&D</p><p>Provides technical support for industry development</p>', '<p>Need to continuously attract and cultivate technical talent</p>', 0, '0', 'fa-users', '');
INSERT INTO `ry_en_article` VALUES (513, 2, 'Industry Experience', '', '', '', 1, 59, 1, 1762248029, 1762248364, 0, '15', '', 'Industry Experience,Technology Accumulation,Professional沉淀', '', 'Silicon Core Technology has 15 years deep accumulation in chip industry, accumulated rich technical experience and industry insights.', 1, '', '', '', '', 0, 30, '', '', '', '', '', '<p>15 years industry深耕 and technology沉淀</p><p>Rich project experience and success cases</p><p>Deep understanding of industry development trends</p>', '<p>Need continuous learning and adaptation to technology changes</p>', 0, '0', 'fa-microchip', '');
INSERT INTO `ry_en_article` VALUES (514, 2, 'Global Business', '', '', '', 1, 58, 1, 1762248029, 1762248332, 0, '50', '', 'Global Business,International Market,Overseas Expansion', '', 'Silicon Core Technology business covers over 50 countries and regions worldwide, established complete international marketing and service network.', 1, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Products and services cover global market</p><p>International operation and management capability</p><p>Provides technical support for global customers</p>', '<p>Need to adapt to market requirements in different countries and regions</p>', 0, '0', 'fa-globe', '');
INSERT INTO `ry_en_article` VALUES (515, 2, 'Patent Technology', '', '', '', 1, 57, 1, 1762248029, 1762248318, 0, '100', '', 'Patent Technology,Intellectual Property,Technology Innovation', '100', 'Silicon Core Technology has over 100 core patent technologies, established solid technology barriers in chip design and manufacturing fields.', 1, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Core technologies with independent intellectual property</p><p>Continuous technology innovation and patent布局</p><p>Provides support for product competitiveness</p>', '<p>Need continuous investment in R&D and patent protection</p>', 0, '0', 'fa-award', '');
INSERT INTO `ry_en_article` VALUES (516, 2, 'Corporate Mission', '', '', '', 1, 56, 1, 1762248029, 1762248584, 0, 'Through innovative chip technology, promote technological progress, empower intelligent world', '', 'Corporate Mission,Development Goals,Social Responsibility', '', 'Silicon Core Technology corporate mission is to promote technological progress through innovative chip technology, provide core power for intelligent world development.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Drive industry development with technology innovation</p><p>Provide technical support for intelligent transformation</p><p>Fulfill corporate social responsibility</p>', '<p>Need continuous technology investment and innovation</p>', 0, '0', 'fa-bullseye', '');
INSERT INTO `ry_en_article` VALUES (517, 2, 'Corporate Vision', '', '', '', 1, 55, 1, 1762248029, 1762248573, 0, 'Become global leading chip design enterprise, lead industry development', '', 'Corporate Vision,Strategic Goals,Industry Leadership', '', 'Silicon Core Technology corporate vision is to become global leading chip design enterprise, play leading role in technology innovation and industry development.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Pursue industry leadership position</p><p>Lead technology development direction</p><p>Promote industry ecosystem construction</p>', '<p>Need continuous innovation and market expansion</p>', 0, '0', 'fa-eye', '');
INSERT INTO `ry_en_article` VALUES (518, 2, 'Core Values', '', '', '', 1, 54, 1, 1762248029, 1762248560, 0, 'Innovation, Integrity, Collaboration, Responsibility, Excellence', '', 'Core Values,Corporate Culture,Value Concepts', '', 'Silicon Core Technology core values are Innovation, Integrity, Collaboration, Responsibility, Excellence, these five aspects constitute corporate culture cornerstone.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Innovation drives development</p><p>Integrity wins trust</p><p>Collaboration creates value</p><p>Responsibility reflects commitment</p><p>Excellence pursues perfection</p>', '<p>Need all staff practice and culture construction</p>', 0, '0', 'fa-handshake', '');
INSERT INTO `ry_en_article` VALUES (623, 4, 'Technological Innovation', '', '', '7nm advanced process technology\nSelf-developed AI computing architecture\nLow-power design technology', 1, 50, 1, 1762245974, 1762245974, 0, 'Has 100+ patent technologies, continuous R&D investment, maintaining technology领先 advantage', '', 'Technology Innovation,Patent Technology,7nm Process,AI Computing Architecture', '', 'Silicon Core Technology has 100+ patent technologies, masters 7nm advanced process technology and self-developed AI computing architecture, maintains industry leading position in low-power design technology.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>7nm advanced process technology brings higher performance and lower power consumption</p><p>Self-developed AI computing architecture深度 optimized for AI applications</p><p>Low-power design technology extends device battery life</p>', '<p>Need continuous R&D investment to maintain technology leading position</p>', 0, '0', 'fa-lightbulb', '');
INSERT INTO `ry_en_article` VALUES (624, 4, 'Full Industry Chain', '', '', 'Chip design and verification\nTape-out manufacturing and packaging\nTesting and quality control', 1, 49, 1, 1762245974, 1762245974, 0, 'From chip design to manufacturing testing full industry chain layout, ensuring product quality controllable', '', 'Full Industry Chain,Chip Design,Tape-out Manufacturing,Quality Control', '', 'Silicon Core Technology has full industry chain layout from chip design, tape-out manufacturing to packaging testing, ensuring product quality全程 controllable, providing one-stop solutions.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Complete chip design process and verification system</p><p>Advanced tape-out manufacturing and packaging technology</p><p>Strict testing standards and quality control process</p>', '<p>Full industry chain layout requires大量资金 and technology investment</p>', 0, '0', 'fa-cogs', '');
INSERT INTO `ry_en_article` VALUES (625, 4, 'Professional Team', '', '', 'Senior chip design experts\nAlgorithm and architecture engineers\nSystem and application engineers', 1, 48, 1, 1762245974, 1762245974, 0, '500+ R&D team, core members average industry experience over 10 years', '', 'Professional Team,R&D Team,Chip Design Experts,Algorithm Engineers', '', 'Silicon Core Technology has 500+ professional R&D team, core members average industry experience over 10 years, covering multiple fields including chip design, algorithm architecture and system applications.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>Senior chip design experts ensure product technology advancement</p><p>Algorithm and architecture engineers optimize system performance</p><p>System and application engineers support product落地 applications</p>', '<p>Need continuous talent cultivation and team building</p>', 0, '0', 'fa-user-tie', '');
INSERT INTO `ry_en_article` VALUES (626, 4, 'Quality Assurance', '', '', 'ISO9001 quality management system\nAutomotive-grade AEC-Q100 quality certification\nIndustrial-grade reliability testing', 1, 47, 1, 1762245974, 1762245974, 0, 'Strict quality management system, products passed multiple international certifications', '', 'Quality Assurance,ISO9001,AEC-Q100,Reliability Testing', '', 'Silicon Core Technology established strict quality management system, products passed multiple international certifications including ISO9001, automotive-grade AEC-Q100, ensuring product high reliability and stability.', 5, '', '', '', '', 0, 30, '', '', '', '', '', '<p>ISO9001 quality management system ensures process standardization</p><p>Automotive-grade AEC-Q100 certification meets automotive electronics requirements</p><p>Industrial-grade reliability testing supports product long-term stable operation</p>', '<p>Certification and maintenance require continuous investment and management</p>', 0, '0', 'fa-shield-alt', '');
INSERT INTO `ry_en_article` VALUES (627, 101, 'Lenovo', 'https://img.icons8.com/color/96/000000/lenovo.png', NULL, NULL, 1, 50, 1, 1762261306, 1762261306, 0, 'Global technology leader in PC and smart devices', NULL, NULL, NULL, 'Strategic partner in PC and smart device chip solutions', 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (628, 101, 'Xiaomi', 'https://img.icons8.com/color/96/000000/xiaomi.png', NULL, NULL, 1, 49, 1, 1762261306, 1762261306, 0, 'Leading smartphone and IoT device manufacturer', NULL, NULL, NULL, 'Cooperation in smartphone and IoT device chip technologies', 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (629, 101, 'Baidu', 'https://img.icons8.com/color/96/000000/baidu.png', NULL, NULL, 1, 48, 1, 1762261306, 1762261306, 0, 'Leading Chinese internet and AI technology company', NULL, NULL, NULL, 'Partnership in AI chip and cloud computing solutions', 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (630, 101, 'Tesla', 'https://img.icons8.com/color/96/000000/tesla.png', NULL, NULL, 1, 47, 1, 1762261306, 1762261306, 0, 'World-leading electric vehicle manufacturer', NULL, NULL, NULL, 'Strategic cooperation in automotive electronics and autonomous driving', 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (631, 101, 'Audi', 'https://img.icons8.com/color/96/000000/audi.png', NULL, NULL, 1, 46, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (632, 101, 'BMW', 'https://img.icons8.com/color/96/000000/bmw.png', NULL, NULL, 1, 45, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (633, 101, 'Mercedes-Benz', 'https://img.icons8.com/color/96/000000/mercedes-benz.png', NULL, NULL, 1, 44, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (634, 101, 'Volkswagen', 'https://img.icons8.com/color/96/000000/volkswagen.png', NULL, NULL, 1, 43, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (635, 101, 'Toyota', 'https://img.icons8.com/color/96/000000/toyota.png', NULL, NULL, 1, 42, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (636, 101, 'Samsung', 'https://img.icons8.com/color/96/000000/samsung.png', NULL, NULL, 1, 41, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (637, 101, 'Dell', 'https://img.icons8.com/color/96/000000/dell.png', NULL, NULL, 1, 40, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (638, 101, 'HP', 'https://img.icons8.com/color/96/000000/hp.png', NULL, NULL, 1, 39, 1, 1762261306, 1762261306, 0, NULL, NULL, NULL, NULL, NULL, 5, NULL, NULL, NULL, NULL, 1, 30, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, '50', '', '');
INSERT INTO `ry_en_article` VALUES (639, 10, 'Smart Voice Assistant Chip', '/uploads/images/product/product31.jpg', '', '<p>Smart voice assistant chip adopts advanced voice processing architecture, integrating high-performance audio processing unit and neural network accelerator. This chip supports multi-language speech recognition and natural language understanding, speech recognition accuracy in complex environments exceeds 95%. Chip adopts low-power design, power consumption in standby state controlled within 1mA, ensuring device battery life.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product32.jpg\" alt=\"Voice Assistant Chip Application\"></p><p>In technical implementation aspect, chip integrates dedicated acoustic front-end processing modules, supporting advanced technologies like noise suppression, echo cancellation and beamforming. Far-field voice wake-up function enables users to achieve accurate voice interaction within 5 meters range. Chip also supports offline voice command recognition, maintaining basic functions in unstable network connection environments.</p><p>This chip has cooperated with multiple smart home manufacturers, applied in products like smart speakers, smart TVs, air conditioners, etc. In actual use, voice interaction response time less than 200 milliseconds, providing users smooth usage experience. Chip compatibility design supports multiple voice assistant platforms,方便厂商进行productdevelopment.</p><p>With rapid development of smart home market, this chip凭借其excellent的performance和reliability, has become preferred solution for many smart device manufacturers, promoted voice interaction technology popularization application in home scenarios.</p>', 1, 50, 1, 1762588037, 1762588037, 0, 'Supporting multi-language recognition and natural language understanding voice processing chip, providing smooth voice interaction experience for smart home', 'Consumer Grade', 'Voice Assistant,Smart Home,Speech Recognition', '899', 'Smart voice assistant chip supports multi-language recognition, integrating audio processing unit, providing smooth voice interaction for smart home.', 1, '', '', 'Voice Technology Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product31.jpg,/uploads/images/product/product32.jpg,/uploads/images/product/product33.jpg', '', '', '', '', '<p>Advanced voice processing with multi-language support and noise cancellation.</p>', '<p>Requires proper microphone placement and acoustic environment.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (640, 10, 'Smart Security Monitoring Chip', '/uploads/images/product/product34.jpg', '', '<p>Smart security monitoring chip specifically designed for video monitoring applications, integrating high-performance image processing unit and intelligent analysis engine. Chip supports 4K ultra HD video encoding processing, performing excellently in intelligent analysis tasks like human detection, vehicle recognition, etc. Adopting advanced computer vision algorithms, target detection accuracy exceeds 98%.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product35.jpg\" alt=\"Security Monitoring Application\"/></p><p>Chip architecture深度optimize for security scenarios, supports multiple video stream parallel processing, single chip can simultaneously process 4 channels 1080P video streams. Intelligent analysis engine can real-time recognize targets like human forms, vehicles, faces, etc., and supports abnormal behavior detection and intelligent alarm functions. In low light environments, chip image enhancement technology can effectively improve picture quality.</p><p>Power consumption management aspect, chip adopts dynamic voltage frequency scaling technology, intelligently adjusting power consumption according to workload. Under light load conditions, power consumption can reduce to 30% of standard mode, suitable for security equipment requiring long-term operation.</p><p>This chip has been applied in smart communities, commercial security, traffic monitoring and other fields. In a smart city project, monitoring system based on this chip successfully identified multiple abnormal events, improving public safety level.</p>', 1, 49, 1, 1762588037, 1762588037, 0, 'Integrated image processing and intelligent analysis function security monitoring chip, supporting 4K video encoding and human/vehicle detection', 'Consumer Grade', 'Security Monitoring,Image Processing,Intelligent Analysis', '1299', 'Smart security monitoring chip supports 4K video encoding and human/vehicle detection, providing reliable visual perception capabilities for security systems.', 1, '', '', 'Security Technology Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product34.jpg,/uploads/images/product/product35.jpg,/uploads/images/product/product36.jpg', '', '', '', '', '<p>High-performance video processing with intelligent analysis capabilities.</p>', '<p>Requires proper camera installation and lighting conditions.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (641, 10, 'Industrial Sensor Chip', '/uploads/images/product/product37.jpg', '', '<p>Industrial sensor chip designed for industrial automation applications, integrating multiple sensor interfaces and high-precision signal processing unit. Chip supports multiple industrial parameter acquisition including temperature, pressure, vibration, displacement, etc., measurement accuracy reaching industry advanced level. Adopting industrial-grade reliability design, operating temperature range -40°C to +85°C.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product38.jpg\" alt=\"Industrial Sensor Application\"/></p><p>Signal processing aspect, chip integrates 24-bit high-precision ADC and programmable gain amplifier, supporting direct access of multiple sensor signals. Digital filtering algorithms effectively suppress electromagnetic interference in industrial environments, ensuring data acquisition accuracy. In vibration monitoring applications, frequency response range reaches 0.1Hz-10kHz, accuracy error less than 1%.</p><p>Chip supports multiple industrial communication protocols, including 4-20mA current loop, industrial Ethernet, PROFIBUS, etc., facilitating integration with existing industrial systems. Self-diagnosis function can real-time monitor sensor status, timely discover faults and alarm.</p><p>This chip has been widely applied in smart manufacturing, equipment condition monitoring, process control and other fields. In a large manufacturing enterprise, monitoring system based on this chip successfully warned multiple equipment abnormalities, avoiding production interruptions.</p>', 1, 48, 1, 1762588037, 1762588037, 0, 'Industrial-grade multi-parameter sensor acquisition chip, supporting temperature pressure vibration monitoring, meeting industrial automation requirements', 'Industrial Grade', 'Industrial Sensor,Data Acquisition,Signal Processing', '1599', 'Industrial sensor chip integrates multiple sensor interfaces, supporting industrial parameter acquisition, meeting automation requirements.', 2, '', '', 'Industrial IoT Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product37.jpg,/uploads/images/product/product38.jpg,/uploads/images/product/product39.jpg', '', '', '', '', '<p>Multi-parameter industrial sensing with high precision measurement.</p>', '<p>Requires proper sensor installation and environmental protection.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (642, 10, 'Smart Medical Monitoring Chip', '/uploads/images/product/product40.jpg', '', '<p>Smart medical monitoring chip specifically designed for wearable medical devices, integrating physiological signal acquisition and health data analysis functions. Chip supports key physiological parameter monitoring like heart rate, blood oxygen saturation, body temperature, electrocardiogram, etc., measurement accuracy meeting medical-grade requirements. Adopting low-power architecture, ensuring device battery life reaching 7 days以上.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product41.jpg\" alt=\"Medical Monitoring Application\"></p><p>Physiological signal processing aspect, chip integrates professional-grade ECG signal acquisition circuits, supporting single-lead ECG monitoring. Photoplethysmography technology achieves non-invasive blood oxygen monitoring, measurement error less than 2%. Motion artifact suppression algorithms effectively eliminate daily activity impact on monitoring data, improving measurement accuracy.</p><p>Health data analysis engine can identify abnormal physiological patterns, providing health risk warnings. Chip supports local data analysis and cloud data synchronization, protecting user privacy while achieving health management continuity. Data encryption transmission ensures personal information security.</p><p>This chip has been applied in smart watches, health bracelets, portable ECG monitoring devices and other products. In clinical verification, heart rate monitoring accuracy reaching 99%, providing reliable technical support for personal health management.</p>', 1, 47, 1, 1762588037, 1762588037, 0, 'Wearable medical device dedicated monitoring chip, supporting heart rate blood oxygen and other physiological parameters precise acquisition analysis', 'Medical Grade', 'Medical Monitoring,Wearable Device,Physiological Parameters', '1399', 'Smart medical monitoring chip supports heart rate blood oxygen monitoring, providing health management functions for wearable devices.', 1, '', '', 'Medical Electronics Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product40.jpg,/uploads/images/product/product41.jpg,/uploads/images/product/product42.jpg', '', '', '', '', '<p>Comprehensive physiological monitoring with medical-grade accuracy.</p>', '<p>Requires proper device wearing and skin contact.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (643, 10, 'Smart Agriculture Monitoring Chip', '/uploads/images/product/product43.jpg', '', '<p>Smart agriculture monitoring chip designed for modern agricultural applications, integrating environmental sensors and crop growth monitoring functions. Chip supports environmental parameter acquisition like soil moisture, light intensity, air temperature humidity, CO2 concentration, etc., providing comprehensive data support for precision agriculture. Adopting anti-corrosion packaging design, adapting to farmland humid and chemical environments.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product44.jpg\" alt=\"Agriculture Monitoring Application\"></p><p>Chip integrates intelligent algorithms, able to provide precise irrigation and fertilization suggestions according to crop growth models. Soil moisture sensor supports multi-point measurement, accurately reflecting soil moisture distribution. Light sensor monitors photosynthetically active radiation, providing basis for greenhouse supplementary lighting control. Environmental data fusion analysis helps farmers optimize planting strategies.</p><p>Communication aspect, chip supports LoRa and NB-IoT communication, adapting to communication needs in remote farmland areas. Solar power design enables monitoring devices work independently long-term, reducing maintenance requirements. Data encryption transmission ensures agricultural data security.</p><p>This chip has been deployed in multiple smart agriculture demonstration bases nationwide. Actual application data shows, precision agriculture system using this chip achieved 30% water saving, 25% fertilizer utilization improvement, 15% crop yield increase.</p>', 1, 46, 1, 1762588037, 1762588037, 0, 'Agricultural environment monitoring dedicated chip, supporting soil moisture light and other parameter acquisition, assisting precision agriculture development', 'Consumer Grade', 'Agriculture Monitoring,Precision Agriculture,Environmental Sensing', '999', 'Smart agriculture monitoring chip supports environmental parameter acquisition, providing data support and management suggestions for precision agriculture.', 1, '', '', 'Agricultural IoT Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product43.jpg,/uploads/images/product/product44.jpg,/uploads/images/product/product45.jpg', '', '', '', '', '<p>Multi-parameter environmental monitoring for precision agriculture.</p>', '<p>Requires proper sensor placement and weather protection.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (644, 10, 'Smart Lighting Control Chip', '/uploads/images/product/product46.jpg', '', '<p>Smart lighting control chip integrates dimming control and environmental perception functions, providing complete control solutions for smart lighting systems. Chip supports multiple dimming methods like 0-10V dimming, PWM dimming, TRIAC dimming, etc., dimming accuracy reaching 1%. Adopting advanced illuminance sensing technology, able to automatically adjust brightness according to ambient light.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product47.jpg\" alt=\"Lighting Control Application\"></p><p>Human body sensing function supports presence detection and motion detection two modes, achieving on-demand lighting. Scene lighting control supports one-click switching of multiple preset scenes, meeting different application scenario lighting needs. Color adjustment function supports 2700K-6500K color temperature stepless adjustment and RGB full-color control, creating comfortable lighting atmosphere.</p><p>Energy saving aspect, chip intelligent scheduling algorithm can optimize lighting strategies according to usage habits, achieving over 30% energy saving effect in commercial lighting applications. Networking control function supports unified management of large-scale lighting systems, simplifying maintenance work.</p><p>This chip has been applied in smart home, commercial lighting, office lighting and other fields. In a large commercial complex project, smart lighting system based on this chip achieved annual electricity saving rate 35%, significantly reducing operating costs.</p>', 1, 45, 1, 1762588037, 1762588037, 0, 'Smart lighting system control chip, supporting precise dimming and environmental perception, achieving energy-saving comfortable lighting', 'Consumer Grade', 'Smart Lighting,Dimming Control,Environmental Perception', '1099', 'Smart lighting control chip supports multiple dimming methods and environmental perception, achieving intelligent energy-saving lighting management.', 1, '', '', 'Smart Lighting Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product46.jpg,/uploads/images/product/product47.jpg,/uploads/images/product/product48.jpg', '', '', '', '', '<p>Intelligent lighting control with multiple dimming methods.</p>', '<p>Requires compatible lighting fixtures and proper installation.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (645, 10, 'Smart Access Control Chip', '/uploads/images/product/product49.jpg', '', '<p>Smart access control chip integrates multiple identity authentication methods and security control functions, providing reliable technical support for modern access control systems. Chip supports multiple authentication methods like fingerprint recognition, face recognition, IC card, password, etc., authentication accuracy exceeding 99.5%. Adopting financial-grade security encryption technology, preventing unauthorized access.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product50.jpg\" alt=\"Access Control Application\"></p><p>Liveness detection function effectively prevents photo, video and other deception methods, improving system security. Multi-factor authentication supports combined verification modes, meeting high security level scenario requirements. Real-time monitoring function can record all access control events, providing complete data support for security management.</p><p>Chip supports remote authorization and management, administrators can perform permission settings and status monitoring through network. Anti-tamper alarm function immediately issues alarm when equipment damaged. Low-power design ensures system operation over 24 hours with backup power during power outage.</p><p>This chip has been widely applied in office buildings, residential communities, factory parks and other places. In a high-end office building project, access control system based on this chip achieved precise permission management for thousands of employees, improving security management efficiency.</p>', 1, 44, 1, 1762588037, 1762588037, 0, 'Multi-function access control system control chip, supporting fingerprint face and other authentication methods, ensuring access security', 'Consumer Grade', 'Access Control,Identity Authentication,Security Management', '1499', 'Smart access control chip supports multiple authentication methods, adopting security encryption technology ensuring access security.', 2, '', '', 'Security Technology Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product49.jpg,/uploads/images/product/product50.jpg,/uploads/images/product/product51.jpg', '', '', '', '', '<p>Multi-authentication access control with high security level.</p>', '<p>Requires proper installation and user management.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (646, 10, 'Environmental Quality Monitoring Chip', '/uploads/images/product/product52.jpg', '', '<p>Environmental quality monitoring chip integrates multiple gas sensors and particulate matter detection units, providing comprehensive data acquisition capabilities for environmental monitoring. Chip supports key environmental parameter monitoring like PM2.5, PM10, carbon dioxide, formaldehyde, VOCs, etc., measurement accuracy reaching professional level standards. Adopting multi-sensor data fusion technology, improving monitoring data accuracy.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product53.jpg\" alt=\"Environmental Monitoring Application\"></p><p>Automatic calibration function ensures sensor long-term operation stability, reducing maintenance requirements. Intelligent warning algorithms can identify environmental pollution trends, timely issuing warning information. Data recording function supports historical data storage and trend analysis, providing scientific basis for environmental governance.</p><p>Chip supports indoor and outdoor multiple application scenarios, monitoring data can be uploaded to cloud platform in real-time through wireless networks. Low-power design suitable for long-term monitoring applications, battery-powered devices can work continuously for months. Dustproof and waterproof design adapts to various environmental conditions.</p><p>This chip has been applied in smart city environmental monitoring, indoor air quality monitoring, industrial environment monitoring and other fields. In a city grid monitoring system, monitoring equipment based on this chip achieved real-time monitoring of regional air quality and pollution source tracking.</p>', 1, 43, 1, 1762588037, 1762588037, 0, 'Multi-parameter environmental quality monitoring chip, real-time monitoring air quality, providing data support for environmental management', 'Consumer Grade', 'Environmental Monitoring,Air Quality,Gas Sensing', '1199', 'Environmental quality monitoring chip supports multi-parameter environmental monitoring, measurement accuracy reaching professional level standards.', 1, '', '', 'Environmental IoT Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product52.jpg,/uploads/images/product/product53.jpg,/uploads/images/product/product54.jpg', '', '', '', '', '<p>Multi-parameter environmental quality monitoring with professional accuracy.</p>', '<p>Requires proper sensor placement and regular calibration.</p>', 108, '50', '', '');
INSERT INTO `ry_en_article` VALUES (647, 10, 'Smart Home Appliance Control Chip', '/uploads/images/product/product55.jpg', '', '<p>Smart home appliance control chip provides intelligent and networking control functions for home appliances, promoting intelligent upgrade of home appliance products. Chip supports multiple home appliance control protocols, including infrared, RF, power line carrier, etc., compatible with mainstream home appliance brands. Adopting unified device abstraction layer, simplifying integration difficulty of different home appliance devices.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product56.jpg\" alt=\"Home Appliance Control Application\"></p><p>Scene control function supports linkage control of home appliance devices, achieving one-click startup of multiple home appliances协同工作. Energy consumption monitoring function real-time statistics home appliance electricity usage, helping users optimize electricity habits. Remote control function supports status monitoring and remote operation of home appliances through mobile App.</p><p>Voice control integration supports mainstream voice assistant platforms, achieving voice control of home appliance devices. Timing task function supports preset home appliance working time and mode, improving usage convenience. Device status feedback function real-time displays home appliance operation status, timely discovering abnormal situations.</p><p>This chip has cooperated with multiple home appliance manufacturers, applied in air conditioners, refrigerators, washing machines, TVs and other products. In smart home systems, home appliance control based on this chip achieved device interconnection, improving user life quality.</p>', 1, 42, 1, 1762588037, 1762588037, 0, 'Home appliance intelligent control chip, supporting multiple control protocols and scene linkage, improving life convenience', 'Consumer Grade', 'Appliance Control,Smart Home,Device Linkage', '899', 'Smart home appliance control chip supports multiple control protocols and scene linkage, achieving intelligent home appliance management.', 1, '', '', 'Smart Home Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product55.jpg,/uploads/images/product/product56.jpg,/uploads/images/product/product57.jpg', '', '', '', '', '<p>Multi-protocol home appliance control with scene linkage.</p>', '<p>Requires proper device pairing and network configuration.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (648, 10, 'Smart Campus Management Chip', '/uploads/images/product/product58.jpg', '', '<p>Smart campus management chip designed for educational scenarios, integrating campus card management, attendance statistics, security monitoring and other functions. Chip supports identification and management of multiple campus card types like student cards, faculty cards, etc., achieving all-in-one campus applications. Attendance statistics function automatically records student attendance, generating statistical reports.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product59.jpg\" alt=\"Campus Management Application\"></p><p>Security monitoring function supports access control and security warnings for key campus areas. Electronic fence function can identify student abnormal entry/exit situations, timely notifying relevant personnel. Consumption management function supports electronic payment in campus canteens, supermarkets and other places,方便校园生活.</p><p>Data statistical analysis function provides decision support for school management, identifying problems and improvement space in campus operation. Multi-campus management function supports unified management of distributed campus systems. Data encryption transmission ensures student information security.</p><p>This chip has been deployed in multiple primary and secondary schools and universities nationwide. Actual usage data shows, smart campus system based on this chip improved management efficiency over 30%, reducing manual management workload.</p>', 1, 41, 1, 1762588037, 1762588037, 0, 'Campus intelligent management chip, supporting campus card applications and security management, improving campus management efficiency', 'Consumer Grade', 'Smart Campus,All-in-One Card,Campus Management', '1699', 'Smart campus management chip supports campus card management and security monitoring, improving campus management intelligence level.', 1, '', '', 'Education IoT Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product58.jpg,/uploads/images/product/product59.jpg,/uploads/images/product/product60.jpg', '', '', '', '', '<p>Comprehensive campus management with all-in-one card functionality.</p>', '<p>Requires proper system deployment and network coverage.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (649, 10, 'Smart Warehouse Management Chip', '/uploads/images/product/product61.jpg', '', '<p>Smart warehouse management chip provides intelligent management solutions for modern logistics warehousing, integrating inventory monitoring, goods tracking, environmental monitoring and other functions. Chip supports multiple goods identification technologies like RFID, QR codes, etc., achieving precise inventory management. Goods positioning function supports real-time tracking of goods location, improving warehouse efficiency.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product62.jpg\" alt=\"Warehouse Management Application\"></p><p>Environmental monitoring function real-time monitors warehouse temperature, humidity and other parameters, ensuring goods storage conditions. Smart shelf management supports automatic inventory statistics and replenishment warnings. Inbound/outbound management function automatically records goods flow, reducing manual operation errors.</p><p>Data analysis function provides decision support for warehouse optimization, identifying inventory turnover rate and space utilization rate issues. Multi-warehouse management function supports协同 operation of distributed warehouse systems. Anti-collision algorithms optimize goods storage layout, improving space utilization efficiency.</p><p>This chip has been applied in e-commerce warehousing, manufacturing warehouses, cold chain logistics and other fields. In a large e-commerce warehouse, smart warehouse system based on this chip improved inventory accuracy to 99.5%, significantly reducing warehouse management costs.</p>', 1, 40, 1, 1762588037, 1762588037, 0, 'Warehouse intelligent management chip, supporting inventory monitoring and goods tracking, improving warehouse management efficiency', 'Consumer Grade', 'Smart Warehouse,Inventory Management,Goods Tracking', '1899', 'Smart warehouse management chip supports inventory monitoring and goods tracking, improving warehouse management intelligence level.', 2, '', '', 'Logistics IoT Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product61.jpg,/uploads/images/product/product62.jpg,/uploads/images/product/product1.jpg', '', '', '', '', '<p>Intelligent warehouse management with precise inventory tracking.</p>', '<p>Requires proper equipment layout and signal coverage.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (650, 10, 'Smart Elevator Control Chip', '/uploads/images/product/product2.jpg', '', '<p>Smart elevator control chip provides intelligent and safety control functions for modern elevator systems, integrating elevator scheduling, safety monitoring, energy management and other capabilities. Chip supports intelligent dispatching algorithms, optimizing elevator operation strategies according to passenger flow and destinations, reducing waiting time. Safety monitoring function real-time monitors elevator operation status, timely discovering abnormalities.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product3.jpg\" alt=\"Elevator Control Application\"></p><p>Energy management function optimizes elevator operation energy consumption, automatically entering energy-saving mode during idle periods. Predictive maintenance function identifies potential faults based on operation data,提前安排 maintenance work. Emergency rescue function automatically activates emergency procedures when faults occur, ensuring passenger safety.</p><p>Data analysis function provides support for elevator operation optimization, identifying usage peaks and operation bottlenecks. Remote monitoring function supports real-time monitoring and fault diagnosis of elevator status. Compatibility design supports integration with building management systems.</p><p>This chip has been applied in office buildings, shopping malls, residential communities and other building types. Actual operation data shows, smart elevator system based on this chip reduced average waiting time 25%, energy consumption reduced over 20%.</p>', 1, 39, 1, 1762588037, 1762588037, 0, 'Elevator intelligent control chip, supporting intelligent scheduling and safety monitoring, improving elevator operation efficiency', 'Consumer Grade', 'Elevator Control,Intelligent Scheduling,Safety Monitoring', '2199', 'Smart elevator control chip supports intelligent dispatching and safety monitoring, improving elevator operation efficiency and safety.', 1, '', '', 'Building Automation Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product2.jpg,/uploads/images/product/product3.jpg,/uploads/images/product/product4.jpg', '', '', '', '', '<p>Intelligent elevator control with safety monitoring features.</p>', '<p>Requires proper installation and regular maintenance.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (651, 10, 'Smart Parking Lot Chip', '/uploads/images/product/product5.jpg', '', '<p>Smart parking lot chip provides complete solutions for modern parking management, integrating parking space detection, vehicle recognition, payment management and other functions. Chip supports multiple parking space detection technologies like geomagnetic, ultrasonic, video, etc., accuracy rate exceeding 99%. License plate recognition function supports automatic identification of vehicle information, achieving contactless payment.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product6.jpg\" alt=\"Parking Lot Application\"></p><p>Intelligent navigation function guides vehicles quickly find available parking spaces, reducing search time. Payment management function supports multiple payment methods, including扫码支付, contactless payment, monthly card management, etc. Data analysis function provides decision support for parking lot operation, optimizing parking space utilization rate and charging standards.</p><p>Remote management function supports real-time monitoring and remote control of parking lot status. Emergency processing function automatically activates emergency procedures in abnormal situations. Compatibility design supports对接 with city parking platforms.</p><p>This chip has been applied in commercial centers, airports, stations and other parking scenarios. Actual application data shows, smart parking lot based on this chip improved parking space turnover rate 40%, significantly improving parking experience.</p>', 1, 38, 1, 1762588037, 1762588037, 0, 'Parking lot intelligent management chip, supporting parking space detection and vehicle recognition, improving parking management efficiency', 'Consumer Grade', 'Smart Parking,Parking Space Detection,Vehicle Recognition', '1399', 'Smart parking lot chip supports parking space detection and vehicle recognition, improving parking lot management intelligence level.', 1, '', '', 'Smart Transportation Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product5.jpg,/uploads/images/product/product6.jpg,/uploads/images/product/product7.jpg', '', '', '', '', '<p>Smart parking management with multiple detection technologies.</p>', '<p>Requires proper installation and network security.</p>', 20, '50', '', '');
INSERT INTO `ry_en_article` VALUES (652, 10, 'Smart Meter Reading Chip', '/uploads/images/product/product8.jpg', '', '<p>Smart meter reading chip provides automatic meter reading solutions for utilities, integrating high-precision metering and remote communication functions. Chip supports multiple utility metering like water, electricity, gas, etc., metering accuracy reaching 0.5级standard. Remote meter reading function supports定hour automatic reporting of usage data, reducing manual meter reading workload.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product9.jpg\" alt=\"Smart Meter Reading Application\"></p><p>Abnormal monitoring function can identify usage abnormalities and equipment faults, timely issuing alarms. Data storage function supports local storage of usage history records, preventing data loss. Remote control function supports remote valve switching,方便费用management和 emergency processing.</p><p>Anti-theft function can detect abnormal electricity/water usage patterns, protecting utility company legitimate rights. Low-power design ensures battery-powered devices work over 10 years. Communication encryption transmission ensures data security.</p><p>This chip has beenscale applied in multiple domestic smart city projects. Actual operation data shows, smart meter reading system based on this chip improved meter reading accuracy to 99.8%, significantly reducing operating costs.</p>', 1, 37, 1, 1762588037, 1762588037, 0, 'Utility smart meter reading chip, supporting remote meter reading and abnormal monitoring, improving meter reading efficiency', 'Consumer Grade', 'Smart Meter Reading,Remote Meter Reading,Utilities', '1099', 'Smart meter reading chip supports remote meter reading and abnormal monitoring, improving utility management efficiency.', 1, '', '', 'Energy IoT Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product8.jpg,/uploads/images/product/product9.jpg,/uploads/images/product/product10.jpg', '', '', '', '', '<p>Remote meter reading with high precision measurement.</p>', '<p>Requires proper installation and communication coverage.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (653, 10, 'Smart Irrigation Control Chip', '/uploads/images/product/product11.jpg', '', '<p>Smart irrigation control chip provides precise control solutions for agricultural irrigation, integrating soil moisture monitoring and intelligent irrigation decision functions. Chip supports multi-point soil moisture monitoring, accurately reflecting soil moisture distribution. Intelligent algorithms optimize irrigation strategies according to crop water requirements and weather forecasts.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product12.jpg\" alt=\"Irrigation Control Application\"></p><p>Valve control function supports precise zonal irrigation control, reducing water resource waste. Rainfall monitoring function automatically adjusts irrigation plans during rainfall. Remote management function supports remote monitoring and control of irrigation systems,方便农户management.</p><p>Data analysis function provides decision support for irrigation optimization, identifying irrigation effects and improvement space. Water-saving mode automatically activates water-saving irrigation schemes during drought periods. Compatibility design supports integration with agricultural IoT platforms.</p><p>This chip has been deployed in multiple agricultural demonstration areas nationwide. Actual application data shows, smart irrigation system based on this chip achieved water-saving effects over 30%, crop yield increased 15%, achieving efficient utilization of water resources.</p>', 1, 36, 1, 1762588037, 1762588037, 0, 'Agricultural smart irrigation control chip, supporting precise irrigation and water-saving management, improving agricultural water use efficiency', 'Consumer Grade', 'Smart Irrigation,Water-saving Irrigation,Agricultural IoT', '1299', 'Smart irrigation control chip supports precise irrigation and water-saving management, improving agricultural water use efficiency.', 1, '', '', 'Agricultural IoT Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product11.jpg,/uploads/images/product/product12.jpg,/uploads/images/product/product13.jpg', '', '', '', '', '<p>Precise irrigation control with water-saving features.</p>', '<p>Requires proper sensor placement and equipment maintenance.</p>', 105, '50', '', '');
INSERT INTO `ry_en_article` VALUES (654, 10, 'Smart Fire Protection Warning Chip', '/uploads/images/product/product14.jpg', '', '<p>Smart fire protection warning chip provides early fire warning functions for building fire protection, integrating smoke detection, temperature sensing, gas monitoring and other sensing capabilities. Chip adopts dual-optical path smoke detection technology, effectively distinguishing fire smoke and dust interference. Temperature monitoring supports differential temperature and fixed temperature two alarm methods, adapting to different environmental requirements.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product15.jpg\" alt=\"Fire Protection Warning Application\"></p><p>Carbon monoxide monitoring function can early detect harmful gases produced by incomplete combustion. Intelligent algorithms can identify fire characteristic patterns, reducing false alarm rate. Linkage control function automatically activates sprinkler systems and alarm devices when detecting fire.</p><p>Self-check function regularly checks sensor status, ensuring system reliability. Remote monitoring function supports real-time monitoring of fire protection equipment status. Backup power design ensures system normal operation 24 hours during mains power interruption.</p><p>This chip has passed national fire product certification, applied in crowded places like shopping malls, hotels, schools, etc. In actual use, fire protection warning system based on this chip多次success预警 initial fires, winning precious time for personnel evacuation.</p>', 1, 35, 1, 1762588037, 1762588037, 0, 'Fire protection intelligent warning chip, supporting multi-parameter fire detection, improving early fire warning capability', 'Consumer Grade', 'Fire Protection Warning,Fire Detection,Safety Monitoring', '1799', 'Smart fire protection warning chip supports multi-parameter fire detection, improving building fire safety level.', 2, '', '', 'Fire Protection IoT Department', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product14.jpg,/uploads/images/product/product15.jpg,/uploads/images/product/product16.jpg', '', '', '', '', '<p>Multi-parameter fire detection with early warning capabilities.</p>', '<p>Requires regular testing and sensor maintenance.</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (655, 10, 'Smart Health Bracelet Chip', '/uploads/images/product/product17.jpg', '', '<p>Smart health bracelet chip provides comprehensive physiological monitoring functions for wearable health devices, integrating heart rate, blood oxygen, exercise monitoring and other health parameter acquisition. Chip adopts photoplethysmography technology, achieving non-invasive heart rate blood oxygen monitoring, measurement accuracy meeting daily health management needs. Exercise monitoring function supports step count, distance, calorie and other exercise data statistics.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product18.jpg\" alt=\"Health Bracelet Application\"></p><p>Sleep monitoring function analyzes sleep quality and sleep stages, providing improvement suggestions. Sedentary reminder function prompts user activity during long stationary periods. Message notification function supports vibration alerts for mobile messages. Low-power design ensures device battery life reaching 7 days以上.</p><p>Waterproof design supports sweat and water splash protection in daily life. Data synchronization function supports data transmission with mobile App and cloud backup. Personalized watch face supports multiple display style choices.</p><p>This chip has cooperated with multiple smart bracelet manufacturers, products sold to global market. User feedback shows, health bracelet based on this chip provided accurate health monitoring data, helping users better understand their health status.</p>', 1, 34, 1, 1762588037, 1762588037, 0, 'Wearable health monitoring chip, supporting heart rate blood oxygen exercise monitoring, assisting personal health management', 'Consumer Grade', 'Health Bracelet,Physiological Monitoring,Exercise Monitoring', '799', 'Smart health bracelet chip supports multiple health parameter monitoring, providing data support for personal health management.', 1, '', '', '可穿戴事业部', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product17.jpg,/uploads/images/product/product18.jpg,/uploads/images/product/product19.jpg', '', '', '', '', '<p>Comprehensive health monitoring with long battery life.</p>', '<p>Requires proper wearing and regular charging.</p>', 17, '50', '', '');
INSERT INTO `ry_en_article` VALUES (656, 10, 'Smart Pet Tracking Chip', '/uploads/images/product/product20.jpg', '', '<p>intelligent宠物追踪chip为宠物management提供位置追踪和health监测功能，集成GPS定位和活动监测capability。chipsupportGPS、北斗、GLONASS多模定位，定位accuracy达到5米以内。活动监测功能记录宠物的day常活动量和休息time。</p><p style=\"text-align: center;\"><img src=\"/uploads/images/product/product21.jpg\" alt=\"宠物追踪application\"/></p><p>电子围栏功能设定safe活动scope，在宠物超出scopehourimmediately告警。health监测功能通过活动模式minute析宠物health状况。远程定位功能support通过手机App实hour查看宠物位置。</p><p>低power consumptiondesign确保equipment续航time达到30天以上。防水防尘design适应宠物户外活动environment。小巧轻便的design确保宠物佩戴舒适。data加密传输保护宠物主人隐私。</p><p>该chip已application于宠物项圈、intelligent背心等宠物用品。用户使用反馈显示，基于该chip的宠物追踪equipment有效防止了宠物走失，让宠物主人更加安心。</p>', 1, 33, 1, 1764259200, 1762846765, 0, 'Pet intelligent management chip, supporting location tracking and health monitoring, ensuring pet safety', '', '宠物追踪,位置定位,健康监测', '999', '智能宠物追踪chip支持位置追踪和健康监测，保障宠物安全和健康。', 1, '', '', '消费电子部', 'Silicon Core Technology', 0, 30, '/uploads/images/product/product20.jpg,/uploads/images/product/product21.jpg,/uploads/images/product/product22.jpg', '', '', '', '', '<p>芯片集成GPS定位和活动监测能力，支持GPS、北斗、GLONASS多模定位，定位精度5米以内。活动监测功能记录宠物日常活动量和休息时间，电子围栏功能设定安全活动范围在宠物超出时立即告警。健康监测功能通过活动模式分析宠物健康状况，远程定位功能支持手机App实时查看宠物位置。</p><p>低功耗设计确保设备续航时间30天以上，防水防尘设计适应宠物户外活动环境。小巧轻便设计确保宠物佩戴舒适，数据加密传输保护宠物主人隐私。芯片应用于宠物项圈、智能背心等宠物用品，用户使用反馈显示宠物追踪设备有效防止宠物走失。</p><p>多模定位提升位置准确性，电子围栏功能保障宠物安全。健康监测帮助了解宠物状态，长续航设计减少充电频率。防水设计适应各种天气条件，轻便设计提升佩戴舒适度。</p>', '<p>定期检查设备电量，及时充电。注意设备防水性能，避免长时间浸水。根据宠物体型选择合适的佩戴方式，确保舒适性。</p>', 100, '50', '', '');
INSERT INTO `ry_en_article` VALUES (657, 20, 'Silicon Core Technology 2024 Annual Technology Summit to be Held in Beijing', '/uploads/images/news/news30.jpg', '', '<p>Silicon Core Technology announced that it will hold the 2024 Annual Technology Summit at the Beijing National Convention Center in December 2024. The summit, themed \"Intelligent Chips, Driving the Future,\" will showcase the company\'s latest technological achievements and application cases in artificial intelligence, Internet of Things, automotive electronics, and other fields. Industry experts, partners, and customer representatives from around the world will attend.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news31.jpg\" alt=\"Technology Summit Preview\"></p><p>During the summit, a main forum and multiple sub-forums will be set up, covering hot topics such as AI chip architecture innovation, edge computing technology, autonomous driving solutions, and industrial IoT applications. The company\'s Chief Technology Officer will release the new generation chip technology roadmap and share the company\'s technology plans in advanced process technology, packaging technology, and energy efficiency optimization.</p><p>Attendees will have the opportunity to personally experience various innovative application demonstrations based on Silicon Core chips, including smart robots, autonomous driving testing platforms, and industrial IoT solutions. The conference will also host multiple technical seminars and partner exchange meetings, providing attendees with in-depth technical exchanges and business cooperation opportunities.</p><p>The summit is expected to attract over 2,000 industry professionals, including representatives from academia, industry, and investment circles. Silicon Core Technology hopes to discuss the development trends of chip technology with industry peers through this event, promoting technological innovation and industrial upgrading.</p><p>Registration for the summit has already started. Interested industry professionals can register online through the company\'s official website or WeChat official account. Early registrants can enjoy discounted tickets, and students can apply for special discounts. The organizing committee will also provide presentation opportunities for outstanding paper authors to promote academic exchange and technology sharing.</p>', 1, 50, 1, 1762588708, 1762588708, 0, 'Annual Technology Summit focuses on AI chips and IoT innovation, gathering industry experts to discuss technology development paths', '', '技术峰会,行业盛会,AI Chip,创新展示', '', 'Silicon Core Technology 2024 Annual Technology Summit will be held in Beijing, showcasing the latest technological achievements in AI chips, IoT, and other fields, promoting industry exchange and cooperation.', 0, '', '', '大会组委会', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (658, 20, 'Silicon Core Technology Campus Technology Competition Officially Opens for Registration', '/uploads/images/news/news32.jpg', '', '<p>Silicon Core Technology officially announced the launch of the 2024 Campus Technology Competition, which is open to full-time undergraduate and postgraduate students nationwide. The competition is divided into two tracks: chip design and chip application innovation, aiming to stimulate students\' interest in chip technology and cultivate innovative talents for the semiconductor industry.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news32.jpg\" alt=\"Campus Competition Launch\"></p><p>The chip design track requires participants to complete specific functional chip designs based on provided design requirements and tool platforms. The chip application innovation track encourages students to develop innovative applications using Silicon Core\'s development boards and chip platforms. The competition will run for three months, including stages for registration, preliminary, semi-final, and final.</p><p>The organizing committee will provide participants with technical training, online Q&A, and development board support. Outstanding entries will have the opportunity to receive venture capital investment and enter Silicon Core Technology\'s talent pool. The total prize pool for this competition exceeds one million yuan, with additional internship and employment opportunities for winners.</p><p>Industry experts and senior engineers will serve as judges for the competition, evaluating entries based on innovation, technical difficulty, practicality, and completeness. The award ceremony will be held during the Annual Technology Summit, where winners will receive trophies and certificates.</p>', 1, 49, 1, 1762588708, 1762588708, 0, 'Campus Technology Competition opens registration, encouraging university students to participate in chip design and application innovation', '', '校园竞赛,Technology Innovation,人才培养,高校合作', '', 'Silicon Core Tech launches Campus Technology Competition, encouraging university students to participate in chip design and application innovation, cultivating talents for the semiconductor industry.', 0, '', '', '竞赛组委会', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (659, 20, 'Silicon Core Technology Open Day Event Invites Industry Visits', '/uploads/images/news/news34.jpg', '', '<p>Silicon Core Technology will hold its annual Open Day event next month, showcasing the company\'s R&D capabilities and technological achievements to industry partners. The event will open the company\'s R&D center, testing laboratories, and smart manufacturing workshops, allowing visitors to gain an in-depth understanding of the entire process from chip design to manufacturing. The three-day event is expected to host over 1,000 visitors.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news35.jpg\" alt=\"Open Day Event\"></p><p>During the Open Day, multiple technical lectures and product demonstrations will be arranged, covering topics such as AI chip architecture, IoT solutions, and automotive electronics platforms. Visitors can witness the chip design process, learn about advanced packaging and testing technologies, and participate in new product trials in the interactive experience area.</p><p>The event features a special partner exhibition area, inviting ecosystem partners to showcase innovative applications based on Silicon Core chips. Multiple technical exchange sessions will also be held, providing visitors with opportunities for direct dialogue with R&D teams. Participants can also schedule one-on-one technical consultations to obtain professional technical advice.</p><p>Silicon Core Technology hopes that through the Open Day event, it can enhance communication with the industry, showcase the company\'s achievements in technological innovation, while collecting market feedback to provide references for product optimization and technology upgrades. The event will also host multiple signing ceremonies to establish new cooperation agreements with partners.</p><p>The visit reservation channel is now open. Interested industry professionals can make online reservations through the company\'s official website. Due to venue limitations, the organizing committee recommends making reservations early to secure attendance. Live streaming will also be provided during the event for remote participation by audiences unable to attend in person.</p>', 1, 48, 1, 1762588708, 1762588708, 0, 'Annual Open Day showcases R&D capabilities, invites industry to visit R&D centers and smart manufacturing workshops', '', '开放日,技术展示,研发中心,业界交流', '', 'Silicon Core Technology holds Open Day event, showcasing R&D capabilities and technical achievements, promoting industry exchange and cooperation.', 0, '', '', '活动组委会', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (660, 20, 'Silicon Core Technology Technical Salon Focuses on Edge Computing', '/uploads/images/news/news36.jpg', '', '<p>Silicon Core Technology will hold an edge computing technology salon in Shenzhen at the end of this month, inviting industry experts to discuss the technological challenges and development opportunities of edge intelligence. The salon will focus on key technology topics such as edge AI chips, low-power design, and real-time data processing, sharing the latest technological progress and application cases.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news37.jpg\" alt=\"Technical Salon Event\"></p><p>The salon has invited multiple experts from academia and industry to share insights on hot topics including edge computing architecture design, algorithm optimization, and security protection. Participants will have the opportunity to gain an in-depth understanding of edge computing application practices in various industries, including industrial IoT, intelligent security, and vehicle networking.</p><p>The event will also feature roundtable discussions where participating experts will engage in in-depth exchanges on the standardization, industrialization, and development trends of edge computing. Participants can discuss technical challenges and industry pain points face-to-face with experts, seeking solutions and cooperation opportunities.</p><p>Silicon Core Technology will showcase its latest edge computing chips and solutions at the salon, including low-power AI inference chips and multi-mode communication chips. Live technology demonstrations will also be conducted to showcase the application effects of edge computing in real scenarios.</p><p>This salon is an important component of Silicon Core Technology\'s technical exchange series. The company hopes that through such events, it can promote technology sharing and industrial collaboration, driving innovation and application of edge computing technology. Registration for the event has started, with limited seats available. Technical professionals interested are advised to register early.</p>', 1, 47, 1, 1762588708, 1762588708, 0, 'Edge computing technology salon discusses edge intelligence development, shares latest technological progress and application practices', '', '技术沙龙,Edge Computing,AI Chip,Industry Exchange', '', 'Silicon Core Technology holds edge computing technology salon, inviting experts to discuss edge intelligence technology challenges and development opportunities.', 0, '', '', '技术交流部', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (661, 20, 'Silicon Core Technology Partners Conference Successfully Held', '/uploads/images/news/news38.jpg', '', '<p>Silicon Core Technology\'s 2024 Annual Partners Conference was successfully held in Shanghai, with representatives from over 200 global partners attending the grand event. With the theme \"Collaborating on Innovation, Winning the Future Together,\" the conference reviewed cooperation achievements over the past year and looked forward to future cooperation opportunities and development directions.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news39.jpg\" alt=\"Partners Conference\"></p><p>During the conference, Silicon Core Technology released a new partner program, including technical training, market support, and joint innovation. The company also signed strategic cooperation agreements with multiple partners to conduct in-depth cooperation in product R&D, market expansion, and ecosystem building.</p><p>Participating partners showcased rich application cases based on Silicon Core chips, covering multiple fields including smart home, industrial automation, and automotive electronics. These cases fully demonstrate the technological advantages and practical value of Silicon Core chips in different application scenarios.</p><p>The conference also featured a partner awards ceremony, recognizing outstanding partners from the past year. Awards included Best Technology Innovation Award, Best Market Development Award, and Best Service Support Award, with a total of 20 partners receiving recognition.</p><p>Silicon Core Technology stated that partners are an important support for the company\'s development. In the future, it will continue to increase investment, improve the cooperation ecosystem, and provide partners with better technical support and business opportunities. The company plans to expand the number of partners to 500 within the next three years, jointly promoting chip technology innovation and application.</p>', 1, 46, 1, 1762588708, 1762588708, 0, 'Annual Partners Conference brings together global partners, releases new cooperation plans and future development outlook', '', '合作伙伴,生态建设,战略合作,市场拓展', '', 'Silicon Core Technology Partners Conference successfully held, releasing new cooperation plans and discussing development strategies with partners.', 0, '', '', '合作发展部', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (662, 20, 'Silicon Core Technology Technical Training Courses Begin Enrollment', '/uploads/images/news/news40.jpg', '', '<p>Silicon Core Technology\'s 2024 technical training courses have officially begun enrollment. These courses target engineers and technical personnel, offering courses in chip design, embedded development, AI algorithms, and other directions. The training adopts a combination of online and offline methods, lasting two months, with an expected enrollment of over 1,000 trainees.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news41.jpg\" alt=\"Technical Training Courses\"></p><p>The training courses are jointly taught by the company\'s senior technical experts and external invited lecturers, covering theoretical foundations, practical cases, and the latest technological trends. Through theoretical learning and project practice, trainees will master core knowledge and application skills of chip-related technologies.</p><p>This training specifically includes specialized courses in popular directions such as AI chip design, IoT system development, and automotive electronics applications. Trainees can choose appropriate course modules based on their needs and can also participate in actual project development to accumulate practical experience.</p><p>After completing the training, participants will receive a completion certificate issued by Silicon Core Technology. Outstanding trainees will have opportunities for internships or employment with the company. The company will also provide continuous technical support and development guidance for trainees.</p><p>Silicon Core Technology hopes that through technical training, it can help technical personnel enhance professional skills while cultivating more professional talent for the industry. Training registration has started. Interested engineers can view detailed course schedules and register online through the company\'s official website.</p>', 1, 45, 1, 1762588708, 1762588708, 0, 'Annual technical training courses enrollment opens, providing professional courses in chip design, embedded development, AI algorithms', '', '技术培训,人才培养,专业技能,工程师培训', '', 'Silicon Core Technology technical training courses begin enrollment, providing professional training in chip design and AI algorithms for engineers.', 0, '', '', '培训发展部', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (663, 20, 'Silicon Core Technology Participates in Global Semiconductor Exhibition', '/uploads/images/news/news42.jpg', '', '<p>Silicon Core Technology will participate in the Global Semiconductor Exhibition held in the United States next month, showcasing the company\'s latest achievements in advanced process technology and chip innovation. The exhibition will focus on products such as 7nm AI training chips, edge inference chips, and automotive electronics platforms, sharing technological progress with the global industry.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news43.jpg\" alt=\"Semiconductor Exhibition\"></p><p>The booth design adopts an open layout, with product display areas, technical exchange areas, and business negotiation areas. Visitors can personally experience various application demonstrations based on Silicon Core chips, including intelligent visual processing, voice interaction, autonomous driving, and other scenarios. Technical lectures will also be held on-site to introduce chip architecture and innovative features.</p><p>The company\'s technical experts will participate in multiple technical forums during the exhibition, sharing experiences in AI chip design, energy efficiency optimization, and system integration. They will also engage in in-depth exchanges with global partners to explore technical cooperation and market opportunities.</p><p>Silicon Core Technology hopes that through this international exhibition, it can showcase the technological strength of Chinese chip enterprises, exchange learning with international peers, while seeking new cooperation opportunities. The company will also use this opportunity to understand global market trends and technological development directions, providing references for future product planning.</p><p>During the exhibition, Silicon Core Technology will host multiple business events, including partner receptions and technical seminars. Interested industry professionals can schedule meetings with company representatives in advance for in-depth technical and business exchanges.</p>', 1, 44, 1, 1762588708, 1762588708, 0, 'Participates in global semiconductor exhibition to showcase advanced process achievements and exchange technology development with international industry', '', '国际展会,技术展示,全球合作,半导体创新', '', 'Silicon Core Technology participates in global semiconductor exhibition, showcasing 7nm AI chips and other latest achievements, promoting international technical exchange.', 0, '', '', '国际市场部', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (664, 20, 'Silicon Core Technology Innovation Competition Finals Successfully Concluded', '/uploads/images/news/news44.jpg', '', '<p>Silicon Core Technology\'s 2024 Innovation Competition finals successfully concluded at the company headquarters, with 10 teams ultimately winning awards after intense competition. The competition received over 300 innovation projects from across the country, covering multiple fields including AI chip applications, IoT solutions, and intelligent hardware.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news45.jpg\" alt=\"Innovation Competition Finals\"></p><p>At the finals, shortlisted teams conducted project demonstrations and defenses. The judging panel evaluated from multiple dimensions including technological innovation, market prospects, and team capabilities. Ultimately, the \"Intelligent Medical Diagnosis System Based on AI Chips\" project won the first prize and received 500,000 yuan in project incubation funding.</p><p>The winning projects demonstrated rich creativity and technical strength, including intelligent agricultural monitoring systems, industrial IoT platforms, edge computing equipment, and other innovative applications. These projects are not only technologically advanced but also have good market application prospects.</p><p>The competition organizing committee provided rich rewards and support for winning teams, including funding support, technical guidance, market resources, and investment connections. Silicon Core Technology will also conduct in-depth cooperation with outstanding teams to jointly promote project industrialization and commercialization.</p><p>The Innovation Competition is an important initiative by Silicon Core Technology to support innovation and entrepreneurship. The company hopes that through such activities, it can stimulate innovation vitality and promote technological progress and industrial development. The next Innovation Competition will launch in spring next year, expanding the participation scope and adding more innovation tracks.</p>', 1, 43, 1, 1762588708, 1762588708, 0, 'Innovation competition finals successfully concluded, ten outstanding teams awarded showcasing rich innovation achievements', '', '创新大赛,创业支持,技术孵化,项目展示', '', 'Silicon Core Technology Innovation Competition finals concluded, ten teams awarded, showcasing AI chip and IoT innovation applications.', 0, '', '', '创新孵化部', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (665, 20, 'Silicon Core Technology Technical Exchange Discusses AI Chips', '/uploads/images/news/news46.jpg', '', '<p>Silicon Core Technology held an AI chip technical exchange in Beijing, inviting experts from academia and industry to discuss the technological challenges and development trends of AI chips. The exchange focused on key technology topics such as neural network acceleration, energy efficiency optimization, and model compression, sharing the latest research achievements and practical experiences.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news47.jpg\" alt=\"Technical Exchange\"></p><p>The meeting invited several renowned scholars and industry experts to deliver keynote reports on cutting-edge topics including AI chip architecture innovation, algorithm-hardware co-design, and large model inference optimization. Participants engaged in in-depth discussions on technical difficulties and solutions, exchanging their respective research achievements and practical experiences.</p><p>Silicon Core Technology showcased its latest AI chip products and solutions at the exchange, including training chips, inference chips, and edge AI chips. The technical team also shared their technology accumulation and practical insights in chip design, algorithm optimization, and system integration.</p><p>The exchange also featured a technology exhibition session, where multiple partners showcased innovative applications based on Silicon Core AI chips, including intelligent visual analysis, natural language processing, and recommendation systems. These applications demonstrated the value and effectiveness of AI chips in actual business scenarios.</p><p>This technical exchange is part of Silicon Core Technology\'s technology sharing series. The company hopes that through such events, it can promote technical exchange and industrial collaboration, driving innovation and development of AI chip technology. More thematic technical exchange activities will be held in the future, covering different technical fields and application scenarios.</p>', 1, 42, 1, 1762588708, 1762588708, 0, 'AI chip technical exchange discusses neural network acceleration, energy efficiency optimization and other key technology development', '', '技术交流,AI Chip,神经网络,能效优化', '', 'Silicon Core Technology holds AI chip technical exchange, experts discuss AI chip technology challenges and development trends.', 0, '', '', '技术研发部', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (666, 20, 'Silicon Core Technology Public Science Activities Enter Campuses', '/uploads/images/news/news48.jpg', '', '<p>Silicon Core Technology\'s public science activities entered multiple primary and secondary school campuses this month, introducing students to the basic principles and application scenarios of chip technology through lively and interesting science lectures and practical activities. The activities aim to stimulate teenagers\' interest in technology and cultivate future technological innovation talent.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news49.jpg\" alt=\"Science Activities Enter Campuses\"></p><p>The science activities included chip knowledge lectures, hands-on experiments, and technology project exhibitions. Company engineers explained chip working principles in easy-to-understand language, demonstrating chip applications in daily products such as smartphones, computers, and smart homes. Students could also participate in simple circuit experiments to personally experience the charm of electronic technology.</p><p>The activities also set up technology innovation workshops, guiding students to create simple electronic projects using open-source hardware. Through hands-on practice, students not only learned electronic knowledge but also developed innovative thinking and problem-solving abilities. Outstanding projects were exhibited and shared at schools.</p><p>Silicon Core Technology donated science books and experimental equipment to participating schools, supporting schools in carrying out technology education activities. The company also plans to establish long-term cooperation relationships with schools, regularly conducting science activities to provide students with continuous learning opportunities.</p><p>Public science activities are an important component of Silicon Core Technology\'s corporate social responsibility projects. The company hopes that through such activities, it can promote the popularization of technology education and contribute to cultivating future technology talent. Future activities will expand their scope to benefit more schools and students.</p>', 1, 41, 1, 1762588708, 1762588708, 0, 'Public science activities enter primary and secondary school campuses, stimulating youth interest in technology through lectures and experiments', '', '公益科普,科技教育,校园活动,人才培养', '', 'Silicon Core Technology public science activities enter campuses, introducing students to chip technology and cultivating interest in technological innovation.', 0, '', '', '公益事业部', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 5, '0', '', '');
INSERT INTO `ry_en_article` VALUES (667, 20, 'Silicon Core Technology Technical Seminar Focuses on Automotive Electronics', '/uploads/images/news/news50.jpg', '', '<p>Silicon Core Technology held an automotive electronics technical seminar in Munich, Germany, jointly discussing the technological requirements and development trends of intelligent connected vehicles with European automakers and component suppliers. The seminar focused on key technology areas such as autonomous driving, intelligent cockpits, and vehicle networking, sharing the latest technological progress and solutions.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news29.jpg\" alt=\"Automotive Electronics Seminar\"></p><p>The meeting invited technical experts from several well-known European automakers to engage in in-depth exchanges on automotive electronics technology standards, safety requirements, and performance indicators. Silicon Core Technology showcased its latest automotive electronics chips and platform solutions, including autonomous driving computing chips, intelligent cockpit processors, and vehicle networking communication chips.</p><p>The seminar also featured technical demonstration sessions, showcasing autonomous driving prototype systems and intelligent cockpit solutions based on Silicon Core chips. Participants could personally experience the functions and performance of these systems and engage in in-depth discussions with R&D teams on technical details.</p><p>Silicon Core Technology reached technical cooperation intentions with multiple European automakers and will conduct in-depth cooperation in autonomous driving and intelligent connectivity. The company will also establish a European R&D center to strengthen localized technical support and product development.</p><p>This seminar is an important initiative of Silicon Core Technology\'s globalization strategy. The company hopes that through cooperation with international automakers, it can enhance its technological strength and market position in the automotive electronics field. Similar technical exchange activities will be held in other regions in the future to promote the development of global automotive electronics technology.</p>', 1, 40, 1, 1762588708, 1762588708, 0, 'Automotive electronics technical seminar held in Munich, discussing autonomous driving and intelligent cockpit development', '', '技术研讨,Automotive Electronics,自动驾驶,国际合作', '', 'Silicon Core Technology holds automotive electronics technical seminar in Munich, discussing intelligent connected vehicle technology with European manufacturers.', 0, '', '', '汽车电子部', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
INSERT INTO `ry_en_article` VALUES (668, 20, 'Silicon Core Technology Annual Technical Forum to be Held Soon', '/uploads/images/news/news28.jpg', '', '<p>Silicon Core Technology\'s Annual Technical Forum will be held next quarter at the Shanghai International Convention Center. With the theme \"Chip Innovation, Leading the Future Intelligently,\" the forum will bring together industry experts, scholars, and enterprise representatives to jointly discuss development trends and innovation opportunities in chip technology. The forum is expected to attract over 1,500 participants.</p><p style=\"text-align: center;\"><img src=\"/uploads/images/news/news27.jpg\" alt=\"Technical Forum Preview\"></p><p>The forum will feature a main venue and multiple parallel sub-forums, covering multiple technology fields including AI chips, IoT, automotive electronics, and industrial control. Renowned scholars and industry leaders will deliver keynote speeches, sharing the latest research achievements and industry insights. Participants can also join technical workshops and roundtable discussions for in-depth exchanges on technical topics.</p><p>Silicon Core Technology will release multiple technological innovation achievements during the forum, including new chip architectures, algorithm optimizations, and system solutions. Technical teams will also conduct live demonstrations to showcase the application effects and performance of these technologies in real scenarios.</p><p>The forum will also host innovation project exhibitions and investment matching activities, building an exchange platform for startup teams and investors. Outstanding innovation projects will have opportunities to receive technical support and investment opportunities from Silicon Core Technology, accelerating technology transfer and commercialization processes.</p><p>Registration for the forum will start soon. Interested industry professionals can follow the company\'s official website and social media for the latest information. The organizing committee will offer discounts for early registrants and establish special channels for student participants. Multiple networking events will also be held during the forum to promote exchanges and cooperation among participants.</p>', 1, 39, 1, 1762588708, 1762588708, 0, 'Annual technical forum gathers industry experts to discuss chip technology innovation trends and opportunities', '', '技术论坛,Industry Exchange,创新成果,技术分享', '', 'Silicon Core Technology Annual Technical Forum to be held soon, discussing technological innovation and development trends in AI chips, IoT and other fields.', 0, '', '', '论坛组委会', 'Silicon Core Tech News Center', 1, 30, '', '', '', '', '', NULL, NULL, 0, '0', '', '');
COMMIT;

-- ----------------------------
-- Table structure for ry_en_cate
-- ----------------------------
DROP TABLE IF EXISTS `ry_en_cate`;
CREATE TABLE `ry_en_cate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Category ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Parent Category ID',
  `title` varchar(120) NOT NULL DEFAULT '' COMMENT 'Category Name',
  `ename` varchar(120) DEFAULT '' COMMENT 'English Name/Route',
  `sname` varchar(120) DEFAULT '' COMMENT 'Subtitle',
  `thumb` varchar(500) DEFAULT '' COMMENT 'Thumbnail',
  `background` varchar(500) DEFAULT '' COMMENT 'Background Image',
  `sort` int(10) unsigned NOT NULL DEFAULT '50' COMMENT 'Sort: Smaller number appears first',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Category Type: 1-Article List 2-Single Page 3-Image List 4-Product 5-News',
  `navmenu` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Navigation Display: 1-Show 0-Hide',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Status: 1-Enable 0-Disable',
  `page_tmp` varchar(120) NOT NULL DEFAULT 'index_article.htm' COMMENT 'Page Template',
  `lst_tmp` varchar(120) NOT NULL DEFAULT 'list_article.htm' COMMENT 'List Template',
  `article_tmp` varchar(120) NOT NULL DEFAULT 'article_article.htm' COMMENT 'Article Template',
  `jump_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Redirect Category ID',
  `keywords` varchar(255) DEFAULT '' COMMENT 'Keywords',
  `description` varchar(500) DEFAULT '' COMMENT 'Description',
  `content` text COMMENT 'Category Content',
  `link` varchar(500) DEFAULT '' COMMENT 'External Link',
  `adminid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Administrator ID',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT 'Creation Time',
  `annex` varchar(500) DEFAULT '' COMMENT 'Attachment',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT 'Update Time',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT 'Delete Time',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_pid` (`pid`),
  KEY `idx_type` (`type`),
  KEY `idx_navmenu` (`navmenu`),
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`),
  KEY `idx_create_time` (`create_time`),
  KEY `idx_adminid` (`adminid`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COMMENT='Category Table';

-- ----------------------------
-- Records of ry_en_cate
-- ----------------------------
BEGIN;
INSERT INTO `ry_en_cate` VALUES (1, 0, 'About', 'about', 'Founded in 2010, dedicated to integrated chip design, R&D, and manufacturing services', '', '/uploads/images/banner-about.jpg', 1, 1, 1, 1, 'index_article.htm', 'list_about.htm', 'article_article.htm', 2, 'Company Introduction,Development History,Corporate Culture', 'Learn about Xinke Technology\'s development history and corporate culture', '', 'about.html', 1, 1744273413, '', 1762841376, 0);
INSERT INTO `ry_en_cate` VALUES (2, 1, 'Company Introduction', 'company', 'Xinke Technology - Leading Chip Technology, Creating an Intelligent Future', '', '/uploads/images/banner-about.jpg', 1, 1, 1, 1, 'index_article.htm', 'list_about.htm', 'article_article.htm', 0, 'Company Profile,Enterprise Introduction', 'Detailed introduction of Xinke Technology', '<p>Xinke Technology is a high-tech enterprise focusing on high-end chip design and manufacturing. We have a complete chip R&D industry chain, from chip design, tape-out manufacturing to packaging and testing, providing customers with one-stop solutions.</p>', 'about.html', 1, 1744273949, '', 1762247140, 0);
INSERT INTO `ry_en_cate` VALUES (3, 1, 'Development History', 'history', 'Witness the Growth and Transformation of Xinke Technology', '', '/uploads/images/banner-about.jpg', 2, 1, 1, 1, 'index_article.htm', 'list_history.htm', 'article_article.htm', 0, 'Development History,Milestones', 'Xinke Technology Development History', '', 'about.html', 1, 1744273966, '', 1762244439, 0);
INSERT INTO `ry_en_cate` VALUES (4, 1, 'Company Advantages', 'advantages', 'Core Competitiveness of Xinke Technology', '', '/uploads/images/banner-about.jpg', 3, 1, 1, 1, 'index_article.htm', 'list_about_icon.htm', 'article_article.htm', 0, 'Core Advantages,Competitive Advantages', 'Introduction to Xinke Technology\'s Core Competitiveness', '', 'about.html', 1, 1744273987, '', 1762245114, 0);
INSERT INTO `ry_en_cate` VALUES (5, 1, 'Honors and Qualifications', 'honors', 'Honors and Recognitions Received by Xinke Technology', '', '/uploads/images/banner-about.jpg', 4, 1, 1, 1, 'index_article.htm', 'list_about_icon.htm', 'article_article.htm', 0, 'Honors and Qualifications,Certifications', 'Honors and Qualifications Obtained by Xinke Technology', '', 'about.html', 1, 1744273988, '', 1762246972, 0);
INSERT INTO `ry_en_cate` VALUES (6, 0, 'Products', 'products', 'Become a Global Professional Chip Design Enterprise', '', '/uploads/images/banner-products.jpg', 2, 4, 1, 1, 'index_article.htm', 'list_product.htm', 'article_product.htm', 0, 'AI Chips,IoT Chips,Auto Electronics Chips', 'Xinke Technology Products Center', '', 'product.html', 1, 1744273857, '', 1762841387, 0);
INSERT INTO `ry_en_cate` VALUES (7, 6, 'AI Chips', 'ai-chips', 'AI Chips', '', '/uploads/images/banner-products.jpg', 1, 4, 1, 1, 'index_article.htm', 'list_product.htm', 'article_product.htm', 0, 'Artificial Intelligence Chips,AI Processors', 'Dedicated AI Chip Products', '', 'product.html', 1, 1744274009, '', 1762589323, 0);
INSERT INTO `ry_en_cate` VALUES (8, 6, 'IoT Chips', 'iot-chips', 'IoT Chips', '', '/uploads/images/banner-products-iot.jpg', 2, 4, 1, 1, 'index_article.htm', 'list_product.htm', 'article_product.htm', 0, 'IoT Chips,Connectivity Chips', 'IoT Connectivity Chip Products', '', 'product.html', 1, 1744430897, '', 1756654358, 0);
INSERT INTO `ry_en_cate` VALUES (9, 6, 'Auto Electronics Chips', 'auto-chips', 'Auto Chips', '', '/uploads/images/banner-products-auto.jpg', 3, 4, 1, 1, 'index_article.htm', 'list_product.htm', 'article_product.htm', 0, 'Auto Chips,Automotive-grade Chips', 'Dedicated Auto Electronics Chips', '', 'product.html', 1, 1744431455, '', 1753972616, 0);
INSERT INTO `ry_en_cate` VALUES (10, 6, 'Consumer Electronics Chips', 'consumer-chips', 'Consumer Chips', '', '/uploads/images/banner-products-other.jpg', 4, 4, 1, 1, 'index_article.htm', 'list_product.htm', 'article_product.htm', 0, 'Consumer Electronics,Mobile Phone Chips', 'Consumer Electronics Chip Products', '', 'product.html', 1, 1744638366, '', 1750319055, 0);
INSERT INTO `ry_en_cate` VALUES (11, 0, 'Solutions', 'solutions', 'Providing Customized Chip Solutions for Different Industry Needs', '', '/uploads/images/banner-solutions.jpg', 3, 1, 1, 1, 'index_article.htm', 'list_solutions_all.htm', 'article_article.htm', 0, 'Solutions,Application Solutions', 'Industry Solutions', '', 'solutions.html', 1, 1756694600, '', 1762261396, 0);
INSERT INTO `ry_en_cate` VALUES (12, 11, 'Industry Pain Points', 'pain-points', 'Current Technical Challenges and Bottlenecks Faced by the Industry', '', '/uploads/images/banner-solutions.jpg', 1, 1, 1, 1, 'index_article.htm', 'list_solutions_one.htm', 'article_article.htm', 0, 'Industry Pain Points,Technical Challenges', 'Current Technical Challenges and Bottlenecks Faced by the Industry', '', 'solutions.html', 1, 1756694601, '', 1756694956, 0);
INSERT INTO `ry_en_cate` VALUES (13, 11, 'Core Advantages', 'core-advantages', 'Unique Value of Xinke Technology Solutions', '', '/uploads/images/banner-solutions.jpg', 2, 1, 1, 1, 'index_article.htm', 'list_solutions_two.htm', 'article_article.htm', 0, 'Core Advantages,Unique Value', 'Unique Value of Xinke Technology Solutions', '', 'solutions.html', 1, 1756694602, '', 1756694957, 0);
INSERT INTO `ry_en_cate` VALUES (14, 11, 'Solution Approach', 'solution-approach', 'Comprehensive Technical Path from Chips to Systems', '', '/uploads/images/banner-solutions.jpg', 3, 1, 1, 1, 'index_article.htm', 'list_solutions_three.htm', 'article_article.htm', 0, 'Solution Approach,Technical Path', 'Comprehensive Technical Path from Chips to Systems', '', 'solutions.html', 1, 1756694603, '', 1756694958, 0);
INSERT INTO `ry_en_cate` VALUES (15, 11, 'Solutions List', 'solutions-list', 'Professional Solutions for Different Industry Needs', '', '/uploads/images/banner-solutions.jpg', 4, 1, 1, 1, 'index_article.htm', 'list_solutions.htm', 'article_article.htm', 0, 'Professional Solutions,Industry Solutions', 'Professional Solutions for Different Industry Needs', '', 'solutions.html', 1, 1756694604, '', 1756694959, 0);
INSERT INTO `ry_en_cate` VALUES (16, 0, 'News', 'news', 'Latest Company Updates, Industry News and Technical Q&A', '', '/uploads/images/banner-news.jpg', 4, 5, 1, 1, 'index_article.htm', 'list_news.htm', 'article_news.htm', 0, 'News,Information,Updates', 'Latest News and Information from Xinke Technology', '', 'news.html', 1, 1744638407, '', 1762841398, 0);
INSERT INTO `ry_en_cate` VALUES (17, 16, 'Company News', 'company-news', 'Company News', '', '/uploads/images/banner-news.jpg', 1, 5, 1, 1, 'index_article.htm', 'list_news.htm', 'article_news.htm', 0, 'Company News,Enterprise Updates', 'Internal News of Xinke Technology', '', 'news.html', 1, 1756654101, '', 1756654101, 0);
INSERT INTO `ry_en_cate` VALUES (18, 16, 'Industry News', 'industry-news', 'Industry News', '', '/uploads/images/banner-news.jpg', 2, 5, 1, 1, 'index_article.htm', 'list_news.htm', 'article_news.htm', 0, 'Industry News,Market Updates', 'Latest Chip Industry News', '', 'news.html', 1, 1756654116, '', 1756654116, 0);
INSERT INTO `ry_en_cate` VALUES (19, 16, 'Technology Updates', 'tech-news', 'Technology News', '', '/uploads/images/banner-news.jpg', 3, 5, 1, 1, 'index_article.htm', 'list_news.htm', 'article_news.htm', 0, 'Technology Updates,R&D Progress', 'Latest Technology R&D Updates', '', 'news.html', 1, 1756654127, '', 1756654127, 0);
INSERT INTO `ry_en_cate` VALUES (20, 16, 'Event News', 'event-news', 'Event News', '', '/uploads/images/banner-news.jpg', 4, 5, 1, 1, 'index_article.htm', 'list_news.htm', 'article_news.htm', 0, 'Events,Exhibitions,Conferences', 'Company Events and Exhibition Information', '', 'news.html', 1, 1756694599, '', 1756694954, 0);
INSERT INTO `ry_en_cate` VALUES (21, 0, 'Contact', 'contact', 'Contact Us', '', '/uploads/images/banner-contact.jpg', 5, 2, 1, 1, 'index_contact.htm', 'list_contact.htm', 'article_article.htm', 22, 'Contact Information,Contact Us', 'Contact Us Page', '', 'contact.html', 1, 1756694607, '', 1762841408, 0);
INSERT INTO `ry_en_cate` VALUES (22, 21, 'Contact Information', 'contact-info', 'Multiple Ways to Contact Us, We Are Always Ready to Serve You', '', '/uploads/images/banner-contact.jpg', 1, 2, 1, 1, 'index_contact.htm', 'list_article.htm', 'article_article.htm', 0, 'Contact Details,Address Phone', 'Detailed Contact Information', '<p>Address: Xinke Building, Zhongguancun Science Park, Haidian District, Beijing</p><p>Phone: 400-123-4567</p><p>Email: contact@xinke-tech.com</p>', 'contact.html', 1, 1756694608, '', 1762224365, 0);
INSERT INTO `ry_en_cate` VALUES (23, 21, 'Online Message', 'online-message', 'Fill out the form and we will contact you as soon as possible', '', '/uploads/images/banner-contact.jpg', 2, 2, 1, 1, 'index_form.htm', 'list_article.htm', 'article_article.htm', 0, 'Message,Feedback', 'Online Message Feedback', '', '', 1, 1756694609, '', 1762224427, 0);
INSERT INTO `ry_en_cate` VALUES (24, 21, 'Join Us', 'jobs', 'We are looking for excellent talents to create a better future together', '', '/uploads/images/banner-contact.jpg', 3, 1, 1, 1, 'index_article.htm', 'list_jobs.htm', 'article_article.htm', 0, 'Recruitment,Positions,Talents', 'Recruitment Information Page', '', 'jobs.html', 1, 1756694610, '', 1756694965, 0);
INSERT INTO `ry_en_cate` VALUES (100, 0, 'Application Fields', 'applications', 'Our chip technology is widely used in various high-tech fields', '', '/uploads/images/banner-contact.jpg', 6, 1, 0, 0, 'index_article.htm', 'list_article.htm', 'article_article.htm', 0, '', '', '', '', 1, 1761792590, '', 1761792715, 0);
INSERT INTO `ry_en_cate` VALUES (101, 0, 'Partners', 'partners', 'We have established long-term cooperative relationships with many well-known enterprises worldwide', '', '', 50, 1, 0, 0, '', '', '', 0, '', '', '', '', 0, 1762260912, '', 1762260912, 0);
COMMIT;

-- ----------------------------
-- Table structure for ry_en_conf
-- ----------------------------
DROP TABLE IF EXISTS `ry_en_conf`;
CREATE TABLE `ry_en_conf` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Configuration ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT 'Configuration Name',
  `ename` varchar(255) NOT NULL DEFAULT '' COMMENT 'Configuration Identifier',
  `value` text NOT NULL COMMENT 'Configuration Value',
  `values` varchar(1000) NOT NULL DEFAULT '' COMMENT 'Optional Values List',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Configuration Type: 1-Single Line Text 2-Radio 3-Checkbox 4-Dropdown 5-Textarea 6-Attachment 7-Float 8-Integer 9-Long Text',
  `model` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Configuration Category: 1-Basic Settings 2-SEO Settings 3-Contact Information 4-Image Watermark 5-Others',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Status: 1-Enable 0-Disable',
  `is_en` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Multi-language Support: 1-Enable 0-Disable',
  `is_os` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'System Field: 1-Yes 0-No',
  `sort` int(10) unsigned NOT NULL DEFAULT '50' COMMENT 'Sort: Smaller number appears first',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `uk_ename` (`ename`),
  KEY `idx_model` (`model`),
  KEY `idx_status` (`status`),
  KEY `idx_type` (`type`),
  KEY `idx_is_os` (`is_os`),
  KEY `idx_sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COMMENT='System Configuration Table';

-- ----------------------------
-- Records of ry_en_conf
-- ----------------------------
BEGIN;
INSERT INTO `ry_en_conf` VALUES (1, 'Site Name', 'sitename', 'Xinke Technology - Chip Technology Company Based on RoyalCMS Framework', '', 1, 1, 1, 0, 0, 1);
INSERT INTO `ry_en_conf` VALUES (2, 'Keywords', 'keywords', 'Chips,AI Chips,IoT Chips,Auto Electronics Chips,Xinke Technology', '', 1, 1, 1, 0, 0, 2);
INSERT INTO `ry_en_conf` VALUES (3, 'Website Description', 'description', 'Xinke Technology - A high-tech enterprise focusing on high-end chip design and manufacturing, providing innovative technology products such as AI chips, IoT chips, and auto electronics chips', '', 2, 1, 1, 0, 0, 3);
INSERT INTO `ry_en_conf` VALUES (4, 'Website ICP Filing', 'beian', '', '', 1, 1, 1, 0, 0, 4);
INSERT INTO `ry_en_conf` VALUES (5, 'Website Copyright', 'banquan', '© 2025 Xinke Technology All Rights Reserved | This website is built based on the RoyalCMS framework for technical demonstration purposes only. The content of this site does not constitute any commercial offer, nor is it an official source of product information.', '', 1, 1, 1, 0, 0, 11);
INSERT INTO `ry_en_conf` VALUES (6, 'Website Domain', 'www', 'www.xinke-tech.com', '', 1, 3, 1, 0, 0, 8);
INSERT INTO `ry_en_conf` VALUES (7, 'Company Phone', 'tel', '400-123-4567', '', 1, 3, 1, 0, 0, 5);
INSERT INTO `ry_en_conf` VALUES (8, 'Company Fax', 'fax', '010-12345678', '', 1, 3, 1, 0, 0, 13);
INSERT INTO `ry_en_conf` VALUES (9, 'Company Email', 'email', 'contact@xinke-tech.com', '', 1, 3, 1, 0, 0, 9);
INSERT INTO `ry_en_conf` VALUES (10, 'Company Address', 'add', 'Xinke Building, Zhongguancun Science Park, Haidian District, Beijing', '', 1, 3, 1, 0, 0, 6);
INSERT INTO `ry_en_conf` VALUES (24, 'Website Logo', 'logo', '/uploads/images/logo.png', '', 6, 2, 1, 0, 0, 14);
INSERT INTO `ry_en_conf` VALUES (29, 'Company Name', 'gsmc', 'XINKE', '', 1, 3, 1, 0, 0, 1);
INSERT INTO `ry_en_conf` VALUES (33, 'Contact Person', 'lxr', 'Mr. Zhang', '', 1, 3, 1, 0, 0, 10);
INSERT INTO `ry_en_conf` VALUES (35, 'Public Security Filing', 'wangan', '', '', 1, 1, 1, 0, 0, 7);
INSERT INTO `ry_en_conf` VALUES (36, 'Site Enabled', 'siteon', '1', '1,0', 3, 1, 1, 0, 1, 50);
INSERT INTO `ry_en_conf` VALUES (37, 'Technical Support Email', 'tech_email', 'support@xinke-tech.com', '', 1, 3, 1, 0, 0, 12);
INSERT INTO `ry_en_conf` VALUES (38, 'Sales Consultation Email', 'sales_email', 'sales@xinke-tech.com', '', 1, 3, 1, 0, 0, 14);
INSERT INTO `ry_en_conf` VALUES (39, 'Cooperation Email', 'cooperation_email', 'partner@xinke-tech.com', '', 1, 3, 1, 0, 0, 15);
INSERT INTO `ry_en_conf` VALUES (48, 'Enable Watermark', 'water', 'Disabled', 'Enabled,Disabled', 3, 4, 1, 0, 1, 19);
INSERT INTO `ry_en_conf` VALUES (49, 'Watermark Image', 'waterimg', '/uploads/images/watermark.png', '', 6, 4, 1, 0, 1, 18);
INSERT INTO `ry_en_conf` VALUES (50, 'Watermark Position', 'water_position', 'Bottom Right', 'Top Left,Top Right,Bottom Left,Bottom Right,Center', 4, 4, 1, 0, 1, 17);
INSERT INTO `ry_en_conf` VALUES (51, 'Watermark Opacity', 'water_opacity', '80', '', 8, 4, 1, 0, 1, 16);
INSERT INTO `ry_en_conf` VALUES (59, 'Weibo Link', 'weibo', 'https://weibo.com/xinketech', '', 1, 5, 1, 0, 0, 20);
INSERT INTO `ry_en_conf` VALUES (60, 'Website Favicon', 'favicon', '/uploads/images/favicon.png', '', 6, 2, 1, 0, 0, 16);
INSERT INTO `ry_en_conf` VALUES (61, 'Zhihu Link', 'zhihu', 'https://www.zhihu.com/org/xin-ke-ke-ji', '', 1, 5, 1, 0, 0, 21);
INSERT INTO `ry_en_conf` VALUES (62, 'Bilibili Link', 'bilibili', 'https://space.bilibili.com/xinketech', '', 1, 5, 1, 0, 0, 22);
INSERT INTO `ry_en_conf` VALUES (63, 'LinkedIn Link', 'linkedin', 'https://www.linkedin.com/company/xinke-tech', '', 1, 5, 1, 0, 0, 23);
INSERT INTO `ry_en_conf` VALUES (64, 'GitHub Link', 'github', 'https://github.com/xinke-tech', '', 1, 5, 1, 0, 0, 24);
INSERT INTO `ry_en_conf` VALUES (69, 'Footer Logo', 'footerlogo', '/uploads/images/footer-logo.png', '', 6, 2, 1, 0, 0, 17);
INSERT INTO `ry_en_conf` VALUES (72, 'Technical Support Phone', 'tech_tel', '400-123-4567 ext 1', '', 1, 5, 1, 0, 0, 31);
INSERT INTO `ry_en_conf` VALUES (73, 'Sales Consultation Phone', 'sales_tel', '400-123-4567 ext 2', '', 1, 5, 1, 0, 0, 32);
INSERT INTO `ry_en_conf` VALUES (74, 'Cooperation Phone', 'cooperation_tel', '400-123-4567 ext 3', '', 1, 5, 1, 0, 0, 33);
INSERT INTO `ry_en_conf` VALUES (75, 'Service Hours', 'service_time', 'Monday to Friday 9:00-18:00', '', 1, 5, 1, 0, 0, 34);
INSERT INTO `ry_en_conf` VALUES (76, 'Technical Documentation Download', 'doc_download', '/downloads/technical-docs/', '', 1, 5, 1, 0, 0, 35);
INSERT INTO `ry_en_conf` VALUES (77, 'SDK Download', 'sdk_download', '/downloads/sdk/', '', 1, 5, 1, 0, 0, 36);
INSERT INTO `ry_en_conf` VALUES (78, 'Driver Download', 'driver_download', '/downloads/drivers/', '', 1, 5, 1, 0, 0, 37);
INSERT INTO `ry_en_conf` VALUES (79, 'Whitepaper Download', 'whitepaper_download', '/downloads/whitepapers/', '', 1, 5, 1, 0, 0, 38);
INSERT INTO `ry_en_conf` VALUES (80, 'Online Consultation QQ', 'consult_qq', '123456789', '', 1, 5, 1, 0, 0, 39);
INSERT INTO `ry_en_conf` VALUES (81, 'Online Consultation WeChat', 'consult_wechat', 'xinke_tech', '', 1, 5, 1, 0, 0, 40);
INSERT INTO `ry_en_conf` VALUES (82, 'Consultation Working Hours', 'consult_time', 'Monday to Sunday 9:00-21:00', '', 1, 5, 1, 0, 0, 41);
INSERT INTO `ry_en_conf` VALUES (83, 'Emergency Technical Support', 'emergency_support', '13800138000', '', 1, 5, 1, 0, 0, 42);
INSERT INTO `ry_en_conf` VALUES (85, 'WeChat Official Account', 'wechat', '/uploads/images/wechat-qrcode.png', '', 6, 2, 1, 0, 0, 7);
INSERT INTO `ry_en_conf` VALUES (91, 'WeChat Consultation', 'wechatt', '/uploads/images/wechat-service.png', '', 6, 2, 1, 0, 0, 22);
INSERT INTO `ry_en_conf` VALUES (99, 'Douyin QR Code', 'douyin', '/uploads/images/douyin-qrcode.png', '', 6, 2, 1, 0, 0, 15);
INSERT INTO `ry_en_conf` VALUES (100, 'Working Hours', 'worktime', 'Monday to Friday: 9:00-18:00', '', 1, 1, 1, 0, 0, 50);
COMMIT;

-- ----------------------------
-- Table structure for ry_en_link
-- ----------------------------
DROP TABLE IF EXISTS `ry_en_link`;
CREATE TABLE `ry_en_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '链接ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '链接名称',
  `url` varchar(500) NOT NULL DEFAULT '' COMMENT '链接地址',
  `thumb` varchar(500) DEFAULT '' COMMENT '链接图片',
  `desc` varchar(500) DEFAULT '' COMMENT '链接描述',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '链接类型：1-文字链接 2-图片链接',
  `sort` int(10) unsigned NOT NULL DEFAULT '50' COMMENT '排序：数值越小越靠前',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1-启用 0-禁用',
  `adminid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_type` (`type`),
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`),
  KEY `idx_adminid` (`adminid`),
  KEY `idx_create_time` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='友情链接表';

-- ----------------------------
-- Records of ry_en_link
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for ry_en_log
-- ----------------------------
DROP TABLE IF EXISTS `ry_en_log`;
CREATE TABLE `ry_en_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '日志ID',
  `adminid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `groupid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理组ID',
  `uname` varchar(128) NOT NULL DEFAULT '' COMMENT '管理员用户名',
  `login_ip` varchar(45) NOT NULL DEFAULT '' COMMENT '登录IP',
  `login_time` int(11) NOT NULL DEFAULT '0' COMMENT '登录时间',
  `login_os` varchar(500) DEFAULT '' COMMENT '登录系统信息',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_adminid` (`adminid`),
  KEY `idx_groupid` (`groupid`),
  KEY `idx_login_time` (`login_time`),
  KEY `idx_uname` (`uname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='登录日志表';

-- ----------------------------
-- Records of ry_en_log
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for ry_en_tag
-- ----------------------------
DROP TABLE IF EXISTS `ry_en_tag`;
CREATE TABLE `ry_en_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '标签名称',
  `ename` varchar(50) DEFAULT NULL COMMENT '英文名称',
  `color` varchar(20) DEFAULT '#3498db' COMMENT '标签颜色',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态：1启用 0禁用',
  `sort` int(11) DEFAULT '0' COMMENT '排序',
  `click` int(11) DEFAULT '0' COMMENT '点击量',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `status` (`status`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COMMENT='标签表';

-- ----------------------------
-- Records of ry_en_tag
-- ----------------------------
BEGIN;
INSERT INTO `ry_en_tag` VALUES (1, '人工智能', 'ai', '#e74c3c', 1, 1, 1560, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (2, '机器学习', 'machine-learning', '#9b59b6', 1, 2, 1280, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (3, '深度学习', 'deep-learning', '#3498db', 1, 3, 980, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (4, '大数据', 'big-data', '#2ecc71', 1, 4, 1120, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (5, '云计算', 'cloud-computing', '#f39c12', 1, 5, 890, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (6, '物联网', 'iot', '#1abc9c', 1, 6, 760, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (7, '5G技术', '5g', '#e67e22', 1, 7, 680, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (8, '区块链', 'blockchain', '#34495e', 1, 8, 540, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (9, '网络安全', 'cybersecurity', '#c0392b', 1, 9, 920, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (10, '前端开发', 'frontend', '#2980b9', 1, 10, 1340, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (11, '后端开发', 'backend', '#8e44ad', 1, 11, 1100, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (12, '移动开发', 'mobile', '#27ae60', 1, 12, 780, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (13, '数据库', 'database', '#d35400', 1, 13, 950, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (14, 'DevOps', 'devops', '#16a085', 1, 14, 620, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (15, '微服务', 'microservices', '#2c3e50', 1, 15, 580, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (16, '容器技术', 'container', '#7f8c8d', 1, 16, 710, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (17, '开源项目', 'open-source', '#e74c3c', 1, 17, 830, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (18, '技术架构', 'architecture', '#9b59b6', 1, 18, 690, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (19, '性能优化', 'performance', '#3498db', 1, 19, 520, 1762183762, NULL);
INSERT INTO `ry_en_tag` VALUES (20, '用户体验', 'ux', '#2ecc71', 1, 20, 450, 1762183762, NULL);
COMMIT;

-- ----------------------------
-- Table structure for ry_form
-- ----------------------------
DROP TABLE IF EXISTS `ry_form`;
CREATE TABLE `ry_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '姓名',
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '手机号码',
  `tel` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '固定电话',
  `num` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '编号',
  `card_id` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '身份证号',
  `content` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '全名',
  `address` varchar(500) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '详细地址',
  `ip` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'IP地址',
  `passport` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '护照号码',
  `wechat` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '微信/QQ',
  `user_agent` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户代理',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '邮箱地址',
  `verify_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '验证码',
  `city` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '城市',
  `area` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '区域位置',
  `form_type` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '表单类型 1-默认',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态 0-待处理 1-已处理',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_phone` (`phone`),
  KEY `idx_email` (`email`),
  KEY `idx_create_time` (`create_time`),
  KEY `idx_status` (`status`),
  KEY `idx_form_type` (`form_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='留言表单表';

-- ----------------------------
-- Records of ry_form
-- ----------------------------
BEGIN;
COMMIT;

-- ----------------------------
-- Table structure for ry_link
-- ----------------------------
DROP TABLE IF EXISTS `ry_link`;
CREATE TABLE `ry_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '链接ID',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '链接名称',
  `url` varchar(500) NOT NULL DEFAULT '' COMMENT '链接地址',
  `thumb` varchar(500) DEFAULT '' COMMENT '链接图片',
  `desc` varchar(500) DEFAULT '' COMMENT '链接描述',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '链接类型：1-文字链接 2-图片链接',
  `sort` int(10) unsigned NOT NULL DEFAULT '50' COMMENT '排序：数值越小越靠前',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：1-启用 0-禁用',
  `adminid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `delete_time` int(11) NOT NULL DEFAULT '0' COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_type` (`type`),
  KEY `idx_status` (`status`),
  KEY `idx_sort` (`sort`),
  KEY `idx_adminid` (`adminid`),
  KEY `idx_create_time` (`create_time`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='友情链接表';

-- ----------------------------
-- Records of ry_link
-- ----------------------------
BEGIN;
INSERT INTO `ry_link` VALUES (1, 'royalcms', 'https://www.royalcms.com.cn', '', '', 1, 50, 1, 0, 1764578298, 1764578298, 0);
COMMIT;

-- ----------------------------
-- Table structure for ry_log
-- ----------------------------
DROP TABLE IF EXISTS `ry_log`;
CREATE TABLE `ry_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '日志ID',
  `adminid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员ID',
  `groupid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理组ID',
  `uname` varchar(128) NOT NULL DEFAULT '' COMMENT '管理员用户名',
  `login_ip` varchar(45) NOT NULL DEFAULT '' COMMENT '登录IP',
  `login_time` int(11) NOT NULL DEFAULT '0' COMMENT '登录时间',
  `login_os` varchar(500) DEFAULT '' COMMENT '登录系统信息',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_adminid` (`adminid`),
  KEY `idx_groupid` (`groupid`),
  KEY `idx_login_time` (`login_time`),
  KEY `idx_uname` (`uname`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='登录日志表';

-- ----------------------------
-- Records of ry_log
-- ----------------------------
BEGIN;
INSERT INTO `ry_log` VALUES (1, 1, 1, 'demo', '::1', 1764581471, 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:145.0) Gecko/20100101 Firefox/145.0');
INSERT INTO `ry_log` VALUES (2, 1, 1, 'demo', '::1', 1764581542, 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:145.0) Gecko/20100101 Firefox/145.0');
INSERT INTO `ry_log` VALUES (3, 1, 1, 'demo', '::1', 1764581599, 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:145.0) Gecko/20100101 Firefox/145.0');
COMMIT;

-- ----------------------------
-- Table structure for ry_tag
-- ----------------------------
DROP TABLE IF EXISTS `ry_tag`;
CREATE TABLE `ry_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '标签名称',
  `ename` varchar(50) DEFAULT NULL COMMENT '英文名称',
  `color` varchar(20) DEFAULT '#3498db' COMMENT '标签颜色',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态：1启用 0禁用',
  `sort` int(11) DEFAULT '0' COMMENT '排序',
  `click` int(11) DEFAULT '0' COMMENT '点击量',
  `create_time` int(11) DEFAULT NULL COMMENT '创建时间',
  `update_time` int(11) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `status` (`status`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COMMENT='标签表';

-- ----------------------------
-- Records of ry_tag
-- ----------------------------
BEGIN;
INSERT INTO `ry_tag` VALUES (1, '人工智能', 'ai', '#e74c3c', 1, 1, 1560, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (2, '机器学习', 'machine-learning', '#9b59b6', 1, 2, 1280, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (3, '深度学习', 'deep-learning', '#3498db', 1, 3, 980, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (4, '大数据', 'big-data', '#2ecc71', 1, 4, 1120, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (5, '云计算', 'cloud-computing', '#f39c12', 1, 5, 890, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (6, '物联网', 'iot', '#1abc9c', 1, 6, 760, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (7, '5G技术', '5g', '#e67e22', 1, 7, 680, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (8, '区块链', 'blockchain', '#34495e', 1, 8, 540, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (9, '网络安全', 'cybersecurity', '#c0392b', 1, 9, 920, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (10, '前端开发', 'frontend', '#2980b9', 1, 10, 1340, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (11, '后端开发', 'backend', '#8e44ad', 1, 11, 1100, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (12, '移动开发', 'mobile', '#27ae60', 1, 12, 780, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (13, '数据库', 'database', '#d35400', 1, 13, 950, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (14, 'DevOps', 'devops', '#16a085', 1, 14, 620, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (15, '微服务', 'microservices', '#2c3e50', 1, 15, 580, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (16, '容器技术', 'container', '#7f8c8d', 1, 16, 710, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (17, '开源项目', 'open-source', '#e74c3c', 1, 17, 830, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (18, '技术架构', 'architecture', '#9b59b6', 1, 18, 690, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (19, '性能优化', 'performance', '#3498db', 1, 19, 520, 1762183762, NULL);
INSERT INTO `ry_tag` VALUES (20, '用户体验', 'ux', '#2ecc71', 1, 20, 450, 1762183762, NULL);
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;
