// ---------------------------- 多语言切换功能 ----------------------------
function initLangSwitch() {
    // 初始化语言切换按钮事件
    $('.lang-btn').on('click', function () {
        const lang = $(this).data('lang'); // 获取目标语言
        switchLanguage(lang); // 执行语言切换
    });
}

// 语言切换核心函数
function switchLanguage(lang) {
    // 根据语言显示不同的加载提示
    const loadingText = lang === 'zh-cn' ? '切换语言中...' : 'Switching language...';
    const loadingIndex = layer.msg(loadingText, {
        icon: 16,
        time: 0
    });

    $.ajax({
        url: '/language/switch', // 语言切换接口
        type: 'POST', // POST请求
        data: { lang: lang }, // 语言参数
        dataType: 'json', // 返回JSON格式
        success: function (response) {
            layer.close(loadingIndex); // 关闭加载提示

            if (response.code === 200) {
                layer.msg(response.msg); // 显示后台返回的成功提示

                // 延迟刷新让用户看到提示
                setTimeout(function () {
                    window.location.reload(); // 刷新页面
                }, 800);
            } else {
                // 根据当前语言显示错误提示
                const errorMsg = lang === 'zh-cn' ? '操作失败' : 'Operation failed';
                layer.msg(response.msg || errorMsg);
            }
        },
        error: function () {
            layer.close(loadingIndex); // 关闭加载提示
            // 根据当前语言显示网络错误
            const errorMsg = lang === 'zh-cn' ? '网络错误，请重试' : 'Network error, please try again';
            layer.msg(errorMsg);
        }
    });
}

// ---------------------------- 表单提交处理 ----------------------------
function initFormSubmit() {
    $(".form-msg").on('submit', function (e) {
        e.preventDefault(); // 阻止默认提交
        const $form = $(this); // 获取表单元素
        const $submitBtn = $form.find('button[type="submit"]'); // 获取提交按钮

        // 根据页面语言显示提交提示
        const currentLang = $('html').attr('lang') || 'zh-cn';
        const submitText = currentLang === 'zh-cn' ? '提交中...' : 'Submitting...';
        const submitIndex = layer.msg(submitText, { icon: 16, time: 0 });

        // 禁用提交按钮防止重复提交
        $submitBtn.prop('disabled', true).addClass('disabled');

        $.ajax({
            url: $form.attr('action'), // 使用表单的action属性
            data: $form.serialize(), // 序列化表单数据
            type: 'POST', // POST请求
            dataType: 'json', // 返回JSON格式
            success: function (data) {
                layer.close(submitIndex); // 关闭提交提示
                $submitBtn.prop('disabled', false).removeClass('disabled'); // 启用按钮

                showStatusMessage(data); // 显示结果消息
                if (data.code === 200) {
                    $form[0].reset(); // 清空表单
                }
            },
            error: function (xhr, status, error) {
                layer.close(submitIndex); // 关闭提交提示
                $submitBtn.prop('disabled', false).removeClass('disabled'); // 启用按钮
                handleAjaxError(xhr, status, error); // 错误处理
            }
        });
    });
}

// ---------------------------- 显示状态消息 ----------------------------
function showStatusMessage(data) {
    if (data.code === 200) {
        layer.msg(data.msg); // 使用后台返回的成功提示
        window.location.reload();
    } else {
        layer.msg(data.msg); // 使用后台返回的错误提示
    }
}

// ---------------------------- AJAX错误处理 ----------------------------
function handleAjaxError(xhr, status, error) {
    console.error('AJAX Error:', status, error); // 控制台错误日志

    // 根据页面语言显示网络错误
    const currentLang = $('html').attr('lang') || 'zh-cn';
    const errorMsg = currentLang === 'zh-cn' ? '网络错误，请稍后重试' : 'Network error, please try again later';
    layer.msg(errorMsg);
}

// 页面加载完成后初始化
$(document).ready(function () {
    initLangSwitch(); // 初始化语言切换
    initFormSubmit(); // 初始化表单提交
});