// RoyalCMS Homepage Specific Function Modules
$(document).ready(function() {
    royalInitSwiper();
    royalInitProductTabs();
    royalInitNewsSlider();
});

// Swiper Carousel Module
function royalInitSwiper() {
    // Main Banner Carousel
    new Swiper('.royal-swiper-banner', {
        loop: true,
        autoplay: { 
            delay: 5000, 
            disableOnInteraction: false 
        },
        pagination: { 
            el: '.swiper-pagination', 
            clickable: true 
        },
        navigation: { 
            nextEl: '.swiper-button-next', 
            prevEl: '.swiper-button-prev' 
        },
        effect: 'fade',
        fadeEffect: { 
            crossFade: true 
        },
        speed: 800
    });

    // News Carousel
    new Swiper('.royal-news-swiper', {
        loop: true,
        autoplay: { 
            delay: 4000, 
            disableOnInteraction: false 
        },
        pagination: { 
            el: '.swiper-pagination', 
            clickable: true 
        },
        speed: 600
    });
}

// Product Tabs Function - Optimized Version
function royalInitProductTabs() {
    const $royalProductTabs = $('.royal-product-tab');
    const $royalProducts = $('.royal-product-card');
    
    // Ensure there's an active tab
    if ($royalProductTabs.filter('.royal-active').length === 0) {
        $royalProductTabs.first().addClass('royal-active');
    }
    
    // Get current active tab category
    const activeCategory = $royalProductTabs.filter('.royal-active').data('category');
    
    // Initially show products for corresponding category
    royalFilterProducts(activeCategory);
    
    $royalProductTabs.on('click', function() {
        // Prevent clicking on already active tab
        if ($(this).hasClass('royal-active')) return;
        
        $royalProductTabs.removeClass('royal-active');
        $(this).addClass('royal-active');
        
        const category = $(this).data('category');
        royalFilterProducts(category);
    });
    
    function royalFilterProducts(category) {
        let hasVisibleProducts = false;
        
        $royalProducts.each(function() {
            const $product = $(this);
            const productCategory = $product.data('category');
            
            if (category === 'all' || productCategory == category) {
                $product.fadeIn(300);
                hasVisibleProducts = true;
            } else {
                $product.hide();
            }
        });
        
        // Show message if no products are displayed
        if (!hasVisibleProducts) {
            showNoProductsMessage(category);
        } else {
            removeNoProductsMessage();
        }
    }
    
    function showNoProductsMessage(category) {
        // Remove existing message first
        removeNoProductsMessage();
        
        const messageText = category === 'all' 
            ? 'No products available at the moment.' 
            : `No products found in the ${category} category.`;
            
        const $message = $(`
            <div class="royal-no-products">
                <div class="royal-no-data">
                    <i class="fas fa-box-open royal-no-data-icon"></i>
                    <h3>No Products Found</h3>
                    <p>${messageText}</p>
                </div>
            </div>
        `);
        
        $royalProducts.first().parent().append($message);
    }
    
    function removeNoProductsMessage() {
        $('.royal-no-products').remove();
    }
}

// News Slider Function
function royalInitNewsSlider() {
    $('.royal-news-list-item').on('click', function() {
        const $this = $(this);
        $this.css('transform', 'scale(0.98)');
        setTimeout(() => $this.css('transform', 'scale(1)'), 150);
    });
}