// RoyalCMS Mobile Functionality
$(document).ready(function() {
    royalInitMobileMenu();
    royalInitMobileNavigation();
    royalInitMobileModals();
    royalInitMobileScrollEffects();
    royalInitMobileLazyLoad();
});

// Mobile Menu Functionality
function royalInitMobileMenu() {
    const $mobileToggle = $('.royal-mobile-menu-toggle');
    const $navMenu = $('.royal-nav-menu');
    const $mobileOverlay = $('<div class="royal-mobile-overlay"></div>');
    
    // Add overlay to page
    $('body').append($mobileOverlay);
    
    // Clone header actions for mobile
    const $headerActions = $('.royal-header-actions').clone();
    $headerActions.addClass('royal-mobile');
    $navMenu.append($headerActions);
    
    // Mobile menu toggle
    $mobileToggle.on('click', function(e) {
        e.stopPropagation();
        const $this = $(this);
        $this.toggleClass('royal-active');
        $navMenu.toggleClass('royal-active');
        $mobileOverlay.toggleClass('royal-active');
        $('body').toggleClass('royal-menu-open');
    });
    
    // Close menu on overlay click
    $mobileOverlay.on('click', function() {
        $mobileToggle.removeClass('royal-active');
        $navMenu.removeClass('royal-active');
        $mobileOverlay.removeClass('royal-active');
        $('body').removeClass('royal-menu-open');
    });
    
    // Mobile dropdown menu click
    $('.royal-has-dropdown > a').on('click', function(e) {
        if ($(window).width() <= 768) {
            e.preventDefault();
            const $parent = $(this).parent();
            const $dropdown = $parent.find('.royal-dropdown-menu');
            
            // Close other dropdowns
            $('.royal-has-dropdown').not($parent).removeClass('royal-active');
            $('.royal-dropdown-menu').not($dropdown).slideUp(200);
            
            // Toggle current dropdown
            $parent.toggleClass('royal-active');
            $dropdown.slideToggle(200);
        }
    });
    
    // Close menu on link click (except dropdowns)
    $('.royal-nav-menu a').not('.royal-has-dropdown > a').on('click', function() {
        if ($(window).width() <= 768) {
            $mobileToggle.removeClass('royal-active');
            $navMenu.removeClass('royal-active');
            $mobileOverlay.removeClass('royal-active');
            $('body').removeClass('royal-menu-open');
        }
    });
    
    // Reset menu on window resize
    $(window).on('resize', function() {
        if ($(window).width() > 768) {
            $mobileToggle.removeClass('royal-active');
            $navMenu.removeClass('royal-active');
            $mobileOverlay.removeClass('royal-active');
            $('body').removeClass('royal-menu-open');
            $('.royal-dropdown-menu').slideUp(200);
            $('.royal-has-dropdown').removeClass('royal-active');
        }
    });
}

// Mobile Navigation Functionality
function royalInitMobileNavigation() {
    const $header = $('.royal-header');
    
    // Header scroll effect
    $(window).on('scroll', royalThrottle(function() {
        const scrollY = $(this).scrollTop();
        if (scrollY > 50) {
            $header.addClass('royal-scrolled');
        } else {
            $header.removeClass('royal-scrolled');
        }
    }, 100));
    
    // Mobile smooth scroll
    $('.royal-nav-menu a[href*="#"]').on('click', function(e) {
        if ($(window).width() <= 768) {
            const targetId = $(this).attr('href');
            
            if (targetId.startsWith('#')) {
                e.preventDefault();
                const $target = $(targetId);
                
                if ($target.length) {
                    // Close mobile menu
                    $('.royal-mobile-menu-toggle').removeClass('royal-active');
                    $('.royal-nav-menu').removeClass('royal-active');
                    $('.royal-mobile-overlay').removeClass('royal-active');
                    $('body').removeClass('royal-menu-open');
                    
                    $('html, body').animate({
                        scrollTop: $target.offset().top - 60
                    }, 600, 'swing');
                }
            }
        }
    });
}

// Mobile Modal Functionality
function royalInitMobileModals() {
    // Mobile modal show
    $('.royal-fixed-btn.royal-consult').on('click', function() {
        royalShowMobileModal('#royal-consultModal');
    });
    
    $('.royal-download').on('click', function() {
        royalShowMobileModal('#royal-downloadModal');
    });
    
    $('.royal-sponsor-btn').on('click', function() {
        royalShowMobileModal('#royal-sponsorModal');
    });
    
    // Mobile modal close
    $('.royal-close-modal').on('click', function(e) {
        e.stopPropagation();
        royalHideMobileModal();
    });
    
    // Close on outside click
    $('.royal-modal').on('click', function(e) {
        if (e.target === this) {
            royalHideMobileModal();
        }
    });
    
    // Close on ESC key
    $(document).on('keydown', function(e) {
        if (e.keyCode === 27 && $('.royal-modal.show').length) {
            royalHideMobileModal();
        }
    });
    
    // Mobile modal show function
    function royalShowMobileModal(modalId) {
        const $modal = $(modalId);
        $modal.addClass('show').fadeIn(300);
        $('body').addClass('royal-modal-open').css('overflow', 'hidden');
    }
    
    // Mobile modal hide function
    function royalHideMobileModal() {
        $('.royal-modal').removeClass('show').fadeOut(200);
        $('body').removeClass('royal-modal-open').css('overflow', '');
    }
}

// Mobile Scroll Effects
function royalInitMobileScrollEffects() {
    // Back to top button
    $('.royal-fixed-btn.royal-top').on('click', function() {
        $('html, body').animate({ scrollTop: 0 }, 600, 'swing');
    });
    
    // Show/hide back to top button
    $(window).on('scroll', royalThrottle(function() {
        const $topBtn = $('.royal-fixed-btn.royal-top');
        const scrollTop = $(this).scrollTop();
        
        if (scrollTop > 300) {
            $topBtn.addClass('royal-visible');
        } else {
            $topBtn.removeClass('royal-visible');
        }
    }, 150));
}

// Mobile Lazy Load Optimization
function royalInitMobileLazyLoad() {
    if ('IntersectionObserver' in window) {
        const lazyImageObserver = new IntersectionObserver(function(entries) {
            entries.forEach(function(entry) {
                if (entry.isIntersecting) {
                    const lazyImage = entry.target;
                    lazyImage.src = lazyImage.dataset.src;
                    lazyImage.classList.remove('lazy');
                    lazyImageObserver.unobserve(lazyImage);
                }
            });
        });

        $('img[data-src]').each(function() {
            lazyImageObserver.observe(this);
        });
    }
}

// Utility Functions
function royalThrottle(func, limit) {
    let inThrottle;
    return function() {
        const args = arguments;
        const context = this;
        if (!inThrottle) {
            func.apply(context, args);
            inThrottle = true;
            setTimeout(() => inThrottle = false, limit);
        }
    };
}

// Mobile AOS Initialization
document.addEventListener('DOMContentLoaded', function() {
    if (typeof AOS !== 'undefined') {
        AOS.init({
            duration: 600,
            once: true,
            offset: 30,
            delay: 50,
            easing: 'ease-out',
            disable: function() {
                return $(window).width() <= 768;
            }
        });
    }
});